<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Discount_Model extends CI_Model {

public function __construct()
   {
      parent::__construct();

   }      

	// new update for orin web site by sachith
	function save_top_deal($data)
   {
     if($this->db->insert('specical_offer_product', $data))
     {
       $lst = $this->db->insert_id();
       return $lst;
     }
     else
     {
       return false;
     }
   }

   function save_daily_deal($data)
   {
     if($this->db->insert('daily_deals_product', $data))
     {
       $lst = $this->db->insert_id();
       return $lst;
     }
     else
     {
       return false;
     }
   }

      public function update_top_deal($data,$sp_dis_id='')
   {
      if($sp_dis_id){
        $this->db->where('sp_dis_id', $sp_dis_id);
        $result=$this->db->update('specical_offer_product', $data); 
        return $result;
      }  else{
        return false;
      }        
   }   

   public function update_daily_deal($data,$sp_dis_id='')
   {
      if($sp_dis_id){
        $this->db->where('daily_deal_id', $sp_dis_id);
        $result=$this->db->update('daily_deals_product', $data); 
        return $result;
      }  else{
        return false;
      }        
   }  

function get_all_discount_product_list(){
  $this->db->select('a.*');
  $this->db->select('p.*');
  $this->db->select('pc.cat_name');
  $this->db->from('specical_offer_product a');
  $this->db->join('product p','p.product_id=a.product_id','left');
  $this->db->join('product_category pc','pc.cat_id=p.cat_id','left');
  $this->db->where('a.approval_status', 1);
  $this->db->where('a.is_remove', 0);
  $this->db->order_by('pc.cat_name','asc');  
  $query = $this->db->get();
	return $query->result_array();
}

function get_all_daily_discount_product_list(){
  $this->db->select('a.*');
  $this->db->select('p.*');
  $this->db->select('pc.cat_name');
  $this->db->from('daily_deals_product a');
  $this->db->join('product p','p.product_id=a.product_id','left');
  $this->db->join('product_category pc','pc.cat_id=p.cat_id','left');
  $this->db->where('a.approval_status', 1);
  $this->db->where('a.is_remove', 0);
  $this->db->order_by('pc.cat_name','asc');  
  $query = $this->db->get();
	return $query->result_array();
}

public function remove_currant_top_deal($id)
{
  $this->db->trans_start(); # Starting Transaction
  $this->db->trans_strict(FALSE); 
  $data=array('category_top'=>0); 
  $this->db->where('is_remove', 0);
  $this->db->where('sp_dis_id', $id);
  $result=$this->db->update('specical_offer_product', $data); 
  $this->db->trans_complete(); # Completing transaction
/*Optional*/

if ($this->db->trans_status() === FALSE) {
    # Something went wrong.
    $this->db->trans_rollback();
    return FALSE;
} 
else {
    # Everything is Perfect. 
    # Committing data to the database.
    $this->db->trans_commit();
    return TRUE;
} 
}  

public function remove_currant_daily_deal($id)
{
  $this->db->trans_start(); # Starting Transaction
  $this->db->trans_strict(FALSE); 
  $data=array('category_top'=>0); 
  $this->db->where('is_remove', 0);
  $this->db->where('daily_deal_id', $id);
  $result=$this->db->update('daily_deals_product', $data); 
  $this->db->trans_complete(); # Completing transaction
/*Optional*/

if ($this->db->trans_status() === FALSE) {
    # Something went wrong.
    $this->db->trans_rollback();
    return FALSE;
} 
else {
    # Everything is Perfect. 
    # Committing data to the database.
    $this->db->trans_commit();
    return TRUE;
}  
}  

public function set_as_top_deal($id)
{
  $this->db->trans_start(); # Starting Transaction
  $this->db->trans_strict(FALSE); 
   $data=array('category_top'=>1);
  $this->db->where('is_remove', 0);
  $this->db->where('sp_dis_id', $id);
  $result=$this->db->update('specical_offer_product', $data);    
  $this->db->trans_complete(); # Completing transaction

/*Optional*/

if ($this->db->trans_status() === FALSE) {
    # Something went wrong.
    $this->db->trans_rollback();
    return FALSE;
} 
else {
    # Everything is Perfect. 
    # Committing data to the database.
    $this->db->trans_commit();
    return TRUE;
}
} 

public function set_as_daily_deal($id)
{
  $this->db->trans_start(); # Starting Transaction
  $this->db->trans_strict(FALSE); 
   $data=array('category_top'=>1);
  $this->db->where('is_remove', 0);
  $this->db->where('daily_deal_id', $id);
  $result=$this->db->update('daily_deals_product', $data);    
  $this->db->trans_complete(); # Completing transaction

/*Optional*/

if ($this->db->trans_status() === FALSE) {
    # Something went wrong.
    $this->db->trans_rollback();
    return FALSE;
} 
else {
    # Everything is Perfect. 
    # Committing data to the database.
    $this->db->trans_commit();
    return TRUE;
}
} 

function product_list(){
    $this->db->select('p.product_code,p.product_name,p.product_id');  
  $this->db->from('product p');
   $this->db->where('p.product_status', 1);
  $this->db->where('p.show_website', 1);
  $this->db->order_by('p.product_name','asc');  
  $query = $this->db->get();
	return $query->result_array();
}

public function remove_daily_deal($id)
{
  $this->db->trans_start(); # Starting Transaction
  $this->db->trans_strict(FALSE); 
   $data=array('is_remove'=>1);
  $this->db->where('is_remove', 0);
  $this->db->where('daily_deal_id', $id);
  $result=$this->db->update('daily_deals_product', $data);    
  $this->db->trans_complete(); # Completing transaction

/*Optional*/

if ($this->db->trans_status() === FALSE) {
    # Something went wrong.
    $this->db->trans_rollback();
    return FALSE;
} 
else {
    # Everything is Perfect. 
    # Committing data to the database.
    $this->db->trans_commit();
    return TRUE;
}
} 

public function remove_top_deal($id)
{
  $this->db->trans_start(); # Starting Transaction
  $this->db->trans_strict(FALSE); 
   $data=array('is_remove'=>1);
  $this->db->where('is_remove', 0);
  $this->db->where('sp_dis_id', $id);
  $result=$this->db->update('specical_offer_product', $data);    
  $this->db->trans_complete(); # Completing transaction

/*Optional*/

if ($this->db->trans_status() === FALSE) {
    # Something went wrong.
    $this->db->trans_rollback();
    return FALSE;
} 
else {
    # Everything is Perfect. 
    # Committing data to the database.
    $this->db->trans_commit();
    return TRUE;
}
}




}
