<?php defined('BASEPATH') OR exit('No direct script access allowed');



class Cart_Model extends CI_Model{    

    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->table = 'order_customer';
    }
    

    function save_order_master($data) {            
        if($data){
            $this->db->insert($this->table, $data);
            $insertid =  $this->db->insert_id();
            return $insertid ;
        } else {
            return false;
        }    
    }
   //dakshina 12/27/2023
    function update_order_address($order_id, $data)
{
    if ($order_id > 0) {
        $this->db->where('order_id', $order_id);
        return $this->db->update('order_customer_address', $data);
    } else {
        return false;
    }
}
    function save_online_payment($data) {            
        if($data){
            $this->db->insert('online_payment', $data);
            $insertid =  $this->db->insert_id();
            return $insertid ;
        } else {
            return false;
        }    
    }

    function save_payment($data) {            
        if($data){
            $this->db->insert('order_customer_payment', $data);
            $insertid =  $this->db->insert_id();
            return $insertid ;
        } else {
            return false;
        }    
    }
    


    

    function save_order_item($data) {            
        if($data){
            $this->db->insert('order_customer_item', $data);
            $insertid =  $this->db->insert_id();
            return $insertid ;
        } else {
            return false;
        }    
    }

    function gen_code ($column_name,$table_name,$type_code)
   {
	$this->db->select_max($column_name);
	$query = $this->db->get($table_name);
     if($query->num_rows() >0)
     {
       $g = $query->result();
       $u = $this->set_ref_no($g[0]->$column_name,$type_code);
       return $u;
     }
     else
     {
       return false;
     }
   }

   function set_ref_no($f,$t)
   {
	  $w='';
   	 $d = date('Y/m/');
	 if($t){
		$w=$t;
	 }
   	 $w =$w.sprintf("%07d",$f+1);
   	 return $w;
   }



   function get_order_details($order_id)
   {
    $this->db->select('oc.*');
        $this->db->select('mp.pay_type_name');
        $this->db->from('order_customer oc');
        $this->db->join('mstr_payment_type mp','oc.payment_type = mp.pay_type_id','left');
        $this->db->where('oc.ord_cus_id', $order_id);
        $query = $this->db->get();
        return $query->row_array();
     }

    function get_order_item_details($order_id)
    {
        
        $this->db->select('p.*');
        $this->db->select('oc.*');
        $this->db->from('order_customer_item oc');
        $this->db->join('product p','oc.product_id = p.product_id','left');
        $this->db->where('oc.order_cus_id', $order_id);
        $query = $this->db->get();
        return $query->result_array(); 
     }

//dakshina 2023.12.28
    // public function save_order_adress($data) {            
    //     if ($data) {
    //         $result = $this->db->insert('order_customer_address', $data);
    
    //         // Add the Birthday Wish Type to the order_customer_address table
    //         if (isset($data['wish_type'])) {
    //             $wish_type_data = array(
    //                 'order_id' => $data['order_id'],
    //                 'wish_type' => $data['wish_type'], // Assuming 'wish_type' is the key for the Birthday Wish Type
    //             );
    //             $this->db->insert('order_customer_address', $wish_type_data);
    //         }
            
    //         return $result;
    //     } else {
    //         return false;
    //     }    
    // }
    
    
    public function save_order_adress($data) {            
        if ($data) {
            $result = $this->db->insert('order_customer_address', $data);
            return $result;
        } else {
            return false;
        }    
    }
   


    function get_packing_item($id){
        $this->db->select('p.*');
        $this->db->select('si.quantity');
        $this->db->from('sale_items si');
        $this->db->join('product p','si.product_id = p.product_id','left');
        $this->db->where('si.sale_id', $id);
        $query = $this->db->get();
        return $query->result_array(); 
    }

    
    function get_city_details($id)
    {
         $this->db->select('mc.*');
         $this->db->from('mstr_city mc');        
         $this->db->where('mc.cid', $id);
         $query = $this->db->get();
         return $query->row_array();
      }
      
       function update_order($id='',$data)
   {
       if($id>0){
        $this->db->where('ord_cus_id', $id);
        return $this->db->update('order_customer', $data);
       }
       else{
           return false;
       }
   }
    

}