<?php
 
class Free_Issue_Process_Model extends CI_Model {
  
  
  function __construct() 
  {
    parent::__construct();
  }
  
    
  	function save_free_product($data_item)
	{
		$result=$this->db->insert('free_issue_product',$data_item);
		return $result;
	}
	function get_free_issue_list($product_id)
    {
        $this->db->select('p.*,u.invoice_type_name');
        $this->db->from('free_issue_product p');
        $this->db->join('master_invoice_type u', 'u.invoice_type_id = p.price_type', 'inner');
        $this->db->where("p.free_status", 1);
        $this->db->where("p.product_id", $product_id);
        $this->db->where("p.is_deleted", 0);
        $query=$this->db->get();
        return $query->result_array();
    }
    function sale_free_product_list($sale_id)
    {
        $this->db->select('p.*,s.batch_id');
        $this->db->from('free_issue_product p');
        $this->db->join('hw_sale_items s', 's.product_id = p.product_id', 'inner');
        $this->db->where("s.sale_id", $sale_id);
        $this->db->where("p.free_status", 1);
        $this->db->where("p.is_deleted", 0);
        $this->db->group_by("s.batch_id");
        $query=$this->db->get();
        return $query->result_array();
    }
    function get_total_sale_product_qty($product_id,$sale_id,$batch_id){
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sale_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $this->db->where('p.sale_id', $sale_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
     public function get_relevent_free_issue_block($product_id,$qty)
	{
	    $this->db->select('p.*');
        $this->db->from('free_issue_product p');
        $this->db->where("p.product_id ", $product_id);
        $this->db->where("p.start_req_qty <=",$qty);
        $this->db->where("p.end_req_qty >",$qty);
        $this->db->where("p.free_status", 1);
        $this->db->where("p.is_deleted", 0);
        $this->db->limit(1);
        $query=$this->db->get();
        $result = $query->row_array();
        if(isset($result['fr_p_id'])){
            $return_result=array(
                'fr_p_id'=>$result['fr_p_id'],
                'free_qty'=>$result['free_qty'],
                'product_cost'=>$result['product_cost']
            );
            return $return_result;
            
        }else{
            return false;
        }
	}
	function update_free_issue_product($data,$id)
	{
		if ($id>0)
		{
			$this->db->where('fr_p_id',$id);
		    return $this->db->update('free_issue_product',$data);
		}
		else 
		{
	        return false;
		}
	}
	
	public function get_free_issue_details($id){
     $this->db->select("si.*");
     $this->db->from("free_issue_product si");
     $this->db->where("si.fr_p_id",$id);
     $query = $this->db->get();  
     return $query->row_array();
  }
  
   
 


}