<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class REPORT_ANALYSE extends CI_Controller
{
    var $main_menu_name = "report_analyse";
    var $sub_menu_name = "";

    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('Common_Model');
        $this->load->library('cart');
        $this->load->model('Area_Model');
        
    }
    public function index()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = '';
    }
    public function customer_product_invoice_analyse()
    {
        $from_date=$this->input->get('srh_from_date');
        $to_date=$this->input->get('srh_to_date');
        $route_id=$this->input->get('route_id');
        if($from_date){
          $from_date=date('Y-m-d', strtotime($from_date));  
        }else{
             $from_date=date('Y-m-d');
        }
        if($to_date){
		$to_date=date('Y-m-d', strtotime($to_date));
        }else{
        $to_date=date('Y-m-d');    
        }
         if(!$route_id){
           $route_id=0; 
        }
        $data['main_category_id']=$this->input->get('main_category');
        $data['srh_from_date_val']=$from_date;
        $data['srh_to_date_val']=$to_date;
        $data['route_id']=$route_id;
        $this->load->model('Report_Analyse_Model');
        $this->load->model('Category_Models');
        $this->load->model('Route_Model');
         $data['route_list'] = $this->Area_Model->get_all_active_areas();
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = 'customer_product_invoice_analyse';
        $data['main_category']  = $this->Category_Models->getCategory();
        if($from_date && $to_date && $route_id){
        $product_list = $this->Report_Analyse_Model->get_sale_product_list($data['main_category_id'],$from_date,$to_date,$route_id);
        $customer_list = $this->Report_Analyse_Model->get_sale_customer_list($data['main_category_id'],$from_date,$to_date,$route_id);
        $sale_item_list = $this->Report_Analyse_Model->get_sale_item_product_list($data['main_category_id'],$from_date,$to_date,$route_id);
        }else{
             $product_list = array();
        $customer_list = array();
        $sale_item_list = array();
        }
        $master_data=array();
       //table header start
        $header_data=array();
        $header_data[]="CUSTOMER";
        foreach($product_list as $row){
            $header_data[]=$row['product_code'];
        }
        $master_data[]=$header_data;
        //table header end
         
         foreach($customer_list as $cus){
            $nested_data=array();
            $nested_data[]=$cus['cus_name']." | ".$cus['cus_code'];
            foreach($product_list as $row){
                $qty = $this->searchForId($cus['cus_id'],$row['product_id'], $sale_item_list);
            $nested_data[]=$qty;
            }
             $total_sale=$this->Report_Analyse_Model->get_sale_product_value($data['main_category_id'],$from_date,$to_date,$route_id,$cus['cus_id']);
            $nested_data[]=$total_sale;
            $master_data[]=$nested_data;
        }
       /*
        $count=0;
        foreach($customer_list as $cus){
            $nested_data1=array();
            $nested_data1[]=$cus['cus_name']." ( ".$cus['cus_code']." ) ";
        foreach($product_list as $row){
                $customer_id=$cus['cus_id'];
                $product_id=$row['product_id'];
                $qty = $this->searchForId($customer_id,$product_id, $sale_item_list);
               $nested_data1[]=$qty;
        }
        $total_sale=0;//$this->Report_Analyse_Model->get_sale_product_value($data['main_category_id'],$from_date,$to_date,$route_id,$cus['cus_id']);
        $nested_data[]=$total_sale;
        $master_data[]=$nested_data1;
       $count++;
        }*/
        $data['cus_product_list']=$master_data;
        //Load your view and pass the data
        $this->load->view('report_distribution/customer_product_sale_view',$data);
    }
    
    
    function searchForId($cusid,$product_id, $array) {
        $total_return_qty=0;
        foreach ($array as $key => $val) {
            if ($val->customer_id == $cusid &&$val->product_id == $product_id  ) {
                 $total_return_qty+= $val->quantity;
            }
        }
        return $total_return_qty;
    }
    
    public function customer_product_sale_return_analyse()
    {
        $from_date=$this->input->get('srh_from_date');
        $to_date=$this->input->get('srh_to_date');
        $route_id=$this->input->get('route_id');
        if($from_date){
          $from_date=date('Y-m-d', strtotime($from_date));  
        }else{
             $from_date=date('Y-m-d');
        }
        if($to_date){
		$to_date=date('Y-m-d', strtotime($to_date));
        }else{
        $to_date=date('Y-m-d');    
        }
        if(!$route_id){
           $route_id=0; 
        }
        $data['main_category_id']=$this->input->get('main_category');
        $data['srh_from_date_val']=$from_date;
        $data['srh_to_date_val']=$to_date;
        $data['route_id']=$route_id;
        $this->load->model('Report_Analyse_Model');
        $this->load->model('Category_Models');
        $this->load->model('Route_Model');
         $data['route_list'] = $this->Area_Model->get_all_active_areas();
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = 'customer_product_sale_return_analyse';
        $data['main_category']  = $this->Category_Models->getCategory();
        
        $product_list = $this->Report_Analyse_Model->get_sale_return_product_list($data['main_category_id'],$from_date,$to_date,$route_id);
        $customer_list = $this->Report_Analyse_Model->get_sale_return_customer_list($data['main_category_id'],$from_date,$to_date,$route_id);
        $sale_item_list = $this->Report_Analyse_Model->get_sale_return_item_product_list($data['main_category_id'],$from_date,$to_date,$route_id);
        $master_data=array();
        $nested_data=array();
        $nested_data[]="CUSTOMER";
        foreach($product_list as $row){
            $nested_data[]=$row['product_code'];
        }
        $master_data[]=$nested_data;
        $count=0;
        foreach($customer_list as $cus){
            $nested_data=array();
            $nested_data[]=$cus['cus_name']." | ".$cus['cus_code'];
        foreach($product_list as $row){
                $customer_id=$cus['cus_id'];
                $product_id=$row['product_id'];
                $qty = $this->searchForReturnId($customer_id,$product_id, $sale_item_list);
               $nested_data[]=$qty;
        }
        
        $total_sale=$this->Report_Analyse_Model->get_sale_return_product_value($data['main_category_id'],$from_date,$to_date,$route_id,$cus['cus_id']);
        $nested_data[]=$total_sale;
        $master_data[]=$nested_data;
       $count++;
        }
        $data['cus_product_list']=$master_data;
        //Load your view and pass the data
        $this->load->view('report_distribution/customer_product_sale_return_view',$data);
    }
    
    function searchForReturnId($cusid,$product_id, $array) {
        $total_return_qty=0;
        foreach ($array as $key => $val) {
            if ($val->customer_id == $cusid &&$val->product_id == $product_id  ) {
                 $total_return_qty+= $val->product_qty;
            }
        }
        return $total_return_qty;
    }
   


 

}