<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manual_Function_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	function save_area($area_data,$area_id)
	{
		if (!$area_id)
		{
			//$this->db->insert($this->tableName,$area_data);
		}else {
			//$this->db->where('area_id', $area_id);
			//return $this->db->update($this->tableName,$area_data);
		}
	}	
	
	public function disable_product($id)
	{
		$data = array(
			'product_status' => 0
		);	
		$this->db->where('product_id', $id);
		$this->db->update('product', $data);
	}
	
	public function enable_product($id)
	{
		$data = array(
			'product_status' => 1
		);	
		$this->db->where('product_id', $id);
		$this->db->update('product', $data);
	}
	
	public function get_unpaid_sales()
	{		
		$this->db->select('s.*');
		$this->db->from('sales s');
		$this->db->where("s.payment_status", 0);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	public function close_sale($id)
	{
		if($id>0){
			$data = array(
			'payment_status' => 1,
			'closed_date' => date("Y-m-d H:i:s")
		);	
		$this->db->where('sale_id', $id);
		$this->db->update('sales', $data);
		}else{
			return false;
		}
		
	}

	public function get_uncomplte_multiple_payment()
	{		
		$this->db->select('s.*');
		$this->db->from('sale_multiple_payment s');
		$this->db->where("s.payment_settlement_status", 0);
		$query = $this->db->get();
		return $query->result_array(); 	
	}

	function get_total_sale_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();

        if($result['sale_pymnt_amount']){
            return $result['sale_pymnt_amount'];
        }else{
            return 0;
        }
	}
	
	function get_total_cheque_return_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.paid_amount');
        $this->db->from('cheque_return_payment sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();
        if($result['paid_amount']){
            return $result['paid_amount'];
        }else{
            return 0;
        }
	}
	
	public function close_payment($id)
	{
		if($id>0){
			$data = array(
			'payment_settlement_status' => 1
		);	
		$this->db->where('smp_id', $id);
		$this->db->update('sale_multiple_payment', $data);
		}else{
			return false;
		}		
	}


	public function get_pending_sale_list()
	{	
		$this->db->select('s.*');
		$this->db->from('sales s');
		$this->db->join('customer c','c.cus_id=s.customer_id','left');
		$this->db->where("s.payment_status", 0);
		$this->db->where("c.cus_credit_status", 1);
		$this->db->order_by('s.sale_datetime','desc');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
		public function get_zero_total_item_cost()
	{	
		$this->db->select('s.*');
		$this->db->from('sale_items s');
		$this->db->where("s.total_item_cost", 0.00);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
		public function update_sale_items($id,$data)
	{
	    if($id>0){
	        	$this->db->where('id', $id);
		        $this->db->update('sale_items', $data);
	    }
	
	}
	
	function duplicate_return_list($id='')
    {
       
        $this->db->select('count(*) as cnt');
        $this->db->select('mobile_ref_no,mobile_date_time,cus_code,cus_name,loading_ref_no,user_first_name,delivery_return_id');
        $this->db->join('customer ','customer.cus_id=delivery_return_master.customer_id','inner');
        $this->db->join('marketing_loading_unloading ','marketing_loading_unloading.id=delivery_return_master.delivery_id','inner');
         $this->db->join('user ','user.user_id=marketing_loading_unloading.rep_id','inner');
        $this->db->group_by(array("mobile_ref_no"));
        $this->db->having("cnt > 1", null, false);
        $this->db->limit(10000);
        $q= $this->db->get("delivery_return_master");
        return $q->result();

    }
    
    function delete_return_master($id){
        if($id>0){
            $this->db->where('delivery_return_id', $id);
		    $this->db->delete('delivery_return_master');
        }
        return true;
    }
    
     function delete_return_item($id){
        if($id>0){
            $this->db->where('delivery_return_id', $id);
		    $this->db->delete('delivery_return_items');
        }
        return true;
    }
	
	
}