<?php
require_once("Main_model.php");
class Shift_model extends Main_model
{
	private $tableName = 'shift';
	private $join = 'comp';
	public function _construct()
	{
		//$this->load->database();
	}
	/*
	Determines if a given string is an exists
	*/
	
	function exist_shift($Name)
	{
		$this->db->from($this->tableName);
		$this->db->where('shift_code',$Name);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			$this->messages->add($this->lang->line('error_shift_exist'), "error");
			return true;
		}
		else
		{
			return false;
		}
	}
	
	
	function count_all($id=0)
	{
		$this->db->from($this->tableName);
		if($id!=0) 
		{
			$this->db->where('Code',$id);
		}
		return $this->db->count_all_results();
	}
	
	/*
	Returns all the shifts
	*/
	function get_all($id=0,$limit=0,$offset=0)
	{
		$this->db->select('t.shift_code, t.Name, t.Shift_From, t.Shift_To, jt.Name');
		$this->db->from($this->tableName." AS t");
		$this->db->join($this->join.' AS jt', 't.Comp_Id = jt.Code','left');
  		$query = $this->db->get();
		return $query->result();
	}
	
	function get_all_shift_code()
	{
		$this->db->select('t.shift_code, t.Name');
		$this->db->from($this->tableName." AS t");
  		$query = $this->db->get();
		return $query->result();
	}
	
	function get_info_start_end_date($shift_code)
	{
		$this->db->select('t.Shift_From, t.Shift_To');
		$this->db->from($this->tableName." AS t");
		$this->db->where('shift_code',$shift_code);
  		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			$h = $this->get_time_difference($query->row()->Shift_From, $query->row()->Shift_To);
			$query->row()->Hours = ($h==0)?24:$h;
			return $query->row();
		}
		else
		{
			return false;
		}
	}
	
	function get_time_difference($time1, $time2) {
    $time1 = strtotime("1980-01-01 $time1");
    $time2 = strtotime("1980-01-01 $time2");
    
        if ($time2 < $time1) {
            $time2 += 86400;
        }
        return (int)date("H", strtotime("1980-01-01 00:00:00") + ($time2 - $time1));
    }

	function get_info($shift_id='')
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where('shift_code',$shift_id);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}

	/*
	Inserts or updates a page
	*/
	function save(&$shift_data,$shift_id=false)
	{
		if (!$shift_id)
		{
			if(!$this->exist_shift($shift_data['shift_code']))
			{
				if($this->db->insert($this->tableName,$shift_data))
				{
					$shift_data['shift_code']=$this->db->insert_id();
					return true;
				}
			}
			return false;
		}
		$this->db->where('shift_code', $shift_id);
		return $this->db->update($this->tableName,$shift_data);
	}
	
	/*
	Deletes one shift
	*/
	function delete($id)
	{
		if($this->delete_image($id))
		{
			$this->db->where('Code', $id);
			return $this->db->delete($this->tableName); 
		}
		return false;
		
	}
	/*
	public function change_status($shift_id,$status)
	{
		$this->db->where('Code', $shift_id);
		return $this->db->update($this->tableName,array( 'pStatus' => $status));	
	}
	*/
	public function change_status($shift_id)
	{
		$this->db->trans_start();
		$this->db->from('employee');
		$this->db->where('Dep_code',$shift_id);
		$this->db->where('Active',1);
		$count = $this->db->count_all_results();
		$this->db->trans_complete();
		if($count==0)
		{
			$this->db->trans_start();
			$this->db->where('Dep_code', $shift_id);
			 $this->db->update($this->tableName,array('Status' => 0));
			 echo $this->db->last_query();
			 //return $this->db->affected_rows();
			 $return = (bool) ($this->db->affected_rows() > 0); 
			 $this->db->trans_complete();
			 return $return;
		}
		else
		{
			$this->messages->add($this->lang->line('error_company_delete'), "error");
			return false;
		}
	}

}
?>