<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Company extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
        $this->load->model('company_model');
        $this->model = $this->company_model;
        $this->load->library('form_validation');
    }

    function index($action = NULL)
    {
        //$this->tmw->checkPermissions();
        //echo $this->data['page'];
        //$data['page'] = 'company';
        
        $this->data['message'] = view_error($this->messages->get(),1);
        $this->data['action'] = $action;
        $this->data['page_title'] = 'Companies';
        $this->data['heading'] = 'Master Files';
        $bc = array(array('link' => base_url('admin'), 'page' => lang('home')), array('link' => '#', 'page' => lang('companys')));
        $meta = array('page_title' => lang('Companies'), 'bc' => $bc);
        $this->page_construct('companys/index', $meta, $this->data);
    }

    function getCompanies()    {
        //$this->tmw->checkPermissions('index');
        
        $action = '<div class="d-flex align-items-sm justify-content-sm">
        <a href="'.base_url('company/edit/$1').'" class="btn btn-sm btn-icon"><i class="bx bx-edit"></i></a>
        <a href="'.base_url('company/delete/$1').'" class="btn btn-sm btn-icon delete-record me-2"><i class="bx bx-trash"></i></a>
        </div>';
        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('companies') .".Id AS Id,
                ".$this->db->dbprefix('companies') .".Code,
                ".$this->db->dbprefix('companies') .".Name,
                ".$this->db->dbprefix('companies') .".Address")
            ->from("companies")
            //->edit_column('status', '$1__$2', 'status,Id')
            //->unset_column('Id')
            ->add_column("Actions", $action, "Id")
            ->unset_column('Id');
        echo $this->datatables->generate();
    }

    function add()
    {
        //$this->sma->checkPermissions(false, true);
        $this->form_validation->set_rules('Code', 'Code', 'required|trim');
        $this->form_validation->set_rules('Name', $this->lang->line("Name"), 'required|trim');
        
        if ($this->form_validation->run('companys/add') == true) {
            $data = array('Name' => $this->input->post('Name'),
                'Address' => $this->input->post('Address'),
                'Code' => $this->input->post('Code'),
            );
        } elseif ($this->input->post('add_customer')) {
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            redirect('company');
        }

        if ($this->form_validation->run() == true && $this->model->addComp($data)) {
            $this->messages->add($this->lang->line("customer_added"), "success");
            $ref = isset($_SERVER["HTTP_REFERER"]) ? explode('?', $_SERVER["HTTP_REFERER"]) : NULL;
            //redirect($ref[0] . '?customer=' . $cid);
            redirect('company');
        } else {
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            $this->data['message'] = view_error($this->messages->get(),1);
            //$this->data['modal_js'] = $this->site->modal_js();
            $this->data['page_title'] = 'Add Company';
            $this->data['heading'] = 'Master Files';
            $this->load->view('templates/companys/add', $this->data);
        }
    }
      
     function edit($id = NULL)
    {
        //$this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $comp_details = $this->model->getCompByID($id);
        $this->form_validation->set_rules('Name', $this->lang->line("Name"), 'required|trim');
        

        if ($this->form_validation->run('companys/add') == true) {
       
            $data = array(
                'Name' => $this->input->post('Name'),
                'Address' => $this->input->post('Address'),
            );
        } elseif ($this->input->post('edit_customer')) {
            $this->messages->add(validation_errors(), "error");
            //redirect($_SERVER["HTTP_REFERER"]);
            redirect('companys');
        }

        if ($this->form_validation->run() == true && $this->model->updateComp($id, $data)) {
           
            $this->messages->add(lang("Company_Updated"), "success");
            //redirect($_SERVER["HTTP_REFERER"]);
            redirect('company');
        } else {
            $this->data['company'] = $comp_details;
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            $this->data['message'] = view_error($this->messages->get());
            $this->data['page_title'] = 'Edit Company';
            $this->data['heading'] = 'Master Files';
            $this->load->view('templates/companys/edit', $this->data);
        }
    }

   
    function deactivate($id = NULL)
    {
        if ($this->companys_model->change_status($id,'Unpublish')) {
            $this->messages->add('companys UnPublished', "success");
        } else {
            if($this->messages->count() == 0)
                $this->messages->add('companys UnPublished error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function activate($id = NULL)
    {
        if ($this->companys_model->change_status($id,'Publish')) {
            $this->messages->add('companys Published', "success");
        } else {
            if($this->messages->count() == 0)
                $this->messages->add('companys Published error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function delete($id = NULL)
    {
        //$this->tmw->checkPermissions(NULL, TRUE);
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if ($this->model->delete($id)) {
            $this->messages->add('companys deleted', "success");
        } else {
            if($this->messages->count() == 0)
            $this->messages->add('companys delete error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function suggestions($term = NULL, $limit = NULL)
    {
        // $this->tmw->checkPermissions('index');
        if ($this->input->get('term')) {
            $term = $this->input->get('term', TRUE);
        }
        if (strlen($term) < 1) {
            return FALSE;
        }
        $limit = $this->input->get('limit', TRUE);
        $rows['results'] = $this->companies_model->getcompanysuggestions($term, $limit);
        echo json_encode($rows);
    }


}