<?php
/**
 * Created by PhpStorm.
 * User: Namal
 * Date: 12/03/2018
 * Time: 11:33 AM
 * 
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Employee_model extends CI_Model
{

    private $tableName = 'employee';
	private $join = 'comp';
    public function __construct()
    {
        parent::__construct();
    }


    public function getEmployeeData() {
        // Fetch data from the employee table
        $this->db->select('EmpNo, work_type, FullName, EmpName, SureName, InitialsName, EPFNo, StartDate, Basic_Salery');
        $query = $this->db->get('employee');
        return $query->result_array();
     }

    public function record_count()
    {
        //$this->db->where('Status','Active');
        $this->db->from('employee');
        return $this->db->count_all_results();
    }

    function get_info($EmpNo='')
	{
		$this->db->from($this->tableName);
		$this->db->where('EmpNo',$EmpNo);
		$query = $this->db->get();
		//echo $this->_getComp();
		//echo $this->db->last_query();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}

    public function getAllEmployee($limit, $start)
    {
        $this->db->limit($limit, $start);
        //$this->db->where('Status','Active');
        $query = $this->db->get("employee");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }


    public function getEmpNameId()
    {
        $this->db->select("EmpNo,FullName");
        $query = $this->db->get("employee");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getEmpNameIdByEmpNo($EmpNo='',$company='')
    {
        $this->db->select("EmpNo,FullName");
        if($EmpNo!='')$this->db->where('EmpNo',$EmpNo);
        if($company!='')$this->db->where('Comp',$company);
        $query = $this->db->get("employee");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getEmpJobs()
    {
        $this->db->select("EmpNo,Designation");
        $query = $this->db->get("employee");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[$row->Designation][] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getEmpJoin($EmpNo='')
    {
        $this->db->select("EmpNo,FullName,StartDate,CONCAT(
            TIMESTAMPDIFF(YEAR, `StartDate`, NOW()), ' years ',
            TIMESTAMPDIFF(MONTH, `StartDate`, NOW()) % 12, ' months ',
            TIMESTAMPDIFF(DAY, `StartDate`, NOW()), ' days'
          ) AS time_difference");
        if($EmpNo!='')$this->db->where('EmpNo',$EmpNo);
        $query = $this->db->get("employee");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getEmpBasicSalary($company='')
    {
        //$this->db->select("EmpNo,FullName");
        //$query = $this->db->get("employee");
        $this->db->select("E.EmpNo,E.FullName,P.Basic_Salary,I.Amount")
            ->from('employee AS E')
            ->join('payroll AS P','E.EmpNo=P.EmpNo','left')
            ->join('increment AS I','E.EmpNo=I.EmpNo','left');
        $this->db->where('E.Active',1);
        if($company!='')$this->db->where('E.Comp',$company);
        $query = $this->db->get();
        $data = array();
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $this->db->select("Code,Amount");
                $this->db->where('EmpNo',$row->EmpNo);
                $this->db->where('Type_Id','A');
                $this->db->where_in('Code', array('0001','0002'));
                $q = $this->db->get("payroll_options");
                $ndata = array();
                if ($query->num_rows() > 0) {
                    foreach ($q->result() as $r) {
                        $ndata[$r->Code] = $r->Amount;
                    }
                }

                $row->br12 = $ndata;
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getEmployeeFilter($where=array())
    {
        $this->db->select("E.*,D.Description AS Department,G.Name AS DesignationName,C.Name AS CompanyName")
            ->from('employee AS E')
            ->join('department AS D','E.Dep_code=D.Dep_code','left')
            ->join('designation AS G','E.Designation=G.Id','left')
            ->join('companies AS C','E.Comp=C.Code','left');
        $this->db->where('E.Active',1);
        $this->db->where($where);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getAll($company='')
    {
        if($company!='')$this->db->where('Comp',$company);
        $query = $this->db->get("employee");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getEmployeeByID($id)
    {
        $this->db->select('*')
            ->from('employee')
            ->where('EmpNo',$id);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            $row =  $q->row();
            return $row;
        }
        return FALSE;
    }

    public function addEmployee($data = array())
    {
        if ($this->db->insert('employee', $data)) {
            $user_data = array( 
                'Username' => $data['IDNo'],
                'Password' => $password_hass = hash('sha512', $data['IDNo']),
                'Type' => 'USER',
                'Comp' => 'rta',
                );
            $this->db->insert('user',$user_data);
            return true;
        }
        return false;
    }

    public function updateEmployee($id,$data = array())
    {
        $this->db->where('EmpNo',$id);
        if ($this->db->update('employee', $data)) {
            return true;
        }
        return false;
    }

    public function updateStatus($id,$status='Pending',$note='')
    {
        $this->db->where('Id', $id);
        if ($this->db->update('employee', array('Status' => $status,'Note' => $note))) {
            return true;
        }
        return false;
    }


    public function change_status($id,$status)
    {
        $this->db->where('Id', $id);
        if ($this->db->update('Employee', array('Status'=>$status))) {
            return true;
        }
        return false;
    }



    public function getOrderByID($id)
    {
        $this->db->select("A.first_name,A.last_name,A.email,A.type,A.address,A.city,A.postal_code,A.state,A.phone,C.country_name,B.TotalAmount as grand_total")
            ->from('Employees_users AS A')
            ->join('Employees AS B','A.Employees_id=B.Id','left')
            ->join('countries AS C','A.country=C.id','left')
            ->where('A.Employees_id',$id);
        $q = $this->db->get();
        if ($q->num_rows() == 1) {
            return $q->row();
        }
        return FALSE;
    }


    public function delete($id)
    {
        /*if ($this->_checkInstitute($id)) {
            return false;
        }

        if ($this->_checkParent($id)) {
            return false;
        }*/
        $Employees =$this->getEventByID($id);
        if ($this->db->delete('Employee', array('Id' => $id))) {
            $this->tmw->file_delete($this->path.'Employees/'.$Employees->FrontImage);
            $this->tmw->file_delete($this->path.'Employees/'.$Employees->BannerImage);
            return true;
        }
        return FALSE;
    }


    function get_all_filter($Dep_code='',$this_month=0)
	{
		/*
		 * EmpNo may has EPFNo or EmpNo
		 * For EmpNo use EId  
		*/
		#IF(t.EPFNo != "",t.EPFNo,t.EmpNo) AS EmpNo
		$this->db->select('t.EmpNo,t.EmpNo as EId,t.Comp,t.EmpName, jt.Name,t.Dep_code,t.work_type');
		//$this->db->select('t.EmpNo,t.Comp,t.EmpName, jt.Name');
		$this->db->from("employee AS t");
		$this->db->join('companies  AS jt', 't.Comp = jt.Code','left');
		//if(!$this->checkAdmin()) $this->db->where('t.Comp',$this->_getComp());
		//if($comp != '') $this->db->where('t.Comp',$comp);
		if($Dep_code != '') $this->db->where('t.Dep_code',$Dep_code);
		$this->db->where('t.Active',1);
		if($this_month==1) $this->db->where("DATE_FORMAT(t.StartDate,'%Y-%m') !='".date('Y-m')."'");
		$this->db->order_by('ABS(t.EPFNo)','asc');
		$query = $this->db->get();
		//echo $this->db->last_query(); die();
		return $query->result(); 
	}


    function get_all_emp_name($EmpNo='')
	{
		$this->db->select('IF(t.EPFNo != "",t.EPFNo,t.EmpNo) AS EmpNo,t.EmpNo as EId, t.EmpName');
		$this->db->from($this->tableName." AS t");
		if($EmpNo!='') $this->db->where('t.EmpNo',$EmpNo);
		$this->db->where('t.Active',1);
        $this->db->order_by('ABS(t.EPFNo) ASC',FALSE);
		$query = $this->db->get();
		$employees = array();
        if($query->num_rows() > 0){

            foreach($query->result() as $row){
                $employees[$row->EId] = $row;
            }
        }
		return $employees;
	}


    function upload_file($image)
	{
		$uploadedFiles = array();
		$config['upload_path'] = './uploads/employees/';
		$config['allowed_types'] = 'gif|jpg|png|bmp|jpeg';
		$config['max_size'] = '3000';
		$config['max_width'] = '4000';
		$config['max_height'] = '4000';
        $this->load->library('upload', $config);
		$upload = $this->upload->do_upload($image);
		$path = $this->upload->data();
		$configThumb = array();
		$configThumb['image_library'] = 'gd2';
		$configThumb['source_image'] = $path['full_path'];
		$configThumb['create_thumb'] = FALSE;
		$configThumb['maintain_ratio'] = FALSE;
		$configThumb['width'] = 204;
		$configThumb['height']=200;
		$this->load->library('image_lib');
					
		$this->image_lib->initialize($configThumb);
					
		if ( ! $this->image_lib->resize())
		{
			$this->messages->add($this->image_lib->display_errors(), "error");
			return false;
		}
		else
		{
			$this->image_lib->clear();
			return $path;
		}
	}
    
}
?>