<?php $this->load->view("templates/common/top_section"); ?>
<!-- Icons. Uncomment required icon fonts -->
<link rel="stylesheet" href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<link rel="stylesheet"
    href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
<!-- /section:basics/content.breadcrumbs -->
<!-- Basic Layout & Basic with Icons -->
<div class="row">
    <div class="col-md-5">
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Add Loan</h5>
            </div>
            <div class="card-body">


                <form class="form-horizontal needs-validation" novalidate action="<?php echo base_url('loan/add'); ?>"
                    method="post" role="form">

                    <div class="mb-3">
                        <label class="form-label" for="EmpNo">Employee</label>
                        <select id="EmpNo" class="select2 form-select form-control" required name="EmpNo">
                            <option value="">--Select Employee --</option>
                            <?php
                            foreach ($employees as $emp) {
                                $select = (isset($e) and $e == $emp->EId) ? 'selected="selected"' : null;
                                echo '<option ' . $select . ' value="' . $emp->EId . '">' . trim($emp->EmpName) . ' -- ' . $emp->EmpNo . '</option>';
                            }
                            ?>
                        </select>
                        <div class="invalid-feedback">
                            Employee is required.
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="name">Year</label>
                        <input type="text" class="form-control" id="Year" <?php echo (isset($loan->Year)) ? 'value="' . $loan->Year . '"' : null; ?> name="Year" placeholder="Year." required />
                        <div class="invalid-feedback">
                            Year is required.
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="FullAmount">Premium</label>
                        <input type="text" class="form-control" <?php echo (isset($loan->FullAmount)) ? 'value="' . $loan->FullAmount . '"' : null; ?> name="FullAmount" id="FullAmount" placeholder="0"
                            required />
                        <div class="invalid-feedback">
                            Premium is required.
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="Installment">Monthly Installment</label>
                        <input type="text" class="form-control" <?php echo (isset($loan->Installment)) ? 'value="' . $loan->Installment . '"' : null; ?> name="Installment" id="Installment"
                            placeholder="0" required />
                        <div class="invalid-feedback">
                            Installment is required.
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="Term">Term</label>
                        <input type="text" class="form-control" <?php echo (isset($loan->Term)) ? 'value="' . $loan->Term . '"' : null; ?> name="Term" id="Term" placeholder="0" required />
                        <div class="invalid-feedback">
                        Term is required.
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Add</button>
                </form>
            </div>
        </div>


    </div>

    <div class="col-md-7">
        <!-- Basic Bootstrap Table -->
        <div class="card">
            <h5 class="card-header">Loan List</h5>
            <div class="card-datatable text-nowrap">
                <table class="table" id="table">
                    <thead>
                        <tr>
                            <th>Year</th>
                            <th>Premium</th>
                            <th>Terms</th>
                            <th>Installment</th>
                            <th>Options</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">

                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Basic Bootstrap Table -->
    </div>

</div>
<div class="row">

</div>


<?php $this->load->view("templates/common/footer"); ?>