<?php $this->load->view("templates/common/top_section"); ?>

<form class="form-horizontal needs-validation" method="get" target="_blank" action="<?= base_url('reports/nopay_report'); ?>">
    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Nopay Report</h5>
                </div>
                <div class="card-body">

                    <div class="">

                        <div class="row mb-3 g-3">

                            <div class="col-12 col-sm-3">
                                <label class="form-label" for="company">Company</label>
                                <select class="select2 form-select" name="company" id="company" required aria-label="Default select example">
                                    <option value="">--Company--</option>
                                    <?php
                                    if (!empty($companies)) {
                                        foreach ($companies as $company) {
                                            echo '<option value="' . $company->Code . '">' . trim($company->Name) . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                            </div>

                            <div class="col-12 col-sm-3">
                                <label class="form-label" for="Month">Year</label>
                                <div class="form-group">
                                    <select class="col-xs-12 col-sm-10 select2 form-select" name="Year" id="Year">
                                        <?php
                                        // use this to set an option as selected (ie you are pulling existing values out of the database)
                                        $already_selected_value = date('Y');
                                        $earliest_year = 2020;
                                        foreach (range(date('Y'), $earliest_year) as $x) {
                                            print '<option value="' . $x . '"' . ($x === $already_selected_value ? ' selected="selected"' : '') . '>' . $x . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-12 col-sm-3">
                                <label class="form-label" for="Month">Month</label>
                                <select class="col-xs-12 col-sm-10 select2 form-select" name="month" id="month">
                                    <option value="">--Select--</option>
                                    <option value="01">January</option>
                                    <option value="02">February</option>
                                    <option value="03">March</option>
                                    <option value="04">April</option>
                                    <option value="05">May</option>
                                    <option value="06">June</option>
                                    <option value="07">July</option>
                                    <option value="08">August</option>
                                    <option value="09">September</option>
                                    <option value="10">October</option>
                                    <option value="11">November</option>
                                    <option value="12">December</option>
                                </select>

                            </div>

                            <div class="col-12 col-sm-3">

                                <label class="form-label" for="company">Employee</label>
                                <select id="EmpNo" class="select2 form-select form-control col-sm-4" name="EmpNo">
                                    <option value="">--Select Employee --</option>
                                    <?php
                                    foreach ($employees as $emp) {
                                        $select = (isset($empNo) and $empNo == $emp->EId) ? 'selected="selected"' : null;
                                        echo '<option ' . $select . ' value="' . $emp->EId . '">' . trim($emp->EmpName) . ' - ' . $emp->EmpNo . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>

                            <div class="col-12 col-sm-3">
                                <button name="submit" id="generate_report" name="make_payroll" type="submit" class="btn btn-info  mt-4"><i class="bx bx-update me-2"></i>Generate</button>
                            </div>
                        </div>




                    </div>
                </div>


            </div>

        </div>
    </div>

</form>

<?php $this->load->view("templates/common/footer"); ?>