<?php $this->load->view("templates/common/top_section"); ?>
<!-- Icons. Uncomment required icon fonts -->
<link rel="stylesheet" href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<link rel="stylesheet"
    href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
<!-- /section:basics/content.breadcrumbs -->
<!-- Basic Layout & Basic with Icons -->
<div class="row">
    <div class="col-md-6">
        <div class="card mb-12">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Apply Leave</h5>
            </div>
            <div class="card-body">


                <form class="form-horizontal needs-validation" novalidate
                    action="<?php echo base_url('leave_transaction/add_user_leave'); ?>" method="post" role="form">
                    <input type="hidden" value="<?=$this->session->userdata('EmpNo');?>" name="EmpNo" />
                    

                    <div class="mb-3">
                        <label class="form-label" for="name">Leave Code</label>
                        <select required class="select2 form-select form-control" name="Leave_Code" id="Leave_Code">
                            <option value="">Leave Code</option>
                            <?php
                            if (is_array($LeaveCodes)) {
                                foreach ($LeaveCodes as $code) {
                                    echo '<option ' . $select . ' value="' . $code->Leave_code . '">' . trim($code->Description) . '</option>';
                                }
                            }
                            ?>
                        </select>
                        <div class="invalid-feedback">
                            Leave is required.
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="form-check form-check-inline mt-3">
                            <input class="form-check-input" type="radio" required name="LeaveType" id="FullDay"
                                value="Full" />
                            <label class="form-check-label" for="FullDay">Full Day</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="LeaveType" id="HalfDay"
                                value="Full" />
                            <label class="form-check-label" for="HalfDay">Half Day</label>
                        </div>

                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="LeaveType" id="ShortLeave"
                                value="Short" />
                            <label class="form-check-label" for="ShortLeave">Short Leave</label>
                        </div>

                        <div class="invalid-feedback">
                            Type is required.
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="dateRangePicker" class="form-label">Leave (Form - To)</label>
                        <div class="input-group input-daterange" id="bs-datepicker-daterange">
                            <input type="text" id="LeaveFrom" name="LeaveFrom" placeholder="Leave From"
                                class="form-control">
                            <span class="input-group-text">to</span>
                            <input type="text" placeholder="LeaveTo" id="LeaveTo" name="LeaveTo" class="form-control">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="Installment">Num of Days</label>
                        <input type="text" min="1" value="1" class="form-control" onChange="return makeBalance();"
                            name="Days" id="Days" placeholder="0" required />
                        <div class="invalid-feedback">
                            Days is required.
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="Term">Reason</label>
                        <input type="text" class="form-control" name="Reason" id="Reason" placeholder="0" />

                    </div>
                    <input type="hidden" name="day" id="day" class="span2 Balance">
                    
                    <button type="submit" class="btn btn-primary">Add</button>
                </form>
            </div>
        </div>


    </div>


</div>

<?php $this->load->view("templates/common/footer"); ?>