<?php
ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');
require FCPATH . '/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
class ExcelReports extends MY_Controller {
    public function __construct()
    {
        parent::__construct();
        // Load database
        //$this->load->model('welcome_message');
    }


    public function etf()
    {
        $data = $this->data;
        $data['month'] = date('Y-m',strtotime('-1 month'));
        $data['page'] = 'epf_etf';
        $data['page_title'] = 'ETF';
        $data['heading'] = 'Reports';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/etf", $data);
    }

    public function etf_report()
    {
        ini_set('memory_limit','2048M');
        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load('excel/ETF.xls');
        $worksheet = $spreadsheet->getActiveSheet();
        $month = date('Y-m',strtotime('-1 month'));
        if ($this->input->get('month')) {
            $month = $this->input->get('month');
        }
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_month_etf_by_employees($month);
        //echo '<pre>',print_r($records); die();
        $format_month = date("Y-m", strtotime($month));
        //echo $format_month; die();
        $r = 5;
        if($records) {
            $i=0;
            
            foreach ($records as $d) {
                $worksheet->getCell('A' . $r)->setValue($d->IDNo);
                $worksheet->getCell('B' . $r)->setValue($d->EmpName);
                $worksheet->getCell('C' . $r)->setValue($d->EmpName);
                $worksheet->getCell('D' . $r)->setValue($d->EPFNo);
                $worksheet->getCell('E' . $r)->setValue($d->ETF);
                $worksheet->getCell('F' . $r)->setValue('B 11158');
                $worksheet->getCell('G' . $r)->setValue($format_month);
                $worksheet->getCell('H' . $r)->setValue($format_month);
                $r++;
            }
        }
        $styleArray = [
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '00000000'],
                ],
            ],
        ];
        $worksheet->getStyle('A5:H' . $r)->applyFromArray($styleArray);
        $name = "etf-".$month.".xls";
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xls');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="etf-'.$month.'.xls"');
        $writer->save("reports/".$name);
        $this->download("reports",$name);
    }


    public function epf()
    {
        $data = $this->data;
        $data['month'] = date('Y-m',strtotime('-1 month'));
        $data['page'] = 'epf_etf';
        $data['page_title'] = 'EPF';
        $data['heading'] = 'Reports';
        $data['message'] = view_error($this->messages->get());
        $this->load->view("templates/reports/epf", $data);
    }

    public function epf_report()
    {
        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load('excel/EPF.xls');
        $worksheet = $spreadsheet->getActiveSheet();
        $month = date('Y-m',strtotime('-1 month'));
        if ($this->input->get('month')) {
            $month = $this->input->get('month');
        }
        $this->load->model('reports/payslip_model');
        $records = $this->payslip_model->get_month_epf_by_employees($month);
        //echo '<pre>',print_r($records); die();
        $format_month = date("Y-m", strtotime($month));
        $r = 5;
        if($records)
        {
            $i=0;
            
            foreach ($records as $d) {
                $worksheet->getCell('A'.$r)->setValue($d->IDNo);
                $worksheet->getCell('B'.$r)->setValue($d->EmpName);
                $worksheet->getCell('C'.$r)->setValue($d->EmpName);
                $worksheet->getCell('D'.$r)->setValue($d->EPFNo);
                $worksheet->getCell('E'.$r)->setValue($d->EPF+$d->EPFepm);
                $worksheet->getCell('F'.$r)->setValue($d->EPFepm);
                $worksheet->getCell('G'.$r)->setValue($d->EPF);
                $worksheet->getCell('H'.$r)->setValue($d->salaryPayable);
                $worksheet->getCell('I'.$r)->setValue('E');
                $worksheet->getCell('J'.$r)->setValue('B');
                $worksheet->getCell('K'.$r)->setValue('11158');
                $worksheet->getCell('L'.$r)->setValue($format_month);
                $worksheet->getCell('M'.$r)->setValue(1);
                $worksheet->getCell('N'.$r)->setValue('1');
                $worksheet->getCell('O'.$r)->setValue('1');
                $r++;
            }
        }

        $styleArray = [
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '00000000'],
                ],
            ],
        ];
        $worksheet->getStyle('A5:O' . $r)->applyFromArray($styleArray);

        $name = "epf-".$month.".xls";
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xls');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'.$name.'.xls"');
        $writer->save("reports/".$name);
        $this->download("reports",$name);
    }


    function download($path,$file){
        $this->load->helper('download');
        $data = file_get_contents($path.'/'.$file);
        force_download($file, $data);
    }


}

?>