<?php
require_once("Main_model.php");
class User_model extends Main_model
{
	private $dbTable = 'user';
	
	public function _construct()
	{
		$this->load->database();
	}
	
	function get_all($limit=0,$offset=0)
	{
		$this->db->select('t.*','jt.Type');
		$this->db->from($this->dbTable.' AS t');
		$this->db->join($this->dbJoinTable.' AS jt', 't.Id = jt.UserId', 'left');
		if($limit!=0) $this->db->limit($limit,$offset);
		$query = $this->db->get();
		return $query->result();
	}
	
	function get_info($user_id='')
	{
		$this->db->select('t.*','jt.Type');
		$this->db->from($this->dbTable.' AS t');
		$this->db->join($this->dbJoinTable.' AS jt', 't.Id = jt.UserId');
		$this->db->where('t.Id',$user_id);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}
	/*
	Attempts to login employee and set session. Returns boolean based on outcome.
	*/
	function login($User_ID, $password)
	{
		$password_hass = hash('sha512', $password);
		$this->db->select('t.*,jt.*');
		$this->db->from($this->dbTable.' AS t');
		$this->db->join('comp AS jt', 't.Comp = jt.Code');
		$this->db->where("t.User_ID",$User_ID);
		$this->db->where("t.Password",$password_hass);
		$query = $this->db->get();
		//echo $this->db->last_query(); die();
		if ($query->num_rows()==1)
		{
			$row=$query->row();
			$user_data = array(
				'Comp' => $row->Comp,
				'Unit_Id' => $row->Unit_Id,
				'User_ID' => $row->User_ID,
				'Type' => $row->Type,
				'CompName' => trim($row->Name),
				'Address' => trim($row->Address),
				'logged_in' => TRUE
			);
			$this->session->set_userdata($user_data);
			//print_r($user_data); 
			//print_r($this->session->userdata($user_data)); die();
			return true;
		}
		return false;
	}
	/*
	Inserts or updates a user
	*/
	function save(&$user_data,$user_id=false,$user_type=2)
	{
		if (!$user_id)
		{
			if($this->db->insert('user',$user_data))
			{
				$user_data['id']=$this->db->insert_id();
				$this->db->insert('admin',array( 'u_id' => $user_data['id'] , 'super' => $user_type));
				return true;
			}
			return false;
		}

		$this->db->where('id', $user_id);
		$this->db->update('user',$user_data);
		$this->db->where('u_id', $user_id);
		return $this->db->update('admin',array('super' => $user_type));
	}
	
	/*
	Determins if a employee is logged in
	*/
	function is_logged_in()
	{
		//echo $this->session->userdata('user_id'); die();
		if($this->session->userdata('User_ID'))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}
?>