<?php
require_once("report.php");
class Summary_transaction extends Report
{
	private $tableMain = 'transaction';
	private $join = 'comp';
	private $join2 = 'employee';
	
	function __construct()
	{
		parent::__construct();
	}

	public function getDataColumns()
	{
		return array($this->lang->line('reports_date'), $this->lang->line('reports_subtotal'), $this->lang->line('reports_total'), $this->lang->line('reports_tax'), $this->lang->line('reports_profit'));
	}
	
	public function getData(array $inputs)
	{	
		//'t.Date, t.Type, t.No_Of_H_D, jt.EmpNo'
		$this->db->select('t.Date, t.Type, t.No_Of_H_D');
		$this->db->from($this->tableMain." AS t");
		$this->db->join($this->join2.' AS jt', 't.EmpNo = jt.EmpNo','left');
		foreach($inputs as $key=>$value)
		{
			if($key=='Date') $this->db->where("MONTH(t.".$key.")",$value);
			else $this->db->where('t.'.$key,$value);
		}
  		$query = $this->db->get();
		$ret = array();
		//echo $this->db->last_query();
		foreach($query->result() as $row)
		{
			$row->Type = get_tns_type($row->Type);
			$ret[] = $row;
		}
		return $ret;
	}
	
	public function getSummaryData(array $inputs)
	{
		$this->db->select('t.Date, t.Type, t.No_Of_H_D');
		$this->db->from($this->tableMain." AS t");
		$type_query = (isset($inputs['type'])) ? $this->db->where('t.Type',$inputs['type']): null;
		$date_query = (!empty($inputs['start_date']) and !empty($inputs['end_date'])) ?
		 $this->db->where( "t.Date BETWEEN '".$inputs['start_date']."' AND '".$inputs['end_date']."'", NULL, FALSE )
		 : null;
		$query = $this->db->get();
		$ret = array();
		//echo $this->db->last_query();
		foreach($query->result() as $row)
		{
			$row->Type = get_tns_type($row->Type);
			$ret[] = $row;
		}
		return $ret;
		return $query->result_array();	
	}
	
	public function get_all_employees($id=0,$limit=0,$offset=0)
	{
		$this->db->select('EmpNo, EmpName');
		$this->db->from($this->join2);
		$this->db->where('Comp',$this->_getComp());
		$this->db->where('Active',1);
		$query = $this->db->get();
		return $query->result();
	}
	
}
?>