<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Products extends CI_Controller {

    var $main_menu_name = "products";
	var $sub_menu_name = "products";

    public function __construct()
     {
            parent::__construct();
            $this->load->model('category_models');
            $this->load->model('product_models');
			$this->load->model('common_model');
	 }
	 //---------------------------------------------------------------------------
    public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$this->load->view('product/products',$data);
	}
	//---------------------------------------------------------------------------
	public function add_product()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] 	= 'add_products';
		$data['main_category'] 	= $this->category_models->getCategory();
		$data['unit_type'] 		= $this->product_models->getUnit();
		$data['brand_type'] 	= $this->product_models->getBrand();
		$data['color_type'] 	= $this->product_models->getColor();
		$data['tax'] 		    = $this->product_models->getTax();
		$this->load->view('product/add_product',$data);
	}
	//---------------------------------------------------------------------------
	public function get_sub_category_by_id()
	{
		$parent_category =  $this->input->get('category_id');

		if ( $parent_category ) {
			$val = $this->category_models->get_sub_category( $this->input->get('category_id') );
			if (!empty($val)) {
				echo '<select name="subcategory" id="subcategory" class="form-control search-select">';
				echo "<option value=''></option>";
				foreach ($val as $key => $lst) {
				echo "<option value='$lst->sub_cat_id'>$lst->sub_cat_name</option>";
				}
				echo '</select>';
			}			
		} else {
			echo NULL;
		}		
	}
	//---------------------------------------------------------------------------
	public function save_product()
	{
        $this->load->library('form_validation'); //form validation lib
        $this->form_validation->set_rules('product_name', 'Product Name', 'trim|required|xss_clean');
        $this->form_validation->set_rules('product_code', 'Product Code', 'trim|required|xss_clean|is_unique[product.product_code]');
        $this->form_validation->set_rules('product_cost', 'product cost', 'trim|required|xss_clean');
        $this->form_validation->set_rules('product_price', 'product price', 'trim|required|xss_clean');
        $this->form_validation->set_rules('wholesale_price', 'wholesale price', 'trim|required|xss_clean');
        $this->form_validation->set_rules('credit_salling_price', 'credit salling price', 'trim|required|xss_clean');	
		$this->form_validation->set_rules('brand', 'Brand', 'trim|required|xss_clean');
		$this->form_validation->set_rules('color', 'Color', 'trim|required|xss_clean');
		$this->form_validation->set_rules('category', 'Category', 'trim|required|xss_clean');
		$this->form_validation->set_rules('subcategory', 'Sub category', 'trim|required|xss_clean');	
		$this->form_validation->set_rules('unit', 'unit', 'trim|required|xss_clean');
		$this->form_validation->set_rules('store_position', 'store position', 'trim|xss_clean');
		$this->form_validation->set_rules('product_details', 'product details', 'trim|xss_clean');
        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
        	$product_name 			= $this->input->post('product_name');
        	$product_code 			= $this->input->post('product_code');
        	$category 	  			= $this->input->post('category');
        	$subcategory  			= $this->input->post('subcategory');
			$brand		  			= $this->input->post('brand');
			$color		  			= $this->input->post('color');
        	$unit 		  			= $this->input->post('unit');
        	$product_cost 			= $this->price_filter($this->input->post('product_cost'));
        	$product_price 			= $this->price_filter($this->input->post('product_price'));
        	$wholesale_price 		= $this->price_filter($this->input->post('wholesale_price'));
        	$credit_salling_price 	= $this->price_filter($this->input->post('credit_salling_price'));
        	$tax 					= $this->input->post('tax');
        	$alert_quty 			= $this->input->post('alert_quty');
        	$product_details 		= $this->input->post('product_details');
			$product_part_no 		= $this->input->post('product_part_no');
			$product_oem_part_number=$this->input->post('product_oem_part_number');
			$product_id=$this->input->post('product_id');
			$store_position=$this->input->post('store_position');
			$product_max_qty=$this->input->post('product_max_qty');
			//------------------------------------------------------------
        	if (!empty($_FILES["userfile"]['name'])) {
                $image_name_enc = "PRODUCT_".time().$_FILES["userfile"]['name'];
                $this->load->library('upload',$this->image_manipulation->product_image_config($image_name_enc));
                if ( ! $this->upload->do_upload()){
                   $st = array('status' =>0,'validation' => $this->upload->display_errors());
                   echo json_encode($st);
                }
                else{

                    $this->load->library('image_lib',$this->image_manipulation->product_image_thumb($image_name_enc,100,100));
                    if ( ! $this->image_lib->resize())
                    {
                        echo $this->image_lib->display_errors();
                    }
                    else
                    {
                      $imgName    = $this->upload->data();
                      $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
					//data array_start
						 $data1 = array(
							'cat_id'  				=> $category,
							'sub_cat_id'  			=> $subcategory,
       						'product_name'        	=> $product_name,
     						'product_code'			=> $product_code,
							'product_image'        	=> $imgName['file_name'],
       						'product_thumb' 		=> $imageThumb,
       						'product_alert_qty'  	=> $alert_quty,
       						'product_unit'  		=> $unit,
       						'product_cost'  		=> $product_cost,
       						'product_price'			=> $product_price,
       						'wholesale_price'  		=> $wholesale_price,
       						'credit_salling_price'  => $credit_salling_price,
       						'tax'  					=> $tax,
       						'product_details' 		=> $product_details,
							'product_part_no' 		=> $product_part_no,
							'product_oem_part_number' => $product_oem_part_number,
							'store_position'=>$store_position,
							'product_max_qty'=>$product_max_qty,
							'brand_id'=>$brand,
							'color_id'=>$color,
						 	);
					//data array_start
                      $last_id = $this->product_models->save_product($data1);  
                       if ($last_id) {
                               $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$last_id+1));
                               echo json_encode($st);

                       } else {
                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }
                       $this->image_lib->clear();
                    } 
                }
        	} else {
				//----------------------------------------------
				 $data2 = array(
							'cat_id'  				=> $category,
							'sub_cat_id'  			=> $subcategory,
       						'product_name'        	=> $product_name,
     						'product_code'			=> $product_code,
       						'product_alert_qty'  	=> $alert_quty,
       						'product_unit'  		=> $unit,
       						'product_cost'  		=> $product_cost,
       						'product_price'			=> $product_price,
       						'wholesale_price'  		=> $wholesale_price,
       						'credit_salling_price'  => $credit_salling_price,
       						'tax'  					=> $tax,
       						'product_details' 		=> $product_details,
							'product_part_no' 		=> $product_part_no,
							'product_oem_part_number' => $product_oem_part_number,
							'store_position'=>$store_position,
							'product_max_qty'=>$product_max_qty,
					 		'brand_id'=>$brand,
							'color_id'=>$color,
						 	);		
				
					  //----------------------------------------------
                      $last_id = $this->product_models->save_product($data2);
                       if ($last_id) {

                               $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$last_id+1));
                               echo json_encode($st);

                       } else {

                               $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
                               echo json_encode($st);
                       }
        	}        	
        }
	}
	//----------------------------------------------------------------------------------------------------
	function price_filter($amount='')
	{
		$s = explode("Rs.",$amount);
		return str_replace(',', '', $s[1]);
	}
	//---------------------------------------------------------------------------
	public function get_list_product($value='')
	{
		$search_key=$this->input->get('search');
		$search_key_val=$search_key['value'];
		$start=$this->input->get('start');
		$length=$this->input->get('length');
		$totalData = 0;		
	    $values = $this->product_models->getProducts($start,$length,$search_key_val);			
		$value_count = $this->product_models->getProducts('','','');
		if($search_key_val){
			$values_c = $this->product_models->getProducts('','',$search_key_val);
			$totalData = count($values_c);	
			}		
		$totalData = $value_count;
		$totalFiltered = $totalData; 		 
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $products) {
				$k ='';	          
			    if ($products->product_status == 0) {$k = "btn-danger";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
              $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;
              
	            $row = array();
				$qty = 0;
				$row[] = '<div style="margin-bottom: 0px; width: 50px; height: 50px;" class="fileupload-new thumbnail"><img alt="" src="'.base_url()."uploads/product/image/thumbs/".$products->product_thumb.'"></div>';
                $row[] =$products->product_code;                
	            $row[] = $products->product_name;
				$row[] = $products->cat_name;
	            $row[] = $retVal;
				if ($this->session->userdata('ss_group_id')==1 || $this->session->userdata('ss_group_id')==2 ){     
				$row[] = $products->product_cost;
				}
				$row[] = $products->wholesale_price;
				$row[] = $products->credit_salling_price;                
                $row[] = $products->product_price;	               
	            $row[] = $qty;	               
	            $actdes='';
	                $actdes =$actdes. '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs '.$k.' dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="'.base_url('products/view').'/'.$products->product_id.'"><i class="fa fa-file-text-o"></i> Product Details</a></li>
							';
							if ($this->session->userdata('ss_group_id')==1 ||$this->session->userdata('ss_group_id')==2){
                        $actdes =$actdes. '    <li><a href="'.base_url('products/edit').'/'.$products->product_id.'"><i class="fa fa-edit"></i> Edit Product</a></li>
							<li class="divider"></li><li><a onclick="product_delete('.$products->product_id.'); return false;" href="#"><i class="fa fa-trash-o"></i> Delete Product</a></li>
							';
							}
						$actdes = $actdes.'	
							<li><a onclick=" print_barcode('.$products->product_id.'); return false;" href="#"><i class="fa fa-print"></i> Print Barcode</a></li>
							<li><a href="'.base_url('products/upload_images').'/'.$products->product_id.'"><i class="fa fa-edit"></i> Upload Images</a></li>
							<li><a href="'.base_url('products/update_specification').'/'.$products->product_id.'"><i class="fa fa-edit"></i> Update Specification</a></li>


							
                            </ul></div>';							
					$row[] =$actdes;						
	                $data[] = $row;				
	            }

	            $output = array('data' =>$data,"recordsTotal"    => intval( $totalData ),  
				"recordsFiltered" => intval( $totalFiltered ));
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	//---------------------------------------------------------------------------
  public function view($product_id = "")
  { 
    $sd = $this->product_models->get_product_by_id($product_id);
    if(!empty($sd)){

          $data['product_details'] = $this->product_models->get_product_by_id($product_id);
          $data['warehouses'] = $this->product_models->get_warehouse_product($product_id);
          $data['main_menu_name'] = $this->main_menu_name;
          $data['sub_menu_name'] = $this->sub_menu_name;
          $this->load->view('product/view_product',$data);
    }else{
          show_404();
    }
  }
  //---------------------------------------------------------------------------
  public function edit($product_id='')
  {
          $data['main_menu_name'] = $this->main_menu_name;
          $data['sub_menu_name']  = $this->sub_menu_name;
          $data['main_category']  = $this->category_models->getCategory();
          $data['unit_type']      = $this->product_models->getUnit();
          $data['tax']            = $this->product_models->getTax();
          $data['product_details'] = $this->product_models->get_product_by_id($product_id);
		  $data['sub_category']   = $this->category_models->getSubCategory($data['product_details']->cat_id);
		  $data['brand_type'] 	= $this->product_models->getBrand();
		  $data['color_type'] 	= $this->product_models->getColor();
          $this->load->view('product/edit_product',$data);
  }
  //---------------------------------------------------------------------------
  public function single_barcode($product_id='')
  {
    $data['product_details'] = $this->product_models->get_product_by_id($product_id);
    $this->load->view('barcode/product_barcode',$data);
  }
  //---------------------------------------------------------------------------
    function gen_barcode($product_code = NULL, $height = 80)
    {
      if($this->input->get('code')){ $product_code = $this->input->get('code'); }
      if($this->input->get('height')){ $height = $this->input->get('height'); }    
    //load library
    $this->load->library('zend');
    //load in folder Zend
    $this->zend->load('Zend/Barcode');
    //'drawText' => FALSE
    $barcodeOptions = array('text' => $product_code, 'barHeight' => $height, 'stretchText' => TRUE );
    $rendererOptions = array('imageType'=>'png', 'horizontalPosition' => 'center', 'verticalPosition' => 'middle');
    $imageResource = Zend_Barcode::render('code128', 'image', $barcodeOptions, $rendererOptions);
    return $imageResource;     
    }
	//---------------------------------------------------------------------------
  function delete_product($product_id='')
  {
    $d = $this->product_models->delete_product($this->input->post('product_id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }    
  }
  //---------------------------------------------------------------------------
  public function update_product()
  {     
	$this->load->library('form_validation'); //form validation lib
	$this->form_validation->set_rules('product_name', 'Product Name', 'trim|required|xss_clean');
	//$this->form_validation->set_rules('product_code', 'Product Code', 'trim|required|xss_clean|is_unique[product.product_code]');
	$this->form_validation->set_rules('product_cost', 'product cost', 'trim|required|xss_clean');
	$this->form_validation->set_rules('product_price', 'product price', 'trim|required|xss_clean');
	$this->form_validation->set_rules('wholesale_price', 'wholesale price', 'trim|required|xss_clean');
	$this->form_validation->set_rules('credit_salling_price', 'credit salling price', 'trim|required|xss_clean');	
	$this->form_validation->set_rules('brand', 'Brand', 'trim|required|xss_clean');
	$this->form_validation->set_rules('color', 'Color', 'trim|required|xss_clean');
	$this->form_validation->set_rules('category', 'Category', 'trim|required|xss_clean');
	$this->form_validation->set_rules('subcategory', 'Sub category', 'trim|required|xss_clean');	
	$this->form_validation->set_rules('unit', 'unit', 'trim|required|xss_clean');
	$this->form_validation->set_rules('store_position', 'store position', 'trim|xss_clean');
	$this->form_validation->set_rules('product_details', 'product details', 'trim|xss_clean');
	$this->form_validation->set_rules('product_id', 'product details', 'required|trim|xss_clean');
	if ($this->form_validation->run() == FALSE)
	{
	   $st = array('status' =>0,'validation' => validation_errors());
	   echo json_encode($st);
	}
	else
	{
		$product_id 			= $this->input->post('product_id');
		$product_name 			= $this->input->post('product_name');
		//$product_code 			= $this->input->post('product_code');
		$category 	  			= $this->input->post('category');
		$subcategory  			= $this->input->post('subcategory');
		$brand		  			= $this->input->post('brand');
		$color		  			= $this->input->post('color');
		$unit 		  			= $this->input->post('unit');
		$product_cost 			= $this->price_filter($this->input->post('product_cost'));
		$product_price 			= $this->price_filter($this->input->post('product_price'));
		$wholesale_price 		= $this->price_filter($this->input->post('wholesale_price'));
		$credit_salling_price 	= $this->price_filter($this->input->post('credit_salling_price'));
		$tax 					= $this->input->post('tax');
		$alert_quty 			= $this->input->post('alert_quty');
		$product_details 		= $this->input->post('product_details');
		$product_part_no 		= $this->input->post('product_part_no');
		$product_oem_part_number=$this->input->post('product_oem_part_number');
		$product_id=$this->input->post('product_id');
		$store_position=$this->input->post('store_position');
		$product_max_qty=$this->input->post('product_max_qty');
		//------------------------------------------------------------
		if (!empty($_FILES["userfile"]['name'])) {
			$image_name_enc = "PRODUCT_".time().$_FILES["userfile"]['name'];
			$this->load->library('upload',$this->image_manipulation->product_image_config($image_name_enc));
			if ( ! $this->upload->do_upload()){
			   $st = array('status' =>0,'validation' => $this->upload->display_errors());
			   echo json_encode($st);
			}
			else{

				$this->load->library('image_lib',$this->image_manipulation->product_image_thumb($image_name_enc,100,100));
				if ( ! $this->image_lib->resize())
				{
					echo $this->image_lib->display_errors();
				}
				else
				{
				  $imgName    = $this->upload->data();
				  $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
				//data array_start
					 $data1 = array(
						'cat_id'  				=> $category,
						'sub_cat_id'  			=> $subcategory,
						'product_name'        	=> $product_name,
						//'product_code'			=> $product_code,
						'product_image'        	=> $imgName['file_name'],
						'product_thumb' 		=> $imageThumb,
						'product_alert_qty'  	=> $alert_quty,
						'product_unit'  		=> $unit,
						'product_cost'  		=> $product_cost,
						'product_price'			=> $product_price,
						'wholesale_price'  		=> $wholesale_price,
						'credit_salling_price'  => $credit_salling_price,
						'tax'  					=> $tax,
						'product_details' 		=> $product_details,
						'product_part_no' 		=> $product_part_no,
						'product_oem_part_number' => $product_oem_part_number,
						'store_position'=>$store_position,
						'product_max_qty'=>$product_max_qty,
						'brand_id'=>$brand,
						'color_id'=>$color,
						 );
				//data array_start
				  $last_id = $this->product_models->update_product($data1,$product_id);  
				   if ($last_id) {
						   $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
						   echo json_encode($st);

				   } else {
						   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
						   echo json_encode($st);
				   }
				   $this->image_lib->clear();
				} 
			}
		} else {
			//----------------------------------------------
			 $data2 = array(
						'cat_id'  				=> $category,
						'sub_cat_id'  			=> $subcategory,
						'product_name'        	=> $product_name,
						//'product_code'			=> $product_code,
						'product_alert_qty'  	=> $alert_quty,
						'product_unit'  		=> $unit,
						'product_cost'  		=> $product_cost,
						'product_price'			=> $product_price,
						'wholesale_price'  		=> $wholesale_price,
						'credit_salling_price'  => $credit_salling_price,
						'tax'  					=> $tax,
						'product_details' 		=> $product_details,
						'product_part_no' 		=> $product_part_no,
						'product_oem_part_number' => $product_oem_part_number,
						'store_position'=>$store_position,
						'product_max_qty'=>$product_max_qty,
						 'brand_id'=>$brand,
						'color_id'=>$color,
						 );		
			
				  //----------------------------------------------
				  $last_id = $this->product_models->update_product($data2,$product_id);
				   if ($last_id) {

						   $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
						   echo json_encode($st);

				   } else {

						   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
						   echo json_encode($st);
				   }
		}        	
	}
  }
  //---------------------------------------------------------------------------
  public function upload_images($product_id='')
  {
          $data['main_menu_name'] = $this->main_menu_name;
          $data['sub_menu_name']  = $this->sub_menu_name;          
		  $data['product_details'] = $this->product_models->get_product_by_id($product_id);

		  $data['images'] = $this->product_models->list_product_image($product_id);
		  
		 
          $this->load->view('product/upload_images',$data);
  }
  //----------------------------------------------------------------------------

  public function save_images()
  {     
	$this->load->library('form_validation'); //form validation lib
	$this->form_validation->set_rules('product_id', 'product details', 'required|trim|xss_clean');
	if ($this->form_validation->run() == FALSE)
	{
	   $st = array('status' =>0,'validation' => validation_errors());
	   echo json_encode($st);
	}
	else
	{
		$product_id 			= $this->input->post('product_id');
		
		//------------------------------------------------------------
		if (!empty($_FILES["userfile"]['name'])) {
			$image_name_enc = "PRODUCT_".time().$_FILES["userfile"]['name'];
			$this->load->library('upload',$this->image_manipulation->product_image_config($image_name_enc));
			if ( ! $this->upload->do_upload()){
			   $st = array('status' =>0,'validation' => $this->upload->display_errors());
			   echo json_encode($st);
			}
			else{

				$this->load->library('image_lib',$this->image_manipulation->product_image_thumb($image_name_enc,100,100));
				if ( ! $this->image_lib->resize())
				{
					echo $this->image_lib->display_errors();
				}
				else
				{
				  $imgName    = $this->upload->data();
				  $imageThumb = $imgName['raw_name']."_thumb".$imgName['file_ext'];
				//data array_start
					 $data1 = array(
						 'product_id'			=>$product_id,
						'product_image'        	=> $imgName['file_name'],
						'product_thumb' 		=> $imageThumb,						
						 );
				//data array_start
				  $last_id = $this->product_models->save_images($data1);  
				   if ($last_id) {
						   $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
						   echo json_encode($st);

				   } else {
						   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
						   echo json_encode($st);
				   }
				   $this->image_lib->clear();
				} 
			}
		} else {
			//----------------------------------------------
			 $data2 = array(						
						 );		
			
				  //----------------------------------------------
				  $last_id = $this->product_models->save_images($data2);
				   if ($last_id) {

						   $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
						   echo json_encode($st);

				   } else {

						   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
						   echo json_encode($st);
				   }
		}        	
	}
  }
  //---------------------------------------------------------------------------
  function delete_image($product_id='')
  {
    $d = $this->product_models->delete_image($this->input->get('id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }    
  }
  //-----------------------------------------------------------------------------
    //---------------------------------------------------------------------------
	public function update_specification($product_id='')
	{
			$data['main_menu_name'] = $this->main_menu_name;
			$data['sub_menu_name']  = $this->sub_menu_name;          
			$data['product_details'] = $this->product_models->get_product_by_id($product_id);  
			$data['specification'] = $this->product_models->list_product_specification($product_id);	   
			$this->load->view('product/product_specification',$data);
	}
	//----------------------------------------------------------------------------

  public function save_specification()
  {     
	$this->load->library('form_validation'); //form validation lib
	$this->form_validation->set_rules('product_id', 'product details', 'required|trim|xss_clean');
	$this->form_validation->set_rules('specification_name', 'Specification category', 'required|trim|xss_clean');
	$this->form_validation->set_rules('specification_value', 'Specification value', 'required|trim|xss_clean');
	if ($this->form_validation->run() == FALSE)
	{
	   $st = array('status' =>0,'validation' => validation_errors());
	   echo json_encode($st);
	}
	else
	{
		$product_id 		= $this->input->post('product_id');		
		$specification_name 		= $this->input->post('specification_name');	
		$specification_value 		= $this->input->post('specification_value');	
		 $data1 = array(
						 'product_id'			=>$product_id,
						'specification_name'    => $specification_name,
						'specification_value' 	=> $specification_value,						
						 );
				//data array_start
				  $last_id = $this->product_models->save_specification($data1);  
				   if ($last_id) {
						   $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%04d",$product_id));
						   echo json_encode($st);

				   } else {
						   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
						   echo json_encode($st);
				   }
				
		}        	
		
  }
  //---------------------------------------------------------------------------
 
  function delete_specification($product_id='')
  {
    $d = $this->product_models->delete_specification($this->input->get('id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This product is already linked. You cannot delete it.');
      echo json_encode($e);
    }    
  }






  //-----------------------------------------------------
}