<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Mobile extends CI_Controller{
    
    function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('session');
        $this->load->library('cart');
        $this->load->model('User_Model');
        $this->load->model('Home_Model');
        $this->load->model('product_model');
        $this->load->helper('security');
        $this->load->model('Cart_Model');
        
        if(is_logged_in()){
            redirect(base_url());
        }
        date_default_timezone_set("asia/Colombo");
    }

    public function index(){
        $data=array('status'=>0,'error'=>1,'msg'=>"access denided");
        echo json_encode($data);
    }
    
    public function getDailyDeals(){
        $product_list = $this->product_model->getTopDeals(10);
        $top_flash_30=$this->product_model->flash_deal_multi_product($product_list);	
        $product_list = $this->product_model->getTopDeals(25);
		$top_flash_50=$this->product_model->flash_deal_multi_product($product_list);	
        $product_list = $this->product_model->getTopDeals(50);
        $top_flash_70=$this->product_model->flash_deal_multi_product($product_list);
        $data=array('top_flash_30'=>$top_flash_30,'top_flash_50'=>$top_flash_50,'top_flash_70'=>$top_flash_70);
        echo json_encode($data);

    }

    public function getDailyDealsAll(){
        $this->load->library('form_validation'); //form validation lib		
        //validations
        $this->form_validation->set_rules('value', 'Value', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        } else
        {	
        $value=$this->input->post('value');	
        $product_list = $this->product_model->getTopDealsAll($value);
        $top_flash=$this->product_model->flash_deal_multi_product($product_list);
        $data=array('top_flash'=>$top_flash,'status' =>1,'message' => validation_errors());
        echo json_encode($data);
        }

    }

    public function getSpecialOffers(){      
        $product_list= $this->Home_Model->get_specical_offer_top_list_mobile();	
        $result=$this->product_model->flash_deal_multi_product($product_list);
        $data=array('special_offer'=>$result,'status' =>1,'message' => "done");
        echo json_encode($data);
    }



    
    public function get_latest(){
        $data['latest'] = $this->Home_Model->get_latest();
        $data['home_product'] = $this->home_Home_Modelmodel->home_product();
        $data['home_accessoreis'] = $this->Home_Model->home_accessoreis();
        $data['home_services'] = $this->Home_Model->home_services();
        
        echo json_encode($data);
    }
    

    public function get_all_category(){
        $data['categories'] = $this->Home_Model->get_category_for_homepage();        
        echo json_encode($data);
    }
    
    
    public function signup() {
        $this->load->library('form_validation'); //form validation lib		
		//validations
		$this->form_validation->set_rules('email', 'User Name or E-mail', 'trim|required|min_length[4]|max_length[40]|xss_clean');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[6]|max_length[40]|xss_clean|matches[com_password]');
		$this->form_validation->set_rules('com_password', 'Confirm Password', 'trim|required|min_length[6]|max_length[40]|xss_clean');
		//check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $cus_id='';
            $status=1;            
            $message="somthing going worng";
            $email=$this->input->post('email');
		    $password=$this->input->post('password');
		    $com_password=$this->input->post('com_password');
           //check pasord are matched
            if($com_password==$password){
                $status=1;
                $message="passwords matched";
            }else{
                $status=0;
                $message="passwords not matched!";
            }
            //check alrady using username
            if($status==1)
            {
                $result = $this->User_Model->check_user($email);
                if($result==0)
                {
                    $status=1;
                    $message="User availble";
                }else{
                    $status=0;
                    $message="User already exist!";
                }
            }
            if($status==1)
            {
                $user_data=array('user_name'=>$email,'paswrd'=>$com_password);
                
                $result = $this->User_Model->save_user($user_data);
                if($result==0){
                    $status=0;
                    $message="Somthing worng while register user. please try again!";
                }else{
                    $user_id=$result;
                    $status=1;
                    $message="User availble"; 
                    $cus_code=$this->User_Model->gen_code('cus_id','customer','CUSMOB');                   
                    $customer_data=array('cus_email'=>$email,'reg_user_id'=>$result,'cus_type'=>'MOB');
                    $result = $this->User_Model->save_user_customer_profile($customer_data);
                    $cus_id=$result;
                    if($result==0){
                        $status=0;
                        $message="Somthing worng while register user. please try again!";
                    }else{
                        $status=1;
                        $message="customer profile saved"; 
                        //email sent
                        if(isset($cus_id)){
                            $cusdata = $this->User_Model->get_customer_details($cus_id); 
                            $confierm_code=mt_rand(100000, 999999);
                            $user =$this->User_Model->get_user_id_by_cus_id_only($cus_id);
                            $user_data=array(
                                'comfirmation_code'=>$confierm_code,                       
                            );
                            $user_id=$cusdata['reg_user_id'];
                            $email=$cusdata['cus_email'];
                            $result=$this->User_Model->update_user($user_id,$user_data);
                            $data['cus_data'] =$cusdata;                           
                            //-------------------------------------------------
                            $body    =  '<html>
                            <head>
                            <title>Account Verfication</title>
                            </head>
                            <body>
                            <h3>Account Verfication</h3>
                            <body>   
                            Confirmation Code : '.$confierm_code.' 
                            <hr>
                            use this code to verify your account
                            <hr>
                            Thank You<br>
                            Team Siyallanka
                            <hr>Note - please note this is an auto generated email. please do not reply to this email. 
                            </body></html>';//$this->load->view('employer/employer_email/selected_mail', $data1, TRUE);
                            $subject = 'Siyallanka password reset , Confirmation code';           
                            $this->load->library('email');
                            $config['protocol'] = "SMTP";
                            $config['smtp_host'] = "smtp.gmail.com";
                            $config['smtp_port'] = "465";
                            $config['smtp_user'] = "sachithworks@gmail.com";
                            $config['smtp_pass'] = "demo1234((";
                            $config['charset'] = "iso-8859-1";
                            $config['mailtype'] = "html";
                            $config['newline'] = "\r\n";
                            $config['validation'] = TRUE;
                            $this->email->initialize($config);          
                            $this->email->from('noreply@siyallanka.com'); 
                            $this->email->to($email);
                            $this->email->set_mailtype("html");
                            $this->email->subject($subject);
                            $this->email->message($body);
                            $responce =$this->email->send();
                            if ($responce) {
                                $email_status = 1;
                            } else {
                                $email_status = 0;
                               // print_r($this->email->print_debugger());  
                            }  
                        }                      
                        //email sent end
                        //CREATE TEMP USER LOGING
                        //$the_session = array("site_user" =>  $user_id, "site_cus" => $cus_id, "login_type" => "temp", "cus_name" => $email);
                        //$this -> session -> set_userdata($the_session);
                    }
                }
            }
            $st = array('status' =>$status,'message' => $message,'site_cus' => $cus_id) ;
            echo json_encode($st);
        }
    }

        public function confirmUser() {
            $this->load->library('form_validation'); //form validation lib		
            //validations
            $this->form_validation->set_rules('code', 'Confirmation Code', 'trim|required|min_length[4]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('site_cus', 'Customer', 'trim|required|xss_clean');
            //check validation	
             if ($this->form_validation->run() == FALSE)
            {
               $st = array('status' =>0,'message' => validation_errors());
               echo json_encode($st);
            }
            else
            {
                //$cus_id=$this -> session -> userdata('site_cus');
                $status=1;            
                $message="somthing going worng";
                $cus_id=$this->input->post('site_cus');
                $code=$this->input->post('code');          
               
                    $result =$this->User_Model->check_code($cus_id,$code);
                    if($result==1){
                        $status=1; $message="password is correct";
                        $user =$this->User_Model->get_user_id_by_cus_id_only($cus_id);
                        $user_data=array(
                            'is_confirm'=>1,
                            'last_modified_date_time'=> date("Y-m-d H:i:s")  ,
                            'last_modify_by'=> $user['reg_user_id']        
                        );
                        $user_id=$user['reg_user_id'];
                        $result=$this->User_Model->update_user($user_id,$user_data);
                        if($result==1){
                            $status=1; $message="Successfully Updated";
                           
                        }else{
                            $status=0; $message="Somthing going worng while confirm in your account ";
                        }
                  
                }
                //------------------------------------           
                $st = array('status' =>$status,'message' => $message) ;
                echo json_encode($st);
            }
        }

        public function login() {
            $this->load->library('form_validation'); //form validation lib		
            //validations
            $this->form_validation->set_rules('username', 'User Name or E-mail', 'trim|required|min_length[6]|max_length[40]|xss_clean');
            $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[6]|max_length[40]|xss_clean');
            $this->form_validation->set_rules('target', 'Link', 'trim|xss_clean');
            //check validation	
             if ($this->form_validation->run() == FALSE)
            {
               $st = array('status' =>0,'message' => validation_errors());
               echo json_encode($st);
            }
            else
            {
                
                $status=1;            
                $message="somthing going worng";
                $email=$this->input->post('username');
                $password=$this->input->post('password');                
                //check alrady using username               
                if($status==1)
                {
                    $result = $this->User_Model->check_user_password($email,$password);
                    if($result==1)
                    {
                        $status=1;
                        $message="User availble";
                        $user_data=$this->User_Model->get_user_details($email,$password);
                    }else{
                        $status=0;
                        $message="Login credentials not found";
                        $user_data=array();
                    }
                }           
                $st = array('status' =>$status,'message' => $message,'cus_details'=>$user_data) ;
                echo json_encode($st);
            }
        }

        function get_customer_details(){

            $this->load->library('form_validation'); //form validation lib		
            //validations
            $this->form_validation->set_rules('site_cus', 'Customer', 'trim|required|xss_clean');
            if ($this->form_validation->run() == FALSE)
            {
               $st = array('cus_data'=>null,'status' =>0,'message' => validation_errors());
               echo json_encode($st);
            } else
            {	
            $value=$this->input->post('site_cus');	
            $user_data = $this->User_Model->get_customer_details($value);
            $data=array('cus_data'=>$user_data,'status' =>1,'message' => validation_errors());
            echo json_encode($data);
            }
        }

        function get_city_list(){         
           
            $user_data = $this->Home_Model->get_city_list();
            $data=array('city_data'=>$user_data,'status' =>1,'message' =>"done");
            echo json_encode($data);
        }
        // mobile order place----------------------------------------------------------

        function placeOrder(){
        $redirect="cart/orderCompleted";
        $this->load->library('form_validation'); //form validation lib		
        $this->form_validation->set_rules('billing_first_name', 'First Name', 'trim|required|min_length[3]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('billing_last_name', 'Last Name', 'trim|required|min_length[3]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('billing_company', 'Company', 'trim|max_length[255]|xss_clean');
        $this->form_validation->set_rules('billing_country', 'Country', 'trim|required|xss_clean');
        $this->form_validation->set_rules('billing_address_1', 'Address', 'trim|required|min_length[3]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('billing_address_2', 'Apartment , Site , Unit', 'trim|max_length[500]|xss_clean');
        $this->form_validation->set_rules('billing_city', 'City', 'trim|required|xss_clean');
        $this->form_validation->set_rules('billing_postcode', 'ZIP code', 'trim|required|min_length[3]|max_length[20]|xss_clean');
        $this->form_validation->set_rules('billing_phone', 'Mobile', 'trim|required|min_length[10]|max_length[15]|xss_clean');
        $this->form_validation->set_rules('billing_email', 'Email', 'trim|required|min_length[3]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('ship_to_different_address', 'Diffarant Address', 'trim|xss_clean');
        $this->form_validation->set_rules('terms', 'trems', 'trim|xss_clean');    
        $this->form_validation->set_rules('payment_method', 'Payment Methord', 'trim|required|xss_clean');
        $this->form_validation->set_rules('terms-field', 'Term Field', 'trim|required|xss_clean'); 
        $this->form_validation->set_rules('order_comments', 'Commente', 'trim|max_length[500]|xss_clean'); 
        $this->form_validation->set_rules('cart', 'Product', 'trim|max_length[500]|xss_clean');   
        $ship_to_different_address=$this->input->post('ship_to_different_address');
        if($ship_to_different_address==1){
        $this->form_validation->set_rules('shipping_first_name', 'First Name', 'trim|required|min_length[3]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('shipping_last_name', 'Last Name', 'trim|required|min_length[3]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('shipping_company', 'Company', 'trim|xss_clean');
        $this->form_validation->set_rules('shipping_country', 'Country', 'trim|xss_clean');
        $this->form_validation->set_rules('shipping_address_1', 'Address', 'trim|required|min_length[3]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('shipping_address_2', 'Address 2', 'trim|max_length[500]|xss_clean');
        $this->form_validation->set_rules('shipping_city', 'City', 'trim|required|xss_clean');
        $this->form_validation->set_rules('shipping_state', 'State', 'trim|xss_clean');
        $this->form_validation->set_rules('shipping_postcode', 'ZIP code', 'trim|required|min_length[3]|max_length[20]|xss_clean'); 
        }
        //check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {

            $cart=stripslashes($this->input->post('cart'));
            $temp_product=json_decode($cart);
            $product_list=$temp_product->cart;
            $status=1;            
            $message="fist step ok";            
            $terms_field=$this->input->post('terms');            
            if($terms_field=="on"){
            $status=1;            
            $message="term and condition accepted";
            
            $cart_count =count($product_list);            
            if($cart_count>0){
                $status=1;            
                $message="term and condition accepted";
                }else{
                    $status=0;            
                    $message="Your Cart is empty!";
                }
            }else{
                $status=0;            
                $message="please accept the terms & conditions";
            }          
            $billing_first_name=$this->input->post('billing_first_name');
		    $billing_last_name=$this->input->post('billing_last_name');
            $billing_company=$this->input->post('billing_company');
            $billing_country=$this->input->post('billing_country');
            $billing_address_1=$this->input->post('billing_address_1');
            $billing_address_2=$this->input->post('billing_address_2');
            $billing_city=$this->input->post('billing_city');  
            $billing_postcode=$this->input->post('billing_postcode');  
            $billing_phone=$this->input->post('billing_phone');  
            $billing_email=$this->input->post('billing_email');  
            $payment_method=$this->input->post('payment_method');            
            $cus_id=$this->input->post('site_cus');   
            $order_comments=$this->input->post('order_comments');    
            if($ship_to_different_address==1){
            $shipping_first_name=$this->input->post('shipping_first_name');
		    $shipping_last_name=$this->input->post('shipping_last_name');
            $shipping_company=$this->input->post('shipping_company');
            $shipping_address_1=$this->input->post('shipping_address_1');
            $shipping_address_2=$this->input->post('shipping_address_2');
            $shipping_city=$this->input->post('shipping_city');
            $shipping_postcode=$this->input->post('shipping_postcode');
            }else{
                $ship_to_different_address=0;
            }
            if($cus_id>0){
                if($status==1){
                    $order_item_array=array();
                    $cus_data = $this->User_Model->get_customer_details($cus_id);               
                    $city_shipping_cost=$cus_data['shiiping_cost']*$cus_data['distance_category_value'];
                    $total_original_value=0;
                    $total_order_value=0;	
                    $total_discount_value=0;
                    $qty_total=0;
                    $total_cost=0;
                    $total_shiipping_cost=0;
                    $stock_availble_status=1;
                    foreach($product_list as $ca){
                     $product_id=$ca->product_id;
                     $qty=$ca->qty;
                     $product_details = $this->product_model->get_single_product($product_id);	
                     $product_shipping_cost=$product_details['sh_cat_value'];
                     $total_shiipping_cost+=$product_shipping_cost*$city_shipping_cost;
                     $qty_total+= $qty;
                     $total_cost+=$product_details['product_cost']*$qty;
                     $total_original_value+=$product_details['original_price']*$qty;
                     $total_order_value+=$product_details['product_price']*$qty;
                     $total_discount_value+=$product_details['discount_value']*$qty;
                     $availble_qty=$product_details['availble_qty'];
                    if($availble_qty<$qty){$stock_availble_status=0;}
                     $nested_data=array(
                        'product_id'=>$product_id,
                        'product_original_price'=>$product_details['original_price'],
                        'product_price'=>$product_details['product_price'],
                        'product_cost'=>$product_details['product_cost'],
                        'product_qty'=>$qty,
                        'total_gross_value'=>$product_details['original_price']*$qty,
                        'total_cost_value'=>$product_details['product_cost']*$qty,
                        'total_net_value'=>$product_details['product_price']*$qty,   
                        'product_discount_value'=>$product_details['discount_value'],
                        'total_net_discount_value'=>$product_details['discount_value']*$qty,
                        'product_discount_id'=>$product_details['product_discount_id'],
                        'product_discount'=>$product_details['product_discount'],
                     );
                     $order_item_array[]=$nested_data;
                     }
                    $temp="";
                    $code=$this->Cart_Model->gen_code('ord_cus_id','order_customer','ODR'); 
                    $order_master_data=array(
                        'order_reference'=>$code,
                        'order_date'=>date("Y-m-d"),
                        'customer_id'=>$cus_id,
                        'order_type_id'=>1,
                        'payment_type'=>$payment_method,
                        'total_order_value'=>$total_order_value,
                        'shipping_cost'=>$total_shiipping_cost,
                        'addtional_cost'=>0,
                        'total_tax_value'=>0,
                        'order_cost'=>$total_cost,
                        'order_status'=>1,
                        'order_payment_status'=>1,
                        'order_approval_status'=>1, 
                        'order_item_total_discount'=>$total_discount_value,
                        'total_item_original_value'=>$total_original_value,
                        'billing_value'=>$total_order_value+$total_shiipping_cost
                    );
                    $stock_availble_status=1;
                    if($stock_availble_status==1){
                        $result=$this->Cart_Model->save_order_master($order_master_data);
                    }else{
                        $result=0;  
                    }                    
                    if($result==0){
                    $status=0;
                    $message="Somthing worng while place the order. please try again!";
                    if($stock_availble_status==0){$message="Selected product out of stock in this time. please goto cart and remove none stock product and try again";}
                    }else{
                        $master_id=$result;
                        foreach($order_item_array as $ca ){
                            $order_item_data=array(
                                'order_cus_id'=>$master_id,
                                'product_id'=>$ca['product_id'],
                                'product_original_price'=>$ca['product_original_price'],
                                'product_price'=>$ca['product_price'],
                                'product_cost'=>$ca['product_cost'],
                                'product_qty'=>$ca['product_qty'],
                                'total_gross_value'=>$ca['total_gross_value'],
                                'total_cost_value'=>$ca['total_cost_value'],
                                'total_net_value'=>$ca['total_net_value'],   
                                'product_discount_value'=>$ca['product_discount_value'],
                                'total_net_discount_value'=>$ca['total_net_discount_value'],
                                'product_discount_id'=>$ca['product_discount_id'],
                                'product_discount'=>$ca['product_discount'],                                            
                            );
                            $result=$this->Cart_Model->save_order_item($order_item_data); 
                            if($result==0){
                                $status=0;
                                $message="Somthing worng while place the order. please try again!";
                                }else{

                                    if($ship_to_different_address==1){
                                    $order_address=array(
                                        'order_id'=>$master_id,
                                        'first_name'=>$shipping_first_name,
                                        'last_name'=>$shipping_last_name,
                                        'company_name'=>$shipping_company,
                                        'zip_code'=>$shipping_postcode,
                                        'contact_number'=>$billing_phone,
                                        'order_comments'=>$order_comments,
                                        'city_id'=>$shipping_city,
                                        'address_1'=>$shipping_address_1,
                                        'address_2'=>$shipping_address_2,
                                        'address_3'=>'',
                                        'address_4'=>'',  
                                        'ship_to_different_address'=>$ship_to_different_address,                                                                                       
                                    );
                                }else{
                                    $order_address=array(
                                        'order_id'=>$master_id,
                                        'first_name'=>$billing_first_name,
                                        'last_name'=>$billing_last_name,
                                        'company_name'=>$billing_company,
                                        'zip_code'=>$billing_postcode,
                                        'contact_number'=>$billing_phone,
                                        'order_comments'=>$order_comments,
                                        'city_id'=>$billing_city,
                                        'address_1'=>$billing_address_1,
                                        'address_2'=>$billing_address_2,
                                        'address_3'=>'',
                                        'address_4'=>'',  
                                        'ship_to_different_address'=>$ship_to_different_address,                                                                                       
                                    );
                                }
                                $result=$this->Cart_Model->save_order_adress($order_address); 
                                    $status=1;
                                    $message="Order placed . Thank You";
                                    if($payment_method==4){
                                        $redirect=$master_id;
                                    }else{
                                        $redirect=$master_id;
                                    }
                                } 
                        }
                    }
                }else{
                }               
            }else{
                $status=0;            
                $message="Logging Timeout. Please login again!";  
            } 
            if($status==1){
                $data = array();
                $this->cart->destroy();
            }  
            $st = array('status' =>$status,'message' => $message,'order_id'=>$redirect) ;
            echo json_encode($st);
        }
    }

    function my_json_decode($s) {
        $s = str_replace(
            array('"',  "'"),
            array('\"', '"'),
            $s
        );
        $s = preg_replace('/(\w+):/i', '"\1":', $s);
        return json_decode(sprintf('{%s}', $s));
    }

    function orderCompleted()
    {
        $order_id=$this->input->post('odr_id'); 
        if($order_id>0){
            $data['order_master_data'] = $this->Cart_Model->get_order_details($order_id); 
            $data['order_item_data'] = $this->Cart_Model->get_order_item_details($order_id); 
            $data['order_tracking'] = $this->User_Model->get_order_tracking_details($order_id);
            $data['order_packing'] = $this->User_Model->get_order_packed_details_by_ord_cus_id($order_id); 
            $data['order_delivery'] =  $this->User_Model->get_order_delivery_details_by_ord_cus_id($order_id);
            $data['order_finished'] =  $this->User_Model->get_order_delivery_details_by_ord_cus_id($order_id);
            $data['order_shipping_adress'] = $this->User_Model->get_shiiping_address($order_id); 
            $st = array('status' =>true,'data' => $data,'order_id'=>$order_id) ;
        }else{
            $st = array('status' =>false,'data' => '','order_id'=>$order_id);
        }
        echo json_encode($st);
       
    }
    
    public function get_sub_category_by_category_id(){
        $id=$this->input->post('id'); 
       $result=$this->Home_Model->get_sub_category_by_category_id($id);
       $data=array();
       //print_r($result);
       
        foreach($result as $rs){
            //$thumb_path=$rs['thumb_path'];
            $image_path=$rs['image_path'];
           $nestedData=array(
               'cat_id'=> $rs['cat_id'],
               'sub_cat_id'=>$rs['sub_cat_id'] ,
               'sub_cat_name'=>$rs['sub_cat_name'] ,
               'sub_cat_code'=>$rs['sub_cat_code'] ,
               'sub_cat_priority'=>$rs['sub_cat_priority'] ,
               'image'=>base_url($image_path.$rs['image']) ,
               );
                $data[]=$nestedData;
            
        }
        echo json_encode($jsondata=array('data'=>$data));

    }
    
     public function shop(){     
		$cat_id=$this->input->post('cat_id');
		$sub_cat_id=$this->input->post('sub_cat_id');
		$sub_cat_2_id=$this->input->post('sub_cat_2_id');
		$keyword=$this->input->post('s');		     
		$product_list = $this->product_model->get_shop_product_list($cat_id,$sub_cat_id,$sub_cat_2_id,$keyword);
		$data['product_list'] =$this->product_model->get_muliti_product($product_list);	
        echo json_encode($data);
    }
    
    public function productView(){     
		$product_id=$this->input->post('pid');
		$data['details'] = $this->product_model->get_single_product($product_id);
		$data['product_details'] = $this->product_model->get_product_details($product_id);
		$data['specification'] = $this->product_model->get_single_product_spesification($product_id);
		$data['connectivity'] = $this->product_model->get_single_product_connectivity($product_id);
		$data['accessories'] = $this->product_model->get_single_product_accessories($product_id);
		$data['images'] = $this->product_model->get_image_list_mobile($product_id);
		$grop_ids = $this->product_model->get_group_id_by_product($product_id);
		if($grop_ids ){
			$data['product_options']=$this->product_model->get_product_list_by_group_id($grop_ids);
		}else{
			$data['product_options']=array();
		}
		echo json_encode($data);
	
    }
    
       public function getTopAdd()
    {
         $top_ban_add = $this->Home_Model->get_top_advertisment_banner();
         $data=array();
        foreach($top_ban_add as $tba){
            $path=$tba['path'];
           $nestedData=array(
               'adv_id'=> $tba['adv_id'],
               'advertisement_header'=>$tba['advertisement_header'] ,
               'advertisement_image'=>base_url($path."/".$tba['advertisement_image']) ,
               'advertisement_remarks'=>$tba['advertisement_remarks'] ,
               'advertisement_details'=>$tba['advertisement_details'] ,
               'start_datetime'=> $tba['start_datetime'],
               'end_datetime'=> $tba['end_datetime'],
               'path'=>base_url($path),
               );
            $data[]=$nestedData;
            
        }
         //print_r($data['top_ban_add']);
         echo json_encode($jsondata=array('data'=>$data));
    }
    
    public function getSpecicalOfferCategories()
    {
        $specical_category_list = $this->Home_Model->get_category_for_specical_offer();
          $data=array();
        foreach($specical_category_list as $tba){
            $image_path=$tba['image_path'];
            $thumb_path=$tba['thumb_path'];
           $nestedData=array(
               'cat_id'=> $tba['cat_id'],
               'cat_name'=>$tba['cat_name'] ,
               'cat_image_thumb'=>base_url($thumb_path."/".$tba['cat_image_thumb']) ,
               'cat_image'=>base_url($image_path."/".$tba['cat_image']) ,
               );
            $data[]=$nestedData;
            
        }
         //print_r($data['top_ban_add']);
         echo json_encode($jsondata=array('data'=>$data));
        
    }
    
     public function getSpecialOffersByCategoryId(){  
        $id=$this->input->post('id');
        //$id=5;
        $product_list= $this->Home_Model->get_specical_offer_sub_list_mobile($id);	
        $result=$this->product_model->flash_deal_multi_product($product_list);
        $data=array('special_offer'=>$result,'status' =>1,'message' => "done");
        echo json_encode($data);
    }
    
    public function myOrders(){
       
        $cus_id=$this->input->post('site_cus');	
        $data['cus_data'] = $this->User_Model->get_customer_details($cus_id);        
        $data['order_list'] = $this->User_Model->get_order_list($cus_id);
        echo json_encode($data);
       
        //----------------------------------------
        
       
    }
    
    public function facebookLogin()
    {
         $this->load->library('form_validation'); //form validation lib		
        //validations
        $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[4]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[4]|max_length[100]|xss_clean');
		$this->form_validation->set_rules('id', 'Id', 'trim|required|min_length[6]|max_length[100]|xss_clean');
		//check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {      
            $target_link="home";
            $status=1;            
            $message="somthing going worng";
            $email=$this->input->post('email');
            $name=$this->input->post('name');
            $id=$this->input->post('id');
            $result = $this->User_Model->check_user($email);
            if($result==0)
            {
            $available_status=0;
            //------------------------------------------
             $code=mt_rand(100000, 999999);
             $user_data=array('user_name'=>$email,'paswrd'=>$code,'sc_m_lg_id'=>$id,'sc_m_lg_type'=>"FACEBOOK",'is_confirm'=>1);
                $result = $this->User_Model->save_user($user_data);
                $user_id=$result;
                $cus_code=$this->User_Model->gen_code('cus_id','customer','CUSMOBI');                   
                $customer_data=array('cus_email'=>$email,'reg_user_id'=>$result,'cus_type'=>'MOBILE');
                $result = $this->User_Model->save_user_customer_profile($customer_data);
                $user_data=$this->User_Model->get_user_details_by_social_media($email,$id);
                //CREATE TEMP USER LOGING
                $st = array('status' =>$status,'cus_details' => $user_data,'login_type'=> "TEMP") ;
                $message="SignUp Complete";
            //--------------------------------------------
            }
            else
            {
             $available_status=1;
             //--------------------------------------------
             $result = $this->User_Model->check_user_sc_m_lg($email,$id);
                if($result==1)
                {
                    $status=1;
                    $message="User availble";
                    $user_data=$this->User_Model->get_user_details_by_social_media($email,$id);
                    $st = array('status' =>$status,'cus_details' => $user_data,'login_type'=> "FULL") ;
                }else{
                    $status=1;
                    $user_id = $this->User_Model->check_user_id_sc_m_lg($email);
                    $user_data=array('sc_m_lg_id'=>$id,'sc_m_lg_type'=>"FACEBOOK",'is_confirm'=>1);
                    $result = $this->User_Model->update_user($user_id,$user_data);
                    $user_data=$this->User_Model->get_user_details_by_social_media($email,$id);
                    $st = array('status' =>$status,'cus_details' => $user_data,'login_type'=> "FULL") ;
                }
             //-------------------------------------------
            }
            echo json_encode($st);
        }
        
    }
    
    public function googleLogin()
    {
         $this->load->library('form_validation'); //form validation lib		
        //validations
        $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[4]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[4]|max_length[100]|xss_clean');
		$this->form_validation->set_rules('id', 'Id', 'trim|required|min_length[6]|max_length[100]|xss_clean');
		//check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {      
            $target_link="home";
            $status=1;            
            $message="somthing going worng";
            $email=$this->input->post('email');
            $name=$this->input->post('name');
            $id=$this->input->post('id');
            $result = $this->User_Model->check_user($email);
            if($result==0)
            {
            $available_status=0;
            //------------------------------------------
             $code=mt_rand(100000, 999999);
             $user_data=array('user_name'=>$email,'paswrd'=>$code,'sc_m_lg_id'=>$id,'sc_m_lg_type'=>"GOOGLE",'is_confirm'=>1);
                $result = $this->User_Model->save_user($user_data);
                $user_id=$result;
                $cus_code=$this->User_Model->gen_code('cus_id','customer','CUSMOBI');                   
                $customer_data=array('cus_email'=>$email,'reg_user_id'=>$result,'cus_type'=>'MOBILE');
                $result = $this->User_Model->save_user_customer_profile($customer_data);
                $user_data=$this->User_Model->get_user_details_by_social_media($email,$id);
                //CREATE TEMP USER LOGING
                $st = array('status' =>$status,'cus_details' => $user_data,'login_type'=> "TEMP") ;
                $message="SignUp Complete";
            //--------------------------------------------
            }
            else
            {
             $available_status=1;
             //--------------------------------------------
             $result = $this->User_Model->check_user_sc_m_lg($email,$id);
                if($result==1)
                {
                    $status=1;
                    $message="User availble";
                    $user_data=$this->User_Model->get_user_details_by_social_media($email,$id);
                    $st = array('status' =>$status,'cus_details' => $user_data,'login_type'=> "FULL") ;
                }else{
                    $status=1;
                    $user_id = $this->User_Model->check_user_id_sc_m_lg($email);
                    $user_data=array('sc_m_lg_id'=>$id,'sc_m_lg_type'=>"GOOGLE",'is_confirm'=>1);
                    $result = $this->User_Model->update_user($user_id,$user_data);
                    $user_data=$this->User_Model->get_user_details_by_social_media($email,$id);
                    $st = array('status' =>$status,'cus_details' => $user_data,'login_type'=> "FULL") ;
                }
             //-------------------------------------------
            }
            echo json_encode($st);
        }
        
    }
    
    public function appleLogin()
    {
         $this->load->library('form_validation'); //form validation lib		
        //validations
        $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[4]|max_length[100]|xss_clean');
       // $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[4]|max_length[100]|xss_clean');
		$this->form_validation->set_rules('id', 'Id', 'trim|required|min_length[6]|max_length[100]|xss_clean');
		//check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {      
            $target_link="home";
            $status=1;            
            $message="somthing going worng";
            $email=$this->input->post('email');
            $name=$this->input->post('name');
            $id=$this->input->post('id');
            $result = $this->User_Model->check_user($email);
            if($result==0)
            {
            $available_status=0;
            //------------------------------------------
             $code=mt_rand(100000, 999999);
             $user_data=array('user_name'=>$email,'paswrd'=>$code,'sc_m_lg_id'=>$id,'sc_m_lg_type'=>"IOS",'is_confirm'=>1);
                $result = $this->User_Model->save_user($user_data);
                $user_id=$result;
                $cus_code=$this->User_Model->gen_code('cus_id','customer','CUSMOBI');                   
                $customer_data=array('cus_email'=>$email,'reg_user_id'=>$result,'cus_type'=>'MOBILE');
                $result = $this->User_Model->save_user_customer_profile($customer_data);
                $user_data=$this->User_Model->get_user_details_by_social_media($email,$id);
                //CREATE TEMP USER LOGING
                $st = array('status' =>$status,'cus_details' => $user_data,'login_type'=> "TEMP") ;
                $message="SignUp Complete";
            //--------------------------------------------
            }
            else
            {
             $available_status=1;
             //--------------------------------------------
             $result = $this->User_Model->check_user_sc_m_lg($email,$id);
                if($result==1)
                {
                    $status=1;
                    $message="User availble";
                    $user_data=$this->User_Model->get_user_details_by_social_media($email,$id);
                    $st = array('status' =>$status,'cus_details' => $user_data,'login_type'=> "FULL") ;
                }else{
                    $status=1;
                    $user_id = $this->User_Model->check_user_id_sc_m_lg($email);
                    $user_data=array('sc_m_lg_id'=>$id,'sc_m_lg_type'=>"IOS",'is_confirm'=>1);
                    $result = $this->User_Model->update_user($user_id,$user_data);
                    $user_data=$this->User_Model->get_user_details_by_social_media($email,$id);
                    $st = array('status' =>$status,'cus_details' => $user_data,'login_type'=> "FULL") ;
                }
             //-------------------------------------------
            }
            echo json_encode($st);
        }
        
    }
    
    public function get_latest_product(){
        $recent_added = $this->product_model->get_recent_items();
        $data['recent_items']=$this->product_model->get_muliti_product($recent_added);
        echo json_encode($data);
    }
    
    public function accountUpdate() {
        $this->load->library('form_validation'); //form validation lib		
		//validations
		$this->form_validation->set_rules('cus_first_name', 'First Name', 'trim|required|min_length[2]|max_length[250]|xss_clean');
		$this->form_validation->set_rules('cus_last_name', 'Last Name', 'trim|required|min_length[2]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('cus_m_phone', 'Mobile', 'trim|required|min_length[10]|max_length[10]|xss_clean');
        $this->form_validation->set_rules('cus_address', 'Address', 'trim|required|min_length[4]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('city', 'City', 'trim|required|min_length[1]|max_length[10]|xss_clean');
        $this->form_validation->set_rules('cus_postal_code', 'ZIP code', 'trim|required|min_length[3]|max_length[10]|xss_clean');
        $this->form_validation->set_rules('target', 'Target', 'trim|xss_clean');  
        $this->form_validation->set_rules('site_cus', 'Customer', 'trim|required|xss_clean');
		//check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $status=1;            
            $message="somthing going worng";
            $target=$this->input->post('target');
            $target_status=0;
            $target_link="";
            if($target){
                $target_status=1;
                if($target=="checkout")
                {
                    $target_link="cart/checkOut"; 
                }
            }
            $cus_first_name=$this->input->post('cus_first_name');
		    $cus_last_name=$this->input->post('cus_last_name');
            $cus_m_phone=$this->input->post('cus_m_phone');
            $cus_address=$this->input->post('cus_address');
            $city=$this->input->post('city');
            $cus_postal_code=$this->input->post('cus_postal_code');
            $cus_m_phone=$this->input->post('cus_m_phone');  
            $site_cus=$this->input->post('site_cus'); 
            
            $customer_data=array(
                'cus_first_name'=>$cus_first_name,
                'cus_last_name'=>$cus_last_name,
                'cus_name'=>$cus_first_name." ".$cus_last_name,
                'cus_m_phone'=>$cus_m_phone,
                'cus_address'=>$cus_address,
                'city_id'=>$city,
                'cus_postal_code'=>$cus_postal_code,
                'cus_m_phone'=>$cus_m_phone,
            );
            $cus_id=$site_cus;

            if($cus_id>0){
                $result=$this->User_Model->update_customer($cus_id,$customer_data); 
                if($result==0){
                    $status=0;
                    $message="Somthing worng while register user. please try again!";
                }else{
                    $status=1;
                    $message="customer profile saved";                    
                }
            }else{
                $status=0;            
                $message="Logging Timeout. Please login again!";  
            }           
           
            $st = array('status' =>$status,'message' => $message,'target_status'=>$target_status , 'target_link'=>$target_link) ;
            echo json_encode($st);
        }
    }
    
    
    function calculateCart(){
            $cart=stripslashes($this->input->post('cart'));
           // print_r($this->input->post('cart'));
            $temp_product=json_decode($cart);
            if(isset($temp_product->cart)){
               $product_list=$temp_product->cart;  
            }else
            {
               $product_list=array(); 
            }
            $cus_id=$this->input->post('site_cus');
            $billing_city=$this->input->post('billing_city');
            $total_order_value=0;
            $total_shiipping_cost=0;
            $total_cost=0;
            $total_discount_value=0;
            $total_original_value=0;
            $qty_total=0;
            foreach($product_list as $ca){
                $city_shipping_cost=150;
                $product_id=$ca->product_id;
                $qty=$ca->qty;
                $product_details = $this->product_model->get_single_product($product_id);	
                $product_shipping_cost=$product_details['sh_cat_value'];
                $total_shiipping_cost+=$product_shipping_cost*$city_shipping_cost;
                $qty_total+= $qty;
                $total_cost+=$product_details['product_cost']*$qty;
                $total_original_value+=$product_details['original_price']*$qty;
                $total_order_value+=$product_details['product_price']*$qty;
                $total_discount_value+=$product_details['discount_value']*$qty;
                $availble_qty=$product_details['availble_qty'];
            }
                $data=array(
                        'total_order_value'=>$total_order_value,
                        'shipping_cost'=>$total_shiipping_cost,
                        'addtional_cost'=>0,
                        'total_tax_value'=>0,
                        'order_cost'=>$total_cost,
                        'order_item_total_discount'=>$total_discount_value,
                        'total_item_original_value'=>$total_original_value,
                        'billing_value'=>$total_order_value+$total_shiipping_cost
                    );
            $st = array('status' =>1,'result' => $data) ;
            echo json_encode($st);
       
    }
    
    
     public function updatePassword() {
        $this->load->library('form_validation'); //form validation lib		
        //validations
        $this->form_validation->set_rules('old_password', 'Old Password', 'trim|required|min_length[4]|max_length[100]|xss_clean');
		$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|min_length[6]|max_length[100]|xss_clean');
		$this->form_validation->set_rules('site_cus', 'Customer', 'trim|required|xss_clean');
       
		//check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $cus_id=$this->input->post('site_cus');
            $status=1;            
            $message="somthing going worng";
            $password_old=$this->input->post('old_password');
            $password=$this->input->post('new_password');
            $confirm_password=$this->input->post('new_password');
            if($password!=$confirm_password){$status=0; $message="Password and confirm password dose not matched"; }
            else{
                $result =$this->User_Model->check_cus_password($cus_id,$password_old);
                if($result==1){
                    $status=1; $message="password is correct";
                    $user =$this->User_Model->get_user_id_by_cus_id($cus_id,$password_old);
                    $user_data=array(
                        'paswrd'=>$confirm_password,
                        'last_modified_date_time'=> date("Y-m-d H:i:s")           
                    );
                    $user_id=$user['reg_user_id'];
                    $result=$this->User_Model->update_user($user_id,$user_data);
                    if($result==1){
                        $status=1; $message="Password successfully Updated";
                       
                    }else{
                        $status=0; $message="Somthing going worng while Update pasword in your account ";
                    }
                }else{
                    $status=0; $message="Incorrect Password";
                }
            }
            //------------------------------------           
            $st = array('status' =>$status,'message' => $message) ;
            echo json_encode($st);
        }
    }
    
    
     public function accountDelete() {
        $this->load->library('form_validation'); //form validation lib		
		//validations
		$this->form_validation->set_rules('password', 'Currant Password', 'trim|required|min_length[6]|max_length[100]|xss_clean');
		$this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|min_length[6]|max_length[100]|xss_clean');
       	$this->form_validation->set_rules('site_cus', 'Customer', 'trim|required|xss_clean');
		//check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $cus_id=$this->input->post('site_cus');
            $status=1;            
            $message="somthing going worng";
            $password=$this->input->post('password');
            $confirm_password=$this->input->post('confirm_password');
            if($password!=$confirm_password){$status=0; $message="Password and confirm password dose not matched"; }
            else{
                $result =$this->User_Model->check_cus_password($cus_id,$password);
                if($result==1){
                    $status=1; $message="password is correct";
                    $user =$this->User_Model->get_user_id_by_cus_id($cus_id,$password);
                    $user_data=array(
                        'is_deleted'=>1,                
                    );
                    $user_id=$user['reg_user_id'];
                    $result=$this->User_Model->update_user($user_id,$user_data);
                    if($result==1){
                        $status=1; $message="Account successfully deleted";
                    }else{
                        $status=0; $message="Somthing going worng while deleting your account ";
                    }
                }else{
                    $status=0; $message="Incorrect Password";
                }
            }
            //------------------------------------           
            $st = array('status' =>$status,'message' => $message) ;
            echo json_encode($st);
        }
    }
    
    public function myAddress(){
      
        $cus_id=$this->input->post('site_cus');
        $cus_data = $this->User_Model->get_customer_details($cus_id);        
        $st = array('status' =>1,'data' => $cus_data) ;
        echo json_encode($st);
    }
    
    
     public function myOrdersHistory(){
       
        $cus_id=$this->input->post('site_cus');
        if(isset($cus_id)){
            $data['order_list'] = $this->User_Model->get_order_list($cus_id);
            $status=1;
        }else
        {
             $data['order_list'] =array();
              $status=0;
        }
         $st = array('status' =>$status,'data' => $data) ;
            echo json_encode($st);
      
        //----------------------------------------
        
       
    }

          
    


    
   
    
}