<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User_Model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->table = 'user_register';
    }
    //new code by sachith eranga

function check_user($username)
{
    $this->db->from($this->table);
    $this->db->where('user_name', $username);
    $query = $this->db->get();
    if($query->num_rows() > 0){
        return true;
    } else {
        return false;
    }
}
public function getOutletNames() {
        $this->db->select('ot.outlet_id,ot.outlet_name');
        $this->db->from('outlet_table ot');
        $this->db->where('outlet_status', 1);
        $query = $this->db->get();
        return $query->result_array();
    }


 function save_user($data) {
    if($data){
        $this->db->insert($this->table, $data);
        $insertid =  $this->db->insert_id();
        return $insertid ;
    } else {
        return false;
    }
}

function save_user_customer_profile($data) {
    if($data){
        $this->db->insert('customer', $data);
        $insertid =  $this->db->insert_id();
        return $insertid ;
    } else {
        return false;
    }
}

 function gen_code ($column_name,$table_name,$type_code)
   {
	$this->db->select_max($column_name);
	$query = $this->db->get($table_name);
     if($query->num_rows() >0)
     {
       $g = $query->result();
       $u = $this->set_ref_no($g[0]->$column_name,$type_code);
       return $u;
     }
     else
     {
       return false;
     }
   }

   function set_ref_no($f,$t)
   {
	  $w='';
   	 $d = date('Y/m/');
	 if($t){
		$w=$t;
	 }
   	 $w =$w.sprintf("%04d",$f+1);
   	 return $w;
   }

   function get_customer_details($cus_id)
   {
       $this->db->select('c.*');
       $this->db->select('mc.cname,mc.shiiping_cost,mc.distance_category_value');
       $this->db->select('u.user_type,u.is_confirm,u.user_privilage_id,u.user_status,u.user_name');
       $this->db->from('customer c');
       $this->db->join('user_register u','c.reg_user_id = u.reg_user_id','left');
       $this->db->join('mstr_city mc','mc.cid = c.city_id','left');
       $this->db->where('c.cus_id', $cus_id);
       $query = $this->db->get();
       return $query->row_array();
   }

   function get_cities()
   {
    $this->db->select('*');
    $this->db->from('mstr_city');
    $this->db->where('status', 1);
    $query = $this->db->get();
    return $query->result_array();
   }

   function update_customer($id='',$data)
   {
       if($id>0){
        $this->db->where('cus_id', $id);
        return $this->db->update('customer', $data);
       }
       else{
           return false;
       }
   }

   function check_user_password($username,$password)
{
    $this->db->from($this->table);
    $this->db->where('user_name', $username);
    $this->db->where('paswrd', $password);
    $this->db->where('is_deleted',0);
    $this->db->where('is_disable',0);
    $this->db->where('user_status',1);
    $query = $this->db->get();
    if($query->num_rows() > 0){
        return true;
    } else {
        return false;
    }
}

  function check_user_sc_m_lg($username,$sc_m_id)
{
    $this->db->from($this->table);
    $this->db->where('user_name', $username);
    $this->db->where('sc_m_lg_id', $sc_m_id);
    $this->db->where('is_deleted',0);
    $this->db->where('is_disable',0);
    $this->db->where('user_status',1);
    $query = $this->db->get();
    if($query->num_rows() > 0){
        return true;
    } else {
        return false;
    }
}

  function check_user_id_sc_m_lg($username)
{
    $this->db->select('reg_user_id');
    $this->db->from($this->table);
    $this->db->where('user_name', $username);
    //$this->db->where('sc_m_lg_id', $sc_m_id);
    $this->db->where('is_deleted',0);
    $this->db->where('is_disable',0);
    $this->db->where('user_status',1);
    $query = $this->db->get();
    $result=$query->row_array();
    return $result['reg_user_id'];


}


function check_cus_password($cus_id,$password)
{
    $this->db->from('user_register ur');
    $this->db->join('customer c','ur.reg_user_id = c.reg_user_id','inner');
    $this->db->where('c.cus_id', $cus_id);
    $this->db->where('ur.paswrd', $password);
    $this->db->where('ur.is_deleted',0);
    $this->db->where('ur.is_disable',0);
    $this->db->where('ur.user_status',1);
    $query = $this->db->get();
    if($query->num_rows() > 0){
        return true;
    } else {
        return false;
    }
}

function get_user_id_by_cus_id($cus_id,$password)
{
    $this->db->select('c.reg_user_id');
    $this->db->from('user_register ur');
    $this->db->join('customer c','ur.reg_user_id = c.reg_user_id','inner');
    $this->db->where('c.cus_id', $cus_id);
    $this->db->where('ur.paswrd', $password);
    $this->db->where('ur.is_deleted',0);
    $this->db->where('ur.is_disable',0);
    $this->db->where('ur.user_status',1);
    $query = $this->db->get();
    if($query->num_rows() > 0){
        return $query->row_array();
    } else {
        return false;
    }
}

function get_user_details($username,$password)
   {
       $this->db->select('c.*');
       $this->db->select('u.user_type,u.is_confirm,u.user_privilage_id,u.user_status');
       $this->db->from('user_register u');
       $this->db->join('customer c','u.reg_user_id = c.reg_user_id','inner');
       $this->db->where('u.user_name', $username);
       $this->db->where('u.paswrd', $password);
       $this->db->where('u.is_deleted',0);
       $this->db->where('u.is_disable',0);
       $this->db->where('u.user_status',1);
       $query = $this->db->get();
       return $query->row_array();
   }

   function get_user_details_by_social_media($username,$password)
   {
       $this->db->select('c.*');
       $this->db->select('u.user_type,u.is_confirm,u.user_privilage_id,u.user_status');
       $this->db->from('user_register u');
       $this->db->join('customer c','u.reg_user_id = c.reg_user_id','left');
       $this->db->where('u.user_name', $username);
       $this->db->where('u.sc_m_lg_id', $password);
       $this->db->where('u.is_deleted',0);
       $this->db->where('u.is_disable',0);
       $this->db->where('u.user_status',1);
       $query = $this->db->get();
       return $query->row_array();
   }


   function get_order_list($cus_id)
   {
    $this->db->select('oc.*');
        $this->db->select('mp.pay_type_name');
        $this->db->select('ds.status_name as del_status');
        $this->db->select('ms.status_name');
        $this->db->from('order_customer oc');
        $this->db->join('mstr_payment_type mp','oc.payment_type = mp.pay_type_id','left');
        $this->db->join('mstr_order_status ms','oc.order_status = ms.status_id','left');
        $this->db->join('sales s','s.ord_cus_id = oc.ord_cus_id','left');
        $this->db->join('mstr_delivery_status ds','s.delivery_status = ds.status_id','left');
        $this->db->where('oc.customer_id', $cus_id);
        $this->db->order_by('oc.ord_cus_id','desc');
        $this->db->group_by('oc.ord_cus_id');
        $query = $this->db->get();
        return $query->result_array();
     }

     public function get_order_tracking_details ($order_id)
     {
        $this->db->select('oc.*,c.*,mos.*');
        $this->db->from('order_customer oc');
        $this->db->join('customer c', 'oc.customer_id = c.cus_id', 'left');
        $this->db->join('mstr_order_status mos', 'oc.order_status = mos.status_id', 'left');
        $this->db->where('oc.ord_cus_id',$order_id);
        $query = $this->db->get();
        return $query->result_array();
     }

     public function get_order_packed_details_by_ord_cus_id($order_id)
  {
	 $this->db->select('oc.*,s.*,c.*');
	 $this->db->from('sales s');
     $this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
	 $this->db->join('order_customer oc', 's.ord_cus_id = oc.ord_cus_id', 'left');
     $this->db->where('oc.ord_cus_id',$order_id);
     $query = $this->db->get();
	 return $query->result_array();
  }

  public function get_order_delivery_details_by_ord_cus_id($order_id)
  {
	 $this->db->select('oc.*,di.*,c.*,d.*');
	 $this->db->from('delivery_item di');
	 $this->db->join('order_customer oc', 'di.ord_cus_id = oc.ord_cus_id', 'left');
	 $this->db->join('customer c', 'oc.customer_id = c.cus_id', 'left');
	 $this->db->join('delivery d', 'di.delivery_id = d.delievery_id', 'left');
	 $this->db->where('oc.ord_cus_id',$order_id);
     $query = $this->db->get();
     return $query->result_array();
  }


  function get_shiiping_address($order_id)
   {
       $this->db->select('osa.*');
       $this->db->select('mc.cname');
      $this->db->from('order_customer_address osa');
      $this->db->join('mstr_city mc','mc.cid = osa.city_id','left');
       $this->db->where('osa.order_id',$order_id);
       $query = $this->db->get();
       return $query->row_array();
   }

   function get_completed_order_list($cus_id)
   {
    $this->db->select('oc.*');
        $this->db->select('mp.pay_type_name');
        $this->db->select('ms.status_name');
        $this->db->from('sales s');
        $this->db->join('order_customer oc','oc.ord_cus_id = s.ord_cus_id','left');
        $this->db->join('mstr_payment_type mp','oc.payment_type = mp.pay_type_id','left');
        $this->db->join('mstr_order_status ms','oc.order_status = ms.status_id','left');
        $this->db->join('mstr_delivery_status ds','s.delivery_status = ds.status_id','left');
        $this->db->where('s.delivery_status',4);
        $this->db->where('oc.customer_id', $cus_id);
        $this->db->order_by('oc.ord_cus_id','desc');
        $query = $this->db->get();
        return $query->result_array();
     }

     function get_order_list_all($cus_id)
     {
      $this->db->select('oc.*');
          $this->db->select('mp.pay_type_name');
          $this->db->select('ms.status_name');
          $this->db->from('order_customer oc');
          $this->db->join('mstr_payment_type mp','oc.payment_type = mp.pay_type_id','left');
          $this->db->join('mstr_order_status ms','oc.order_status = ms.status_id','left');
          $this->db->join('sales s','oc.ord_cus_id = s.ord_cus_id','left');
          $this->db->where('oc.customer_id', $cus_id);
          $this->db->order_by('oc.ord_cus_id','desc');
          $query = $this->db->get();
          return $query->result_array();
       }

     function get_completed_order_list_all($cus_id)
     {
      $this->db->select('oc.*');
          $this->db->select('mp.pay_type_name');
          $this->db->select('ds.status_name as del_status');
          $this->db->select('ms.status_name');
          $this->db->from('order_customer oc');
          $this->db->join('mstr_payment_type mp','oc.payment_type = mp.pay_type_id','left');
          $this->db->join('mstr_order_status ms','oc.order_status = ms.status_id','left');
          $this->db->join('sales s','oc.ord_cus_id = s.ord_cus_id','left');
          $this->db->join('mstr_delivery_status ds','s.delivery_status = ds.status_id','left');
          $this->db->where('oc.customer_id', $cus_id);
          $this->db->order_by('oc.ord_cus_id','desc');
          $query = $this->db->get();
          return $query->result_array();
       }

       function update_user($id='',$data)
   {
       if($id>0){
        $this->db->where('reg_user_id', $id);
        return $this->db->update('user_register', $data);
       }
       else{
           return false;
       }
   }


   function insert_wishlist($data) {
    if($data){
        $this->db->insert('customer_wishlist', $data);
         return true ;
    } else {
        return false;
    }
}

function get_wishlist_item($cus_id)
{
    $this->db->select('pc.*');
		$this->db->select('p.*');
		$this->db->select('b.brand_name');
		$this->db->select('c.color');
		$this->db->select('sh.sh_cat_value');
		$this->db->from('customer_wishlist cw');
		$this->db->join('product p','cw.product_id=p.product_id','left');
		$this->db->join('product_category pc','p.cat_id=pc.cat_id','left');
		$this->db->join('mstr_brand b','p.brand_id=b.brand_id','left');
		$this->db->join('color c','p.color_id=c.color_id','left');
		$this->db->join('shipping_cost_category sh','p.shipping_cost_category=sh.shc_cat_id','left');
		$this->db->where("p.product_status",1);
		$this->db->where("pc.cat_status",1);
        $this->db->where("cw.cus_id",$cus_id);
        $this->db->group_by('cw.product_id');
		$query=$this->db->get();
		return $query->result_array();

  }


  function remove_wishlist($cus_id,$product_id)
  {
    $this ->db -> where('cus_id', $cus_id);
    $this ->db -> where('product_id', $product_id);
    $result =$this ->db -> delete('customer_wishlist');
    return $result;
  }

  function check_code($cus_id,$code)
{
    $this->db->from('user_register ur');
    $this->db->join('customer c','ur.reg_user_id = c.reg_user_id','inner');
    $this->db->where('c.cus_id', $cus_id);
    $this->db->where('ur.comfirmation_code', $code);
    $this->db->where('ur.is_deleted',0);
    $this->db->where('ur.is_disable',0);
    $this->db->where('ur.user_status',1);
    $query = $this->db->get();
    if($query->num_rows() > 0){
        return true;
    } else {
        return false;
    }
}

function get_user_id_by_cus_id_only($cus_id)
{
    $this->db->select('c.reg_user_id');
    $this->db->from('user_register ur');
    $this->db->join('customer c','ur.reg_user_id = c.reg_user_id','inner');
    $this->db->where('c.cus_id', $cus_id);
    $this->db->where('ur.is_deleted',0);
    $this->db->where('ur.is_disable',0);
    $this->db->where('ur.user_status',1);
    $query = $this->db->get();
    if($query->num_rows() > 0){
        return $query->row_array();
    } else {
        return false;
    }
}

function get_cus_id_using_username($user_name)
{
    $this->db->select('c.reg_user_id,c.cus_id');
    $this->db->from('user_register ur');
    $this->db->join('customer c','ur.reg_user_id = c.reg_user_id','inner');
    $this->db->where('ur.user_name', $user_name);
    $this->db->where('ur.is_deleted',0);
    $this->db->where('ur.is_disable',0);
    $this->db->where('ur.user_status',1);
    $query = $this->db->get();
    if($query->num_rows() > 0){
        return $query->row_array();
    } else {
        return false;
    }
}

function check_confirmation_code($email,$code)
{
    $this->db->from('user_register ur');
    $this->db->join('customer c','ur.reg_user_id = c.reg_user_id','inner');
    $this->db->where('ur.user_name', $email);
    $this->db->where('ur.comfirmation_code', $code);
    $this->db->where('ur.is_deleted',0);
    $this->db->where('ur.is_disable',0);
    $this->db->where('ur.user_status',1);
    $query = $this->db->get();
    if($query->num_rows() > 0){
        return true;
    } else {
        return false;
    }
}




//----------------------------------------------------------------
}
