<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('core_model.php');
class Customer_Damage_Model extends Core_Model {
 
  public $table_config=array(
      'mater_table'=>'exchange_master',
      'master_table_primary_id'=>'exc_id',
      'master_table_seconrary_id'=>'exchange_itemsexchange_items',
      'item_table'=>'return_items',
      'item_table_primary_id'=>'rtni_id',
      'item_table_seconrary_id'=>'rtn_id',
      'sub_item_table'=>'',
      'sub_item_table_primary_id'=>'',
      'sub_item_table_seconrary_id'=>'',
      );
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct($this->table_config);
  }

	function save_master($data){
		return $this->save_master_table($data);
	}
	function save_return_item($data){
		return $this->save_item_table($data);
	}
	function get_list_return() {
	    return $this->get_result_mater_record_data();
	}
	public function get_row_return_info($id){
	     return $this->get_row_array_mater_record_data_by_primary_id($id);
	 }
	public function delete_return($id){
	    return $this->delete_master_table_by_primary_id($id);
	}
	public function delete_return_item($id){
	    return $this->delete_item_table_by_primary_id($id);
	}
	public function disable_return($id){
		$data = array(
			'status' => 0
		);	
	    return $this->update_master_table_by_primary_id($warehouse_id,$data);
	}
	public function enable_return($warehouse_id){
		$data = array(
			'status' => 1
		);	
		return  $this->update_master_table_by_primary_id($warehouse_id,$data);
	}
	public function update_master($id,$data){
		return  $this->update_master_table_by_primary_id($id,$data);
	}
	function update_return_item($id,$data){
	    	return  $this->update_item_table_by_primary_id($id,$data);
	}
	
	
	
	
	
		public function get_cus_damage_type(){
		 $this->db->select("o.*");
        $this->db->from('master_customer_damage_type o');
        $this->db->where('o.mcdt_status',1);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
	}
	
	
	public function get_cus_damage_info($id)
	{
		 $this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,a.mas_name,,r.mcdt_name,w.address,w.phone,c.cus_address,c.cus_phone,p.product_name,p.product_code");
        $this->db->from('exchange_master o');
        $this->db->join("customer c", "c.cus_id = o.exc_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.exc_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.exc_warehouse_id", "inner");
        $this->db->join("master_approval_status a", "a.approval_status_id = o.exc_approval_status", "inner");
        $this->db->join('master_customer_damage_type r', 'r.mcdt_id = o.cus_damage_type', 'inner');
         $this->db->join('product p', 'p.product_id = o.product_id', 'inner');
        $this->db->where('o.exc_id',$id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	
	
		public function get_cus_damage_list($start, $length, $search_key_val)
	{
		 $this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,a.mas_name,,r.mcdt_name,w.address,w.phone,c.cus_address,c.cus_phone,p.product_name,p.product_code");
        $this->db->from('exchange_master o');
        $this->db->join("customer c", "c.cus_id = o.exc_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.exc_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.exc_warehouse_id", "inner");
        $this->db->join("master_approval_status a", "a.approval_status_id = o.exc_approval_status", "inner");
        $this->db->join('master_customer_damage_type r', 'r.mcdt_id = o.cus_damage_type', 'inner');
         $this->db->join('product p', 'p.product_id = o.product_id', 'inner');
        //$this->db->where('o.exc_id',$id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	//-------------------------------------------------------------------------

		function get_return_type_dynamic($search_key_val){
	    $this->db->select("o.*");
        $this->db->from('master_return_type o');
        $this->db->where("o.m_rtn_type_status = 1  AND  o.m_rtn_type_name LIKE '%$search_key_val%'");
        $query = $this->db->get();
        return $query->result_array();
	}
	
	function get_return_product_list($id){
	     $this->db->select("o.*,p.product_name,p.product_code,u.unit_code,mrc.mrc_name,p.product_name_other");
        $this->db->from('return_items o');
        $this->db->join("product p", "p.product_id = o.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->join("master_return_condition mrc", "mrc.mrc_id = o.quality_level", "inner");
        $this->db->where('o.rtn_id',$id);
        $this->db->order_by('o.rtni_id','desc');
        $query = $this->db->get();
        return $query->result_array();
	}
	 function check_already_added($product_id,$id){
        $this->db->from('return_items o');
        $this->db->where('o.product_id',$product_id);
        $this->db->where('o.rtn_id',$id);
        $query = $this->db->get();
        return $query->num_rows() ;
	}
		function get_return_item_price_cost($id)
	{
		$this->db->select("p.*");
        $this->db->from('return_items p');
        $this->db->where('p.rtni_id',$id);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	function get_return_total_values($id){
		$this->db->select_sum("p.rtn_total_value");
		$this->db->select_sum("p.rtn_total_cost");
        $this->db->from('return_items p');
        $this->db->where('p.rtn_id',$id);
        $query = $this->db->get();
        $result = $query->row_array();
        if(isset($result['rtn_total_cost'])){
            $return_data=array(
                'total_cost'=>$result['rtn_total_cost'],
                'total_price'=>$result['rtn_total_value']
                );
                return $return_data;
        }else{
            $return_data=array(
                'total_cost'=>0,
                'total_price'=>0
                );
                return $return_data;
        }
	}
	function get_return_list($start, $length, $search_key_val){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,r.m_rtn_type_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('return_master o');
        $this->db->join("customer c", "c.cus_id = o.rtn_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.rtn_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.rtn_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.rtn_approval_status', 'inner');
        $this->db->join('master_return_type r', 'r.m_rtn_type_id = o.return_type_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where("o.rtn_ref_no LIKE '$search_key_val%'");
             $this->db->or_where("c.cus_name LIKE '$search_key_val%'");
        }else{
    
        }
		$this->db->order_by("o.rtn_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
	
	
		function get_account_approval_return_list_old($start, $length, $search_key_val=''){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,r.m_rtn_type_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('return_master o');
        $this->db->join("customer c", "c.cus_id = o.rtn_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.rtn_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.rtn_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.rtn_approval_status', 'inner');
        $this->db->join('master_return_type r', 'r.m_rtn_type_id = o.return_type_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where("o.rtn_approval_status = 1 AND o.pickup_status = 1 AND o.account_approval_status = 0 AND rtn_status = 1 AND o.rtn_ref_no LIKE '$search_key_val%'");
             $this->db->or_where("o.rtn_approval_status = 1 AND o.pickup_status = 1 AND o.account_approval_status = 0  AND rtn_status = 1 AND c.cus_name LIKE '$search_key_val%'");
             $this->db->or_where("o.rtn_approval_status = 1 AND o.pickup_status = 1 AND o.account_approval_status = 0  AND rtn_status = 1 AND c.cuscode_name LIKE '$search_key_val%'");
        }else{
            $this->db->where("o.rtn_approval_status = 1 AND o.pickup_status = 1 AND o.account_approval_status = 0 AND rtn_status = 1");
        }
		$this->db->order_by("o.rtn_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }



	function get_account_approval_return_list(){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,r.m_rtn_type_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('return_master o');
        $this->db->join("customer c", "c.cus_id = o.rtn_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.rtn_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.rtn_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.rtn_approval_status', 'inner');
        $this->db->join('master_return_type r', 'r.m_rtn_type_id = o.return_type_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->where("o.rtn_approval_status = 1 AND o.pickup_status = 1 AND o.account_approval_status = 0 AND rtn_status = 1");
		$this->db->order_by("o.rtn_id", "desc");
        $query = $this->db->get();
        return $query->result();
           
    }
	
	
	
	
function get_store_approval_return_list($start, $length, $search_key_val){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,r.m_rtn_type_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('return_master o');
        $this->db->join("customer c", "c.cus_id = o.rtn_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.rtn_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.rtn_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.rtn_approval_status', 'inner');
        $this->db->join('master_return_type r', 'r.m_rtn_type_id = o.return_type_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where("o.rtn_approval_status != 2 AND  o.allocated_delievery = 0 AND o.allocated_dispatch_note = 0 AND o.pickup_status = 0 AND o.account_approval_status = 0 AND rtn_status = 1 AND o.rtn_ref_no LIKE '$search_key_val%'");
             $this->db->or_where("o.rtn_approval_status != 2 AND o.allocated_delievery = 0 AND o.allocated_dispatch_note = 0 AND o.pickup_status = 0 AND o.account_approval_status = 0  AND rtn_status = 1 AND c.cus_name LIKE '$search_key_val%'");
             $this->db->or_where("o.rtn_approval_status != 2 AND  o.allocated_delievery = 0 AND o.allocated_dispatch_note = 0 AND o.pickup_status = 0 AND o.account_approval_status = 0  AND rtn_status = 1 AND c.cuscode_name LIKE '$search_key_val%'");
        }else{
            $this->db->where("o.rtn_approval_status != 2 AND o.allocated_delievery = 0 AND o.allocated_dispatch_note = 0 AND o.pickup_status = 0 AND o.account_approval_status = 0 AND rtn_status = 1");
        }
		$this->db->order_by("o.rtn_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
	
	
	 function insert_return_stock_table($data){
		 $this->db->insert('return_stock',$data);
		 return $this->db->insert_id();
	}
	
	 function insert_batch_table($data){
		 $this->db->insert('batch_product',$data);
		 return $this->db->insert_id();
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//******************************************************************************************
	

	
	

	
	
	public function get_order_product_price_cost($product_id)
	{
		$this->db->select("p.product_price,p.credit_salling_price,p.wholesale_price,p.product_cost");
        $this->db->from('product p');
        $this->db->where('p.product_id',$product_id);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	

	
	
	
	
	
	
	
	
	
		public function get_order_list_pp($id)
	{
		 $this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code");
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }
	}
	
	function get_order_approval_pending_list($start, $length, $search_key_val){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where("o.odr_approval_status = 0 AND o.odr_status = 1 AND o.odr_ref_no LIKE '$search_key_val%'");
             $this->db->or_where("o.odr_approval_status = 0 AND o.odr_status = 1 AND c.cus_name LIKE '$search_key_val%'");
        }else{
                $this->db->where("o.odr_approval_status = 0 AND o.odr_status = 1");
        }
		$this->db->order_by("o.odr_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    function get_order_approved_pending_pickup_list()
    {
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        $this->db->order_by("o.odr_priority", "asc");
		$this->db->order_by("o.odr_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
    function get_order_approved_pending_pickup_item_list(){
       $this->db->select("oi.*,p.product_name,p.product_code,u.unit_code");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        $this->db->order_by('o.odr_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
     function get_order_approved_pending_pickup_products(){
       $this->db->select("oi.product_id");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        $this->db->where("o.odr_approval_status = 1 AND o.odr_status = 1 AND o.pickup_status = 0 ");
        $this->db->group_by('oi.product_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    function save_order_plan($data){
		 $this->db->insert('order_plan_master',$data);
		 return $this->db->insert_id();
	}
	function save_order_plan_item($data){
		 $this->db->insert('order_plan_item',$data);
		 return $this->db->insert_id();
	}
	 function get_order_plan_list($start, $length, $search_key_val){
        $this->db->select('p.*,m.mas_name');
        $this->db->select('u.user_first_name AS added_user_first_name ,u.user_last_name AS added_user_last_name');
        $this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_master p');
        $this->db->join('master_approval_status m', 'm.approval_status_id = p.opm_approval_status', 'inner');
        $this->db->join('user u', 'u.user_id = p.added_user_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where(" p.prm_ref_no LIKE '$search_key_val%'");
        }else{
    
        }
		$this->db->order_by("p.opm_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
     function get_order_approved_completed_pickup_list($id){
       	$this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code,m.mas_name,opm.opm_approval_status");
       	$this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_item opi');
        $this->db->join("order_plan_master opm", "opm.opm_id = opi.opm_id", "inner");
        $this->db->join("order_master o", "o.odr_id = opi.order_id", "inner");
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "inner");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "inner");
        $this->db->join('master_approval_status m', 'm.approval_status_id = o.odr_approval_status', 'inner');
        $this->db->join('user ua', 'ua.user_id = o.approval_by', 'left'); 
        $this->db->where("opi.opm_id",$id);
        $this->db->order_by("o.odr_priority", "asc");
		$this->db->order_by("o.odr_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
     public function get_order_approved_completed_pickup_item_list($id){
       $this->db->select("oi.*,p.product_name,p.product_code,u.unit_code");
        $this->db->from('order_items oi');
        $this->db->join("order_plan_item o", "o.order_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->join("mstr_unit u", "u.unit_id = p.product_unit", "inner");
        $this->db->where("o.opm_id",$id);
        $this->db->order_by('o.order_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function delete_order_plan_item($id){
	    if($id>0){
	       $this->db->where('order_id', $id);
		return $this->db->delete('order_plan_item'); 
	    }else{
	        return false;
	    }
	}
	 public function update_order_plan_master($id,$data){
	     if($id>0){
	   	$this->db->where('opm_id', $id);
		return $this->db->update('order_plan_master',$data);
	     }else{
	        return false;
	    }
	}
	public function get_planned_order_list($id){
	    $this->db->select("o.*");
        $this->db->from('order_plan_item opi');
        $this->db->join("order_master o", "o.odr_id = opi.order_id", "inner");
        $this->db->where("opi.opm_id",$id);
       $this->db->group_by("o.odr_id");
        $query = $this->db->get();
        return $query->result_array();
	}
	 function get_planned_order_item_list($id){
       $this->db->select("oi.*,p.product_price,p.wholesale_price,p.credit_salling_price,p.product_weight,,p.product_cost,o.price_type_id");
        $this->db->from('order_items oi');
        $this->db->join("order_master o", "o.odr_id = oi.odr_id", "inner");
        $this->db->join("product p", "p.product_id = oi.product_id", "inner");
        $this->db->where("oi.odr_id",$id);
        $this->db->order_by('o.odr_id','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
	 function save_dispach_note($data){
		 $this->db->insert('dispatch_note_master',$data);
		 return $this->db->insert_id();
	}
	function save_dispach_note_item($data){
		 $this->db->insert('dispatch_note_item',$data);
		 return $this->db->insert_id();
	}
	function get_order_plan_details($id){
        $this->db->select('p.*,m.mas_name');
        $this->db->select('u.user_first_name AS added_user_first_name ,u.user_last_name AS added_user_last_name');
        $this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('order_plan_master p');
        $this->db->join('master_approval_status m', 'm.approval_status_id = p.opm_approval_status', 'inner');
        $this->db->join('user u', 'u.user_id = p.added_user_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        $this->db->where("p.opm_id",$id);
        $query = $this->db->get();
        return $query->row_array();
    }
   
    public function update_dispatch_note($id,$data){
	     if($id>0){
	   	$this->db->where('dpn_id', $id);
		return $this->db->update('dispatch_note_master',$data);
	     }else{
	        return false;
	    }
	}
	function get_loading_unloading_charge(){
	    $this->db->select("o.*");
        $this->db->from('loading_and_unloading_chagers o');
        $this->db->where('o.id',1);
        $query = $this->db->get();
        $result = $query->row_array();
        if(isset($result['unit_qty'])&&isset($result['charge'])){
           return $return_data=array('unit_qty'=>$result['unit_qty'],'charge'=>$result['charge']);
        }else{
            return $return_data=array('unit_qty'=>0,'charge'=>0);
        }
	}
	function check_product_batch_validation($id){
	    $this->db->from('product o');
        $this->db->where('o.product_id',$id);
        $this->db->where('o.is_batch_validate',1);
        $query = $this->db->get();
        return $query->num_rows() ;
	}
    function get_active_batch_list($product_id){
        $this->db->select("o.*");
        $this->db->from('batch_product o');
        $this->db->where('o.product_id',$product_id);
        $this->db->where('o.batch_status',1);
        $query = $this->db->get();
        return $query->result_array() ; 
    }
    function get_batch_details($id){
        $this->db->select("o.*");
        $this->db->from('batch_product o');
        $this->db->where('o.batch_id',$id);
        $query = $this->db->get();
        return $query->row_array() ; 
    }
    function check_batch_validation($id)
	{
		$this->db->from('order_items o');
        $this->db->where('o.odri_id',$id);
        $this->db->where('o.is_batch_validate',1);
        $query = $this->db->get();
        return $query->num_rows() ;
	}
	 function get_order_approved_qty($id)
	{
	    $this->db->select("o.approved_qty");
		$this->db->from('order_items o');
        $this->db->where('o.odri_id',$id);
        $query = $this->db->get();
        $result = $query->row_array() ;
        if(isset($result['approved_qty'])){
            return $result['approved_qty'];
        }else{
            return  0;
        }
	}
	function get_original_invoice_dynamic($search_key_val,$return_invoice_type,$customer_id,$warehouse_id){
	    $this->db->select("o.sale_id,o.sale_reference_no,o.card_ref_number");
        $this->db->from('sales o');
        if($return_invoice_type && $customer_id && $warehouse_id){
          $this->db->where("o.sale_status = 1  AND o.warehouse_id = ".$warehouse_id." AND o.invoice_type = ".$return_invoice_type." AND o.customer_id = ".$customer_id." AND   o.sale_reference_no LIKE '%$search_key_val%'");  
        }else{
             $this->db->where("o.sale_status = -1 ");  
        }
        $this->db->limit(100);
        $query = $this->db->get();
        return $query->result_array();
	}
	
		function get_original_invoice_item_dynamic($search_key_val,$invoice_id){
	    $this->db->select("o.id,o.quantity,o.unit_price,p.product_code,p.product_name");
        $this->db->from('sale_items o');
        $this->db->join('product p','p.product_id=o.product_id','inner');
        if($invoice_id){
          $this->db->where("o.sale_id = ".$invoice_id."  AND   p.product_code LIKE '%$search_key_val%'");  
          $this->db->or_where("o.sale_id = ".$invoice_id."  AND   p.product_name LIKE '%$search_key_val%'"); 
        }else{
             $this->db->where("o.sale_id = -1 ");  
        }
        $this->db->limit(100);
        $query = $this->db->get();
        return $query->result_array();
	}
	
	function get_sale_item_details($id){
	     $this->db->select("o.*");
        $this->db->from('sale_items o');
        $this->db->where('o.id',$id);
        $query = $this->db->get();
        return $query->row_array() ;  
	}
	
}