<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sys_Settings_Model extends CI_Model {
  
  private $tableName = 'system_settings';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
 

	function save_sys_setting($vehicle_data,$vehicle_id=false)
	{
		if (!$vehicle_id)
		{
			$this->db->insert($this->tableName,$vehicle_data);
		}else {
			$this->db->where('sys_setting_id', $vehicle_id);
			return $this->db->update($this->tableName,$vehicle_data);
		}
	}	

		function get_all_sys_setting_list() {
		$this->db->select($this->tableName.'.*');
		
		$this->db->order_by("sys_setting_id", "desc");
		$this->db->where("sys_setting_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result(); 
	}
	
		
	function get_all_sys_setting() {
		$this->db->select('system_settings.*');
		$this->db->from('system_settings');
		$this->db->order_by('sys_setting_id', 'desc');
		$this->db->where("sys_setting_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		
		
		//print_r($query);
		return $query->result_array();
	}
	

	
	
	
	
	public function get_sys_setting_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("sys_setting_id", $id);
		$this->db->order_by("sys_setting_id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
	
	public function delete_sys_setting($id)
	{
	    return false;
		$this->db->where('sys_setting_id', $id);
		$this->db->delete($this->tableName);
	
	}

	public function disable_sys_setting($id)
	{
		$data = array(
			'system_setting_status' => 0,
			'last_modify_by'=>$this->session->userdata('ss_user_id'),
			'last_update_on'=>date("Y-m-d H:i:s"),
		);	
		$this->db->where('sys_setting_id', $id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_sys_setting($id)
	{
		$data = array(
			'system_setting_status' => 1,
			'last_modify_by'=>$this->session->userdata('ss_user_id'),
			'last_update_on'=>date("Y-m-d H:i:s"),
		);	
		$this->db->where('sys_setting_id', $id);
		$this->db->update($this->tableName, $data);
	}
}