<?php
 
class Batch_Process_Model extends CI_Model {
  
  
  function __construct() 
  {
    parent::__construct();
  }

  public function get_product_by_code($term = '')
  {
    $this->db->select('*');
    $this->db->from('product p');
    //$this->db->where('p.product_status',1);
    $this->db->where('p.product_status = 1 AND p.sub_product_of = 0 AND `product_code` LIKE "%'.$term.'%"');
    $this->db->or_where('p.product_status = 1 AND p.sub_product_of = 0 AND `product_name` LIKE "%'.$term.'%"');
    $query=$this->db->get();
     if($query->num_rows() >0)
     {
       //echo $this->db->last_query();
       return $query->result();
     }
     else
     {
       return false;
     }
  }
  
  	//get Purchased Qty By WarehouseId
	public function getPurchasedQtyByWarehouseId($warehouse_id,$product_id,$srh_from_date='',$srh_to_date='')
	{
		$this->db->select_sum('pi.quantity');
		$this->db->from('purchase_items pi');
		$this->db->join('purchases p', 'p.id = pi.purchase_id', 'left');
		if($warehouse_id)
		$this->db->where('p.warehouse_id',$warehouse_id);
		$this->db->where('pi.product_id',$product_id);
		if($srh_to_date){
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date . "+1 days"));
			$this->db->where("p.date <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){
			$this->db->where("p.date >=",$srh_from_date);//("id !=",$id);
		}
		$query=$this->db->get();
		//echo $this->db->last_query();
		return $data['quantity']=$query->row()->quantity;
	}

  function get_tax_by_id($tax_id='')
  {
     $this->db->select('t.*');
     $this->db->from('tax_rates t');
     $this->db->where('t.id',$tax_id); 
     $query = $this->db->get();
   
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
  }

  public function get_warehouse()
  {
     $this->db->select('*');
     $this->db->from('warehouses');
     $query = $this->db->get();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
  }

  public function get_supplier()
  {
     $this->db->select('*');
     $this->db->from('supplier');
     $query = $this->db->get();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
  }

  public function add_grn_header($podate,$reference_no,$supplier,$discount,$powarehouse,$note,$grand_total,$total,$order_cal_des,$supp_invocie_no)
  {
    $data = array(
       'reference_no' => $reference_no ,
       'warehouse_id' => $powarehouse,
       'supplier_id'  => $supplier,
       'date'         => date('Y-m-d H:i', strtotime($podate)),
       'note'         => $note,
       'total'        => $total,
       'grand_total'  => $grand_total,
       'discount'     => $discount,
       'discount_cal' => $order_cal_des,
	   'supp_invocie_no'=>$supp_invocie_no
    );

    if($this->db->insert('purchases', $data)){
      return $this->db->insert_id();
    }else{
      return false;
    }
  }
  
  
  	//Sales item save
	function save_grn_item($data_item)
	{
			$this->db->insert('purchase_items',$data_item);
	}
	
	function save_grn($data_item,$grn_id=false)
	{
			
		if (!$grn_id)
		{
			$this->db->insert('purchases',$data_item);
		}else {
			$this->db->where('id', $grn_id);
			return $this->db->update('purchases',$data_item);
		}
	}

  public function add_grn_list_item( $product_id_array, $grn_header_id,$product_array, $product_name_array, $unit_cost_array, $quantity_array, $product_discount_array,$gross_total,$sub_total,$discount_cal)
  {
    $data = array(
       'purchase_id'  => $grn_header_id ,
       'product_id'   => $product_id_array,
       'product_code' => $product_array,
       'product_name' => $product_name_array,
       'quantity'     => $quantity_array,
       'unit_price'   => $unit_cost_array,
       'sub_total'    => $sub_total,
       'discount'     => $product_discount_array,
       'discount_cal' => $discount_cal
    );

    if($this->db->insert('purchase_items', $data)){
      return true;
    }else{
      return false;
    }
  }
  public function getpurchases()
  {
     $this->db->select("p.product_name,p.product_code");
     $this->db->select("spl.supp_company_name");
     $this->db->select("si.*");
     $this->db->select("s.reference_no,s.supp_invocie_no,s.date");
     $this->db->from("purchase_items si");
     $this->db->join("product p", "p.product_id = si.product_id", "left"); 
     $this->db->join("purchases s", "s.id = si.purchase_id", "left"); 
     $this->db->join("supplier spl", "spl.supp_id = s.supplier_id", "left");
     $this->db->where("si.is_batch_created",0);
     $this->db->order_by("s.reference_no", "desc");
     $query = $this->db->get();  
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {

       return false;
     }
  }

  public function get_gen_item_id_details($id){
     $this->db->select("p.product_name,p.product_code");
     $this->db->select("spl.supp_company_name");
     $this->db->select("si.*");
     $this->db->select("s.reference_no,s.supp_invocie_no,s.date");
     $this->db->from("purchase_items si");
     $this->db->join("product p", "p.product_id = si.product_id", "left"); 
     $this->db->join("purchases s", "s.id = si.purchase_id", "left"); 
     $this->db->join("supplier spl", "spl.supp_id = s.supplier_id", "left");
     $this->db->where("si.id",$id);
     $query = $this->db->get();  
     return $query->row_array();
  }
  
  	function save_batch($data_item)
	{
		$result=$this->db->insert('batch_product',$data_item);
		return $result;
	}
	
	public function update_product($id)
	{
	    if($id>0){
	        	$data = array(
			'is_batch_created' => 1
		);	
		$this->db->where('id', $id);
		$this->db->update('purchase_items', $data);
	        
	    }else{
	        //echo "Update Error";
	        return false;
	    }
	
	}
	
	
	 public function get_batch_list_by_product_id($id){
     $this->db->select("si.*");
     $this->db->from("batch_product si");
     $this->db->where("si.product_id",$id);
     $this->db->where("si.is_deleted",0);
     $query = $this->db->get();  
     return $query->result();
  }
  
  	public function update_batch($id,$data)
	{
	    if($id>0){
		$this->db->where('batch_id', $id);
		return $this->db->update('batch_product', $data);
	    }else{
	        return false;
	    }
	}
  
  
 


}