<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Hw_Delivery_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	
	
	public function update_vehicle($id,$data)
	{
		if($id>0)
		{
			$this->db->where('id', $id);
			return $this->db->update('store_note_items', $data);	
		}
		else{
			return false;
		}
	}
	
		public function update_master($id,$data)
	{
		if($id>0)
		{
			$this->db->where('stn_id', $id);
			return $this->db->update('store_notes', $data);	
		}
		else{
			return false;
		}
	}
	
	function get_all_store_note($id=''){
	    $this->db->select('stn.*,wh.id,wh.name,u.user_first_name');
		$this->db->from('store_notes stn')
		->join('warehouses wh', 'wh.id = stn.warehouse_id', 'left')
		->join('user u', 'u.user_id = stn.completed_by', 'left')
		;
		$this->db->where('stn.sale_id', $id);
		$this->db->order_by("stn.stn_code", "asc");
		$query=$this->db->get();
	    return $query->result_array();           
	
	}
	
	public function get_delivary_details($vehicle_id)
	{
		$this->db->select('stni.*,product.product_name');
		$this->db->select('vehicles.vehicle_code');	
		$this->db->select('drivers.driver_name');	
		
		$this->db->from('store_note_items stni');
		$this->db->join('product','product.product_id = stni.product_id');
		$this->db->join('vehicles','stni.vhicle_id=vehicles.vehicle_id','left');		
		$this->db->join('drivers','vehicles.vehicle_id=drivers.driver_id','left');
		
		
		$this->db->where("stni.vhicle_id",$vehicle_id);
		$this->db->where("stni.customer_issued",0);
		
		
		
		$query=$this->db->get();
		return $query->result_array();
	}
	public function get_delivary_stns($vehicle_id)
	{
		$this->db->select('*');
		$this->db->select('vehicles.vehicle_code');	
		$this->db->select('drivers.driver_name');	
		$this->db->select('product.product_name');	
		
		$this->db->from('store_notes stn');
		$this->db->join('store_note_items stni','stn.stn_no = stni.stn_no AND stn.warehouse_id = stni.stn_wh_id');
		
		$this->db->join('product','product.product_id = stni.product_id');
		$this->db->join('vehicles','stni.vhicle_id=vehicles.vehicle_id','left');		
		$this->db->join('drivers','vehicles.driver_id=drivers.driver_id','left');
		
		
		$this->db->where("stni.vhicle_id",$vehicle_id);
		$this->db->where("stni.customer_issued",0);
		
		
		
		$query=$this->db->get();
		
		//echo $this->db->last_query();
		
		return $query->result_array();
	}

		
	
	
	
}