<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_Analyse_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

  function get_sale_product_list($cat_id='',$from='',$to='',$route_id=''){
    $this->db->select('p.product_code,p.product_id'); 
    $this->db->from('sale_items si');
    $this->db->join('sales s','s.sale_id=si.sale_id','inner');
    $this->db->join('product p','p.product_id=si.product_id','inner');
    if($route_id){
    $this->db->join('customer c','c.cus_id=s.customer_id','inner');
    $this->db->join('routes r','r.route_id=c.route_id','inner');
    }
    if($cat_id){
        $this->db->where('p.cat_id',$cat_id);
    }
     if($from){
        $this->db->where("date(s.sale_datetime) >=",$from);
    }
     if($to){
       	$this->db->where("date(s.sale_datetime) <=",$to);
    }
    if($route_id){
        $this->db->where('r.area_id',$route_id);
    }
    //$this->db->limit(1000);
    $this->db->group_by('si.product_id');
    $query = $this->db->get();
    return $query->result_array();
  }
  
  function get_sale_customer_list($cat_id='',$from='',$to='',$route_id=''){
    $this->db->select('c.cus_id,c.cus_name,c.cus_code'); 
    $this->db->from('customer c');
    $this->db->join('sales s','c.cus_id=s.customer_id','inner');
     if($route_id){
    $this->db->join('routes r','r.route_id=c.route_id','inner');
    }
    if($cat_id){
        $this->db->where('p.cat_id',$cat_id);
    }
     if($from){
        $this->db->where("date(s.sale_datetime) >=",$from);
    }
     if($to){
       	$this->db->where("date(s.sale_datetime) <=",$to);
    }
     if($route_id){
        $this->db->where('r.area_id',$route_id);
    }
    $this->db->limit(1000);
    $this->db->group_by('s.customer_id');
    $query = $this->db->get();
    return $query->result_array();}

	
	function get_customer_name(){
		$this->db->select('c.cus_name,c.cus_id'); 
		$this->db->from('customer c');
		$this->db->limit(50);
		$query = $this->db->get();
	return $query->result_array();}
	

  function get_sale_qty_value_total($cus_id='',$product_id='',$from='',$to=''){
    $this->db->select_sum('si.quantity');
    $this->db->select_sum('si.net_total');
    $this->db->from('sale_items si');
    $this->db->join('sales s','s.sale_id=si.sale_id','inner');
    
    if($cus_id){
        $this->db->where('s.customer_id',$cus_id);
    }
     if($product_id){
        $this->db->where('si.product_id',$product_id);
    }
     if($from){
        $this->db->where("date(s.sale_datetime) >=",$from);
    }
     if($to){
       	$this->db->where("date(s.sale_datetime) <=",$to);
    }
    $query = $this->db->get();
    $result= $query->row_array();
    $data=array('qty'=>0,'value'=>0);
    if(isset($result['quantity'])){
         $data=array('qty'=>$result['quantity'],'value'=>$result['net_total']);
    }
    return $data;
  }



    function get_sale_item_product_list($cat_id='',$from='',$to='',$route_id=''){
    $this->db->select('p.product_id,s.customer_id,si.quantity'); 
    $this->db->from('sale_items si');
    $this->db->join('product p','p.product_id=si.product_id','inner');
    $this->db->join('sales s','s.sale_id=si.sale_id','inner');
     if($route_id){
    $this->db->join('customer c','c.cus_id=s.customer_id','inner');
    $this->db->join('routes r','r.route_id=c.route_id','inner');
    }
    
       if($cat_id){
        $this->db->where('p.cat_id',$cat_id);
    }
     if($from){
        $this->db->where("date(s.sale_datetime) >=",$from);
    }
     if($to){
       	$this->db->where("date(s.sale_datetime) <=",$to);
    }
     if($route_id){
        $this->db->where('r.area_id',$route_id);
    }
    $this->db->limit(5000);
    $query = $this->db->get();
    return $query->result();
  }
    
  
function get_sale_product_value($cat_id='',$from='',$to='',$route_id='',$cus_id=''){
    $this->db->select_sum('si.net_total'); 
    $this->db->from('sale_items si');
    $this->db->join('product p','p.product_id=si.product_id','inner');
    $this->db->join('sales s','s.sale_id=si.sale_id','inner');
    if($route_id){
    $this->db->join('customer c','c.cus_id=s.customer_id','inner');
    $this->db->join('routes r','r.route_id=c.route_id','inner');
    }
    if($cat_id){
        $this->db->where('p.cat_id',$cat_id);
    }
     if($from){
        $this->db->where("date(s.sale_datetime) >=",$from);
    }
     if($to){
       	$this->db->where("date(s.sale_datetime) <=",$to);
    }
    if($cus_id){
      $this->db->where('s.customer_id',$cus_id);  
    }
    if($route_id){
        $this->db->where('r.area_id',$route_id);
    }
    $query = $this->db->get();
    $result= $query->row_array();
    if(isset($result['net_total'])){
        return $result['net_total'];
    }else{
        return 0;
    }
  }

//retun

function get_sale_return_product_list($cat_id='',$from='',$to='',$route_id=''){
    $this->db->select('p.product_code,p.product_id'); 
    $this->db->from('delivery_return_items si');
    $this->db->join('product p','p.product_id=si.product_id','inner');
    $this->db->join('delivery_return_master s','s.delivery_return_id=si.delivery_return_id','inner');
    if($route_id){
    $this->db->join('customer c','c.cus_id=s.customer_id','inner');
    $this->db->join('routes r','r.route_id=c.route_id','inner');
    }
    if($cat_id){
        $this->db->where('p.cat_id',$cat_id);
    }
     if($from){
        $this->db->where("date(s.system_date_time) >=",$from);
    }
     if($to){
       	$this->db->where("date(s.system_date_time) <=",$to);
    }
    if($route_id){
        $this->db->where('r.area_id',$route_id);
    }
    $this->db->limit(1000);
    $this->db->group_by('si.product_id');
    $query = $this->db->get();
    return $query->result_array();
  }
  
  function get_sale_return_customer_list($cat_id='',$from='',$to='',$route_id=''){
    $this->db->select('c.cus_id,c.cus_name,c.cus_code'); 
    $this->db->from('customer c');
    $this->db->join('delivery_return_master s','c.cus_id=s.customer_id','inner');
     if($route_id){
   
    $this->db->join('routes r','r.route_id=c.route_id','inner');
    }
    if($cat_id){
        $this->db->where('p.cat_id',$cat_id);
    }
     if($from){
        $this->db->where("date(s.system_date_time) >=",$from);
    }
     if($to){
       	$this->db->where("date(s.system_date_time) <=",$to);
    }
     if($route_id){
        $this->db->where('r.area_id',$route_id);
    }
    $this->db->limit(1000);
    $this->db->group_by('s.customer_id');
    $query = $this->db->get();
    return $query->result_array();
  }

    function get_sale_return_item_product_list($cat_id='',$from='',$to='',$route_id=''){
    $this->db->select('p.product_id,s.customer_id,si.product_qty'); 
    $this->db->from('delivery_return_items si');
    $this->db->join('product p','p.product_id=si.product_id','inner');
     $this->db->join('delivery_return_master s','s.delivery_return_id=si.delivery_return_id','inner');
     if($route_id){
    $this->db->join('customer c','c.cus_id=s.customer_id','inner');
    $this->db->join('routes r','r.route_id=c.route_id','inner');
    }
    
       if($cat_id){
        $this->db->where('p.cat_id',$cat_id);
    }
     if($from){
        $this->db->where("date(s.system_date_time) >=",$from);
    }
     if($to){
       	$this->db->where("date(s.system_date_time) <=",$to);
    }
     if($route_id){
        $this->db->where('r.area_id',$route_id);
    }
    $this->db->limit(5000);
    $query = $this->db->get();
    return $query->result();
  }
    
    function get_sale_return_product_value($cat_id='',$from='',$to='',$route_id='',$cus_id=''){
    $this->db->select_sum('si.product_total_sale_value'); 
    $this->db->from('delivery_return_items si');
    $this->db->join('product p','p.product_id=si.product_id','inner');
    $this->db->join('delivery_return_master s','s.delivery_return_id=si.delivery_return_id','inner');
    if($route_id){
    $this->db->join('customer c','c.cus_id=s.customer_id','inner');
    $this->db->join('routes r','r.route_id=c.route_id','inner');
    }
    if($cat_id){
        $this->db->where('p.cat_id',$cat_id);
    }
     if($from){
        $this->db->where("date(s.system_date_time) >=",$from);
    }
     if($to){
       	$this->db->where("date(s.system_date_time) <=",$to);
    }
    if($cus_id){
      $this->db->where('s.customer_id',$cus_id);  
    }
    if($route_id){
        $this->db->where('r.area_id',$route_id);
    }
    $query = $this->db->get();
    $result= $query->row_array();
    if(isset($result['product_total_sale_value'])){
        return $result['product_total_sale_value'];
    }else{
        return 0;
    }
  }

  















   
   
}