<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Designation extends MY_Controller {

    private $model; 
    public function __construct()
    {
        parent::__construct();
        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
        $this->load->model('designation_model');
        $this->model = $this->designation_model;
        
    }
    // this function for index page (Home)
    function index($id=null)
    {
        $data = $this->data;
        $data['page'] = 'designation';
        $data['Edit'] = $this->Edit;
        if($id and $data['Edit'])
        {
            $data['edit'] = true;
            $data['designation'] = $this->model->get_info($id,$this->attn->getComp());
        }
        $data['message'] = view_error($this->messages->get());
        $this->load->view('templates/designation/add',$data);
    }

    public function getDesignations()
    {
        $this->load->library('datatables');
        $action = '<div class="d-flex align-items-sm justify-content-sm">
        <a href="'.site_url('designation/edit/$1/').'" class="btn btn-sm btn-icon"><i class="bx bx-edit"></i></a>
        </div>';
        $this->datatables
            ->select("Id,Code,Name,TJobs")
            ->from("designation")
            ->where($this->db->dbprefix('designation') . '.Comp', $this->attn->getComp())
            ->add_column("Actions", $action, "Id")
        ->unset_column('Id');
        echo $this->datatables->generate();
    }

    function add()
    {
        $data = $this->data;
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('Name', 'Name', 'trim|required');
        $this->form_validation->set_rules('Code', 'Code', 'trim|required|is_unique[designation.Code]');
        if ($this->form_validation->run('designation/add') == true) {
            $d_data = array(
                'Comp' => $this->attn->getComp(),
                'Code' => $this->input->post('Code'),
                'Name' => $this->input->post('Name'),
                'TJobs' => $this->input->post('TJobs'),
            );
            //echo '<pre>',print_r($d_data); die();

        } elseif ($this->input->post('add')) {
            $this->messages->add(validation_errors(), "error");
            redirect('designation/add');
        }
        if ($this->form_validation->run() == true && $this->model->AddRecord($d_data)) {
            $this->messages->add('Designation successfully added', "success");
            redirect('designation/add');
        } else {
            $data['page'] = 'designation';
            $data['Edit'] = $this->Edit;
            $data['page_title'] = 'Add Designation';
            $data['heading'] = 'Master Files';
            /*if($id and $data['Edit'])
            {
                $data['edit'] = true;
                $data['designation'] = $this->model->get_info($id,$this->attn->getComp());
            }*/
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/designation/add',$data);
        }
    }

    function edit($id=null)
    {
        $data = $this->data;
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('Name', 'Name', 'trim|required');
        if ($this->form_validation->run('designation/edit') == true) {
            $d_data = array(
                'Code' => $this->input->post('Code'),
                'Name' => $this->input->post('Name'),
                'TJobs' => $this->input->post('TJobs'),
            );

        } elseif ($this->input->post('edit_designation')) {
            $this->messages->add(validation_errors(), "error");
            redirect('designation/edit/'.$id);
        }
        if ($this->form_validation->run() == true && $this->model->editRecord($d_data,$id)) {
            $this->messages->add('Designation successfully edited', "success");
            redirect('designation/add');
        } else {
            $data['page'] = 'designation';
            $data['Edit'] = $this->Edit;
            if($id)
            {
                $data['edit'] = true;
                $data['designation'] = $this->model->get_info($id,$this->attn->getComp());
            }
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/designation/edit',$data);
        }
    }

    public function post()
    {
        $post_id=$this->input->post('Id')=='' ? false:$this->input->post('Id');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('Name', 'Name', 'trim|required');
        if ($this->form_validation->run() == FALSE)
        {
            $this->messages->add(validation_errors(), "error");
            redirect('designation');
        }
        else
        {
            $d_data = array(
                'Comp' => ($this->input->post('Comp')!='') ? $this->input->post('Comp'):$this->session->userdata('Comp'),
                'Name' => $this->input->post('Name')
            );
            //get save id
            $returnId = $this->model->save($d_data,$post_id);
            $postType = ($post_id) ? 'edit' : 'post';
            if($returnId)
            {
                $this->messages->add($this->lang->line('success_designation_'.$postType), "success");
                redirect('designation');
            }
            else
            {
                if($this->messages->count() == 0) $this->messages->add($this->lang->line('error_designation_'.$postType), "error");
                redirect('designation');
            }
        }
    }
}
?>