<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Items extends MY_Controller {
	
	private $model;
	
	public function __construct()
	{
		parent::__construct();
		if (!$this->loggedIn) {
			$this->session->set_userdata('requested_page', $this->uri->uri_string());
			redirect('login');
		}
		$this->load->model('items_model');
		$this->model = $this->items_model;
	}

	// this function for index page (Home)
	function index()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['page'] = 'item';
		$data['Edit'] = $this->Edit;
		//$data['items'] = $this->model->get_all('A',$this->attn->getComp());
		$data['message'] = view_error($this->messages->get());
		$data['page_title'] = 'Allowances';
		$data['heading'] = 'Master Files';
		$data['v'] = '&type=A';
		$data['url'] = base_url('items');
		$this->load->view('templates/items/add-allowance',$data);
	}
	
	function deduction()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['page'] = 'deduction';
		//$data['items'] = $this->model->get_all('D',$this->attn->getComp());
		$data['message'] = view_error($this->messages->get());
		$data['page_title'] = 'Deduction';
		$data['heading'] = 'Master Files';
		$data['v'] = '&type=D';
		$data['url'] = base_url('items/deduction');
		$this->load->view('templates/items/add-deduction',$data);
	}
	
	function nopay()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['page'] = 'nopay';
		//$data['items'] = $this->model->get_all(array('N','L'),$this->attn->getComp());
		$this->load->model('settings_model');
		$data['setting'] = $this->settings_model->get_info($this->attn->getComp());
		$data['message'] = view_error($this->messages->get());
		$data['v'] = '&type=S';
		$data['page_title'] = 'No Pay';
		$data['heading'] = 'Master Files';
		$data['url'] = base_url('items/nopay');
		$this->load->view('templates/items/add-nopay',$data);
	}
	
	function over_time()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['page'] = 'over_time';
		$data['Edit'] = $this->Edit;
		//$data['items'] = $this->model->get_all('O',$this->attn->getComp());
		//echo '<pre>',print_r($data['items']); die();
		$this->load->model('settings_model');
		$data['setting'] = $this->settings_model->get_info($this->attn->getComp());
		$data['message'] = view_error($this->messages->get());
		$data['page_title'] = 'Orver Time Register';
		$data['heading'] = 'Master Files';
		$data['v'] = '&type=O';
		$data['table'] = 1;
		$data['url'] = base_url('items/over_time');
		$this->load->view('templates/items/add-over-time',$data);
	}
	
	public function edit($id=null, $code=null)
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		//$data['page'] = 'company';
		$data['Edit'] = $this->Edit;
		//$data['page'] = 'allowance';
		$data['page'] = 'item';
		$data['v'] = '&type=A';
		if($id and $code)
		{
			$where = array('Id' => $id, 'Code' => $code);
			$data['item'] = $this->model->get_info($where);
		}
		//$data['items'] = $this->model->get_all('A',$this->attn->getComp());
		$data['page_title'] = 'Allowances Edit';
		$data['heading'] = 'Master Files';
		$data['url'] = base_url('items');
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/items/add-allowance',$data);
	}
	
	public function deduction_edit($id=null, $code=null)
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		if($id and $code)
		{
			$where = array('Id' => $id, 'Code' => $code);
			$data['item'] = $this->model->get_info($where);
		}
		$data['page'] = 'deduction';
		$data['page_title'] = 'Deductions Edit';
		$data['heading'] = 'Master Files';
		$data['v'] = '&type=D';
		//$data['items'] = $this->model->get_all('D',$this->attn->getComp());
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/items/add-deduction',$data);
	}
	
	public function nopay_edit($id=null, $code=null)
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$this->load->model('settings_model');
		$data['setting'] = $this->settings_model->get_info($this->attn->getComp());
		$data['Edit'] = $this->Edit;
		if($id and $code)
		{
			$where = array('Id' => $id, 'Code' => $code);
			$data['item'] = $this->model->get_info($where);
			$data['edit'] = $this->Edit;
		}
		//$data['items'] = $this->model->get_all(array('N','L'),$this->attn->getComp());
		$data['message'] = view_error($this->messages->get());
		$data['page'] = 'nopay';
		$data['page_title'] = 'No Pay';
		$data['v'] = '&type=S';
		$data['heading'] = 'Master Files';
		$data['url'] = base_url('items/nopay');
		$this->load->view('templates/items/add-nopay',$data);
	}
	
	public function orver_time_edit($id=null, $code=null)
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$this->load->model('settings_model');
		$data['page_title'] = 'Orver Time Edit';
		$data['heading'] = 'Master Files';
		$data['page'] = 'over_time';
		$data['setting'] = $this->settings_model->get_info($this->attn->getComp());
		$data['Edit'] = $this->Edit;
		if($id and $code)
		{
			$where = array('Id' => $id, 'Code' => $code);
			$data['item'] = $this->model->get_info($where);
			$data['edit'] = $this->Edit;
		}
		$data['v'] = '&type=O';
		$data['table'] = 1;
		//$data['items'] = $this->model->get_all(array('O'),$this->attn->getComp());
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/items/add-over-time',$data);
	}
	
	public function get_ids()
	{
		$rtn = array();
		$Id = $this->input->post('Id');
		$ids = $this->model->get_all_by_id($Id);
		if($ids)
		{
			$rtn['type']= 1;
			$va = '<option value="0">--Select--</option>';
			foreach($ids as $id)
			{
				$va .= '<option value="'.$id->Code.'">'.$id->Name.'</option>';
			}
			$rtn['message']= $va;
		}
		else
		{
			$rtn['type']= 0;
			$rtn['message']='';
		}
		echo json_encode($rtn);
	}

	public function post()
	{
		//echo '<pre>', print_r($_POST),die(); 
		$post_id=$this->input->post('Id')=='' ? false:$this->input->post('Id');
		$url ='';
		switch($post_id)
		{
			case 'A':
				$url = 'items';
				break;
			case 'D':
				$url = 'items/deduction';
				break;
			case 'L':
				$url = 'items/nopay';
				break;
			case 'N':
				$url = 'items/nopay';
				break;	
			case 'O':
				$url = 'items/over_time';
				break;			
		}
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<span>', '</span>');
		if($post_id){
			$this->form_validation->set_rules('Code', 'Code', 'trim|required|min_length[1]|max_length[10]');
		}else{
			$this->form_validation->set_rules('Code', 'Code', 'trim|required|min_length[1]|max_length[10]|is_unique[items.Code]');
		}
		
		$this->form_validation->set_rules('Name', 'Name', 'trim|required');
		if ($this->form_validation->run() == FALSE)
		{
			$this->messages->add(validation_errors(), "error");
			//redirect($url);
			redirect($_SERVER["HTTP_REFERER"]);
		}
		else
		{
			$items_data = array(
			'Id' => $this->input->post('Id'),
			'Comp' => $this->attn->getComp(),
			'Name' => $this->input->post('Name', TRUE),
			'Code' => str_replace(' ', '', $this->input->post('Code', TRUE)),
			'Rate' => ($this->input->post('Rate', TRUE))?$this->input->post('Rate', TRUE):0.00,
			'EPF' => ($this->input->post('EPF'))? $this->input->post('EPF'):'no',
			'Tax' => ($this->input->post('Tax'))?$this->input->post('Tax'):'no',
			'Basic' => ($this->input->post('Basic'))?$this->input->post('Basic'):'no',
			'Fix' => ($this->input->post('Fix'))?$this->input->post('Fix'):'no',
			);

            if($this->input->post('Amount')){
                $items_data['Amount'] = $this->input->post('Amount');

            }
            //echo '<pre>',print_r($items_data); die();
			$where = array('Id' => $this->input->post('Id'), 'Code' => $this->input->post('Code'));
			
			//get save id
			$returnId = $this->model->save($items_data,$where);
			$postType = ($post_id) ? 'edit' : 'post';
			if($returnId)
			{
				$this->messages->add($this->lang->line('success_items_'.$postType), "success");
				//redirect($url);
				redirect($_SERVER["HTTP_REFERER"]);
			}
			else
			{
				if($this->messages->count() == 0) $this->messages->add($this->lang->line('error_items_'.$postType), "error");
				//redirect($url);
				redirect($_SERVER["HTTP_REFERER"]);
			}
		}	
	}

	//change status
	public function status($id)
	{
		if(isset($id))
		{
			if($this->model->change_status($id,$this->attn->getComp()))
			{
				$this->messages->add($this->lang->line('success_company_delete'), "success");
			}
			else
			{
				$this->messages->add($this->lang->line('error_company_delete'), "error");
			}
		}
		else
		{
			$this->messages->add($this->lang->line('error_company_delete'), "error");
		}
		redirect('add-department');
	}

	public function get_details_filter()
	{
		$type = isset($_GET['type'])?$_GET['type']:0;
		$url ='';
		switch($type)
		{
			case 'A':
				$url = 'items/edit';
				break;
			case 'D':
				$url = 'items/deduction_edit';
				break;
			case 'S':
				$url = 'items/nopay_edit';
				break;
			case 'O':
				$url = 'items/orver_time_edit';
				break;
		}
		$comp = $this->attn->getComp();
		$this->load->library('datatables');

		$action = '<div class="d-flex align-items-sm justify-content-sm">
        <a href="'.site_url($url.'/$1/$2').'" class="btn btn-sm btn-icon"><i class="bx bx-edit"></i></a>
        </div>';

		if($type=='S') {
			$this->datatables
				->select($this->db->dbprefix('items') . ".Id as id,
			" . $this->db->dbprefix('items') . ".Code AS Code,
			" . $this->db->dbprefix('items') . ".Name,
			" . $this->db->dbprefix('items') . ".Rate")
				->from("items")
				->join('comp', $this->db->dbprefix('items') . '.Comp=' . $this->db->dbprefix('comp') . '.Code', 'left')
				->where($this->db->dbprefix('items') . '.Id', 'N')
				->or_where($this->db->dbprefix('items') . '.Id', 'L')
				->where($this->db->dbprefix('items') . '.Comp', $comp)
				->add_column("Actions", "$action", "id,Code")
				->unset_column('id');
		}else if($type!='O' AND $type!='S') {
			$this->datatables
			->select($this->db->dbprefix('items') . ".Id as id,
			" . $this->db->dbprefix('items') . ".Code AS Code,
			" . $this->db->dbprefix('items') . ".Name,
			" . $this->db->dbprefix('items') . ".Amount,
			" . $this->db->dbprefix('items') . ".EPF,
			" . $this->db->dbprefix('items') . ".Basic,
			" . $this->db->dbprefix('items') . ".Fix")
				->from("items")
				->join('comp', $this->db->dbprefix('items') . '.Comp=' . $this->db->dbprefix('comp') . '.Code', 'left')
				->where($this->db->dbprefix('items') . '.Id', $type)
				//->where($this->db->dbprefix('items') . '.Comp', $comp)
			->add_column("Actions", $action, "id,Code")
			->unset_column('id');

		}else{

			$this->datatables
			->select($this->db->dbprefix('items') . ".Id as id,
			" . $this->db->dbprefix('items') . ".Code AS Code,
			" . $this->db->dbprefix('items') . ".Name,
			" . $this->db->dbprefix('items') . ".Rate")
				->from("items")
				->join('comp', $this->db->dbprefix('items') . '.Comp=' . $this->db->dbprefix('comp') . '.Code', 'left')
				->where($this->db->dbprefix('items') . '.Id', $type)
				//->where($this->db->dbprefix('items') . '.Comp', $comp)
			->add_column("Actions", $action, "id,Code")
				->unset_column('id');
		}

		echo $this->datatables->generate();

	}
}
?>