<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Leave_transaction extends MY_Controller {
	
	private $model;
	
	 public function __construct()
	{
		parent::__construct();
		if (!$this->loggedIn) {
			$this->session->set_userdata('requested_page', $this->uri->uri_string());
			redirect('login');
		}
		$this->load->model('transaction/leave_transaction_model');
		$this->model=$this->leave_transaction_model;
        //$this->model->apply_leaves();
	} 
	// this function for index page (Home)
	function index()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
        $data['page_title'] = 'Pending Leaves';
        $data['heading'] = 'Leaves';
		$data['message'] = view_error($this->messages->get());
		$data['shipts'] = $this->model->get_all($this->attn->getComp());
		$this->load->view('templates/transaction/shift_trsc_details',$data);
	}

    function pending()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
        $data['page_title'] = 'Pending Leaves';
        $data['heading'] = 'Leaves';
        $data['page'] = 'pending_leaves';
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/transaction/pending',$data);
	}

    function approved()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
        $data['page_title'] = 'Approved Leaves';
        $data['heading'] = 'Leaves';
        $data['page'] = 'approved_leaves';
		$data['message'] = view_error($this->messages->get());
		$this->load->view('templates/transaction/approved',$data);
	}

    public function post_leave_transaction($id=null)
    {
        //to get menus from Secure_area contraller
        $id = ($this->input->get('id'))?$this->input->get('id'):null;
        $code = ($this->input->get('code'))?$this->input->get('code'):null;
        $type= ($this->input->get('type'))?$this->input->get('type'):null;
        $date = ($this->input->get('date'))?$this->input->get('date'):null;
        //echo $date;
        //echo '<pre>',print_r($_GET); die();
        $data = $this->data;
        $data['Edit'] = $this->Edit; 
        $data['page'] = 'leaveTapply';
        $data['edit'] = false;
        if($id)
        {
            $data['emp'] = $id;
        }
        if($id and $code and $type and $date)
        {
            $where = array(
                'Comp_Id' => $this->attn->getComp(),
                'EmpNo' => $id,
                'Leave_Code' => $code,
                'LeaveType' => $type,
                'LeaveDate' => $date,
            );

            $data['edit'] = true;
            $data['leaveT'] = $this->model->get_leave($where);
            //echo '<pre>',print_r($data['leaveT']); die();
        }
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_emp_name();
        $this->load->model('leave_model');
        $data['LeaveCodes'] = $this->leave_model->get_all_leave_code();
        //echo '<pre>',print_r($data['LeaveCodes']); die();
        //$data['leaveTs'] = $this->model->get_all();
        $data['message'] = view_error($this->messages->get());
        $data['page_title'] = 'Leave Entry';
        $data['heading'] = 'Transaction';
        $data['url'] = base_url('leave-transaction');
        $this->load->view('templates/transaction/leave_t_add',$data);
    }

    function add($id=null)
    {
        $data = $this->data;
        if($id)
        {
            $data['emp'] = $id;
        }
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('EmpNo', 'Emp No', 'trim|required');
        $this->form_validation->set_rules('Leave_Code', 'Leave Code', 'trim|required');
        $this->form_validation->set_rules('Days', 'Days', 'trim|required');
        $this->form_validation->set_rules('LeaveFrom', 'Leave From Date', 'trim|required');
        $this->form_validation->set_rules('LeaveTo', 'Leave To Date', 'trim|required');
        if ($this->form_validation->run('leave_transaction/add') == true) {
            $leave_data = array(
                'Comp_Id' => $this->attn->getComp(),
                'EmpNo' => $this->input->post('EmpNo'),
                'Leave_Code' => $this->input->post('Leave_Code'),
                'LeaveType' => ($this->input->post('LeaveType'))?$this->input->post('LeaveType'):'full',
                'LeaveFrom' => $this->input->post('LeaveFrom'),
                'LeaveTo' => $this->input->post('LeaveTo'),
                'Year' => $yearOnly = date('Y', strtotime($this->input->post('LeaveFrom'))),
                'Days' => $this->input->post('Days'),
                'Reason' => $this->input->post('Reason'),
                'AddedUser' => $this->session->userdata('Unit_Id'),
            );
            $emp = $this->input->post('EmpNo');
        }elseif ($this->input->post('add_leave')) {
            $this->messages->add(validation_errors(), "error");
            redirect('leave_transaction/add');
        }

        if ($this->form_validation->run() == true && $this->model->save($leave_data)) {
            $this->messages->add($this->lang->line('success_leaveT_post'), "success");
            redirect('leave_transaction/add?id='.$emp);
        } else {
            $this->messages->add(validation_errors(), "error");
            $data['page'] = 'leaveTapply';
            $data['edit'] = false;
            $this->load->model('employee_model');
            $data['employees'] = $this->employee_model->get_all_emp_name();
            $this->load->model('leave_model');
            $data['LeaveCodes'] = $this->leave_model->get_all_leave_code();
            $data['page_title'] = 'Leave Entry';
            $data['heading'] = 'Timesheet';
            $data['url'] = base_url('leave-transaction');
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/transaction/leave_t_add',$data);
        }
    }


    function edit_year($id=null)
    {
        $this->attn->checkPermissions('leave_transaction_add');
        $data = $this->data;
        if($this->input->get('id'))
        {
            $data['emp'] =$this->input->get('id');
        }
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('EmpNo', 'Emp No', 'trim|required');
        $this->form_validation->set_rules('Leave_Code', 'Leave Code', 'trim|required');
        $this->form_validation->set_rules('Days', 'Days', 'trim|required');
        if ($this->form_validation->run('leave_transaction/edit_year') == true) {
            $where = array(
                'Comp_Id' => $this->attn->getComp(),
                'EmpNo' => $this->input->post('EmpNo'),
                'Leave_Code' => $this->input->post('Leave_Code'),
				'Year' => date('Y'),
            );
			$leave_data = array(
                'Days' => $this->input->post('Days'),
                'Balance' => $this->input->post('Balance'),
            );
            $emp = $this->input->post('EmpNo');
        }elseif ($this->input->post('add_leave')) {
            $this->messages->add(validation_errors(), "error");
            redirect('leave-transaction/edit_year');
        }

        if ($this->form_validation->run() == true && $this->model->edit_year_leaves($leave_data,$where)) {
            $this->messages->add('Year Leaves successfully updated', "success");
            redirect('leave_transaction/edit_year?id='.$emp);
        } else {
            $this->messages->add(validation_errors(), "error");
            $data['page'] = 'edit_year_leave';
            $data['edit'] = false;
            $this->load->model('employee_model');
            $data['employees'] = $this->employee_model->get_all_emp_name($this->attn->getComp());
            $this->load->model('leave_model');
            $data['LeaveCodes'] = $this->leave_model->get_all_leave_code($this->attn->getComp());
            $data['page_title'] = 'Leave Entry';
            $data['heading'] = 'Timesheet';
            $data['url'] = base_url('leave_transaction');
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/transaction/edit_year_leave',$data);
        }
    }

    function add_year($id=null)
    {
        $this->attn->checkPermissions('leave_transaction_add');
        $this->load->model('transaction/leave_transaction_model');
        $data = $this->data;
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('year', 'year', 'trim|required');
        if ($this->form_validation->run('leave_transaction/add_year') == true) {
            $year = $this->input->post('year');

        }elseif ($this->input->post('add_leave')) {
            $this->messages->add(validation_errors(), "error");
            redirect('leave-transaction/add_year');
        }

        if ($this->form_validation->run() == true && $this->leave_transaction_model->apply_leaves($year)) {
            $this->messages->add('Year Leaves successfully added', "success");
            redirect('leave_transaction/add_year');
        } else {
            $this->messages->add(validation_errors(), "error");
            $data['page'] = 'add_year_leave';
            $data['edit'] = false;
            $data['page_title'] = 'Year Leave Entry';
            $data['heading'] = 'Timesheet';
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/transaction/add_year_leave',$data);
        }
    }

    //view completed attendance month wise
    function monthly_got_leaves()
    {
        $data = $this->data;
        $data['page'] = 'monthly_got_leaves';
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_filter($this->attn->getComp());
        $v = "";
        if ($this->input->post('month') and $this->input->post('EmpNo')) {
            $v .= "&month=" . $this->input->post('month');
            $data['month'] = $this->input->post('month');
            $v .= "&EmpNo=" . $this->input->post('EmpNo');
            $data['EmpNo'] = $this->input->post('EmpNo');
            $month_leaves = $this->model->get_month_leaves($this->attn->getComp(),$data['month'],$data['EmpNo']);
            $month_nopay = $this->model->get_month_nopay($this->attn->getComp(),$data['month'],$data['EmpNo']);
            $data['month_leaves'] = $month_leaves;
            $data['month_nopay'] = $month_nopay;
            //$this->attn->p($month_leaves);die();
        }

        $data['v'] = $v;
        $data['message'] = view_error($this->messages->get());
        $data['page_title'] = 'Month Leaves';
        $data['heading'] = 'Transaction';
        $data['url'] = base_url('attendance');
        $this->load->view('templates/transaction/monthly_got_leaves', $data);
    }

    public function getLeaves()
    {
        $lastmonth = date('Y-m-d', strtotime(date('Y-m')." -1 month"));
        $emp = $this->input->get('emp');
        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('leave_transaction').".Leave_Code as Code,
            ".$this->db->dbprefix('leave').".Description,
            CONCAT(".$this->db->dbprefix('leave_transaction').".LeaveFrom,'/',".$this->db->dbprefix('leave_transaction').".LeaveTo) AS toform,
            ".$this->db->dbprefix('leave_transaction').".LeaveType AS type,
			".$this->db->dbprefix('leave_transaction').".Days AS days,
			".$this->db->dbprefix('leave_transaction').".EmpNo AS EmpNo,
			".$this->db->dbprefix('leave_transaction').".Comp_Id AS comp,
			".$this->db->dbprefix('leave_transaction').".Year AS Year,
            ".$this->db->dbprefix('leave_transaction').".Status,
			".$this->db->dbprefix('leave_transaction').".Reason")
            ->from("leave_transaction")
            ->join('employee', $this->db->dbprefix('leave_transaction').'.EmpNo = '.$this->db->dbprefix('employee') .'.EmpNo','left')
            ->join('leave', $this->db->dbprefix('leave_transaction').'.Leave_Code = '.$this->db->dbprefix('leave').'.Leave_code','left')
           
            //->where($this->db->dbprefix('leave_year_applyed') .'.EmpNo', $emp)
            ->where($this->db->dbprefix('employee').'.Active',1)
            ->where($this->db->dbprefix('leave_transaction').".Year = YEAR('".$lastmonth."')")
            ->add_column("Actions",
                "
                
                <div class=\"dropdown\">
				<button type=\"button\" class=\"btn p-0 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
				  <i class=\"bx bx-dots-vertical-rounded\"></i>
				</button>
				<div class=\"dropdown-menu\">
				  
				  <a class=\"dropdown-item\" href='". site_url('leave_transaction/delete_leave/$1/$2/$3/$4/$5') . "'
					><i class=\"bx bx-trash me-1\"></i> Delete</a>
				</div>
			  </div>", "EmpNo,Year,Code,date,days")
            ->unset_column('comp,Year,EmpNo');
        if(!empty($emp)){
            $this->db->where('leave_transaction.EmpNo', $emp);
        }
        echo $this->datatables->generate();
    }

    public function getPendingLeaves()
    {
        $lastmonth = date('Y-m-d', strtotime(date('Y-m')." -1 month"));
        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('leave_transaction').".Leave_Code as Code,
            ".$this->db->dbprefix('leave').".Description,
            CONCAT(".$this->db->dbprefix('leave_transaction').".LeaveFrom,'/',".$this->db->dbprefix('leave_transaction').".LeaveTo) AS toform,
            ".$this->db->dbprefix('leave_transaction').".LeaveType AS type,
			".$this->db->dbprefix('leave_transaction').".Days AS days,
			".$this->db->dbprefix('leave_transaction').".EmpNo AS EmpNo,
			".$this->db->dbprefix('leave_transaction').".Comp_Id AS comp,
			".$this->db->dbprefix('leave_transaction').".Year AS Year,
			".$this->db->dbprefix('leave_transaction').".LeaveFrom AS date,
            ".$this->db->dbprefix('leave_transaction').".Status,
			".$this->db->dbprefix('leave_transaction').".Reason")
            ->from("leave_transaction")
            ->join('employee', $this->db->dbprefix('leave_transaction').'.EmpNo = '.$this->db->dbprefix('employee') .'.EmpNo','left')
            ->join('leave', $this->db->dbprefix('leave_transaction').'.Leave_Code = '.$this->db->dbprefix('leave').'.Leave_code','left')
           
            //->where($this->db->dbprefix('leave_year_applyed') .'.EmpNo', $emp)
            ->where($this->db->dbprefix('leave_transaction').'.Status','Pending')
            ->add_column("Actions",
                " 
                <div class=\"dropdown\">
				<button type=\"button\" class=\"btn p-0 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
				  <i class=\"bx bx-dots-vertical-rounded\"></i>
				</button>
				<div class=\"dropdown-menu\">
				  
				  <a class=\"dropdown-item\" href='". site_url('leave_transaction/delete_leave/$1/$2/$3/$4') . "'
					><i class=\"bx bx-trash me-1\"></i> Delete</a>
                  <a class=\"dropdown-item\" href='". site_url('leave_transaction/changes_status/$1/$2/$3/$4') . "'
					><i class='bx bxs-message-square-check'></i> Approve</a>

                    
				</div>
			  </div>", "EmpNo,Year,Code,date")
            ->unset_column('comp,Year,EmpNo,date');
        if(!empty($emp)){
            $this->db->where('leave_transaction.EmpNo', $emp);
        }
        echo $this->datatables->generate();
    }

    function changes_status($EmpNo,$Year,$Leave_Code,$date)
    {
        $where = array(
            'EmpNo'=>$EmpNo,
            'Year'=>$Year,
            'Leave_Code'=>$Leave_Code,
            'LeaveFrom'=>$date,
        );

        $update = array(
            'Status'=>'Approved',
            'ApprovedUser'=>$Yea,
            'ApprovedDateTime'=>date('Y-m-d H:i:s'),
           
        );
        
        if ($this->model->changes_status($where,$update)) {
            $this->messages->add('Approved', "success");
        } else {
            if($this->messages->count() == 0)
                $this->messages->add('Approve error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    
    public function getApproveLeaves()
    {
        $lastmonth = date('Y-m-d', strtotime(date('Y-m')." -1 month"));
        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('leave_transaction').".Leave_Code as Code,
            ".$this->db->dbprefix('leave').".Description,
            CONCAT(".$this->db->dbprefix('leave_transaction').".LeaveFrom,'/',".$this->db->dbprefix('leave_transaction').".LeaveTo) AS toform,
            ".$this->db->dbprefix('leave_transaction').".LeaveType AS type,
			".$this->db->dbprefix('leave_transaction').".Days AS days,
			".$this->db->dbprefix('leave_transaction').".EmpNo AS EmpNo,
			".$this->db->dbprefix('leave_transaction').".Comp_Id AS comp,
			".$this->db->dbprefix('leave_transaction').".Year AS Year,
			".$this->db->dbprefix('leave_transaction').".LeaveFrom AS date,
            ".$this->db->dbprefix('leave_transaction').".Status,
			".$this->db->dbprefix('leave_transaction').".Reason")
            ->from("leave_transaction")
            ->join('employee', $this->db->dbprefix('leave_transaction').'.EmpNo = '.$this->db->dbprefix('employee') .'.EmpNo','left')
            ->join('leave', $this->db->dbprefix('leave_transaction').'.Leave_Code = '.$this->db->dbprefix('leave').'.Leave_code','left')
           
            //->where($this->db->dbprefix('leave_year_applyed') .'.EmpNo', $emp)
            ->where($this->db->dbprefix('leave_transaction').'.Status','Approved')
            ->add_column("Actions",
                " 
                <div class=\"dropdown\">
				
			  </div>", "EmpNo,Year,Code,date")
            ->unset_column('comp,Year,EmpNo,date');
        if(!empty($emp)){
            $this->db->where('leave_transaction.EmpNo', $emp);
        }
        echo $this->datatables->generate();
    }

    public function getBalanceLeaves()
    {
        $lastmonth = date('Y-m-d', strtotime(date('Y-m')." -1 month"));
        $emp = $this->input->get('emp');
        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('leave_year_applied').".Leave_Code as Code,
            ".$this->db->dbprefix('leave').".Description,
			".$this->db->dbprefix('leave_year_applied').".Days,
			".$this->db->dbprefix('leave_year_applied').".Balance")
            ->from("leave_year_applied")
            ->join('leave', $this->db->dbprefix('leave_year_applied').'.Leave_Code = '.$this->db->dbprefix('leave').'.Leave_code','left')
            ->where($this->db->dbprefix('leave_year_applied').".Year = YEAR('".$lastmonth."')")
            ->where($this->db->dbprefix('leave_year_applied').'.EmpNo', $emp);
        if(!empty($emp)){
            $this->db->where('leave_year_applied.EmpNo', $emp);
        }
        echo $this->datatables->generate();
    }

    public function post()
    {
        $post_id=$this->input->post('emp_no')=='' ? false: $this->input->post('emp_no');
        echo '<pre>',print_r($_POST); die();
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('EmpNo', 'Emp No', 'trim|required');
        $this->form_validation->set_rules('Leave_Code', 'Leave Code', 'trim|required');
        $this->form_validation->set_rules('Days', 'Days', 'trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('LeaveDate', 'Leave Date', 'trim|required');
        if ($this->form_validation->run() == FALSE)
        {
            $this->messages->add(validation_errors(), "error");

            redirect('leave-transaction');
        }
        else
        {
            $leave_data = array(
                'Comp_Id' => $this->attn->getComp(),
                'EmpNo' => $this->input->post('EmpNo'),
                'Leave_Code' => $this->input->post('Leave_Code'),
                'LeaveType' => ($this->input->post('LeaveType'))?$this->input->post('LeaveType'):'full',
                'LeaveDate' => $this->input->post('LeaveDate'),
                'LeaveFrom' => $this->input->post('LeaveFrom'),
                'LeaveTo' => $this->input->post('LeaveTo'),
                'Year' => $yearOnly = date('Y', strtotime($this->input->post('LeaveFrom'))),
                'Days' => $this->input->post('Days'),
                'Reason' => $this->input->post('Reason'),
                'Balance' => $this->input->post('Balance')
            );
            $emp = $this->input->post('EmpNo');
            //get save id
            $returnId = $this->model->save($leave_data,$post_id);
            $postType = ($post_id) ? 'edit' : 'post';
            if($returnId)
            {
                $this->messages->add($this->lang->line('success_leaveT_'.$postType), "success");
                redirect('leave-transaction/'.$emp);
            }
            else
            {
                if($this->messages->count() == 0) $this->messages->add($this->lang->line('error_leaveT_'.$postType), "error");
                redirect('leave-transaction/'.$emp);
            }
        }
    }

	//to fill the From To date : Using jquery ajax
	public function get_days()
	{
		$leave_code = (isset($_POST['Leave_Code'])) ? $_POST['Leave_Code']:'';
		$days = $this->model->get_leave_balance($_POST);
		echo json_encode($days);
	}

    function delete_leave($EmpNo = NULL,$Year = NULL,$Leave_Code = NULL,$LeaveFrom = NULL,$days = NULL)
    {
        if ($this->model->delete_leave($EmpNo,$Year,$Leave_Code,$LeaveFrom,$days)) {
           
            $this->messages->add('Leave Deleted', "success");
			redirect('leave_transaction/add');
            exit();
        }
        $this->messages->add('Error', "error");
        redirect('leave_transaction/add');
    }

    //NoPay

    function add_nopay($id=null)
    {
        $data = $this->data;
        $data['emp'] = ($this->input->get('id'))?$this->input->get('id'):null;
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<span>', '</span>');
        $this->form_validation->set_rules('EmpNo', 'Emp No', 'trim|required');
        $this->form_validation->set_rules('Code', 'Code', 'trim|required');
        $this->form_validation->set_rules('Days', 'Days', 'trim|required');
        $this->form_validation->set_rules('NopayFrom', 'Nopay From Date', 'trim|required');
        $this->form_validation->set_rules('NopayTo', 'Nopay To Date', 'trim|required');
        if ($this->form_validation->run('leave_transaction/add') == true) {
            $data = array(
                'Comp_Id' => $this->attn->getComp(),
                'EmpNo' => $this->input->post('EmpNo'),
                'Code' => 'NP',
                'NopayFrom' => $this->input->post('NopayFrom'),
                'NopayTo' => $this->input->post('NopayTo'),
                'Year' => $yearOnly = date('Y', strtotime($this->input->post('NopayFrom'))),
                'Days' => $this->input->post('Days'),
                'Reason' => $this->input->post('Reason'),
            );
            $emp = $this->input->post('EmpNo');
        }elseif ($this->input->post('add_nopay')) {
            $this->messages->add(validation_errors(), "error");
            redirect('leave_transaction/add_nopay');
        }

        if ($this->form_validation->run() == true && $this->model->add_nopay($data)) {
            $this->messages->add($this->lang->line('success_leaveT_post'), "success");
            redirect('leave_transaction/add_nopay?id='.$emp);
        } else {
            $this->messages->add(validation_errors(), "error");
            $data['page'] = 'add_nopay';
            $data['edit'] = false;
            $this->load->model('employee_model');
            $data['employees'] = $this->employee_model->get_all_emp_name($this->attn->getComp());
            $data['page_title'] = 'Nopay Entry';
            $data['heading'] = 'Nopay Transaction';
            $data['url'] = base_url('leave-transaction');
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/transaction/nopay_t_add',$data);
        }
    }

    public function getNopays()
    {
        $lastmonth = date('Y-m-d', strtotime(date('Y-m')." -1 month"));
        $emp = $this->input->get('emp');
        $this->load->library('datatables');
        $this->datatables
            ->select("Code,NopayFrom,NopayTo,Days,EmpNo,Comp_Id AS comp,Year,Reason")
            ->from("nopay_transaction")
            ->where('Comp_Id', $this->attn->getComp())
            ->where('EmpNo', $emp)
            ->where("Year = YEAR('".$lastmonth."')")
            ->add_column("Actions",
                "
                <div class=\"dropdown\">
				<button type=\"button\" class=\"btn p-0 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
				  <i class=\"bx bx-dots-vertical-rounded\"></i>
				</button>
				<div class=\"dropdown-menu\">
				  <a class=\"dropdown-item\" href='". site_url('leave_transaction/delete_nopay/$1/$2/$3/$4/$5') . "'
					><i class=\"bx bx-trash me-1\"></i> Delete</a>
				</div>
			  </div>", "comp,EmpNo,Year,Code,NopayFrom")
            ->unset_column('comp,Year,EmpNo,Code');
        echo $this->datatables->generate();
    }

    function delete_nopay($comp_id = NULL,$EmpNo = NULL,$Year = NULL,$Code = NULL,$NopayFrom = NULL)
    {
        if ($this->model->delete_nopay($comp_id,$EmpNo,$Year,$Code,$NopayFrom)) {
            $this->messages->add('Nopay Deleted', "success");
			redirect('leave_transaction/add_nopay');
        }
        $this->messages->add('Error', "error");
			redirect('leave_transaction/add_nopay');
    }

    public function get_leave_days()
	{
		$leave_code = (isset($_POST['Leave_Code'])) ? $_POST['Leave_Code']:'';
		$EmpNo = (isset($_POST['EmpNo'])) ? $_POST['EmpNo']:'';
		$days = $this->model->get_leave_days($_POST);
		echo json_encode($days);
	}

}
?>