<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Shift extends MY_Controller {
	
	private $model;
	
	 public function __construct()
	{
		parent::__construct();
		if (!$this->loggedIn) {
			$this->session->set_userdata('requested_page', $this->uri->uri_string());
			redirect('login');
		}
		$this->load->model('shift_model');
		$this->model=$this->shift_model;
	} 
	// this function for index page (Home)
	function index()
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['message'] = view_error($this->messages->get());
		$data['page'] = 'shift';
		$data['shifts'] = $this->model->get_all();
		$this->load->view('templates/shift/index',$data);
	}
	
	public function add($id=null)
	{
		//to get menus from Secure_area contraller
		$data = $this->data;
		$data['Edit'] = $this->Edit;
		$data['page'] = 'shift';
		$data['edit'] = false;
		if($id and $data['Edit'])
		{
			$data['edit'] = true;
			$data['shift'] = $this->model->get_info($id,$this->attn->getComp());
			//echo '<pre>',print_r($data['shift']); die();
		}
		//$data['shifts'] = $this->model->get_all();
		$data['message'] = view_error($this->messages->get());
		$data['page_title'] = 'Shift Register';
		$data['heading'] = 'Master Files';
		$data['url'] = base_url('shift/add');
		$this->load->view('templates/shift/add',$data);
	}

	public function get_details_filter()
	{
		$this->load->library('datatables');

		$action = '<div class="d-flex align-items-sm justify-content-sm">
        <a href="'.site_url('shift/add/$1').'" class="btn btn-sm btn-icon"><i class="bx bx-edit"></i></a>
        </div>';

		$this->datatables
			->select($this->db->dbprefix('shift') . ".shift_code as code,
			" . $this->db->dbprefix('shift') . ".Name,
			" . $this->db->dbprefix('shift') . ".Shift_From,
			" . $this->db->dbprefix('shift') . ".Shift_To")
			->from("shift")
			->join('comp', $this->db->dbprefix('shift') . '.Comp_Id=' . $this->db->dbprefix('comp') . '.Code', 'left')
			->where($this->db->dbprefix('shift') . '.Comp_Id', $this->attn->getComp())
			->add_column("Actions", $action, "code");
			//->unset_column('id');
		echo $this->datatables->generate();
	}

	public function post()
	{
		$post_id=$this->input->post('shift_id')=='' ? false:$this->input->post('shift_id');
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<span>', '</span>');
		$this->form_validation->set_rules('shift_code', 'Shift  Code', 'trim|required');
		$this->form_validation->set_rules('Name', 'Name', 'trim|required');
		if ($this->form_validation->run() == FALSE)
		{
			$this->messages->add(validation_errors(), "error");
			redirect('shift/add');
		}
		else
		{
			$shift_data = array(
			'Comp_Id' =>($this->input->post('Comp')!='') ? $this->input->post('Comp'):$this->session->userdata('Comp'),
			'shift_code' => ($this->input->post('shift_code')!='') ? $this->attn->clean($this->input->post('shift_code')):null,
			'Name' => $this->input->post('Name'),
			'Shift_From' => date('H:i:s',strtotime($this->input->post('From'))),
			'Shift_To' => date('H:i:s',strtotime($this->input->post('To')))
			);
			//get save id
			$returnId = $this->model->save($shift_data,$post_id);
			$postType = ($post_id) ? 'edit' : 'post';
			if($returnId)
			{
				$this->messages->add($this->lang->line('success_shift_'.$postType), "success");
				redirect('shift/add');
			}
			else
			{
				if($this->messages->count() == 0) $this->messages->add($this->lang->line('error_shift_'.$postType), "error");
				redirect('shift/add');
			}
		}	
	}
	
	//to fill the From To date : Using jquery ajax
	public function get_start_end_date()
	{
		$ship_code = (isset($_POST['shift_code'])) ? $_POST['shift_code']:'';
		$dates = $this->model->get_info_start_end_date($ship_code);
		echo json_encode($dates);
	}
	
	//change status
	public function status($id)
	{
		if(isset($id))
		{
			if($this->model->change_status($id))
			{
				$this->messages->add($this->lang->line('success_company_delete'), "success");
			}
			else
			{
				$this->messages->add($this->lang->line('error_company_delete'), "error");
			}
		}
		else
		{
			$this->messages->add($this->lang->line('error_company_delete'), "error");
		}
		redirect('add-department');
	}
}
?>