<?php
require_once("Main_model.php");
class Attendance_model extends Main_model
{
	private $tableName = 'temp_attn';
	private $tableMain = 'attendenceinfo';
	private $join = 'comp';
	private $join2 = 'employee';
	public $comp;
	// t- norrmal table
	// tj- join table

	public function _construct()
	{
		//$this->load->database();
	}

	function _setComp()
	{
		$this->comp = $this->session->userdata('Comp');
	}

	function _getComp()
	{
		$this->_setComp();
		return $this->comp;
	}

	private function _exist($where)
	{
		$this->db->from('attendance');
		$this->db->where($where);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function get_info($user,$date,$comp)
	{
		$this->db->select('A.*,C.Name,E.EmpName');
		$this->db->from('attendance AS A');
		$this->db->join('comp AS C','A.Comp=C.Code','left');
		$this->db->join('employee AS E','(A.USER=E.EmpNo AND E.Comp=A.Comp)','left');
		$this->db->where('E.Active', '1');
		$this->db->where('A.Comp', $comp);
		$this->db->where('A.USER', $user);
		$this->db->where('A.DATE', $date);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}

	function get_today_records($date=null)
	{
		//t.Comp=".$this->_getComp()." AND
		$where = (!is_null($date)) ? " WHERE DATE(t.Clock_Time) ='".$date."' ":' ';
		$query = $this->db->query("SELECT t.*, tj.Name, tj2.EmpName FROM ".$this->tableName." AS t
		LEFT JOIN ".$this->join." AS tj ON t.Comp=tj.Code
		LEFT JOIN ".$this->join2." AS tj2 ON t.User_ID=tj2.EmpNo
		".$where."
		ORDER BY t.User_ID,t.Clock_Time
		");
		return $query->result();
	}

	function get_today_completes_records()
	{
		$date = ($this->session->userdata('complete_date')) ? $this->session->userdata('complete_date'): strtotime(date('Y-m-d'));
		$this->db->trans_start();
		$query = $this->db->query("SELECT t.*, tj2.EmpName FROM ".$this->tableMain." AS t
		LEFT JOIN ".$this->join2." AS tj2 ON t.User_ID=tj2.EmpNo
		WHERE 
		CASE WHEN t.Clock_In = '0000-00-00 00:00:00' THEN t.Clock_Out
        ELSE t.Clock_In END > '".$date."'
		ORDER BY CASE WHEN t.Clock_In = '0000-00-00 00:00:00' THEN t.Clock_Out
        ELSE t.Clock_In END ASC,t.User_ID ASC");
		$this->db->trans_complete();
		return $query->result();
	}

	function count_all()
	{
		$this->db->from('attendance');
		if(!$this->checkAdmin())
		{
			//$this->db->where('Comp', $this->attn->getComp());
			$this->db->where('DEVICE', $this->attn->getDivice());
		}
		return $this->db->count_all_results();
	}

	function add_record_for_day($records)
	{
		return $this->db->insert('attendance',$records);
	}

	function get_all_formated($limit=0,$offset=0)
	{
		$this->db->select('A.*,C.Name,E.EmpName');
		$this->db->from('attendance AS A');
		$this->db->join('comp AS C','A.Comp=C.Code','left');
		$this->db->join('employee AS E','A.USER=E.EmpNo','left');
		$this->db->where('E.Active', '1');
		if(!$this->checkAdmin())
		{
			//$this->db->where('A.Comp', $this->attn->getComp());
			$this->db->where('A.DEVICE', $this->attn->getDivice());
		}
		$this->db->order_by("A.DATE", "DESC");
		//$this->db->order_by("ID", "DESC");
		$this->db->limit($limit,$offset);
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_user_shift()
	{
		$this->db->select('E.*,T.StartDate,T.EndDate,S.Shift_From,S.Shift_To');
		$this->db->from('employee AS E');
		$this->db->join('shift_transaction AS T','E.EmpNo=T.EmpNo AND E.Comp=T.Comp_Id','left');
		$this->db->join('shift AS S','T.Shift_code=S.shift_code AND E.Comp=S.Comp_Id','left');
		$this->db->where('E.Active', '1');
		if(!$this->checkAdmin())
		{
			//$this->db->where('E.Comp', $this->attn->getComp());
			//$this->db->where('E.DEVICE', $this->attn->getDivice());
		}
		//$this->db->order_by("ID", "DESC");
		//$this->db->limit($limit,$offset);
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_all_today_not($comp='', $date=0)
	{
		$divice = (!$this->checkAdmin()) ? "`DEVICE`=".$this->db->escape($this->attn->getDivice())." AND":null;

		$Comp = ($comp!='')?" AND E.Comp='".$comp."'":'';
		$d = ($date!=0) ? " DATE(INOUTTIME) = '".$date."'":"DATE(INOUTTIME) = '".date('Y-m-d')."'";
		//$Comp = (!$this->checkAdmin() or $comp !=0) ? " AND Comp=".$this->db->escape(($comp !=0) ? $comp:$this->attn->getComp()):null;
		$query = $this->db->query("SELECT E.EmpNo,E.EmpName,C.Name FROM `employee` AS E LEFT JOIN `comp` AS C ON E.Comp=C.Code WHERE E.Active='1' AND EmpNo NOT IN (SELECT `USER` FROM `attendenceinfo` WHERE ".$divice." ".$d.")
		 ".$Comp);
		//echo $this->db->last_query();
		return $query->result_array();
	}

    function get_all_today($comp='', $date)
    {
        $date = ($date!='')?$date:date('Y-m-d');
        $divice = (!$this->Admin) ? " AND A.DEVICE=".$this->db->escape($this->attn->get_unit_id()):null;
        $Comp = (!$this->Admin) ? "  ":null;
        if($this->Admin)
        {
            $Comp = ($comp!='') ? " C.Code=".$this->db->escape($comp)." AND E.Comp=".$this->db->escape($comp)." AND ":null;
        }
        else
        {
            $Comp = " E.Comp=".$this->db->escape($comp)." AND ";
        }
        // AND E.Comp=D.Comp_Id
        $query = $this->db->query("SELECT A.*,C.Name,E.EmpName,E.EmpPic,D.Description AS Department FROM `attendenceinfo` AS A LEFT JOIN `comp` AS C ON A.DEVICE=C.Unit_Id LEFT JOIN `employee` AS E
 ON A.USER=E.EmpNo LEFT JOIN `department` AS D ON E.Dep_code=D.Dep_code
 WHERE ".$Comp." DATE(A.INOUTTIME) = '".$date."' AND `USER`!=0 GROUP BY DATE(A.INOUTTIME),A.USER,A.DEVICE ORDER BY A.DEVICE,D.Dep_code,A.INOUTTIME ASC");
        $rt = $query->result_array();
        //echo $this->db->last_query(); die();
        return $rt;
    }

    function get_all_yesterday($comp='', $date)
    {
        $date = ($date!='')?$date:date('Y-m-d');
        $divice = (!$this->Admin) ? " AND A.DEVICE=".$this->db->escape($this->attn->get_unit_id()):null;
        $Comp = (!$this->Admin) ? " ":null;
        if($this->Admin)
        {
            $Comp = ($comp!='') ? " C.Code=".$this->db->escape($comp)." AND ":null;
        }
        else
        {
            $Comp = " ";
        }
        // AND E.Comp=D.Comp_Id
        $query = $this->db->query("SELECT A.*,C.Name,E.EmpName,E.EmpPic,D.Description AS Department FROM `attendenceinfo` AS A LEFT JOIN `comp` AS C ON A.DEVICE=C.Unit_Id LEFT JOIN `employee` AS E
 ON A.USER=E.EmpNo LEFT JOIN `department` AS D ON E.Dep_code=D.Dep_code
 WHERE ".$Comp." DATE(A.INOUTTIME) = '".$date."' AND `USER`!=0 GROUP BY A.INOUTTIME DESC,A.USER,A.DEVICE ORDER BY A.DEVICE,D.Dep_code,A.INOUTTIME ASC");
        $rt = $query->result_array();
        $records = array();
        if($rt){

            foreach($rt as $row){
                $records[$row['USER']] = $row;
            }
        }
        return $records;
    }

	function get_all_today_count()
	{
		$divice = (!$this->checkAdmin()) ? " DEVICE=".$this->db->escape($this->attn->getDivice())." AND":null;
		$query = $this->db->query("
		SELECT DEVICE FROM `attendenceinfo`
		 WHERE ".$divice." DATE(INOUTTIME)='".date('Y-m-d')."'");
		return $query->num_rows();
	}

	function get_all()
	{
		//new funstion
		$user_query = (isset($inputs['user_id'])) ? "(USER='".$inputs['user_id']."') " : null;
		$and = (isset($user_query)) ? "AND ":null;
		$date_query = '';
		if(!empty($inputs['start_date']) and !empty($inputs['end_date']))
		{
			$date_query = $and." DATE(INOUTTIME) BETWEEN '".$inputs['start_date']."' AND '".$inputs['end_date']."'";
		}
		else if(!empty($inputs['start_date']) and empty($inputs['end_date']))
		{
			$date_query = $and." DATE(INOUTTIME)='".$inputs['start_date']."'";
		}
		$query = $this->db->query("SELECT `ID`,`DEVICE`,`USER`,`NAME`,`INOUTTIME` FROM `attendenceinfo`
		ORDER BY DATE(INOUTTIME),`USER`,`NAME` ASC");
		return $query->result_array();
	}

	function get_all_comp($comp='')
	{
		$q =($comp!='')?"WHERE Code='".$comp."'":'';
		$query = $this->db->query("SELECT Code as Comp,Unit_id FROM `comp` ".$q." ORDER BY `Unit_Id` ASC");
		return $query->result_array();
	}

	function get_attn_rows($Unit_id)
	{
		$this->db->select_min('DATE');
		$max_date = $this->db->get('attendance')->row()->DATE;
		//echo $this->db->last_query();
		//die();
		$dateTime = new DateTime($max_date);
		$lastMonth = $dateTime->modify('- 7 days')->format('Y-m-d');
		//echo $lastMonth; die();
		$maxid_query = '';
		//echo $lastMonth; die();
		if(isset($lastMonth) and !empty($lastMonth))
		{
			if ($lastMonth!="0000-00-00") {
				$maxid_query = "AND DATE(INOUTTIME) > '".$lastMonth."'";
			}else{
				$maxid_query = "AND DATE(INOUTTIME) > '".$max_date."'";
			}
		}
		else
		{

		}
        $maxid_query = "AND DATE(INOUTTIME) > '2018-05-31'";
		//echo $maxid_query, die();
		$query = $this->db->query("SELECT `ID`,`DEVICE`,`USER`,`NAME`, DATE(INOUTTIME) AS DATE, TIME(INOUTTIME) AS TIME FROM `attendenceinfo`
		WHERE DEVICE='".$Unit_id."' AND (USER !='1.84E+17' OR USER !='0') ".$maxid_query." ORDER BY `INOUTTIME` ASC");

		return $query->result_array();
	}

	function get_attn_records($Unit_id,$user)
	{
		$this->db->select('*');
		$this->db->where('USER', $user);
		$this->db->where('DEVICE', $Unit_id);
		$this->db->order_by('DATE', 'DESC');
		$this->db->limit(1);
		$result = $this->db->get('attendance')->row();
		$maxid_query = '';
		if(isset($result->ID) and !empty($result->ID))
		{
			if ($result->OUTDATE!="0000-00-00") {
				$maxid_query = "AND DATE(INOUTTIME) > '".$result->OUTDATE."'";
			}else{
				$maxid_query = "AND DATE(INOUTTIME) > '".$result->DATE."'";
			}
		}
		else
		{

		}
		//echo $yesterday, die();
		$query = $this->db->query("SELECT `ID`,`DEVICE`,`USER`,`NAME`, DATE(INOUTTIME) AS DATE, TIME(INOUTTIME) AS TIME FROM `attendenceinfo`
		WHERE DEVICE='".$Unit_id."' AND (USER !='1.84E+17' OR  USER !='0') ".$maxid_query." AND USER='".$user."' ORDER BY `INOUTTIME` ASC");
		//echo $this->db->last_query();
		return $query->result_DEVICEarray();
	}

	function get_attn_records_by_user($Unit_id,$user,$date)
	{
		$this->db->where('DATE <', $date);
		$this->db->where('USER', $user);
		if($this->db->delete('attendance'))
		{
			$query = $this->db->query("SELECT `ID`,`DEVICE`,`USER`,`NAME`, DATE(INOUTTIME) AS DATE, TIME(INOUTTIME) AS TIME FROM `attendenceinfo`
			WHERE DEVICE='".$Unit_id."' AND (USER !='1.84E+17' AND  USER !='0') AND USER=".$user." AND DATE(INOUTTIME) > '".$date."' ORDER BY `INOUTTIME` ASC");
			return $query->result_array();
		}
		return false;
	}

	function get_month_attn_records_by_user($user,$month)
	{
		$this->db->select('*');
		$this->db->where('USER', $user);
		$this->db->where('DATE_FORMAT(DATE,\'%Y-%m\')', $month);
		$this->db->order_by('DATE');
		$query = $this->db->get('attendance');
		//echo $this->db->last_query(); die();
		if($query->num_rows() > 0){
			return $query->result();
		}
		return false;
	}

    function get_month_attn_ot_records_by_user($user,$month)
    {
        $this->db->select('*');
        $this->db->where('USER', $user);
        $this->db->where('DATE_FORMAT(DATE,\'%Y-%m\')', $month);
        $this->db->order_by('DATE');
        $query = $this->db->get('attn_ot');
        if($query->num_rows() > 0){
            return $query->result();
        }
        return false;
    }

    function get_month_in_out_records_by_user($user,$month)
    {
        $this->db->select('*');
        $this->db->where('USER', $user);
        $this->db->where('DATE_FORMAT(INOUTTIME,\'%Y-%m\')', $month);
        $this->db->order_by('INOUTTIME');
        $query = $this->db->get('attendenceinfo');
        if($query->num_rows() > 0){
            return $query->result();
        }
        return false;
    }

	function get_attn_records_user($Unit_id,$user)
	{
		$this->db->where('USER', $user);
		if($this->db->delete('attendance'))
		{
			$query = $this->db->query("SELECT `ID`,`DEVICE`,`USER`,`NAME`, DATE(INOUTTIME) AS DATE, TIME(INOUTTIME) AS TIME FROM `attendenceinfo`
			WHERE DEVICE='".$Unit_id."' AND (USER !='1.84E+17' AND  USER !='0') AND USER=".$user." ORDER BY `INOUTTIME` ASC");
			return $query->result_array();
		}
		return false;
	}

	function get_latest_records($Unit_id)
	{
		$this->db->trans_start();
		$this->db->select_max('ID');
		$query = $this->db->get('attendance');
		$this->db->trans_complete();
		$id = (isset($query->row()->ID))? $query->row()->ID:0;
		$yesterday = date("Y-m-d", mktime(0, 0, 0, date("m") , date("d")-1,date("Y")));
		//echo $yesterday, die();
		$query = $this->db->query("SELECT `ID`,`DEVICE`,`USER`,`NAME`,`INOUTTIME` FROM `attendenceinfo`
		WHERE ID > ".$id ." AND DEVICE='".$Unit_id."' AND DATE(INOUTTIME) <= '".$yesterday."' AND (USER !='1.84E+17' AND USER !='0') ORDER BY DATE(INOUTTIME),`USER`,`ID`,`NAME` ASC");
		return $query->result_array();
	}

	function get_all_search($search='', $type=0, $limit=0,$offset=0)
	{
		$string_array = array();
		$date = $user = $comp = $deparment = '';
		if(!empty($search))
		{
			parse_str($search, $string_array);
			foreach($string_array as $key=>$value)
			{
				switch($key)
				{
					case 'd':
						$date=$value;
						break;
					case 'u':
						$user = $value;
						break;
					case 'comp':
						$comp = $value;
						break;
					case 'deparment':
						$deparment = $value;
						break;
				}
			}
		}
		//A.ID,A.USER,A.DATE,A.INTIME,A.OUTTIME,A.OUTDATE,E.EmpName AS NAME, C.Name'
		$this->db->select('A.ID,A.USER,A.DATE,,E.EmpName,A.INTIME,A.OUTTIME,A.OUTDATE,,A.NAME, C.Name');
		$this->db->from('attendance AS A');
		$this->db->join('employee AS E','A.USER=E.EmpNo AND A.Comp = E.Comp','left');
		$this->db->join('comp AS C','A.Comp=C.Code','left');
		$this->db->where('E.Active', '1');

		if(!empty($comp))
		{
			$this->db->where('A.Comp', $comp);
		}

		if(!empty($deparment))
		{
			$this->db->where('E.Dep_code', $deparment);
		}
		if(!empty($date) and !empty($user))
		{
			$this->db->where('A.USER', $user);
			$this->db->where('A.DATE', $date);
		}
		else if(!empty($date) and empty($user))
		{
			$this->db->where('A.DATE', $date);
		}
		else if(empty($date) and !empty($user))
		{
			$this->db->where('A.USER', $user);
		}
		//if(!$this->checkAdmin()) $this->db->where('A.Comp', $this->attn->getComp());
		//if(!$this->checkAdmin()) $this->db->where('E.Comp', $this->attn->getComp());
		//$this->db->where('A.DEVICE', $this->attn->getDivice());
		//$this->db->where('E.Active', 1);
		//get count
		if($type==1) return $this->db->count_all_results();
		$this->db->limit($limit,$offset);
		$this->db->order_by("A.DATE", "DESC");
		$query = $this->db->get();
		//echo $this->db->last_query(); die();
		return $query->result_array();

	}

	function move_temp_attn($user,$date)
	{
		$this->db->truncate('attn_temp');
		$query = $this->db->query("INSERT INTO attn_temp select * from attendance where USER = '".$user."' AND DATE > '".$date."'");
		if($query){
			$q = $this->db->query("DELETE FROM attendance where USER = '".$user."' AND DATE > '".$date."'");
		}
		return true;
	}

	function edit_rows_recovery($user,$date)
	{
		$query = $this->db->query("select * from attn_temp where USER = '".$user."' AND DATE >= '".$date."' AND EDIT = 1");
		if($query->num_rows() > 0)
		{
			foreach ($query->result() as $row){

				$where = array();
				$where['USER'] = $row->USER;
				$where['DATE'] = $row->DATE;
				$where['Comp'] = $row->Comp;
				$data = array(
					'INTIME' => $row->INTIME,
					'OUTTIME' => $row->OUTTIME,
					'OUTDATE' => $row->OUTDATE
				);
				$this->db->where($where);
				$this->db->update('attendance', $data);
			}
		}
		$this->db->truncate('attn_temp');
		return true;
	}

	function change_in_out_date($data, $where)
	{
		$this->db->where($where);
		//if(!$this->checkAdmin()) $this->db->where('Comp', $this->attn->getComp());
		return $this->db->update('attendance',$data);
	}

	function delete_record($where)
	{
		return $this->db->delete('attendance', $where);
	}

	function delete_dp()
	{
		return $this->db->empty_table('department1');
	}

	/*
	Inserts or updates a page
	*/
	function save(&$data)
	{
		if(is_array($data))
		{
			$this->db->insert_ignore_batch('attendance', $data);
			return true;
		}
		return false;
	}

	function addRecord(&$row,$where=array())
	{
		$this->db->select_max('ID');
		$q = $this->db->get('attendance');
		$max_id = 0;
		if ($q->num_rows() > 0)
		{
			$max_id = $q->row()->ID;
		}
		$row["ID"] = $max_id;
		if(!$this->exist($where))
		{
			if($this->db->insert('attendance',$row))
			{
				return true;
			}
		}
		return false;
	}

	function updateRecords($rows=array(),$month=NULL,$emp=NULL)
	{
		if(!empty($rows)){

            $this->db->where('USER',$emp);
            $this->db->LIKE('DATE',$month,'both');
            if($this->db->delete('attendance'))
            {
                return $this->db->insert_ignore_batch('attendance', $rows);
            }

			/*foreach($rows as $row){
				$where = array(
					'Comp' => $row['Comp'],
					'USER' => $row['USER'],
					'DATE' => $row['OLDDATE'],
					'DEVICE' => $row['DEVICE'],
					'ID' => $row['ID'],
				);
				if($this->exist($where))
				{
					unset($row['OLDDATE']);
					$this->db->where($where);
                    if($row['INTIME']=='00:00:00' or empty($row['INTIME']))
                        $this->db->delete('attendance');
                    else
                        $this->db->update('attendance',$row);
				}
			}*/
		}
		return false;
	}

    function updateOTRecords($rows=array(),$month=NULL,$emp=NULL)
    {
        if(!empty($rows)){

            $this->db->where('USER',$emp);
            $this->db->LIKE('DATE',$month,'both');
            if($this->db->delete('attn_ot'))
            {
                return $this->db->insert_ignore_batch('attn_ot', $rows);
            }
        }
        return false;
    }

    function updateDateRecords($rows=array())
    {
        if(!empty($rows)){
            foreach($rows as $row){
                $where = array(
                    'Comp' => $row['Comp'],
                    'USER' => $row['USER'],
                    'DATE' => $row['DATE'],
                    'DEVICE' => $row['DEVICE']
                );
                unset($row['OLDDATE']);
                if($this->exist($where))
                {
                    $this->db->where($where);
                    if($row['INTIME']=='00:00:00' or empty($row['INTIME']))
                        $this->db->delete('attendance');
                    else
                        $this->db->update('attendance',$row);
                }else{
                    unset($row['OLDDATE']);
                    if($row['INTIME']!='00:00:00' and !empty($row['INTIME']))
                        $this->db->insert('attendance',$row);


                }
            }
        }
        return true;
    }

	function exist($where)
	{
		$this->db->from('attendance');
		$this->db->where($where);
		$query = $this->db->get();
		//echo $this->db->last_query();
		if($query->num_rows()==1)
		{
			$this->messages->add('Record already exist', "error");
			return true;
		}
		else
		{
			return false;
		}
	}

	function save_batch(&$data)
	{
		$this->db->trans_start();
		$this->db->select_max('Clock_Time');
		$query = $this->db->get($this->tableName);
		if ($query->num_rows()==1)
		{
			$this->session->set_userdata(array('last_date' => $query->row()->Clock_Time));
		}
		$this->db->trans_complete();

		if(is_array($data))
		{
			/*$this->db->trans_start();
			$this->db->query("DROP TABLE IF EXISTS `temp_attn2`");
			$this->db->query("CREATE TABLE temp_attn2 SELECT * FROM temp_attn");
			$this->db->trans_complete();*/
			$this->db->trans_start();
			foreach ($data as $item) {
				$insert_query = $this->db->insert_string($this->tableName, $item);
				$insert_query = str_replace('INSERT INTO', 'INSERT IGNORE INTO', $insert_query);
				$this->db->query($insert_query);
			}
			$this->db->trans_complete();
			return true;
		}
		return false;
	}

	function save_batch_main(&$data)
	{
		if(is_array($data))
		{
			foreach ($data as $item) {
				//$userData = array('EmpNo' => $item['User_ID'] ,'Comp' => $item['Comp'] ,'EmpName' => $item['EmpName']);
				unset($item['EmpName']);
				$this->db->trans_start();
				$insert_query = $this->db->insert_string($this->tableMain, $item);
				$insert_query = str_replace('INSERT INTO', 'INSERT IGNORE INTO', $insert_query);
				$this->db->query($insert_query);
				//echo $this->db->last_query(); die();
				$this->db->trans_complete();
			}
			return true;
		}
		return false;
	}

    function add_month_completed_attn(&$data,$month)
    {
        
        $this->db->like('DATE', $month, 'both');
        if($this->db->delete('attn_completed'))
        {
			if(!empty($data))
            	$this->db->insert_ignore_batch('attn_completed', $data);
			else
				return false;
				
            return true;
        }
        return false;
    }

    function get_all_month_attns($month)
    {
        $sql = "SELECT A.Comp, A.USER AS USER,A.DATE,INTIME,A.OUTTIME,A.OUTDATE,DATE_FORMAT(A.DATE,'%d') AS ind,DATE_FORMAT(A.OUTDATE,'%d') AS outd,DATE_FORMAT(A.DATE,'%Y-%m') AS inmonth,DATE_FORMAT(A.OUTDATE,'%Y-%m') AS outmonth,
        IF(A.DATE= A.OUTDATE,1,0) AS SHIFT,
        IF(
			TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',H.Shift_From))) > 0,
			TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',H.Shift_From))),
			'0'
		) AS diff,
		IF(
			A.DATE=A.OUTDATE,
			TIME_TO_SEC(TIMEDIFF(CONCAT(A.DATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',A.INTIME))),
			TIME_TO_SEC(TIMEDIFF(CONCAT(A.DATE,' ','23:59:59'),CONCAT(A.DATE,' ',A.INTIME)))
		) AS InDay,
		IF(
			A.DATE=A.OUTDATE,
			0,
			TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.OUTDATE,' ','00:00:00')))
		) AS OutDay,
		TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',A.INTIME))) AS DayShift,
		WEEKDAY(A.DATE) AS weekday,
		WEEKDAY(A.OUTDATE) AS outweekday
FROM attendance AS A LEFT JOIN employee AS E ON (A.USER=E.EmpNo)
LEFT JOIN shift_transaction AS S ON (E.EmpNo=S.EmpNo)
LEFT JOIN shift AS H ON (S.Shift_code=H.shift_code)
WHERE
  (DATE_FORMAT(A.DATE,'%Y-%m')= '" . $month . "' OR DATE_FORMAT(A.OUTDATE,'%Y-%m')= '" . $month . "') AND E.Active='1' ORDER BY ABS(A.USER),A.DATE,A.INTIME ASC";
        $query = $this->db->query($sql);
        //echo $this->db->last_query(); die();
        return $query->result();
    }

    function get_completed_attendance($month,$EmpNo)
    {
        $this->db->select('DATE, INTIME, OUTDATE, OUTTIME, OT, DOT,TOT');
        $this->db->from('attn_completed');
        $this->db->where('USER', $EmpNo);
        $this->db->where("DATE_FORMAT(DATE, '%Y-%m')='$month'");
        $this->db->order_by('DATE','ASC');
        $query = $this->db->get();
        return $query->result();
    }

	function get_completed_attendance_date_wise($month)
    {
        $this->db->select('USER,DATE, INTIME, OUTDATE, OUTTIME, OT, DOT,TOT');
        $this->db->from('attn_completed');
        $this->db->where("DATE_FORMAT(DATE, '%Y-%m')='$month'");
        $this->db->order_by('USER,DATE','ASC');
        $query = $this->db->get();
        $records = array();
        if($query->num_rows() > 0){
            $i=1;
            $emp_rows = array();
            $empNo = 0;
            //echo '<pre>',print_r($query->result()); die();
            foreach($query->result() as $row){
                if($i==1){
                    $empNo = $row->USER;
                    $emp_rows[$row->DATE] = $row;
                }else{
                    if($empNo==$row->USER){
                        $emp_rows[$row->DATE] = $row;
                    }else{
                        $records[$empNo] = $emp_rows;
                        $empNo = $row->USER;
                        $emp_rows = array();
                        $emp_rows[$row->DATE] = $row;
                    }
                }
                $i++;
            }
            $records[$empNo] = $emp_rows;
        }
        return $records;
    }
}
?>