<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Department extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
        $this->load->model('department_model');
        $this->model = $this->department_model;
        $this->load->library('form_validation');
    }

    function index($action = NULL)
    {
        //$this->tmw->checkPermissions();
        //echo $this->data['page'];
        //$this->data['page'] = 'department';
        $this->data['message'] = view_error($this->messages->get(),1);
        $this->data['action'] = $action;
        $bc = array(array('link' => base_url('admin'), 'page' => lang('home')), array('link' => '#', 'page' => lang('departments')));
        $meta = array('page_title' => lang('Departments'), 'bc' => $bc);
        $this->page_construct('departments/index', $meta, $this->data);
    }

    function getDepartments()    {
        //$this->tmw->checkPermissions('index');
        $action = '<a href="'.base_url('department/edit/$1').'" data-toggle="modal" data-target="#myModal" class="btn btn-success-outline rounded">Edit</a>
        <button data-url="'.base_url('department/delete/$1').'" class="delete-row btn btn-danger-outline rounded">Delete</button>';
        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('department') .".Id AS Id,
                ".$this->db->dbprefix('department') .".Dep_code,
                ".$this->db->dbprefix('department') .".Description")
            ->from("department")
            //->edit_column('status', '$1__$2', 'status,Id')
            //->unset_column('Id')
            ->add_column("Actions", $action, "Id")
            ->unset_column('Id');
        echo $this->datatables->generate();
    }

    function add()
    {
        //$this->sma->checkPermissions(false, true);
        $this->form_validation->set_rules('Code', 'Code', 'required|trim');
        $this->form_validation->set_rules('Description', $this->lang->line("Name"), 'required|trim');
        
        if ($this->form_validation->run('departments/add') == true) {
            $data = array(
                'Comp_Id' => $this->input->post('Comp'),
                'Description' => $this->input->post('Description'),
                'Dep_code' => $this->input->post('Code'),
            );
        } elseif ($this->input->post('add_customer')) {
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            redirect('department');
        }

        if ($this->form_validation->run() == true && $this->model->addDepartment($data)) {
            $this->messages->add($this->lang->line("Department_Added"), "success");

            redirect('department');
        } else {
            $this->data['page_title'] = 'Add Department';
		    $this->data['heading'] = 'Department';
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            $this->data['message'] = view_error($this->messages->get(),1);
            $this->load->model('company_model');
            $this->data['companies'] = $this->company_model->getAll();
            $this->load->view('templates/departments/add', $this->data);
        }
    }
    
     function edit($id = NULL)
    {
        //$this->sma->checkPermissions(false, true);
        
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $comp_details = $this->model->getCompByID($id);
        //echo '<pre>',print_r($comp_details); die();
        $this->form_validation->set_rules('Description', $this->lang->line("Name"), 'required|trim');
        

        if ($this->form_validation->run('departments/add') == true) {
       
            $data = array(
                'Description' => $this->input->post('Description'),
                'Comp_Id' => $this->input->post('Comp'),
            );
        } elseif ($this->input->post('edit_customer')) {
            $this->messages->add(validation_errors(), "error");
            //redirect($_SERVER["HTTP_REFERER"]);
            redirect('departments');
        }

        if ($this->form_validation->run() == true && $this->model->updateComp($id, $data)) {
           
            $this->messages->add(lang("Department_Updated"), "success");
            //redirect($_SERVER["HTTP_REFERER"]);
            redirect('department');
        } else {
            $this->data['department'] = $comp_details;
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            $this->data['message'] = view_error($this->messages->get());
            $this->load->model('company_model');
            $this->data['companies'] = $this->company_model->getAll();
            $this->data['page_title'] = 'Edit Department';
            $this->data['heading'] = 'Department';
            $this->load->view('templates/departments/edit', $this->data);
        }
    }

   
    function deactivate($id = NULL)
    {
        if ($this->departments_model->change_status($id,'Unpublish')) {
            $this->messages->add('departments UnPublished', "success");
        } else {
            if($this->messages->count() == 0)
                $this->messages->add('departments UnPublished error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function activate($id = NULL)
    {
        if ($this->departments_model->change_status($id,'Publish')) {
            $this->messages->add('departments Published', "success");
        } else {
            if($this->messages->count() == 0)
                $this->messages->add('departments Published error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function delete($id = NULL)
    {
        //$this->tmw->checkPermissions(NULL, TRUE);
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if ($this->departments_model->delete($id)) {
            $this->messages->add('departments deleted', "success");
        } else {
            if($this->messages->count() == 0)
            $this->messages->add('departments delete error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function suggestions($term = NULL, $limit = NULL)
    {
        // $this->tmw->checkPermissions('index');
        if ($this->input->get('term')) {
            $term = $this->input->get('term', TRUE);
        }
        if (strlen($term) < 1) {
            return FALSE;
        }
        $limit = $this->input->get('limit', TRUE);
        $rows['results'] = $this->companies_model->getdepartmentsuggestions($term, $limit);
        echo json_encode($rows);
    }


}