<?php
/**
 * Created by PhpStorm.
 * User: Namal
 * Date: 1/26/2016
 * Time: 3:14 PM
 */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Payslip {
    private $CI;

    public function __construct()
    {
        $this->CI =& get_instance();
        $this->CI->load->library('session');
        $this->CI->load->library('messages');
        $this->CI->load->library('attn');
        $this->CI->config->item('base_url');
    }

    function make_allowance_deduction($options=array(),$type='A',$field='')
    {
        $printNames = array();
        $printNames_basic = array();
        $printNames_epf = array();
        $price = 0;
        $sub_price = 0;
        $rt = array();
        //echo '<pre>',print_r($options),'</pre>'; die();
        foreach($options as $op)
        {
            if(($op['Id_Item']==$type))
            {
                $cprice = (float)$op[$field];
                $price = $price+$cprice;

                if(isset($op['Basic']) and $op['Basic']=='yes'){
                    $p = (float)$op[$field];
                    $sub_price = $sub_price+$p;
                    $printNames_basic[] = array($op['Name'],$cprice,$op['Id_Item'],$op['Rate'],$op['Item_Code']);
                }else if($op['EPF']=='yes'){
					$printNames_epf[] = array($op['Name'],$cprice,$op['Id_Item'],$op['Rate'],$op['Item_Code']);
					$printNames[] = array($op['Name'],$cprice,$op['Id_Item'],$op['Rate'],$op['Item_Code']);
                }else{
                    $printNames[] = array($op['Name'],$cprice,$op['Id_Item'],$op['Rate'],$op['Item_Code']);
                }

            }
        }
        $rt[0] = $price;
        $rt[1] = ($price-$sub_price);
        $rt[2] = $printNames;
        $rt[3] = $printNames_basic;
        $rt[5] = $printNames_epf;
        return $rt;
    }

    function make_month_items($records = array())
    {
        $formatted = array();
        if(is_array($records) and !empty($records))
        {
            $i=0;
            $emp_no = NULL;
            $rows = array();
            foreach($records as $record) {
                if ($i == 0) {
                    $emp_no = $record['EmpNo'];
                    $rows[] = $record;
                } else {
                    if ($record['EmpNo'] == $emp_no) {
                        $rows[] = $record;
                    } else {
                        $formatted[$emp_no] = $rows;
                        unset($rows);
                        $emp_no = $record['EmpNo'];
                        $rows[] = $record;
                    }
                }
                $i++;
            }
            $formatted[$emp_no] = $rows;
            unset($rows);
        }
        return $formatted;
    }

    function make_options($options=array(),$type='N',$field='',$no='no',$sal=0,$days=null,$hour=null)
    {
        $multi = (isset($hour)) ? 1:0; //remove multiplication errors
        $price = 0;
        $printNames = array();
        $rt = array();
        foreach($options as $op)
        {
            if($type==$op['Id_Item'])
            {
                $cprice = 0;
                $rate = $op['IRate'];
                if($multi==1)
                {
                    if($multi==1)
                    {
                        if($rate!=0 and $days!=0 and $hour!=0)
                        {
                            $fv = $op[$field];
                            $decimal = $fv - (int) $fv;
                            $val =  ($decimal/60)*100;
                            $new_val = (float)((int) $fv + (float)$val);
                            $new_val = round($new_val, 4);
                            $cprice = round(((float)(($sal/($days*$hour))*(float)$new_val)*$rate),2);
                        }
                    }
                }
                else if($multi==0)
                {
                    if($days!=0 and $rate!=0)
                    {
                        $cprice = round(((float)(($sal/$days)*(float)$op[$field])*$rate),2);
                    }
                }
                $price = $price+$cprice;
                if($type=='O' or $type=='D'){
                    if($op['Rate']!=='0.00')
                        $printNames[] = array($op['Name']."({$rate}) - hours ".$op['Rate'],$cprice,$op['Id_Item'],$op['Rate'],$op['Item_Code']);
                }elseif ($type=='N'){
                    if($op['Rate']!=='0.00')
                        $printNames[] = array($op['Name']."({$rate}) - Days ".$op['Rate'],$cprice,$op['Id_Item'],$op['Rate'],$op['Item_Code']);
                }else $printNames[] = array($op['Name']."({$rate})",$cprice,$op['Id_Item'],$op['Rate'],$op['Item_Code']);
            }
        }
        $rt[0] = $price;
        $rt[1] = $printNames;
        return $rt;
    }

    function get_last_month($month){

        $dt = new DateTime($month);
        $dt->modify('last month');

        $output = $dt->format('Y-m');

        return strtoupper($output);
    }

    function round_down_to_hundred($theNumber=0){
        $theNumber = 100 * floor($theNumber/100);
        return $theNumber;
    }

    function breakdownDenominations($amount, $denominations) {
        arsort($denominations); // sort the denomination values from high to low
        $count = array();
        foreach ($denominations as $key=>$value) {
            while ($amount >= $value) {
                $amount = round($amount - $value,2); // decrement by the value of the denomination
                if (!isset($count[$key])) {
                    $count[$key] = 1;
                } else {
                    $count[$key]++; // track the occurrence of each denomination
                }
            }
        }
        // you could return the $count array here if you want to do database stuff
        $breakdown = array();
        foreach ($count as $key=>$value) {
            $breakdown[$key] = $value; // combine the keys with the value for formatting
        }
        return $breakdown;
    }
}