<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Site extends CI_Model
{

	public function __construct() {
		parent::__construct();
	}

    public function get_countries() {
        $this->db->order_by("country_name", "asc");
        $q = $this->db->get('countries');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

	public function get_total_provinces() {
		$this->db->order_by("name_english", "asc");
		$q = $this->db->get('provinces');
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

	public function get_total_districts($p_id=NULL) {
		if($p_id) $this->db->where('p_id',$p_id);
		$this->db->order_by("name_english", "asc");
		$q = $this->db->get('districts');
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

    public function get_district_by_id($id) {
        $q = $this->db->get_where('districts', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

	public function get_district_by_slug($slug) {
		$q = $this->db->get_where('districts', array('slug' => $slug), 1);
		if ($q->num_rows() > 0) {
			return $q->row();
		}
		return FALSE;
	}


	public function get_total_cities($d_id=NULL) {
		if($d_id) $this->db->where('d_id',$d_id);
		$this->db->order_by("name_english", "asc");
		$q = $this->db->get('cities');
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

    public function getSearchCities($d_id) {
        $this->db->select('id, name_english as text')
            ->where('d_id', $d_id)->order_by('name_english');
        $q = $this->db->get("cities");
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

	public function get_city($id) {
		$q = $this->db->get_where('cities', array('d_id' => $id), 1);
		if ($q->num_rows() > 0) {
			return $q->row();
		}
		return FALSE;
	}

    public function get_city_by_slug($slug) {
        $q = $this->db->get_where('cities', array('slug' => $slug), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
        
        public function getParentCategories()
    {
        $this->db->where('ParentId', NULL)->or_where('ParentId', 0);
        $q = $this->db->get("categories");
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

	public function get_main_subjects() {
		$this->db->order_by("name_english", "asc");
		$q = $this->db->get_where('subjects', array('parent' => 0));
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

	public function get_main_categories() {
		$this->db->order_by("name_english", "asc");
		$q = $this->db->get_where('category', array('parent' => 0));
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

	public function get_sub_categories($main) {
		$this->db->order_by("name_english", "asc");
		$q = $this->db->get_where('category', array('parent' => $main));
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

	public function get_total_categories() {
		$this->db->order_by("name_english", "asc");
		$q = $this->db->get('category');
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

	public function get_category($id) {
		$q = $this->db->get_where('category', array('id' => $id),1);
		if ($q->num_rows() > 0) {
			return $q->row();
		}
		return FALSE;
	}
	
	public function get_total_subjects() {
		$this->db->order_by("name_english", "asc");
		$q = $this->db->get('subjects');
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}


	public function get_setting() {
		$q = $this->db->get('settings');
		if ($q->num_rows() > 0) {
			return $q->row();
		}
		return FALSE;
	}

	public function getDateFormat($id) {
		$q = $this->db->get_where('date_format', array('id' => $id), 1);
		if ($q->num_rows() > 0) {
			return $q->row();
		}
		return FALSE;
	}

	public function getCities() {
		$this->db->order_by("name_english", "asc");
		$q = $this->db->get('cities');
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}



	public function getUser($id = NULL) {
		if (!$id) {
			$id = $this->session->userdata('user_id');
		}
		$q = $this->db->get_where('users', array('id' => $id), 1);
		if ($q->num_rows() > 0) {
			return $q->row();
		}
		return FALSE;
	}

	public function getAllCategories() {
		$this->db->order_by("Name", "asc");
		$q = $this->db->get('categories');
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

	public function getCategoryByID($id) {
		$q = $this->db->get_where('categories', array('id' => $id), 1);
		if ($q->num_rows() > 0) {
			return $q->row();
		}
		return FALSE;
	}

	public function modal_js() {
		return '<script type="text/javascript">' . file_get_contents($this->data['assets'] . 'js/modal.js') . '</script>';
	}
	

	public function checkPermissions() {
		$q = $this->db->get_where('permissions', array('group_id' => $this->session->userdata('group_id')), 1);
		if ($q->num_rows() > 0) {
			return $q->result_array();
		}
		return FALSE;
	}

	public function getUpcomingEvents() {
		$dt = date('Y-m-d');
		$this->db->where('date >=', $dt)->order_by('date')->limit(5);
		if ($this->Settings->restrict_calendar) {
			$q = $this->db->get_where('calendar', array('user_id' => $this->session->userdata('iser_id')));
		} else {
			$q = $this->db->get('calendar');
		}
		if ($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

	public function getUserGroup($user_id = false) {
		if (!$user_id) {
			$user_id = $this->session->userdata('user_id');
		}
		$group_id = $this->getUserGroupID($user_id);
		$q = $this->db->get_where('groups', array('id' => $group_id), 1);
		if ($q->num_rows() > 0) {
			return $q->row();
		}
		return FALSE;
	}

	public function getUserGroupID($user_id = false) {
		$user = $this->getUser($user_id);
		return $user->group_id;
	}

    public function validate_captcha($captcha)
    {
        $expiration = time()-7200; // Two hour limit
        $this->db->query("DELETE FROM captcha WHERE captcha_time < ".$expiration);
        // Then see if a captcha exists:
        $sql = "SELECT COUNT(*) AS count FROM captcha WHERE word = ? AND ip_address = ? AND captcha_time > ?";
        $binds = array($captcha, $this->input->ip_address(), $expiration);
        $query = $this->db->query($sql, $binds);
        $row = $query->row();
        echo $row->count; die();

        if ($row->count == 1)
        {
            echo 'dsfsf'; die();
            return true;
            //echo "You must submit the word that appears in the image";
        }
        else
        {
            return false;
        }

    }
	
}