<?php
require_once("report.php");
class Summary_attendence extends Report
{
	private $tableMain = 'attendance';
	private $join = 'comp';
	private $join2 = 'employee';
	
	function __construct()
	{
		parent::__construct();
	}

	public function getDataColumns()
	{
		return array($this->lang->line('reports_date'), $this->lang->line('reports_subtotal'), $this->lang->line('reports_total'), $this->lang->line('reports_tax'), $this->lang->line('reports_profit'));
	}

	public function getData($date, $EmpNo, $Comp, $department)
	{
		//new funstion
		$this->db
			->select("A.USER,E.EmpName,C.Name,A.DATE,A.INTIME,A.OUTDATE,A.OUTTIME")
			->from("attendance AS A")
			->join('comp AS C', "A.Comp=C.Code", 'left')
			->join('employee AS E', 'A.USER=E.EmpNo  AND E.Comp=A.Comp', 'left')
			->where('A.Comp', $this->attn->getComp())
			->where('A.DEVICE', $this->attn->get_unit_id());

		if ($Comp != null) {
			$this->db->where("A.Comp", $Comp);
			$this->db->where("C.Code", $Comp);
		}

		if ($EmpNo != null) {
			$this->db->where("A.USER", $EmpNo);
			$this->db->where("E.EmpNo", $EmpNo);
		}
		if ($date != null) {
			$this->db->where('A.DATE="' . date('Y-m-d', strtotime($date)) . '"');
		}
		if ($department != null) {
			$this->db->where("E.Dep_code", $department);
		}
		$this->db->order_by("A.DATE", "desc");

		$query = $this->db->get();
		return $query->result_array();
	}
	

	
	public function getSummaryData(array $inputs)
	{
		$this->db->select('sum(subtotal) as subtotal, sum(total) as total, sum(tax) as tax,sum(profit) as profit');
		$this->db->from('sales_items_temp');
		$this->db->where('sale_date BETWEEN "'. $inputs['start_date']. '" and "'. $inputs['end_date'].'"');
		if ($inputs['sale_type'] == 'sales')
        {
            $this->db->where('quantity_purchased > 0');
        }
        elseif ($inputs['sale_type'] == 'returns')
        {
            $this->db->where('quantity_purchased < 0');
        }   
		return $this->db->get()->row_array();		
	}



	public function get_all_employees($comp, $emp=0)
	{
		$query = $this->db->query("SELECT EmpNo,EmpName,Basic_Salery FROM `employee` WHERE Comp=".$this->db->escape($comp)." AND Active='1' ORDER BY EmpNo ASC");
		return $query->result();
	}

	public function get_all_employee_filter($comp, $emp=0)
	{
		$nemp = ($emp!=0)? " AND EmpNo='".$emp."'":'';
		$query = $this->db->query("SELECT EmpNo,EmpName,Basic_Salery FROM `employee` WHERE Comp=".$this->db->escape($comp)." AND Active='1' $nemp ORDER BY EmpNo ASC");
		return $query->result();
	}
	
	public function get_items($id=0,$month,$comp)
	{
		$query = $this->db->query("SELECT t.*,i.Description,i.EPF FROM `trans` as t 
		LEFT JOIN items AS i
		ON t.Item_Code=i.Code AND t.Id_Item=i.Id
		 WHERE t.EmpNo=".$this->db->escape($id)." AND t.Comp=".$this->db->escape($comp)." AND t.month=".$this->db->escape($month)."");
		//echo $this->db->last_query(); die();
		return $query->result_array();
	}
	
	public function get_setting($comp)
	{
		$this->db->select('*');
		$this->db->from("settings");
		$this->db->where('Comp',$comp);
  		$query = $this->db->get();
		return $query->row();
	}

	public function get_user_shift($user_id)
	{
		$this->db->select('S.Shift_From,S.Shift_To,T.Hours');
		$this->db->from("shift AS S");
		$this->db->join("shift_transaction AS T",'S.shift_code=T.Shift_code AND S.Comp_Id=T.Comp_Id','left');
		$this->db->where('t.EmpNo',$user_id);
		$query = $this->db->get();
		if($query->num_rows()== 1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}

	}


	public function get_ot($EmpNo, $comp=null,$manth,$hours=8,$outtime='17:00:00',$comtabel=60)
	{
		//new funstion
		$user_query = (isset($EmpNo)) ? "(A.USER ='".$EmpNo."') " : null;
		$and = (isset($user_query)) ? "AND ":null;
		$date_query = '';
		if(!empty($manth))
		{
			$date_query = $and." DATE_FORMAT(A.DATE,'%Y-%m')= '".$manth."' ";
		}


		$com_query = ($comp !=null) ? " AND A.Comp = '$comp' ":null;

		$query = $this->db->query("SELECT A.USER,E.EmpName AS NAME,D.Description,A.DATE,INTIME,A.OUTTIME,A.OUTDATE,
		TIME_FORMAT(TIMEDIFF(A.OUTTIME,A.INTIME),'%H:%i') AS HOURS
,IF(TIME_TO_SEC(TIMEDIFF(A.OUTTIME,A.INTIME)) > ".$hours."  ,TIME_FORMAT(TIMEDIFF(A.OUTTIME,'".$outtime."'),'%H:%i'),'00:00') AS Extra,
IF(TIME_TO_SEC(IF(TIME_TO_SEC(TIMEDIFF(A.OUTTIME,A.INTIME)) > '".$hours."', TIME_FORMAT( TIMEDIFF(A.OUTTIME,'".$outtime."') , '%H:%i' ), '00:00' )) > (".$comtabel.")*60,IF(TIME_TO_SEC(TIMEDIFF(A.OUTTIME,A.INTIME)) > '".$hours."', TIME_FORMAT( TIMEDIFF(A.OUTTIME,'".$outtime."') , '%H:%i' ), '00:00' ),'00:00') AS OT
		FROM employee AS E LEFT JOIN attendance AS A ON (A.USER=E.EmpNo AND A.Comp=E.Comp)
		LEFT JOIN department AS D ON A.Comp=D.Comp_Id  AND E.Dep_code=D.Dep_code
		 WHERE ".$user_query.$date_query." $com_query AND E.Active='1' AND A.OUTTIME !='00:00:00' ORDER BY A.DATE,A.INTIME,A.NAME,A.USER ASC");
		//echo $this->db->last_query();die();
		return $query->result_array();
	}

	public function getComp($comp)
	{
		$this->db->select('Name,Address');
		$this->db->from("comp");
		$this->db->where('Code',$comp);
		$query = $this->db->get();
		return $query->row_array();
	}

}
?>