<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Customers extends CI_Controller {

    var $main_menu_name = "people";
	var $sub_menu_name = "customers";

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Customer_Model');
		$this->load->model('Common_Model');
		$this->load->model('Country_Model');
		
	}
	
	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		
		$this->load->view('customers',$data);
	}

	public function create_customers()
	{
        $data['id'] = 1;
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'create_customer';
		$data['city_list'] = $this->Country_Model->get_all_areas();
        if (isset($_GET['cus_id'])) {
			$cus_id=$_GET['cus_id'];
		}
		else {
			$cus_id='';
		}
		if($cus_id){
			$data['cus_id']=$cus_id;
			$data['type']='E';
			$data['pageName']='UPDATE CUSTOMER';
			$data['btnText']='Update Customer';
			$data['customer']= $this->Customer_Model->get_customer_info($cus_id);	
		}
		else {
			$data['cus_id']='';
			$data['type']='A';
			$data['pageName']='ADD CUSTOMER';
			$data['btnText']='Add Customer';
			$data['customer']=array();
		}
		$data['country_list'] = $this->Common_Model->get_all_country();
        $this->load->view('models/create_customer',$data);	
	}
	
	function get_all_customers() {
		$this->db->select('cus_name','cus_id');
		$this->db->order_by("cus_name", "asc");
		$this->db->where("cus_status=1");//("id !=",$id);
		$query = $this->db->get('customers');
		return $query->result_array();
	}
	
	
	public function save_customer()
	{
		$cus_id=$this->input->post('cus_id');
		$type=$this->input->post('type');
		$country_id=$this->input->post('country_id');
		$city_name=$this->input->post('city_name');
		$city_id=$this->input->post('city_id');
		$cus_name=$this->input->post('cus_name');
		$cus_code=$this->input->post('cus_code');
		$cus_email=$this->input->post('cus_email');
		$cus_phone=$this->input->post('cus_phone');
		$cus_address=$this->input->post('cus_address');
		$cus_state=$this->input->post('cus_state');
		$cus_type=$this->input->post('cus_type');
		$cus_postal_code=$this->input->post('cus_postal_code');	
		$cus_credit_limit = $this->input->post('cus_credit_limit');
		if(!is_numeric($cus_id)) $cus_id = 0;
		if(!is_numeric($city_id)) $city_id = 0;
		
		$this->load->library('form_validation'); //form validation lib
		if($type=='A')
		{
			$this->form_validation->set_rules('cus_code', 'Code', 'required|is_unique[customer.cus_code]');
		}
		else if($type=='E')
		{
			$this->form_validation->set_rules('cus_code', 'Code', 'required');
		}
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		$data=array(
			'country_id'=>$country_id,
			'cus_id'=>$cus_id,
			'city_name'=>$city_name,	
			'city_id'=>$city_id,
			'cus_name'=>$cus_name,
			'cus_code'=>$cus_code,
			'cus_email'=>$cus_email,
			'cus_phone'=>$cus_phone,	
			'cus_address'=>$cus_address,
			'cus_state'=>$cus_state,
			'cus_type'=>$cus_type,
			'cus_postal_code'=>$cus_postal_code,
			'cus_credit_limit'=>$cus_credit_limit
		);
		$_insert=$this->Customer_Model->save_customer($data,$cus_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type,'status' =>1));
			} else {
				echo json_encode(array('status'=>'0'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type,'status' =>1));
		}	
			
			 //$st = array('status' =>1,'validation' => validation_errors());
            // echo json_encode($st);
		}
	}
	
	public function list_customer()
	{
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'cus_id', 
		1 => 'cus_name',
		2=> 'cus_email',
		3 =>'cus_phone', 
		4 => 'cus_phone',
		5=> 'cus_id'
	);
	
	$data = array();
	$customers = $this->Customer_Model->get_all_customer();
	$totalData = count($customers);
	$totalFiltered = $totalData;  
	
	foreach ($customers as $row){
		$nestedData=array(); 
		$nestedData[] =	$row['cus_code'];
		$nestedData[] = $row['cus_name'];
		$nestedData[] = $row['cus_email'];
		$nestedData[] =	$row['cus_phone'];
		$nestedData[] = $row['city_name'];
		$nestedData[] = $row['cus_credit_limit'];
		
		if($row['block_on_limit']==1){

		 $block_action ='<a class="btn btn-xs btn-bricky tooltips" style="cursor: pointer;" onClick="blocking_status_change('.$row['cus_id'].' , 0 )"><i class="fa fa-check"></i> Allow to exceed credit limit </a>';

	}

	

	if($row['block_on_limit']==0){

		 $block_action ='<a class="btn btn-xs btn-warning tooltips" style="cursor: pointer;" onClick="blocking_status_change('.$row['cus_id'].' , 1 )"><i class="fa fa-times"></i> Deny to exceed credit limit </a>';

	}
	
	$nestedData[]=	'<div class="btn">'.$block_action.'</div>';
	$nestedData[] = $row['cus_type'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';$block_action = '';
		$actionTxtUpdate='<a onClick="click_customer_update_btn('.$row['cus_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit customers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
		if($row['cus_status']==1){
			$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable customer" onClick="disableCustomerData('.$row['cus_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
		if($row['cus_status']==0){
			$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable customer" onClick="enableCustomerData('.$row['cus_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
	}
	
		$actionTxtDelete='<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete customer" onClick="deleteCustomerData('.$row['cus_id'].')">
															<i class="glyphicon fa fa-trash-o"></i></a>';
	
	
	
	$nestedData[]=	'<div class="btn">'.$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete.'</div>';
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}
	

	function delete_customer() {
		$cus_id	= $this->input->post('cus_id');
		$this->Customer_Model->delete_customer($cus_id);
        if ($cus_id) {
        	echo json_encode(array('id'=>$cus_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function disable_customer() {
		$cus_id	= $this->input->post('cus_id');
		$this->Customer_Model->disable_customer($cus_id);
        if ($cus_id) {
        	echo json_encode(array('id'=>$cus_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_customer() {
		$cus_id	= $this->input->post('cus_id');
		$this->Customer_Model->enable_customer($cus_id);
        if ($cus_id) {
        	echo json_encode(array('id'=>$cus_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	public function get_customer_city(){
		
		$cus_id=$this->input->get('cus_id');
		$data_customer=$this->Customer_Model->get_customer_info($cus_id);
//print_r($data_customer);
//		return $data_customer;
//		$cus_address=$data_customer['city_id'];
		//echo json_encode(array('city_id'=>$cus_address));
		echo json_encode($data_customer);
	}
	
	public function get_customers() {
        $srh_customer_id = $this->input->get('srh_customer_id');
        $customers = $this->Customer_Model->get_customers($srh_customer_id);

        echo json_encode($customers);
    }
	
	function get_customer_credit_limit() {
        $cus_id = $this->input->get('cus_id');
        $data_customer = $this->Customer_Model->get_customer_info($cus_id);
        $cus_credit_limit = $data_customer['cus_credit_limit'];
		$block_on_limit = $data_customer['block_on_limit'];
        echo json_encode(array('cus_credit_limit' => $cus_credit_limit, 'block_on_limit' => $block_on_limit));
    }
	
	function blocking_status_change() {
		$cus_id	= $this->input->post('cus_id');
		$status	= $this->input->post('status');
		
		$this->Customer_Model->blocking_status_change($cus_id , $status);
        if ($cus_id) {
        	echo json_encode(array('id'=>$cus_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
}