<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Purchases extends CI_Controller {
	
    var $main_menu_name = "purchases";
	  var $sub_menu_name = "categories";

      function __construct() 
      {
        parent::__construct();
        $this->load->model('purchases_model');
        $this->load->model('common_model');
		$this->load->model('Sequerty_Model');
        $this->load->library('form_validation');
		$this->load->model('User_Model');
      }

    public function index($e=0)
    {
		//if (!$this->User_Model->is_logged_in_k()) {
			//$this->User_Model->checkLoginPanel_k();
		//}
      $data['error'] = $e;
      $data['main_menu_name'] = $this->main_menu_name;
      $data['sub_menu_name'] = "list_purchases";
      $this->load->view('purchases_list',$data);
    }
	public function purchases_item_list($e=0)
    {
		//if (!$this->User_Model->is_logged_in_k()) {
			//$this->User_Model->checkLoginPanel_k();
		//}
      $data['error'] = $e;
      $data['main_menu_name'] = $this->main_menu_name;
      $data['sub_menu_name'] = "purchases_item_list";
      $this->load->view('purchases_item_list',$data);
    }
	
    public function get_list_purchases($value='')
    {
		$search_key     = $this->input->get('search');
        $search_key_val = $search_key['value'];
			//$srh_length = strlen($search_key_val);
			//if($srh_length <3)$search_key_val = '';
        $start          = $this->input->get('start');
        $length         = $this->input->get('length');
        $totalData      = 0;
		$totalFiltered  = 0;
		$values =	'';
		if ($search_key_val) {
			$values = $this->purchases_model->getpurchases($start, $length, $search_key_val);
			$count = $this->purchases_model->getpurchases_count('', '', $search_key_val);
			$totalData = $count['count'];// print_r();
			$totalFiltered  = $totalData;
		}else{
			$values = $this->purchases_model->getpurchases($start, $length, '');
			$count = $this->purchases_model->getpurchases_count('', '', '');
			$totalData = $count['count'];// print_r();
			$totalFiltered  = $totalData;
		}
			
            
            $data = array();
            $pay_st;
            if (!empty($values)) {
                foreach ($values as $purchases) {
                $grn_total_paid = $this->purchases_model->grn_pay_total($purchases->id);
                if (empty($grn_total_paid[0]->grn_paid_total)) {
                  $pay_st = '<span class="label label-warning">Pending</span>';
                }else{
                  if ($grn_total_paid[0]->grn_paid_total >= $purchases->grand_total) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                  }else{
                    $pay_st = '<span class="label label-info">Partial</span>';
                  }
                }
                
                $row = array();
                    $row[] = $purchases->date;
                    $row[] = $purchases->reference_no;
                    $row[] = $purchases->supp_company_name;
					$row[] = $purchases->supp_invocie_no;
                    $row[] = number_format($purchases->grand_total,2,'.',',');
                    $row[] = number_format($grn_total_paid[0]->grn_paid_total,2,'.',',');
                    $row[] = number_format($purchases->grand_total - $grn_total_paid[0]->grn_paid_total,2,'.',',');
                    $row[] = $pay_st;
					$txtReturn = '<li><a href="'.base_url('purchase_return/manage/'.$purchases->id).'"><i class="fa fa-"></i> Return </a></li>';
                    $row[] = '<div class="text-center"><div class="btn-group text-left">
                    <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                    <ul role="menu" class="dropdown-menu pull-right">
                    <li><a href="'.base_url('purchases/view/'.$purchases->id).'"><i class="fa fa-file-text-o"></i> GRN Details</a></li>
                    '.$txtReturn.'
					</ul></div>
                    </div>';
                    $data[] = $row;
                }

                $output = array(
				"recordsTotal" => intval($totalData),
				"recordsFiltered" => intval($totalFiltered),
				"data" => $data
			);
                echo json_encode($output);
            }else{
                $output = array('data' =>'');
                echo json_encode($output);

            }
       }

 public function get_list_purchases_items($value='')
    {
			$search_key=$this->input->get('search');
			$search_key_val=$search_key['value'];
			$start=$this->input->get('start');
			$length=$this->input->get('length');
					
            $values = $this->purchases_model->getpurchasesitems($start,$length,$search_key_val);
            $data = array();
            $pay_st;
            if (!empty($values)) {
                foreach ($values as $purchases) {
                
                /*if (empty($purchases->sale_pymnt_amount)) {
                  $pay_st = '<span class="label label-warning">Pending</span>';
                }else{
                  if ($purchases->grn_total_paid >= $purchases->grand_total) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                  }else{
                    $pay_st = '<span class="label label-info">Partial</span>';
                  }
                }*/
                

                $row = array();
                    $row[] = $purchases->date;
                    $row[] = $purchases->reference_no;
                    $row[] = $purchases->supp_company_name;
					$row[] = $purchases->product_name;
                    $row[] = $purchases->product_code;
                    /*$row[] = number_format($purchases->grn_total_paid,2,'.',',');
                    $row[] = number_format($purchases->grand_total - $purchases->grn_total_paid,2,'.',',');
                    $row[] = $pay_st;*/
                    $row[] ='';/* '<div class="text-center"><div class="btn-group text-left">
                    <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                    <ul role="menu" class="dropdown-menu pull-right">
                    <li><a href="'.base_url('purchases/view/'.$purchases->id).'"><i class="fa fa-file-text-o"></i> GRN Details</a></li>
                    </ul></div>
                    </div>';*/
                    $data[] = $row;
                }

                $output = array('data' =>$data);
                echo json_encode($output);
            }else{
                $output = array('data' =>'');
                echo json_encode($output);

            }
       }




    public function add_purchases()
    {
		//if (!$this->User_Model->is_logged_in_k()) {
		//	$this->User_Model->checkLoginPanel_k();
		//}
      $data['main_menu_name'] = $this->main_menu_name;
      $data['sub_menu_name'] = 'add_purchases';
      $data['warehouse'] = $this->purchases_model->get_warehouse();
      $data['supplier'] = $this->purchases_model->get_supplier();

      if (isset($_POST['submit'])) {

              $this->form_validation->set_rules('supplier', 'supplier', 'required');

              if ($this->form_validation->run() == FALSE)
              {
                $this->load->view('purchases',$data);
              }
              else
              {
                $podate       = $this->input->post('podate');
                $reference_no = $this->common_model->gen_ref_number('id','purchases','GRN');
                $supplier     = $this->input->post('supplier');
                $discount     = $this->input->post('discount');
                $powarehouse  = $this->input->post('powarehouse'); 
                $note         = $this->input->post('note');
                $grand_total  = $this->input->post('hgtotal');
                $total        = $this->input->post('total');
                $order_cal_des= $this->input->post('order_cal_des');
				$supp_invocie_no           = $this->input->post('supp_invocie_no');

                $grn_header_id = $this->purchases_model->add_grn_header($podate,$reference_no,$supplier,$discount, $powarehouse,$note , $grand_total,$total,$order_cal_des,$supp_invocie_no);

                if ($grn_header_id) {
                    $product_id_array       = $this->input->post('product_id');
                    $product_array          = $this->input->post('product');
                    $product_name_array     = $this->input->post('product_name');
                    $unit_cost_array        = $this->input->post('unit_cost');
                    $quantity_array         = $this->input->post('quantity');
                    $product_discount_array = $this->input->post('product_discount');
                    $gross_total            = $this->input->post('gross_total');
                    $sub_total              = $this->input->post('subtotal');
                    $discount_cal           = $this->input->post('discount_cal');
                  //echo count($product_array);
                  //die();
                  for ($i=0; $i <count($product_array); $i++) { 
                    $this->purchases_model->add_grn_list_item($product_id_array[$i], $grn_header_id,$product_array[$i], $product_name_array[$i], $unit_cost_array[$i], $quantity_array[$i], $product_discount_array[$i],$gross_total,$sub_total[$i],$discount_cal[$i]);
                    $this->common_model->add_fi_table("grn",$grn_header_id,$product_id_array[$i],$quantity_array[$i],$unit_cost_array[$i]);
                  }

                $this->index(1);

                }
              }
        }else{

            $this->load->view('purchases',$data);

        }
      
    }

    public function get_product_by_code()
    {
        
        $emp_array=array();
        $product_code = $this->input->get('term');
        $get_product_all_by_id  = $this->purchases_model->get_product_by_code($product_code);
          if (!empty($get_product_all_by_id)) {
            $empar=array();
            foreach ($get_product_all_by_id as $key => $value) {
              $r      = $get_product_all_by_id[$key];
              $lb = $get_product_all_by_id[$key]->product_name;
              
               $rand_var=date("YmdHis");
               
              $label  = array("id"=>$rand_var,"item_id"=>$get_product_all_by_id[$key]->product_id,"label"=>$get_product_all_by_id[$key]->product_code.' / '.$get_product_all_by_id[$key]->product_part_no.' / '.$get_product_all_by_id[$key]->product_oem_part_number.' / '.$get_product_all_by_id[$key]->product_name.' / LKR.'.$get_product_all_by_id[$key]->product_cost,"qty"=>1,'row' =>$r,'value'=>$get_product_all_by_id[$key]->product_name);
              array_push($empar,$label);
            }
              echo json_encode($empar);

          } else {

            echo '[{"id":0,"label":"No matching result found! Product might be out of stock in the selected warehouse.","value":"hg"}]';
          }
      
    }

    public function purchases_details($purchas_id='')
    {
      
      $data['main_menu_name'] = $this->main_menu_name;
      $data['sub_menu_name'] = "view_purchases";
      $data['po_header'] = $this->purchases_model->getpurchases_by_id($purchas_id);
      $data['po_middle'] = $this->purchases_model->get_purchese_data_by_id($purchas_id);
      $data['po_payment']= $this->purchases_model->get_payment_by_id($purchas_id);
      $data['po_paid_total'] = $this->purchases_model->grn_pay_total($purchas_id);
      $data['purchas_id'] = $purchas_id;
      $this->load->view('purchases_details',$data);
    }
	
	public function getPurchasedQtyByWarehouseId() {

        $srh_warehouse_id = $this->input->get('srh_warehouse_id');
        $product_id = $this->input->get('product_id');

        $purchased_qty = $this->purchases_model->getPurchasedQtyByWarehouseId($srh_warehouse_id, $product_id);

        echo json_encode($purchased_qty);
    }
	
	public function getReturnQtyByWarehouseId() {

        $srh_warehouse_id = $this->input->get('srh_warehouse_id');
        $product_id = $this->input->get('product_id');
        $p_returned_qty = $this->purchases_model->getReturnQtyByWarehouseId($srh_warehouse_id, $product_id);

        echo json_encode($p_returned_qty);
    }
	
	function purchased_items($value = '') {
        //$this->load->library('user_agent');
        //echo 'test:'.$this->agent->referrer(); ;
        //echo $this->uri->segment('3');
        //print_r($_GET);
		
		$this->load->model('purchases_return_model');
		
        $page = '';
        $page = $this->input->get('page');
        $sale_id = $this->input->get('sale_id');
        $term = $this->input->get('term');
        $data['purchase_items'] = $this->purchases_model->get_products_suggestions_for_return($term, $sale_id);
        //print_r($data['purchase_items']);
        $json = array();
        //echo "Count:".count($data['purchase_items']);
        print_r($data['purchase_items']);
        foreach ($data['purchase_items'] as $row) {
            $saleqty = 0;
            if ($page == 'purchase_return_add') {
                //check invoice have this item
                $saleqty = $this->purchases_return_model->get_avalable_product_qty_for_return($row['product_id'], $this->session->userdata('ss_warehouse_id'), $sale_id);
            }

            //set price
            /* 	$price_tmp=0;
              if($in_type=='Cash'){
              $price_tmp=$row['product_price'];
              }
              if($in_type=='Credit'){
              $price_tmp=$row['wholesale_price'];
              }
              if($in_type=='Wholesale'){
              $price_tmp=$row['wholesale_price'];
              }
             */
            $product_name = $row['product_name'];
            $product_code = $row['product_code'];
//			$product_part_no=$row['product_part_no'];
//			$product_oem_part_number=$row['product_oem_part_number'];
            $product_id = $row['product_id'];
            $product_price = $row['unit_price'];
//			$product_price=$price_tmp;
            /* 			$sendParameters="'$product_id','$product_name','$product_code','$product_price'";
              $sendParameters="$product_id,$product_name,$product_code,$product_price";
             */ $extraName = '';
            /* 	$extraName.=", Selling Price: ".number_format($product_price, 2, '.', ',');
              if($product_part_no) $extraName.=", Part No: $product_part_no";
              if($product_oem_part_number) $extraName.=", OEM Part No: $product_oem_part_number";
              $qty_in_stock=0;
              $srh_warehouse_id=$this->session->userdata('ss_warehouse_id');
              $transferd_qty=0;
              $transfer_reseve_qty=0;
              $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id);
              $transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$product_id);
              $sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$product_id);
              $purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$product_id);
              $product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$product_id);
              $sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$product_id);
              $qty_in_stock=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty;
              //$qty_in_stock=$purchased_qty;
              $extraName.=", Qty in stock: $qty_in_stock";

             */


            $json_itm = array(
                'id' => $row['product_id'],
                'product_id' => $row['product_id'],
                'product_code' => $row['product_code'],
                'product_name' => $row['product_name'],
                'product_price' => $row['unit_price'],
                'quantity' => $row['quantity'],
//					'product_part_no'=> $row['product_part_no'],
//					'item_cost'=> $row['product_cost'],
//					'product_oem_part_number'=> $row['product_oem_part_number'],
                'value' => $row['product_name'] . " (" . $row['product_code'] . ")",
                'label' => $row['product_name'] . " (" . $row['product_code'] . ")$extraName"
            );
            //print_r($json_itm);
            //	if($page=='sales_return_add'){
            //			if($saleqty){
            array_push($json, $json_itm);
            //		}
            //}else {
            //			array_push($json,$json_itm);
            //		}
        }
        echo json_encode($json);
    }

}