<?php
class Purchases_Model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    public function get_product_by_code($product_code = '')
    {
        $this->db->select('p.*');
        $this->db->from('product p');
        $this->db->like('p.product_name', $product_code);
        $this->db->or_like('p.product_code', $product_code);
        $this->db->limit('50');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
    function get_purchase_info($id)
    {
        $this->db->select('*');
        $this->db->from('purchases');
        $this->db->where("purchases.id", $id);
        $this->db->order_by("purchases.id", "desc");
        $query = $this->db->get();
        return $query->row_array();
    }
	function get_purchase_info_for_return($id)
    {
        $this->db->select('purchases.*,supplier.supp_company_name as supplier_name');
        $this->db->from('purchases');
		$this->db->join('supplier','purchases.supplier_id = supplier.supp_id');
		$this->db->where("purchases.id", $id);
        $this->db->order_by("purchases.id", "desc");
        $query = $this->db->get();
        return $query->row_array();
    }
	function get_total_paid_by_grn_id($sale_id){
		$this->db->select_sum('sale_pymnt_amount');
		$this->db->from('sale_payments');
		$this->db->where("sale_id",$sale_id)->where("(sale_payment_type='grn')");
		$query=$this->db->get();
		//echo $this->db->last_query();
		if($query->row()->sale_pymnt_amount){
			return $query->row()->sale_pymnt_amount;
		}else {
			return 0;
		}
  	}
    public function getPurchasedQtyByWarehouseId($warehouse_id, $product_id, $srh_from_date = '', $srh_to_date = '', $search_key_val = '', $cat_srh = '')
    {
        $this->db->select_sum('pi.quantity');
        $this->db->from('purchase_items pi');
        $this->db->join('purchases p', 'p.id = pi.purchase_id', 'left');
        $this->db->join("product pr", "pr.product_id = pi.product_id", "left");
        $this->db->join("product_category pc", "pr.cat_id = pc.cat_id", "left");
        if ($cat_srh) {
            $this->db->where("pc.cat_name", $cat_srh);
        }
        if ($search_key_val) {
            $this->db->where("pi.product_code LIKE '%$search_key_val%'", "left");
        }
        if ($product_id)
            $this->db->where('pi.product_id', $product_id);
        if ($srh_to_date) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($srh_to_date));
            $this->db->where("p.date <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($srh_from_date));
            $this->db->where("p.date >=", $srh_from_date);
        }
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $data['quantity'] = $query->row()->quantity;
        } else {
            return 0;
        }
    }
    function get_tax_by_id($tax_id = '')
    {
        $this->db->select('t.*');
        $this->db->from('tax_rates t');
        $this->db->where('t.id', $tax_id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
    public function get_warehouse()
    {
        $this->db->select('*');
        $this->db->from('warehouses');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
    public function get_supplier()
    {
        $this->db->select('*');
        $this->db->from('supplier');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
    public function add_grn_header($podate, $reference_no, $supplier, $discount, $powarehouse, $note, $grand_total, $total, $order_cal_des, $supp_invocie_no)
    {
        $data = array(
            'reference_no' => $reference_no,
            'warehouse_id' => $powarehouse,
            'supplier_id' => $supplier,
            'date' => date('Y-m-d H:i', strtotime($podate)),
            'note' => $note,
            'total' => $total,
            'grand_total' => $grand_total,
            'discount' => $discount,
            'discount_cal' => $order_cal_des,
            'supp_invocie_no' => $supp_invocie_no
        );
        if ($this->db->insert('purchases', $data)) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }
    function save_grn_item($data_item)
    {
        $this->db->insert('purchase_items', $data_item);
    }
    function save_grn($data_item, $grn_id = false)
    {
        if (!$grn_id) {
            $this->db->insert('purchases', $data_item);
        } else {
            $this->db->where('id', $grn_id);
            return $this->db->update('purchases', $data_item);
        }
    }
    public function add_grn_list_item($product_id_array, $grn_header_id, $product_array, $product_name_array, $unit_cost_array, $quantity_array, $product_discount_array, $gross_total, $sub_total, $discount_cal)
    {
        $data = array(
            'purchase_id' => $grn_header_id,
            'product_id' => $product_id_array,
            'product_code' => $product_array,
            'product_name' => $product_name_array,
            'quantity' => $quantity_array,
            'unit_price' => $unit_cost_array,
            'sub_total' => $sub_total,
            'discount' => $product_discount_array,
            'discount_cal' => $discount_cal
        );
        if ($this->db->insert('purchase_items', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function getpurchases($start = '', $length = '', $search_key_val = '')
    {
        $this->db->select("s.*,spl.*");
        $this->db->from("purchases s");
        $this->db->join("supplier spl", "spl.supp_id = s.supplier_id", "left");
        //warehouse_id
        $ss_warehouse_id=$this->session->userdata('ss_warehouse_id');
        $this->db->where("s.warehouse_id",$ss_warehouse_id);
        
		if ($search_key_val) {
            $this->db->where("s.reference_no LIKE '%$search_key_val%' OR spl.supp_company_name LIKE '%$search_key_val%' OR s.supp_invocie_no LIKE '%$search_key_val%'");
        }
		if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
        }
        $this->db->group_by("s.id");
        $this->db->order_by("s.reference_no", "desc");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
	
	function getpurchases_count($start = '', $length = '', $search_key_val = '')
    {
        $this->db->select("COUNT(s.id) AS count");
        $this->db->from("purchases s");
        $this->db->join("supplier spl", "spl.supp_id = s.supplier_id", "left");
		if ($search_key_val) {
            $this->db->where("s.reference_no LIKE '%$search_key_val%' OR spl.supp_company_name LIKE '%$search_key_val%' OR s.supp_invocie_no LIKE '%$search_key_val%'");
        }
        //$this->db->group_by("s.id");
        //$this->db->order_by("s.reference_no", "desc");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
    }
    public function getpurchasesitems($start = '', $length = '', $search_key_val = '')
    {
        $this->db->select("p.date,p.reference_no,pi.product_name,pi.product_code,spl.supp_company_name");
        $this->db->from("purchase_items pi");
        $this->db->join("purchases p", "pi.purchase_id = p.id");
        $this->db->join("supplier spl", "spl.supp_id = p.supplier_id", "left");
        if ($search_key_val) {
            $this->db->where("          spl.supp_company_name LIKE '%$search_key_val%' 
                                OR      p.reference_no LIKE '%$search_key_val%' 
                                OR      pi.product_code LIKE '%$search_key_val%'
            ");
        }
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
        }
        $this->db->order_by("p.reference_no", "desc");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
	public function get_purchese_items_for_return($po_id = '')
    {
        $this->db->select('*');
        $this->db->from('purchase_items');
        $this->db->where('purchase_items.purchase_id', $po_id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }
    }
    public function getpurchases_by_id($po_id = '')
    {
        $this->db->select("p.* , sp.*,wh.id as warehouse_id,wh.*");
        $this->db->from("purchases p");
        $this->db->join("supplier sp", " sp.supp_id = p.supplier_id", "left");
        $this->db->join("warehouses wh", " wh.id = p.warehouse_id", "left");
        $this->db->where("p.id", $po_id);
        $this->db->order_by("p.reference_no", "desc");
        $this->db->group_by("p.id");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
    public function get_purchese_data_by_id($po_id = '')
    {
        $this->db->select('*');
        $this->db->from('purchase_items');
        $this->db->where('purchase_items.purchase_id', $po_id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
    public function get_payment_by_id($purchase_id = '')
    {
        $this->db->select('sp.*');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.sale_id', $purchase_id);
        $this->db->where('sp.sale_payment_type', 'grn');
        $query = $this->db->get();
        return $query->result();
    }
    function grn_pay_total($purchase_id = '')
    {
        $this->db->select('SUM(sp.sale_pymnt_amount) AS grn_paid_total');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.sale_id', $purchase_id);
        $this->db->where('sp.sale_payment_type', 'grn');
        $query = $this->db->get();
        return $query->result();
    }
	function grn_total_paid_for_return($purchase_id)
    {
        $this->db->select('SUM(sp.sale_pymnt_amount) AS grn_paid_total');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.sale_id', $purchase_id);
        $this->db->where('sp.sale_payment_type', 'grn');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_all_grn_for_report($srh_warehouse_id, $srh_to_date, $srh_from_date, $from = '', $to = '', $srh_supplier_id)
    {
        $this->db->select("s.*,spl.*, sp.sale_pymnt_amount, SUM(sp.sale_pymnt_amount) AS grn_total_paid");
        $this->db->from("purchases s");
        $this->db->join("sale_payments sp", "s.id = sp.sale_id AND sp.sale_payment_type ='grn'", "left");
        $this->db->join("supplier spl", "spl.supp_id = s.supplier_id", "left");
        $this->db->join("warehouses w", "w.id = s.warehouse_id", "left");
        if ($srh_warehouse_id) {
            $this->db->where("s.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_supplier_id) {
            $this->db->where("s.supplier_id", $srh_supplier_id);
        }
        if ($srh_to_date) {
            $this->db->where("s.date <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $this->db->where("s.date >=", $srh_from_date);
        }
        if ($to) {
            $this->db->limit($to, $from);
        }
        $this->db->group_by("s.id");
        $this->db->order_by("s.reference_no", "desc");
        $query = $this->db->get();
        return $query->result_array();
    }
    /*public function getReturnQtyByWarehouseId($warehouse_id, $product_id, $srh_from_date = '', $srh_to_date = '', $search_key_val = '', $cat_srh = '')
    {
        $this->db->select_sum('pi.quantity');
        $this->db->from('purchase_return_items pi');
        $this->db->join('purchases_return p', 'p.pr_id = pi.pr_id', 'left');
        $this->db->join('product pr', 'pi.product_id = pr.product_id');
        $this->db->join("product_category pc", "pr.cat_id = pc.cat_id", "left");
        if ($cat_srh) {
            $this->db->where("pc.cat_name", $cat_srh);
        }
        if ($search_key_val) {
            $this->db->where("pi.product_code LIKE '%$search_key_val%'", "left");
        }
        if ($product_id)
            $this->db->where('pi.product_id', $product_id);
        if ($srh_to_date) {
            $this->db->where("p.date <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $this->db->where("p.date >=", $srh_from_date);
        }
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $data['quantity'] = $query->row()->quantity;
        } else {
            return 0;
        }
    }*/
	
	function get_products_suggestions_for_return($term = '',$purchase_id = '')
    {
        $this->db->select('purchase_id,product_id,product_code,product_name,unit_price,quantity');
		$this->db->from('purchase_items');
        if ($term) {
            $this->db->where("product_code LIKE '%$term%'");
            $this->db->or_where("product_name LIKE '%$term%'");
        }
		if($purchase_id){
			$this->db->where('purchase_items.purchase_id', $po_id);
			}
        $this->db->limit(10, 0);
		$this->db->order_by("product_name", "asc");
        $query = $this->db->get();
        return $query->result_array();
    }
	public function get_grn_item_list_by_grn_id($grn_id)
	 {
		$this->db->select('purchase_items.*, product.*, product.product_sn_exissts, product.product_code,product.product_part_no,product.product_oem_part_number');
		$this->db->from('purchase_items');
		$this->db->join('product', 'purchase_items.product_id = product.product_id', 'left');
		$this->db->order_by("purchase_items.id", "desc");
		$this->db->where("purchase_items.purchase_id", $grn_id);//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
		
	 }
}