<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Sales_Model extends CI_Model
{
    private $tableName = 'sales';
    function __construct()
    {
        parent::__construct();
    }
    
    public function get_cus_tot_credit($cus_id)
	{
		$this->db->select_sum('s.sale_total');
		$this->db->from('sales s');
		//$this->db->join('sales s', 's.sale_id = si.sale_id', 'left');
		$this->db->where('s.customer_id',$cus_id);
		
		$query=$this->db->get();
		return $query->row()->sale_total;
	}	

function get_sale_print() {
		$this->db->select('s.sale_id');
		$this->db->from('sales s');
	
		$this->db->where("s.phone_bill_print_status",0);//("id !=",$id);
		$this->db->where("s.is_phone_bill",1);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	public function get_cus_paid_amount($cus_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
		$this->db->from('sales s');
		$this->db->join('sale_payments sp', 'sp.sale_id = s.sale_id', 'left');
		$this->db->where('s.customer_id',$cus_id);
		$this->db->where('sp.sale_payment_type','sale');
		
		$query=$this->db->get();
		//echo $this->db->last_query();
		return $query->row()->sale_pymnt_amount;
		
	}
	
	public function get_cus_return_amount($cus_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
		$this->db->from('sale_payments sp');
		//$this->db->join('sale_payments sp', 's.sale_id = s.sale_id', 'left');
		$this->db->join('sales_return sr', 'sp.sale_id = sr.sl_rtn_id', 'left');
		$this->db->where('sr.customer_id',$cus_id);
		$this->db->where('sp.sale_payment_type','sales_return');
		
		$query=$this->db->get();
		return $query->row()->sale_pymnt_amount;
	}	
	
    public function getSoldQtyByWarehouseId($warehouse_id, $product_id, $srh_from_date = '', $srh_to_date = '', $search_key_val = '', $cat_srh = '')
    {
        $this->db->select_sum('si.quantity');
        $this->db->from('sale_items si');
        $this->db->join('sales s', 's.sale_id = si.sale_id', 'left');
        $this->db->join('product p', 'si.product_id = p.product_id');
        $this->db->join("product_category pc", "p.cat_id = pc.cat_id", "left");
        if ($cat_srh) {
            $this->db->where("pc.cat_name", $cat_srh);
        }
        if ($product_id)
            $this->db->where('si.product_id', $product_id);
        if ($search_key_val) {
            $this->db->where("p.product_code LIKE '%$search_key_val%'", "left");
        }
        if ($srh_to_date) {
            $this->db->where("s.sale_datetime <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $this->db->where("s.sale_datetime >=", $srh_from_date);
        }
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $data['quantity'] = $query->row()->quantity;
        } else {
            return 0;
        }
    }
    function get_all_sales_for_view($srh_warehouse_id = '', $srh_customer_id = '')
    {
        $query = $this->db->query('SELECT sum(sale_total) FROM sales WHERE customer_id = ' . $srh_customer_id . ' AND warehouse_id = ' . $srh_warehouse_id . ' ');
        return $query->result_array();
    }
    function get_all_sales_return_for_view($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_customer_id = '')
    {
		$this->db->select('SUM(`sl_rtn_total`)');
        $this->db->from('sales_return');
        $this->db->where('customer_id', $srh_customer_id);
		//$this->db->join('sale_payments', 'sales_return.sl_rtn_id = sale_payments.sale_id', 'left');
        if ($srh_warehouse_id) {
            $this->db->where("sales_return.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_to_date) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($srh_to_date . ""));
            $this->db->where("sales_return.sl_rtn_datetime <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($srh_from_date));
            $this->db->where("sales_return.sl_rtn_datetime >=", $srh_from_date);
        }
		//$this->db->where('sale_pymnt_paying_by !=', 'Cash');
        $query  = $this->db->get();
        $result = $query->result_array();
        return $result;
		
//        $query = $this->db->query('SELECT sum(sl_rtn_total) FROM sales_return WHERE customer_id = ' . $srh_customer_id . ' AND warehouse_id = ' . $srh_warehouse_id . ' ');
//        return $query->result_array();
    }
    function getPaymentsForView($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $ss_user_id = '', $srh_customer_id = '')
    {
        $warehouse_id = '';
        $this->db->select('sum(p.sale_pymnt_amount),b.*');
        $this->db->from('sale_payments p');
        $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
        $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
        $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
        $this->db->where("p.sale_pymnt_paying_by != ", "Cheque_Return");
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by !=", $srh_payment_term);
        }
        if ($srh_customer_id) {
            $this->db->where("b.warehouse_id =" . $srh_warehouse_id . " AND b.customer_id=" . $srh_customer_id . "");
        } else if ($srh_warehouse_id) {
            $this->db->where("b.warehouse_id", $srh_warehouse_id);
        } else {
            $this->session->userdata('ss_warehouse_id');
            $warehouse_id = $this->session->userdata('ss_warehouse_id');
            $this->db->where("b.warehouse_id", $warehouse_id);
        }
        $this->db->order_by("b.sale_id", "desc");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
        }
    }
    function get_all_sales_return_for_report($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $sale_id = '', $from = '', $to = '')
    {
        $this->db->select('sr.* , c.cus_name ,SUM(p.sale_pymnt_amount) AS total_paid_amount');
        $this->db->from('sales_return sr');
        $this->db->join('customer c', 'sr.customer_id = c.cus_id', 'left');
        $this->db->join('sale_payments p', 'sr.sl_rtn_id = p.sale_id', 'left');
        $this->db->where("p.sale_payment_type", 'sales_return');
        $this->db->order_by("sr.sl_rtn_id", "desc");
        $this->db->group_by('sr.sl_rtn_id');
        if ($srh_warehouse_id) {
            $this->db->where("sr.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_to_date) {
            $this->db->where("sr.sl_rtn_datetime <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $this->db->where("sr.sl_rtn_datetime >=", $srh_from_date);
        }
        if ($to) {
            $this->db->limit($to, $from);
        }
        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_sale_info_by_customer_id($id)
    {
        $this->db->select('*');
        $this->db->from('sales');
        $this->db->where("customer_id", $id);
        $this->db->order_by("sale_id", "desc");
        $query = $this->db->get();
        return $query->result();
    }
    function getPaymentsForPrint($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '')
    {
        $this->db->select('p.*,c.cus_name,b.*,u.user_first_name');
        $this->db->from('sale_payments p');
        $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
        $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
        $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
        $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term);
        }
        if ($srh_warehouse_id) {
            $this->db->where("b.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_to_date) {
            $this->db->where("p.sale_pymnt_date_time <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $this->db->where("p.sale_pymnt_date_time >=", $srh_from_date);
        }
        $this->db->order_by("b.sale_id", "desc");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
        }
    }
	function get_cash_of_day($srh_warehouse_id = '', $srh_date = '', $srh_type = '', $srh_payment_term = '', $srh_user_id = ''){
        $this->db->select('c.cus_name,b.*,u.user_first_name');
        $this->db->select_sum('sale_pymnt_amount');
        $this->db->from('sale_payments p');
        $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
        $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
        $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
        $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term);
        }
        if ($srh_warehouse_id) {
            $this->db->where("b.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_date) {//echo $srh_date;
            $this->db->where("DATE(p.sale_pymnt_date_time)", $srh_date);
        }
		if ($srh_user_id) {
            $this->db->where("p.user_id", $srh_user_id);
        }
		
        //$this->db->order_by("b.sale_id", "desc");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
			$res = $query->result();
			//print_r($res);
            return $res[0]->sale_pymnt_amount;
        } else {
        }
    }
    function getBestSales($year = null, $month = 0, $from = 0, $to = 0)
    {
        $this->db->select('SUM(ft.fi_qty)AS fi_qty_tot,p.product_name,p.product_code,p.product_part_no,p.product_oem_part_number');
        $this->db->from('fi_table ft');
        $this->db->join('product p', 'ft.fi_item_id = p.product_id', 'left');
        $this->db->where('ft.fi_type_id', 'sale');
        if ($month) {
            $this->db->where('MONTH(ft.fi_date_time)', $month, FALSE);
        }
        if ($year) {
            $this->db->where('YEAR(ft.fi_date_time)', $year, FALSE);
        }
        if ($to) {
            $this->db->limit($to, $from);
        }
        $this->db->order_by("fi_qty_tot", "desc");
        $this->db->group_by('ft.fi_item_id');
        $query = $this->db->get();
        return $query->result();
    }
    function get_next_ref_no()
    {
        //$ss_warehouse_id=$this->session->userdata('ss_warehouse_id');
        //$this->db->where('warehouse_id', $ss_warehouse_id);
        $this->db->select_max('sale_id');
        return $this->db->get('sales');
    }
    function get_avalable_product_qty($product_id, $warehouse_id)
    {
        $this->db->select_sum('fi_qty');
        $query = $this->db->get('fi_table');
        return $query->row()->fi_qty;
    }
    function get_total_paid_by_sale_id($sale_id)
    {
        $this->db->select_sum('sale_pymnt_amount');
        $this->db->from('sale_payments');
        $this->db->where("sale_id", $sale_id)->where("(sale_payment_type='sale' OR sale_payment_type='pos_sale')");
        $query = $this->db->get();
        if ($query->row()->sale_pymnt_amount) {
            return $query->row()->sale_pymnt_amount;
        } else {
            return 0;
        }
    }
    public function get_sale_info($id)
    {
        $this->db->select('sales.*,user.user_first_name,user_group.user_group_name');
        $this->db->from('sales');
        $this->db->join('user', 'sales.user = user.user_id', 'left');
        $this->db->join('user_group', 'user_group.user_group_id = user.group_id', 'left');
        $this->db->where("sale_id", $id);
        $this->db->order_by("sale_id", "desc");
        $query = $this->db->get();
        return $query->row_array();
    }
    public function get_sale_item_list_by_sale_id($sale_id)
    {
        $this->db->select('sale_items.product_id, product.product_name, product.product_code, sale_items.quantity, sale_items.discount, sale_items.discount_val, sale_items.unit_price, sale_items.gross_total,product.product_part_no,product.product_oem_part_number,product_name_sinhala');
        $this->db->from('sale_items');
        $this->db->join('product', 'sale_items.product_id = product.product_id', 'left');
        $this->db->order_by("sale_items.id", "desc");
        $this->db->where("sale_items.sale_id", $sale_id);
        $query = $this->db->get();
        return $query->result_array();
    }
    function save_sales(&$supplier_data, $sale_id = false)
    {
        if (!$sale_id) {
            $this->db->insert($this->tableName, $supplier_data);
        } else {
            $this->db->where('sale_id', $sale_id);
            return $this->db->update($this->tableName, $supplier_data);
        }
    }
    
    
    function update_sale(&$supplier_data, $sale_id = false)
    {
        
       // print_r($supplier_data); //die();
        
        //echo "sale_id:$sale_id";
        
        if ($sale_id) {
            $this->db->where('sale_id', $sale_id);
            return $this->db->update('sales', $supplier_data);
        }
    }
    
    function save_sales_item(&$data_item)
    {
        $this->db->insert('sale_items', $data_item);
    }
    function get_all_sales_for_report($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $sale_id = '', $from = '', $to = '', $srh_customer_id = '', $srh_in_type = '')
    {
        $this->db->select('s.* , c.cus_name ,SUM(p.sale_pymnt_amount) AS total_paid_amount');
        $this->db->from('sales s');
        $this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
        $this->db->join('sale_payments p', 's.sale_id = p.sale_id', 'left');
        $this->db->order_by("s.sale_id", "desc");
        $this->db->group_by('s.sale_id');
        if ($srh_warehouse_id) {
            $this->db->where("s.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_in_type) {
            $this->db->where("s.in_type", $srh_in_type);
        }
        if ($srh_to_date) {
            $this->db->where("s.sale_datetime <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $this->db->where("s.sale_datetime >=", $srh_from_date);
        }
        if ($sale_id) {
            $this->db->where("s.sale_id =", $sale_id);
        }
        if ($srh_customer_id) {
            $this->db->where("s.customer_id", $srh_customer_id);
        }
        if ($to) {
            $this->db->limit($to, $from);
        }
        $query = $this->db->get();
        return $query->result_array();
    }
    
    function get_all_sales_grand_total($columns='')
    {
        $this->db->select('SUM(sale_total) as grand_total');
        $this->db->from('customer');
        $this->db->join('sales', 'sales.customer_id = customer.cus_id', 'left');
        $this->db->order_by("sales.sale_id", "desc");
        $this->db->where("sales.sale_id IS NOT NULL");
        //warehouse_id
        $ss_warehouse_id=$this->session->userdata('ss_warehouse_id');
        $this->db->where("sales.warehouse_id",$ss_warehouse_id);
        
		if($columns[0])$this->db->where("sales.sale_id",$columns[0]);
		if($columns[1] and $columns[2]==''){
			$srh_date = date('Y-m-d' , strtotime($columns[1]));
			$this->db->where("DATE(sales.sale_datetime)",$columns[1]);
		}
		if($columns[2]){
			$from_date = date('Y-m-d' , strtotime($columns[1]));
			$to_date = date('Y-m-d' , strtotime($columns[2]));
			$this->db->where('DATE(sales.sale_datetime) BETWEEN "' . $from_date . '" AND "' . $to_date . '"');
		}
		if($columns[3])$this->db->where("sales.sale_reference_no",$columns[3]);
		if($columns[4])$this->db->where("customer.cus_id",$columns[4]);
        $query = $this->db->get();
        //echo $this->db->last_query(); die();
        return $query->row()->grand_total;
    }
    
    function get_all_sales($start = '', $length = '', $search_key_val = '',$columns='')
    {
        $this->db->select('sales.*, customer.cus_name');
        $this->db->from('customer');
        $this->db->join('sales', 'sales.customer_id = customer.cus_id', 'left');
        $this->db->order_by("sales.sale_id", "desc");
        $this->db->where("sales.sale_id IS NOT NULL");
        if ($search_key_val) {
            $this->db->where("sales.sale_reference_no LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%' OR sales.deli_ord_no LIKE '%$search_key_val%' OR sales.sale_total LIKE '%$search_key_val%'  OR sales.cash_cus_name LIKE '%$search_key_val%' ");
        }
        
        //warehouse_id
        $ss_warehouse_id=$this->session->userdata('ss_warehouse_id');
        $this->db->where("sales.warehouse_id",$ss_warehouse_id);
        
		if($columns[0])$this->db->where("sales.sale_id",$columns[0]);
		if($columns[1] and $columns[2]==''){
			$srh_date = date('Y-m-d' , strtotime($columns[1]));
			$this->db->where("DATE(sales.sale_datetime)",$columns[1]);
		}
		if($columns[2]){
			$from_date = date('Y-m-d' , strtotime($columns[1]));
			$to_date = date('Y-m-d' , strtotime($columns[2]));
			$this->db->where('DATE(sales.sale_datetime) BETWEEN "' . $from_date . '" AND "' . $to_date . '"');
		}
		if($columns[3])$this->db->where("sales.sale_reference_no",$columns[3]);
		if($columns[4])$this->db->where("customer.cus_id",$columns[4]);
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
        }
        $query = $this->db->get();
        //echo $this->db->last_query(); die();
        return $query->result_array();
    }
    
	function get_all_sales_count($start = '', $length = '', $search_key_val = '',$columns='')
    {
        $this->db->select('COUNT(sales.sale_id) AS count_s');
        $this->db->from('customer');
        $this->db->join('sales', 'sales.customer_id = customer.cus_id', 'left');
        $this->db->order_by("sales.sale_id", "desc");
        $this->db->where("sales.sale_id IS NOT NULL");
        if ($search_key_val) {
            $this->db->where("sales.sale_reference_no LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'");
        }
		if($columns[0])$this->db->where("sales.sale_id",$columns[0]);
		
		if($columns[1] and $columns[2]==''){
			$srh_date = date('Y-m-d' , strtotime($columns[1]));
			$this->db->where("DATE(sales.sale_datetime)",$columns[1]);
		}
		if($columns[2]){
			$from_date = date('Y-m-d' , strtotime($columns[1]));
			$to_date = date('Y-m-d' , strtotime($columns[2]));
			$this->db->where('DATE(sales.sale_datetime) BETWEEN "' . $from_date . '" AND "' . $to_date . '"');
		}
			
			
		if($columns[3])$this->db->where("sales.sale_reference_no",$columns[3]);
		if($columns[4])$this->db->where("customer.cus_id",$columns[4]);
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
        }
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_all_sale_items($start = '', $length = '', $search_key_val = '')
    {
        $this->db->select('product.product_code,sales.sale_datetime,sales.sale_reference_no, customer.cus_name');
        $this->db->from('sale_items');
        $this->db->join('product', 'product.product_id = sale_items.product_id');
        $this->db->join('sales', 'sales.sale_id = sale_items.sale_id', 'left');
        $this->db->join('customer ', 'customer.cus_id = sales.customer_id');
        $this->db->order_by("sale_items.sale_id", "desc");
        if ($search_key_val) {
            $this->db->where("sales.sale_reference_no LIKE '%$search_key_val%' OR product.product_code LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'");
        }
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
        }
        $query = $this->db->get();
        return $query->result_array();
    }
    function delete_sales($sale_id)
    {
        $query = $this->db->query('DELETE FROM `sales` WHERE `sale_id` = ' . $sale_id . '');
        $query = $this->db->query('DELETE FROM `sale_items` WHERE `sale_id` = ' . $sale_id . '');
        $query = $this->db->query('DELETE FROM `sale_payments` WHERE `sale_id` = ' . $sale_id . ' AND `sale_payment_type`= "sale" ');
    }
	function delete_sale_payments($sale_id,$in_type){
		$this->db->query('DELETE FROM `sale_payments` WHERE `sale_id` = '.$sale_id.' AND `sale_payment_type` = "'.$in_type.'" ');
	}
	function sale_pymnts_delete_by_sp_id($sp_id){
		$this->db->query('DELETE FROM `sale_payments` WHERE `sale_pymnt_id` = '.$sp_id.'');
	}
	function cheque_return_by_sp_id($sp_id){
		$this->db->query('UPDATE `sale_payments` SET `sale_pymnt_paying_by`= "Cheque_Return" WHERE `sale_pymnt_cheque_no` = '.$sp_id.'');
	}	
    function get_all_sales_for_print_sales()
    {
        $this->db->select('s.* , c.cus_name ,SUM(p.sale_pymnt_amount) AS total_paid_amount');
        $this->db->from('sales s');
        $this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
        $this->db->join('sale_payments p', 's.sale_id = p.sale_id', 'left');
        $this->db->order_by("s.sale_id", "desc");
        $this->db->group_by('s.sale_id');
        $this->db->where("s.sale_id IS NOT NULL");
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_sale_payments_by_sale_id($sale_id)
    {
        $this->db->select('sale_payments.*,user.user_first_name,user_group.user_group_name');
        $this->db->from('sale_payments');
        $this->db->join('user', 'sale_payments.user_id = user.user_id', 'left');
        $this->db->join('user_group', 'user.group_id = user_group.user_group_id', 'left');
        $this->db->order_by("sale_payments.sale_pymnt_id", "desc");
        $this->db->where("sale_payments.sale_id", $sale_id);
        $this->db->where("sale_payments.sale_payment_type", 'sale');
        $query = $this->db->get();
        return $query->result();
    }
    function get_products_suggestions($term)
    {
        $this->db->select('product_id,product_code,product_name,wholesale_price,wholesale_price_2,product_price,product_price_2,product_oem_part_number,product_part_no,product_cost,credit_salling_price,product_name_sinhala');
        $this->db->order_by("product_name", "asc");
        if ($term) {
            $this->db->where("product_status = '1' AND product_code LIKE '%$term%'");
            $this->db->or_where("product_status = '1' AND product_name LIKE '%$term%'");
        }
        $this->db->limit(10, 0);
        $query = $this->db->get('product');
        return $query->result_array();
    }
    function get_all_products()
    {
        $this->db->select('product' . '.*');
        $this->db->order_by("product_name", "asc");
        $this->db->where("product_id IS NOT NULL");
        $query = $this->db->get('product');
        return $query->result_array();
    }
    function save_sale_payments(&$data, $sale_pymnt_id = false)
    {
        if (!$sale_pymnt_id) {
            return $this->db->insert('sale_payments', $data);
        } else {
            $this->db->where('supp_id', $sale_pymnt_id);
            return $this->db->update('sale_payments', $data);
        }
    }
    function get_all_sales_return_for_balance_report($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_customer_id = '')
    {
        $this->db->select('sr.* , c.cus_name,SUM(p.sale_pymnt_amount) AS total_paid_amount');
        $this->db->from('sales_return sr');
        $this->db->join('customer c', 'sr.customer_id = c.cus_id', 'left');
        $this->db->join('sale_payments p', 'sr.sl_rtn_id = p.sale_id', 'left');
        if ($srh_customer_id) {
            $this->db->where("sr.customer_id", $srh_customer_id);
        }
		$this->db->where('sale_pymnt_paying_by !=', 'Cash');
        if ($srh_warehouse_id) {
            $this->db->where("sr.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_from_date) {
            $this->db->where("sr.sl_rtn_datetime >=", $srh_from_date);
        }
        if ($srh_to_date) {
            $this->db->where("sr.sl_rtn_datetime <=", $srh_to_date);
        }
        $this->db->order_by("sr.sl_rtn_id", "desc");
        $this->db->group_by('sr.sl_rtn_id');
		$query = $this->db->get();
        return $query->result_array();
    }
    function getPaymentsForBalance($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $ss_user_id = '', $srh_customer_id = '')
    {
        $warehouse_id = '';
        $sel          = 'p.*,c.cus_name,b.*';
        if ($ss_user_id)
            $sel .= ',u.user_first_name';
        $this->db->select($sel);
        $this->db->from('sale_payments p');
		
		if ($srh_type == 'sale'){
        $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
		}
		if ($srh_type == 'sales_return')
        $this->db->join('sales_return b', 'b.sl_rtn_id = p.sale_id', 'left');

        $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
        $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
        $this->db->where('sale_pymnt_paying_by !=', 'Cheque_Return');
        if ($ss_user_id)
            $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        if ($srh_from_date) {
            $this->db->where("p.sale_pymnt_date_time >=", $srh_from_date);
        }
        if ($srh_to_date) {
            $srh_to_date = date('Y-m-d H:i:s', strtotime($srh_to_date));
            $this->db->where("p.sale_pymnt_date_time <=", $srh_to_date);
        }
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term);
        }
        if ($ss_user_id) {
            $this->db->where("p.user_id", $ss_user_id);
        }
        if ($srh_customer_id) {
            $this->db->where("b.warehouse_id =" . $srh_warehouse_id . " AND b.customer_id=" . $srh_customer_id . "");
        } else if ($srh_warehouse_id) {
            $this->db->where("b.warehouse_id", $srh_warehouse_id);
        } else {
            $this->session->userdata('ss_warehouse_id');
            $warehouse_id = $this->session->userdata('ss_warehouse_id');
            $this->db->where("b.warehouse_id", $warehouse_id);
        }
        $this->db->order_by("b.sale_id", "desc");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
        }
    }
    function get_all_sales_for_report_balance($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $sale_id = '', $from = '', $to = '', $srh_customer_id = '')
    {
        $this->db->select('s.* , c.cus_name ,SUM(p.sale_pymnt_amount) AS total_paid_amount');
        $this->db->from('sales s');
        $this->db->join('customer c', 's.customer_id = c.cus_id', 'left');
        $this->db->join('sale_payments p', 's.sale_id = p.sale_id', 'left');
        $this->db->order_by("s.sale_id", "desc");
        $this->db->group_by('s.sale_id');
        if ($srh_warehouse_id) {
            $this->db->where("s.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_from_date) {
            $this->db->where("s.sale_datetime >=", $srh_from_date);
        }
        if ($srh_to_date) {
            $this->db->where("s.sale_datetime <=", $srh_to_date);
        }
        if ($sale_id) {
            $this->db->where("s.sale_id =", $sale_id);
        }
        if ($srh_customer_id) {
            $this->db->where("s.customer_id", $srh_customer_id);
        }
        if ($to) {
            $this->db->limit($to, $from);
        }
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_all_sum_sales_for_summery_report($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $sale_id = '', $from = '', $to = '', $srh_customer_id = '')
    {
        $this->db->select('SUM(`sale_total`) AS sale_total');
        $this->db->from('sales');
        $this->db->where('sales.customer_id', $srh_customer_id);
        if ($srh_warehouse_id) {
            $this->db->where("sales.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_to_date) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($srh_to_date . ""));
            $this->db->where("sales.sale_datetime <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($srh_from_date));
            $this->db->where("sales.sale_datetime >=", $srh_from_date);
        }
        $query  = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    function get_sum_sales_return($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $sale_id = '', $from = '', $to = '', $srh_customer_id = '')
    {
        $this->db->select('SUM(`sl_rtn_total`) AS sale_return_total');
        $this->db->from('sales_return');
        $this->db->where('customer_id', $srh_customer_id);
        if ($srh_warehouse_id) {
            $this->db->where("sales_return.warehouse_id", $srh_warehouse_id);
        }
        if ($srh_to_date) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($srh_to_date ));
            $this->db->where("sales_return.sl_rtn_datetime <=", $srh_to_date);
        }
       // if ($srh_from_date) {
//            $srh_from_date = date('Y-m-d 00:00:00', strtotime($srh_from_date));
//            $this->db->where("sales_return.sl_rtn_datetime >=", $srh_from_date);
//        }
        $query  = $this->db->get();
        $result = $query->row_array();
		return $result;
    }
    function getSumPaymentsForBalanceRep($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $ss_user_id = '', $srh_customer_id = '', $return_name = '')
    {
        $warehouse_id = '';
        $sel          = 'SUM(p.sale_pymnt_amount) AS ' . $return_name . '';
        if ($ss_user_id)
            $sel .= ',u.user_first_name';
        $this->db->select($sel);
        $this->db->from('sale_payments p');
        $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
        if ($ss_user_id)
            $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        if ($srh_from_date) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($srh_from_date));
            $this->db->where("p.sale_pymnt_added_date_time >=", $srh_from_date);
        }
        if ($return_name == 'tot_sp') {
            $this->db->where('sale_pymnt_paying_by !=', 'Cheque_Return');
        }
        if ($return_name == 'unrealized_chq') {
            $srh_to_date = date('Y-m-d H:i:s', strtotime($srh_to_date . ""));
            $this->db->where("p.sale_pymnt_date_time >=", $srh_to_date);
        } else if ($srh_to_date) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($srh_to_date . ""));
            $this->db->where("p.sale_pymnt_added_date_time <=", $srh_to_date);
        }
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        if ($srh_payment_term) {
            $this->db->where("p.sale_pymnt_paying_by", $srh_payment_term);
        }
        if ($ss_user_id) {
            $this->db->where("p.user_id", $ss_user_id);
        }
        if ($srh_customer_id) {
            $this->db->where("b.warehouse_id =" . $srh_warehouse_id . " AND b.customer_id=" . $srh_customer_id . "");
        } else if ($srh_warehouse_id) {
            $this->db->where("b.warehouse_id", $srh_warehouse_id);
        } else {
            $this->session->userdata('ss_warehouse_id');
            $warehouse_id = $this->session->userdata('ss_warehouse_id');
            $this->db->where("b.warehouse_id", $warehouse_id);
        }
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
        }
    }
    function getChequeForPrint($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $ss_user_id = '')
    {
        if ($srh_type == 'grn') {
            $sel = 'p.*,b.reference_no as sale_reference_no,c.supp_company_name as cus_name, smp_amount';
            if ($ss_user_id)
                $sel .= ',u.user_first_name';
            $this->db->select($sel);
            $this->db->from('sale_payments p');
            $this->db->join('purchases b', 'b.id = p.sale_id', 'left');
            $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
            $this->db->join('supplier c', 'c.supp_id = b.supplier_id', 'left');
            $this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
            $this->db->where("p.sale_pymnt_paying_by", 'Cheque');
            if ($ss_user_id)
                $this->db->join('user u', 'u.user_id = p.user_id', 'left');
            $this->db->where("p.sale_payment_type", $srh_type);
            if ($srh_payment_term) {
            }
            if ($ss_user_id) {
                $this->db->where("p.user_id", $ss_user_id);
            }
            if ($srh_warehouse_id) {
            }
            if ($srh_to_date) {
                $this->db->where("date(p.sale_pymnt_added_date_time) <=", $srh_to_date);
            }
            if ($srh_from_date) {
                $this->db->where("date(p.sale_pymnt_added_date_time) >=", $srh_from_date);
            }
            $this->db->order_by("p.sale_pymnt_id", "desc");
            $this->db->group_by("p.sale_pymnt_cheque_no");
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
            }
        } else {
            $sel = 'p.*,c.cus_name,b.*,smp_amount';
            if ($ss_user_id)
                $sel .= ',u.user_first_name';
            $this->db->select($sel);
            $this->db->from('sale_payments p');
            $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
            $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
            $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
            $this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
            $this->db->where("p.sale_pymnt_paying_by", 'Cheque');
            if ($ss_user_id)
                $this->db->join('user u', 'u.user_id = p.user_id', 'left');
            if ($srh_type)
                $this->db->where("p.sale_payment_type", $srh_type);
            if ($srh_payment_term) {
            }
            if ($ss_user_id) {
                $this->db->where("p.user_id", $ss_user_id);
            }
            if ($srh_warehouse_id) {
            }
            if ($srh_to_date) {
                $this->db->where("date(p.sale_pymnt_added_date_time) <=", $srh_to_date);
            }
            if ($srh_from_date) {
                $this->db->where("date(p.sale_pymnt_added_date_time) >=", $srh_from_date);
            }
            $this->db->order_by("p.sale_pymnt_id", "desc");
            $this->db->group_by("p.sale_pymnt_cheque_no");
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
            }
        }
    }
    function getUnrealizedChequeForPrint($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $ss_user_id = '')
    {
        if ($srh_type == 'grn') {
            $sel = 'p.*,b.reference_no as sale_reference_no,c.supp_company_name as cus_name, smp_amount';
            if ($ss_user_id)
                $sel .= ',u.user_first_name';
            $this->db->select($sel);
            $this->db->from('sale_payments p');
            $this->db->join('purchases b', 'b.id = p.sale_id', 'left');
            $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
            $this->db->join('supplier c', 'c.supp_id = b.supplier_id', 'left');
			$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
            $this->db->where("p.sale_pymnt_paying_by", 'Cheque');
            if ($ss_user_id)
                $this->db->join('user u', 'u.user_id = p.user_id', 'left');
            $this->db->where("p.sale_payment_type", $srh_type);
            if ($srh_payment_term) {
            }
            if ($ss_user_id) {
                $this->db->where("p.user_id", $ss_user_id);
            }
            if ($srh_from_date) {
                $srh_from_date = date('Y-m-d', strtotime($srh_from_date . ""));
                $this->db->where("p.sale_pymnt_cheque_date >=", $srh_from_date);
            }
            $this->db->order_by("p.sale_pymnt_id", "desc");
			$this->db->group_by("p.sale_pymnt_cheque_no");
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
            }
        } else {
            $sel = 'p.*,c.cus_name,b.*, smp_amount';
            if ($ss_user_id)
                $sel .= ',u.user_first_name';
            $this->db->select($sel);
            $this->db->from('sale_payments p');
            $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
            $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
            $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
			$this->db->join('sale_multiple_payment smp', 'smp.smp_id = p.smp_id', 'left');
            $this->db->where("p.sale_pymnt_paying_by", 'Cheque');
            if ($ss_user_id)
                $this->db->join('user u', 'u.user_id = p.user_id', 'left');
            if ($srh_type) {
                $this->db->where("p.sale_payment_type", $srh_type);
            }
            if ($srh_payment_term) {
            }
            if ($ss_user_id) {
                $this->db->where("p.user_id", $ss_user_id);
            }
            if ($srh_warehouse_id) {

            }
            if ($srh_from_date) {//echo $srh_from_date;
                $srh_from_date = date('Y-m-d', strtotime($srh_from_date . ""));
                $this->db->where("date(p.sale_pymnt_cheque_date) >=", $srh_from_date);
            }
            $this->db->order_by("p.sale_pymnt_id", "desc");
			$this->db->group_by("p.sale_pymnt_cheque_no");
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
            }
        }
    }
    function getRetChequeForPrint($srh_warehouse_id = '', $srh_to_date = '', $srh_from_date = '', $srh_type = '', $srh_payment_term = '', $ss_user_id = '')
    {
        $sel = 'p.*,c.cus_name,b.*';
        if ($ss_user_id)
            $sel .= ',u.user_first_name';
        $this->db->select($sel);
        $this->db->from('sale_payments p');
        $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
        $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
        $this->db->join('customer c', 'c.cus_id = b.customer_id', 'left');
        $this->db->where("p.sale_pymnt_paying_by", 'Cheque_Return');
        if ($ss_user_id)
            $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        if ($srh_type) {
            $this->db->where("p.sale_payment_type", $srh_type);
        }
        if ($srh_payment_term) {
        }
        if ($ss_user_id) {
            $this->db->where("p.user_id", $ss_user_id);
        }
        if ($srh_warehouse_id) {
        }
        if ($srh_to_date) {
            $srh_to_date = date('Y-m-d', strtotime($srh_to_date . ""));
            $this->db->where("p.sale_pymnt_added_date_time <=", $srh_to_date);
        }
        if ($srh_from_date) {
            $this->db->where("p.sale_pymnt_added_date_time >=", $srh_from_date);
        }
        $this->db->order_by("p.sale_pymnt_id", "desc");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
        }
    }
}