<?php
 
class Common_Model extends CI_Model {
  
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  
  
  public function get_order_items($order_cus_id = ""){
      $this->db->select("oci.*,p.product_name,p.product_id");
     $this->db->from("order_customer_item oci");
	 $this->db->join('product p','oci.product_id = p.product_id','left');
     $this->db->where("oci.order_cus_id",$order_cus_id);
	 
     $query = $this->db->get();  
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
  }
  
   function getPendingOrderNotification(){
		$this->db->select('oc.*');
		//$this->db->from('sales s');
		//$this->db->join('sale_payments sp', 's.sale_id = sp.sale_id', 'left');
		$this->db->from('order_customer oc');
		//$this->db->join('sales s', 's.sale_id = sp.sale_id', 'left');
		//$this->db->join('warehouses w', 's.warehouse_id = w.id', 'left');
		
		//$this->db->where("r.po_prepared_status",'0');
		$this->db->where("oc.order_status","1");
		//$this->db->where("s.is_approve_requerd","1");
	//	$this->db->order_by("sp.sale_pymnt_id", "desc");
		$query = $this->db->get();
		return $query->result();
  } 
  
  function get_all_country() {
		$this->db->select('country_id, country_short_name');
		$this->db->order_by("country_short_name", "asc");
		$this->db->where("country_status", "1");
		$query = $this->db->get('mstr_country');
		return $query->result_array();
  }
  
  
    function getGTNNotification(){
		$this->db->select('p.*,w.*');
		$this->db->from('transfer p');
		$this->db->join('warehouses w', 'w.id = p.trnsfr_from_warehouse_id', 'left');
		$this->db->order_by("p.trnsfr_id", "desc");
		//$this->db->where("r.po_prepared_status",'0');
		$this->db->where("reviewed_status = ''");
		$query = $this->db->get();
		return $query->result();
  } 
  
   	public function get_trnsfr_item_list_by_trnsfr_id($trnsfr_id)
	 {
		$this->db->select('transfer_item.trnsfr_itm_id,transfer_item.trnsfr_itm_unit_price,transfer_item.product_id, product.product_name, product.product_code, transfer_item.trnsfr_itm_quantity, product.product_part_no,product.product_oem_part_number');
		$this->db->from('transfer_item');
		$this->db->join('product', 'transfer_item.product_id = product.product_id', 'left');
		$this->db->order_by("transfer_item.trnsfr_itm_id", "desc");
		$this->db->where("transfer_item.trnsfr_id", $trnsfr_id);//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
		
	 }
	 
  public function get_warehouse_info($id)
	 {
		$this->db->select('*');
		$this->db->from('warehouses');
		$this->db->where("id", $id);
		$this->db->order_by("id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
  
  function get_all_status() {
		$this->db->select('mstr_status.*');
		$this->db->order_by("status_order", "desc");
		$this->db->where("status_staus", "1");
		$query = $this->db->get('mstr_status');
		return $query->result_array();
  }
  
  function get_all_cr_limit() {
		$this->db->select('cr_limit_id, cr_limit_name');
		$this->db->order_by("cr_limit_status", "asc");
		$this->db->where("cr_limit_status", "1");
		$query = $this->db->get('mstr_cr_limit');
		return $query->result();
  }
  
  public function get_country_name_by_id($country_id) {
		$this->db->select('country_short_name');
		$this->db->order_by("country_short_name", "asc");
		$this->db->where("country_id", $country_id);
		$query = $this->db->get('mstr_country');
		return $query->result_array();
   }
   
  public function get_city_list_by_country_id($country_id) {
		$this->db->select('cname,cid');
		$this->db->order_by("cname", "asc");
		$this->db->where("country_id", $country_id);
		$query = $this->db->get('mstr_city');
		//echo $this->db->last_query();
		return $query->result();
   }
   
   public function gen_ref_number($column_name,$table_name,$type_code)
   {
	$this->db->select_max($column_name);
	$query = $this->db->get($table_name);
     if($query->num_rows() >0)
     {
       $g = $query->result();
       $u = $this->set_ref_no($g[0]->$column_name,$type_code);
       return $u;
     }
     else
     {
       return false;
     }
   }

   function set_ref_no($f,$t)
   {
	  $w='';
   	 $d = date('Y/m/');
	 if($t){
		$w=$t;
	 }
   	 $w =$w.sprintf("%04d",$f+1);
   	 return $w;
   }

   public function add_fi_table($type,$ref_id,$product,$quantity,$unit_cost)
   {
    $data = array(
       'fi_type_id'  => $type,
       'fi_ref_id'   => $ref_id,
       'fi_item_id'  => $product,
       'fi_qty'      => $quantity,
       'fi_cost'     => $unit_cost
    );

    if($this->db->insert('fi_table', $data)){
      return $this->db->insert_id();
    }else{
      return false;
    }

   }
   
   //User Activitie
   public function add_user_activitie($details)
   {
    $data = array(
       'details'   => $details,
	    'page'  => base_url(uri_string()),
       'user_id'  =>  $this->session->userdata('ss_user_id'),
       'warehouse_id'  => $this->session->userdata('ss_warehouse_id'),
       'datetime'     => date("Y-m-d H:i:s"),
	   'ip'     => $this->input->ip_address()
    );

    if($this->db->insert('logs', $data)){
      return $this->db->insert_id();
    }else{
      return false;
    }

   }
   
	public function is_avalable_for_use_this_link_for_user($group_id ,$page)
	 {
		$this->db->select('usrgp_permission_page,usrgp_permission_view,usrgp_permission_add,usrgp_permission_edit,usrgp_permission_delete');
		$this->db->from('user_group_permission');
		//$array = array('user_group_id' => $group_id, 'usrgp_permission_page' => $page);
		$array = array('user_group_id' => $group_id);
		$this->db->where($array); 
		$this->db->order_by("user_group_id", "desc");
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result_array(); 
	 }
	 
	   public function check_option_valable_by_setting_id($sett_id) {
		  // echo "sett_id:$sett_id";
		$this->db->select('s.sett_status');
		$this->db->from('settings s');
		$this->db->where("s.sett_id", $sett_id);
		//$this->db->where('sis.pis_number',$pis_number);
		//$query = $this->db->get('s.sett_status');
		$query = $this->db->get();
		$rtn_des=$query->result();
		//echo $this->db->last_query();
		return ($rtn_des[0]->sett_status);
   }
   
   
    public function send_sms($message,$send_phone) {
     // echo "send_phone:$send_phone";
		//$message="SmartFix Service Center \nInv no : $service_reference_no \nStatus : Done \nAmount = $service_charge \nYour Job has been ready to Collect - 0112851615";
				//$message="SmartFixServiceCenter Sanath";
				//$myStr=123456789;
				//$send_phone = substr($send_phone_first, 0, 10);	
				$sms_api=$this->check_option_valable_by_setting_id(2);	
			
				$url = 'https://cpsolutions.dialog.lk/index.php/cbs/sms/send';
				$fields = array(
				'destination'      => "$send_phone",
				'q'      => "$sms_api",
				'message'    => "$message \nhttp://facebook.com/smartphonelk",
				 //'from'      => '0714617138'
				);
				$result=1;
				if($send_phone){
					$ch = curl_init();
					//set the url, number of POST vars, POST data
					curl_setopt($ch, CURLOPT_URL, $url);
					curl_setopt($ch, CURLOPT_POST, count($fields));
					curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
					//execute post
					ob_start();
					$result =curl_exec($ch);
					ob_end_clean();
					//close connection
					curl_close($ch);
				}
				return $result;
   }
   
   
	public function get_next_warehouse_ref_no($warehouse_id,$warehouse_column,$warehouse_last_id_column,$table){
		$this->db->select_max($warehouse_last_id_column);
		$this->db->where($warehouse_column, $warehouse_id);
		$query = $this->db->get($table);
		if($query->num_rows() >0){
			$g = $query->result();
			$u = $g[0]->$warehouse_last_id_column;
			return $u;
		}
		else{
			return false;
		}
	}

}