<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports extends CI_Controller {

    var $main_menu_name = "reports";
	var $sub_menu_name = "suppliers";

	public function __construct()
	{
		parent::__construct();

		
		$this->load->model('Common_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Transfer_Model');
		$this->load->model('Sales_Model');
		$this->load->model('Purchases_Model');
		
		$this->load->model('Product_Damage_Model');
		$this->load->model('Sales_Return_Model');
		$this->load->model('Sequerty_Model');
		$this->load->model('Product_Models');
		$this->load->model('Customer_Model');
		$this->load->model('User_Model');
		$this->load->model('Product_Models');
		$this->load->model('Expenses_Model');
		$this->load->model('Report_Model');
		$this->load->model('category_models');
		
	}
	
	public function index()
	{
		$this->load->model('Supplier_Model');
		$data['suppliers'] = $this->Supplier_Model->get_all_supplier();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$this->load->view('rep_reports',$data);
	}



	public function transfer_items() {
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'transfer_items';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['rep_list'] = $this->User_Model->getUserstypeByID(5);
		$data['category_list'] 	= $this->category_models->getCategory();
		$this->load->view('transfer_items', $data);
		//  else
		//  show_404();
	}	
	
	   public function list_transfer_items() {
        $requestData = $this->input->post();
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');
		$srh_from_date = $this->input->post('srh_from_date');
        $srh_to_date = $this->input->post('srh_to_date');
		$srh_warehouse_id = $this->input->post('srh_warehouse_id');
		$srh_sales_rep_id = $this->input->post('srh_sales_rep_id');
		$category = $this->input->post('category');
		
		//get all sales

        $data = array();
        $sales_tot = $this->Report_Model->get_all_transfer('','',$search_key_val,$srh_from_date,$srh_to_date,$srh_warehouse_id,$srh_sales_rep_id,'item_count');
		$sales = $this->Report_Model->get_all_transfer($start,$length,$search_key_val,$srh_from_date,$srh_to_date,$srh_warehouse_id,$srh_sales_rep_id);
	
		$totalData = ($sales_tot);
		$totalFiltered = $totalData;  
		
        //print_r($sales);
        foreach ($sales as $row) {
			
            $nestedData = array();
            $trnsfr_id=$row['trnsfr_id'];
            $nestedData[] = site_date($row['trnsfr_datetime']);
            $nestedData[] = "<center>" . $row['trnsfr_reference_no'] . "</center>";
			//get to warehouse name
			 $ware_house_des=$this->Warehouse_Model->get_warehouse_info($row['trnsfr_to_warehouse_id']);
            $nestedData[] = $ware_house_des['name'];//$row['cus_name'];
            $nestedData[] = $row['trnsfr_total'];
			$nestedData[] = '';//"<left>" . $row['product_name'] . "</left>";
            $actionTxtDisble = '';
            $actionTxtEnable = '';
            $actionTxtUpdate = '';
            $actionTxtDelete = '';
            $nestedData[] = ''; 
			 $nestedData[] = ''; 
			 $nestedData[] ='';
			
            $data[] = $nestedData;
			
			
			//get sale items by sale id
			//$sale_items = $this->Sales_Model->get_all_sale_items('', '', '',$sale_id,$category);
			$trnsfr_item_list= $this->Transfer_Model->get_trnsfr_item_list_by_trnsfr_id($trnsfr_id);
			foreach ($trnsfr_item_list as $sale_items_row) {
				//print_r($sale_items_row);
				$no_of_items=0;
				$trnsfr_itm_id=$sale_items_row['trnsfr_itm_id'];
				$saleItemData = array();
				$saleItemData[] ='';
				$saleItemData[] ='';
				$saleItemData[] ='';
				$saleItemData[] ='';
				$qty=$sale_items_row['trnsfr_itm_quantity'];
				//get returned qty by sale_id and product id
				//$returned_qty_des=$this->Sales_Model->get_returned_qty_by_sale_id_and_product_id($sale_id,$sale_items_row['product_id']);
				$sale_sn_list='';
				//$sale_sn_list="<br/> $sale_id , $sale_item_id";
				// $sn_list=$this->Sales_Model->get_sales_serial_by_id($sale_id,$sale_item_id);
				$sn_list=$this->Transfer_Model->get_transfer_serial_by_id($trnsfr_id,$trnsfr_itm_id);
				if(!empty($sn_list)){
				//echo "<br/> Serial No. ";
				foreach ($sn_list as $sn) { 
				$sale_sn_list.=" $sn->tis_number , ";
				
				}
				}
				
				if($sale_sn_list) $sale_sn_list="<br/> Emei: ".$sale_sn_list;
				
				
				//print_r($returned_qty_des);
				$returned_qty=0;
				$returned_dis_text='';
				$balance_qty=0;
				//$returned_qty=intval($returned_qty_des->quantity);
				//if($returned_qty){
				//	$returned_dis_text="  <span class='label label-danger'>$returned_qty Item(s) Returned</span>";
				//}
				
				$balance_qty=$sale_items_row['trnsfr_itm_quantity']-$returned_qty;
				
				$no_of_items=$no_of_items+$balance_qty;
				
				$cal_class_1='';
				$cal_class_2='';
				//if($sale_items_row['cat_id']==3)
				{
					$cal_class_1="";//"<span class='label label-success'>";
					$cal_class_2="";//"</span>";
				}
				$saleItemData[] ="<left>$cal_class_1".$sale_items_row['product_name'].' ('. $sale_items_row['product_code'].") X ($qty) $cal_class_1 $returned_dis_text $sale_sn_list</left>";
				if($this->session->userdata('ss_group_id')==1){
				$saleItemData[] ='';//number_format($balance_qty*$sale_items_row['item_cost'], 2, '.', '');
				}else{
					$saleItemData[] ='';
				}
				$val_tmp=1;
				$qty_tmp=$qty;
				if($qty==0.00)
				{
				    
				    $qty_tmp=1;
				}
				
				if(!empty($qty)){
				$val_tmp=($sale_items_row['trnsfr_itm_unit_price']/$qty_tmp);//*$balance_qty;
				}
				$saleItemData[] =number_format($val_tmp, 2, '.', '');
				$saleItemData[] =$no_of_items;
				//	
				$data[] = $saleItemData;			
			}
			

			
			
        }

        $json_data = array(
           // "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

	
	
public function get_list_payments_for_report()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$srh_type='sale';
		 $values = $this->Sales_Model->getPaymentsForPrint($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		 
		// echo $this->db->last_query();
		 
		
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
	        if (!empty($values)) {
	            foreach ($values as $users) {
					$invoice_no='';
					$display=false;
					if($users->sale_payment_type=='sale'){
						$invoice_no=$users->sale_reference_no;
						$display=true;
					}else if($users->sale_payment_type=='sales_return'){
						//get sales return ref no
						$sales_return_des=$this->Sales_Return_Model->get_sale_return_info($users->sale_id);
						$invoice_no=$sales_return_des['sl_rtn_reference_no'];
						$warehouse_id_sales_rtn=$sales_return_des['warehouse_id'];
						if($warehouse_id_sales_rtn==$srh_warehouse_id){
							$display=true;
						}else {
							$display=false;
						}
					}
					
					if($display){
					
	            $row = array();
					$bkng_id=$users->sale_id;
					$paymnt_id=$users->sale_pymnt_id;
					  $row[] = sprintf("%04d", $users->sale_pymnt_id);
					  $row[] = ($users->sale_pymnt_date_time);
					   $row[] = $invoice_no;
					  
					   
					// checked="checked"
					$pymnt_collected='';
					$checked_status='';
					if($pymnt_collected==1) {
						$checked_status='checked=\"checked\"';
					}else {
						$checked_status='';
					}
					/*
					  $row[] = "<label class=\"checkbox-inline\">
										<input id=\"collected_$paymnt_id\" type=\"checkbox\" class=\"flat-red\" value=\"$paymnt_id\" onchange=\"changeColectedStatus($paymnt_id,this.checked)\" $checked_status>
										Collected
									</label>";	
									
							
									
*/
						$returned_text='';
						if($users->sale_pymnt_cheque_rtn_status==1)
						{
							$returned_text='Returned';
						}
						$sale_pymnt_amount=$users->sale_pymnt_amount;
						$credit_card_interest_rate=0.03;//3%
						$credit_card_interest=0;
						if($users->sale_pymnt_paying_by=='Credit Card'){
							if($users->extra_val_1){
								$credit_card_interest=$sale_pymnt_amount*$credit_card_interest_rate;
							}
						}
						
						 $row[] =  $users->cus_name;
						 $row[] =  $users->sale_payment_type;
						 $row[] =  $users->sale_pymnt_paying_by;
						  $row[] = number_format($users->sale_pymnt_amount, 2, '.', '');
						   $row[] = number_format($credit_card_interest, 2, '.', '');
						    $row[] = $users->sale_pymnt_amount;	
							 $row[] = $returned_text;	
                      		$paid=0;
							//$paid=$this->Booking_Model->get_total_paid_by_booking_id($bkng_id);
						//$row[] =number_format($paid, 2, '.', ',');
						
							//$row[] =number_format($users->bkng_tot_amount-$paid, 2, '.', ',');
				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;
	
	                $data[] = $row;
					}
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}
	public function print_product_code_popup()
	{
		$data['main_menu_name'] = 'reports';
		$cat_srh=$this->uri->segment(3);
		$sub_cat_srh=$this->uri->segment(4);
		$data['product_list'] = $this->Product_Models->getProductsProduCodePrint($cat_srh,$sub_cat_srh);
		$this->load->view('models/print_product_code_popup',$data);
		
	}
	
		public function print_product_barcode_list_popup()
	{
		$data['main_menu_name'] = 'reports';
		$cat_srh=$this->uri->segment(3);
		$sub_cat_srh=$this->uri->segment(4);
		$data['product_list'] = $this->Product_Models->getProductsProduCodePrint($cat_srh,$sub_cat_srh);
		$this->load->view('models/print_product_barcode_list_popup.php',$data);
		
	}
	
	public function print_product_code_list_popup()
	{
		$data['main_menu_name'] = 'reports';
		$cat_srh=$this->uri->segment(3);
		$sub_cat_srh=$this->uri->segment(4);
		$data['product_list'] = $this->Product_Models->getProductsProduCodePrint($cat_srh,$sub_cat_srh);
		$this->load->view('models/print_product_code_list_popup',$data);
		
	}
	
	public function print_product_code()
	{
		$this->load->model('category_models');
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'print_product_code';
		
		$cat_srh=$this->input->post('cat_srh');
		$sub_cat_srh=$this->input->post('cat_srh');
		
		
		$data['category_list'] 	= $this->category_models->getCategory();
		// $data['sub_category_list']   = $this->category_models->getSubCategory(1);
		
		$this->load->view('rep_product_code_print',$data);
		
		
			
	}
	
	public function get_list_product_for_code_print($value='')
	{
		$cat_srh=$this->input->post('cat_srh');
		$sub_cat_srh=$this->input->post('sub_cat_srh');
		
			$this->load->model('Product_Models');
	        $values = $this->Product_Models->getProductsProduCodePrint($cat_srh,$sub_cat_srh);
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $products) {

	            if ($products->product_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
				$retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;

	            $row = array();
				
				
				 $row = array();
				
				 
                  $row[] = $products->product_code;
	                $row[] = $products->product_name;
					 $row[] = $products->cat_name;//. " ($products->supp_code)";
					  $row[] = $products->sub_cat_name;
					  
					
	                //$row[] = $transferd_qty;
	                $data[] = $row;
	            }

	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	}
	
	public function user_activitie(){
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'user_activitie';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$this->load->view('rep_user_activitie',$data);
	}

	public function sale_interest(){
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'user_activitie';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$this->load->view('rep_sale_interest',$data);
	}

	
	public function get_list_user_activitie_for_print($value='')
	{
		$this->load->model('User_Model');
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d H:i:s', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d H:i:s', strtotime($this->input->post('srh_from_date')));
		}
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'id', 
		1 => 'id',
		2=> 'id',
		3 =>'id', 
		4 => 'id',
	
	);
	$data = array();
	$grn_data = $this->User_Model->get_all_user_activitie_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date);
	$totalData = count($grn_data);
	$totalFiltered = $totalData;  
	
	foreach ($grn_data as $row){
		$nestedData=array(); 
		$id=$row['id'];
		$nestedData[] =$row['id'];
		$nestedData[] =$row['details'];
		/*$nestedData[]=$row['page'];*/ 
		$nestedData[] = $row['user_first_name'];
		$nestedData[] =display_date_time_format($row['datetime']);

	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}



	
	public function get_list_sale_interest($value='')
	{
		//$this->load->model('User_Model');
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		//$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'id', 
		1 => 'id',
		2=> 'id',
		3 =>'id', 
		4 => 'id',
	);
	$data = array();
	$grn_data = $this->Sales_Model->get_list_sale_interest($srh_warehouse_id,$srh_to_date,$srh_from_date);
	$totalData = count($grn_data);
	$totalFiltered = $totalData;  
	foreach ($grn_data as $row){
		$nestedData=array(); 
		$id=$row['si_id'];
		$nestedData[] =$row['si_id'];
		$nestedData[] =$row['sale_reference_no'];
		$nestedData[] =$row['si_amount'];
		/*$nestedData[]=$row['page'];*/ 
		$nestedData[] = $row['si_remark'];
		$nestedData[] =display_date_time_format($row['si_added']);

	$data[] = $nestedData;
	}
	
	$grn_data = $this->Sales_Model->get_list_sale_current_interest($srh_warehouse_id,$srh_to_date,$srh_from_date);
	$totalData = count($grn_data)+$totalData;
	$totalFiltered = $totalData;  
	foreach ($grn_data as $row){
		$nestedData=array(); 
		$id='';//$row['si_id'];
		$nestedData[] ='';
		$nestedData[] =$row['sale_reference_no'];
		$nestedData[] =$row['current_interest'];
		/*$nestedData[]=$row['page'];*/ 
		$nestedData[] = $row['current_interest_remark'];
		$nestedData[] =display_date_time_format($row['current_interest_date']);

	$data[] = $nestedData;
	}
	
	

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
		
	public function grn()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'grn';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['supplier_list'] = $this->Purchases_Model->get_supplier();
		$this->load->view('rep_grn',$data);
	}
	
	public function get_list_grn_for_print($value='')
	{
		$this->load->model('Purchases_Model');
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_supplier_id=$this->input->post('srh_supplier_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	$data = array();
	$grn_data = $this->Purchases_Model->get_all_grn_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','',$srh_supplier_id);
	$totalData = count($grn_data);
	$totalFiltered = $totalData;  
	
	foreach ($grn_data as $row){
		
		
		$p_status='';
		$total_paid_amount=$row['grn_total_paid'];
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		  $p_status='Pending';
		}else{
		  if ($total_paid_amount >= $row['grand_total']) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		$nestedData=array(); 
		$id=$row['id'];
		$nestedData[] =display_date_time_format($row['date']);
		$nestedData[] = $row['reference_no'];
		$nestedData[] = $row['supp_company_name'];	
		$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['grand_total'], 2, '.', '');
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['grand_total']-$total_paid_amount, 2, '.', '');
		$data[] = $nestedData;
		}}
		else {
			$nestedData=array(); 
		$id=$row['id'];
		$nestedData[] =display_date_time_format($row['date']);
		$nestedData[] = $row['reference_no'];
		$nestedData[] = $row['supp_company_name'];	
		$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['grand_total'], 2, '.', '');
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['grand_total']-$total_paid_amount, 2, '.', '');
		$data[] = $nestedData;
		}
		
		
		
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	

	public function print_grn()
	{
		
		$this->load->model('Purchases_Model');
		$this->load->model('Supplier_Model');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->get('srh_warehouse_id');
		$srh_supplier_id=$this->input->get('srh_supplier_id');
		$srh_payment_status=$this->input->get('srh_payment_status');
		$data['srh_payment_status']=$srh_payment_status;
		//echo "$srh_warehouse_id";
		if($this->input->get('srh_to_date')){
			$srh_to_date=date('Y-m-d H:i:s', strtotime($this->input->get('srh_to_date')));
		}
		if($this->input->get('srh_from_date')){
			$srh_from_date=date('Y-m-d H:i:s', strtotime($this->input->get('srh_from_date')));
		}
		$this->load->model('Sales_Model');
		//$data['sales_list'] = $this->Sales_Model->get_all_sales_for_print_sales();
		$data['grn_list'] = $this->Purchases_Model->get_all_grn_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','',$srh_supplier_id);
		
		$srh_supplier_name='';
		
		if($srh_warehouse_id){
			$warehouse_details=$this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
			$data['warehouse_details']=$warehouse_details;
			$data['srh_warehouse_name']=$warehouse_details['name'];
		}else {
			$data['srh_warehouse_name']="-All-";
		}
		if($srh_supplier_id){
			$supplier_details=$this->Supplier_Model->get_supplier_info($srh_supplier_id);
			
			$srh_supplier_name=$supplier_details['supp_company_name'];
		}
		$data['srh_supplier_name']=$srh_supplier_name;
		if($srh_to_date){
			$data['srh_to_date_dis']=display_date_time_format($srh_to_date);
		}else {
			$data['srh_to_date_dis']='';	
		}
		if($srh_from_date){
			$data['srh_from_date_dis']=display_date_time_format($srh_from_date);
		}else {
			$data['srh_from_date_dis']='';	
		}
		
		
		
		$this->load->view('models/print_grn',$data);
	}
	

	public function daily_sales()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'daily_sales';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['rep_list'] = $this->User_Model->getUserstypeByID(5);
		$this->load->view('rep_sales_daily',$data);
	}	

	public function sales()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = $this->Customer_Model->get_all_customers();
		$this->load->view('rep_sales',$data);
	}


	public function sales_rep()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales_rep';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = array();//$this->Customer_Model->get_all_customers();
		//$data['rep_list'] = $this->User_Model->getUserstypeByID(2);
		$data['rep_list'] = $this->User_Model->getSalesRep();
		//print_r($data['rep_list']);
		
		$this->load->view('rep_sales_rep',$data);
	}
	
	public function sales_rep_comm()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales_rep_comm';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = $this->Customer_Model->get_all_customers();
		$data['rep_list'] = $this->User_Model->getUserstypeByID(4);
		//print_r($data['rep_list']);
		
		$this->load->view('rep_sales_rep_comm',$data);
	}
		
	public function print_sale()
	{
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->get('srh_warehouse_id');
		$srh_customer_id=$this->input->get('srh_customer_id');
		//echo "cus id:".$srh_customer_id;
		$srh_payment_status=$this->input->get('srh_payment_status');  
		$data['srh_payment_status']=$srh_payment_status;
		if($this->input->get('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->get('srh_to_date')));
		}
		if($this->input->get('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->get('srh_from_date')));
		}
		$this->load->model('Sales_Model');
		//$data['sales_list'] = $this->Sales_Model->get_all_sales_for_print_sales();
		$data['sales_list'] = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id);
		
		
		
		$srh_customer_name='';
		
		if($srh_customer_id){
			$customer_details=$this->Customer_Model->get_customer_info($srh_customer_id);
			//$data['customer_details']=$customer_details;
			$data['srh_customer_name']=$customer_details['cus_name'];
		}else {
			$data['srh_customer_name']="-All-";
		}
		
		if($srh_warehouse_id){
			$warehouse_details=$this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
			$data['srh_warehouse_name']=$warehouse_details['name'];
			$data['warehouse_details']=$warehouse_details;
		}else {
			$data['srh_warehouse_name']="-All-";
		}
		if($srh_to_date){
			$data['srh_to_date_dis']=($srh_to_date);
		}else {
			$data['srh_to_date_dis']='';	
		}
		if($srh_from_date){
			$data['srh_from_date_dis']=($srh_from_date);
		}else {
			$data['srh_from_date_dis']='';	
		}
		
		$this->load->view('models/print_sale',$data);
	}
	
	public function suppliers()
	{
		$this->load->model('Supplier_Model');
		$data['suppliers'] = $this->Supplier_Model->get_all_supplier();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$this->load->view('rep_suppliers',$data);
	}
	
	public function print_supplier()
	{
		$this->load->model('Supplier_Model');
		$data['suppliers_list'] = $this->Supplier_Model->get_all_supplier();

		$this->load->view('models/print_supplier',$data);
	}
	
	public function products()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = '';//$this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products';
		$data['category_list'] 	= $this->category_models->getCategory();
		$this->load->view('rep_products',$data);
	}
	
	public function products_quantity()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = $this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'products_quantity';
		$data['category_list'] 	= $this->category_models->getCategory();
		$this->load->view('rep_products_quantity',$data);
	}
	
	public function supplier_products()
	{
		$this->load->model('Product_Models');
		$this->load->model('purchases_model');
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = $this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'supplier_products';
		$data['supplier_list']=$this->purchases_model->get_supplier();
		
		$this->load->view('rep_supplier_products',$data);
	}
	
	public function alert_quantity()
	{
		$this->load->model('Product_Models');
		$this->load->model('category_models');
		$data['category_list'] 	= $this->category_models->getCategory();
		
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['product_list'] = $this->Product_Models->getProducts();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'alert_quantity';
		$this->load->view('rep_alert_quantity',$data);
	}
	
	public function print_products()
	{
		$this->load->model('Product_Models');
		
		$data['product_list'] = $this->Product_Models->getProducts();
		$this->load->view('models/print_products',$data);
	}
	
	public function print_alert_quantity()
	{
		$this->load->model('Product_Models');
		
		$data['product_list'] = $this->Product_Models->getProducts();
		$this->load->view('models/print_alert_quantity',$data);
	}

	public function get_list_sales_for_print($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_sales_rep_id=$this->input->post('srh_sales_rep_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		if($this->input->post('srh_to_date')){
			$srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
			//$srh_to_date=date('Y-m-d', strtotime($srh_to_date);
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id,$srh_sales_rep_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$p_status='';
		$pay_st ='';
		$sale_id=$row['sale_id'];
		$total_paid_amount=0;
		$total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		//$total_paid_amount=$row['total_paid_amount']; 
		
		$return_tot_amt=0;
		$return_tot_amt=$this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $row['cus_name'];
		$nestedData[] = $rep_name;
		$nestedData[] =number_format($row['sale_inv_rc'], 2, '.', '');
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		   $p_status='Pending';
		}else{
		  if ($total_paid_amount >= ($row['sale_total']-$return_tot_amt)) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] =number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
	
		}}else {
			$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
		}
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	




	public function get_list_sales_for_rep_comm_print($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_sales_rep_id=$this->input->post('srh_sales_rep_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		if($this->input->post('srh_to_date')){
			$srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date') . ' +1 day'));
			//$srh_to_date=date('Y-m-d', strtotime($srh_to_date);
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();
	
	//get rep details
	$rep_details=$this->User_Model->get_user_info($srh_sales_rep_id);
	//echo $this->db->last_query();
	//print_r($rep_details);	
	$rep_com_1=$rep_details['rep_com_1'];
	$rep_com_2=$rep_details['rep_com_2'];
	$rep_com_3=$rep_details['rep_com_3'];
	
	$sales = $this->Sales_Model->get_all_sales_for_rep_com_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id,$srh_sales_rep_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$rep_comm=0;
		$p_status='';
		$pay_st ='';
		$sale_id=$row['sale_id'];
		$total_paid_amount=0;
		$total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		//$total_paid_amount=$row['total_paid_amount']; 
		
		$return_tot_amt=0;
		$return_tot_amt=$this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[]=$row['sale_pymnt_date_time'];
		$nestedData[] = $row['cus_name'];
		$nestedData[] = $rep_name;
	
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		   $p_status='Pending';
		}else{
		  if ($total_paid_amount >= ($row['sale_total']-$return_tot_amt)) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		
		$sale_date=$row['sale_datetime'];;
		$sale_payment_date=$row['sale_pymnt_date_time'];
		$datetime1 = new DateTime($sale_date);
		$datetime2 = new DateTime($sale_payment_date);
		$interval = $datetime1->diff($datetime2);
		//$rep_comm=$interval->format('%R%a days');
		$days_deff=$interval->format('%R%a');
		
		if($days_deff>=0) {
			if($days_deff>=0 && $days_deff<=30){
				$rep_com_rete=$rep_com_1;
			}
			else if($days_deff>30 && $days_deff<=60){
				$rep_com_rete=$rep_com_2;
			}
			else if($days_deff>60){
				$rep_com_rete=$rep_com_3;
			}
			
			$rep_comm=$total_paid_amount*($rep_com_rete/100);
			
		}
		
		//if($days_deff<0) {$rep_comm='-';}
		
		
		//$rep_comm_ary=explode("Rs.",$rep_comm);
		//$rep_comm=100;
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] =number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');
		$nestedData[] =number_format($rep_comm, 2, '.', '');
		//$nestedData[] =$rep_comm;
		

	$data[] = $nestedData;
	
		}}else {
			$nestedData[]=$pay_st;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');
		$nestedData[] =number_format($rep_comm, 2, '.', '');
		//$nestedData[] =$rep_comm;
		$data[] = $nestedData;
		}
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	
	
	public function get_list_sales_for_print_rep_sales($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_sales_rep_id=$this->input->post('srh_sales_rep_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		if($this->input->post('srh_to_date')){
			$srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date') . ' +1 day'));
			//$srh_to_date=date('Y-m-d', strtotime($srh_to_date);
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id,$srh_sales_rep_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$p_status='';
		$pay_st ='';
		$sale_id=$row['sale_id'];
		$total_paid_amount=0;
		$total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		//$total_paid_amount=$row['total_paid_amount']; 
		
		$return_tot_amt=0;
		$return_tot_amt=$this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		

$now = strtotime(date("Y-m-d H:i:s")); // or your date as well
$your_date = strtotime($row['sale_datetime']);
$datediff = $now - $your_date;

$diff =  floor($datediff / (60 * 60 * 24));
if($diff<0) $diff=0;

		
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $row['cus_name'];
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		   $p_status='Pending';
		}else{
		  if ($total_paid_amount >= ($row['sale_total']-$return_tot_amt)) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		//$nestedData[]=$pay_st;
		$nestedData[] = $rep_name;
		$nestedData[] = $diff;
		
		$nestedData[] ='';
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] =number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
	
		}}else {
			$nestedData[]=$pay_st;
			$nestedData[] = $rep_name;
			$nestedData[] = $diff;
		//$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] =$return_tot_amt;
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$return_tot_amt-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
		}
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	
	public function get_list_sales_report_for_print_daily($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_rep_id=$this->input->post('srh_rep_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_return_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_rep_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$sale_id=$row['sale_id'];
		$total_paid_amount=$row['total_paid_amount']; //$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		$nestedData[] =display_date_time_format($row['sl_rtn_datetime']);
		$nestedData[] = $row['sl_rtn_reference_no'];
		
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		}else{
		  if ($total_paid_amount >= $row['sl_rtn_total']) {
			$pay_st = '<span class="label label-success">Paid</span>';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
		  }
		}
		
		$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sl_rtn_total'], 2, '.', '');
	
		//$nestedData[] = number_format($row['sl_rtn_total']-$row['cost_total'], 2, '.', '');

	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
		
	
	public function get_list_sales_for_print_daily($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$sale_id=$row['sale_id'];
		
		//get rep name
		$rep_name='';
		//$rep_name='';
		if(!empty($row['rep_id'])){
		$rep_name_des=$this->User_Model->get_user_info($row['rep_id']);
		$rep_name=$rep_name_des['user_first_name'];
		}
		
		$total_paid_amount=$row['total_paid_amount']; //$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $rep_name;
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		}else{
		  if ($total_paid_amount >= $row['sale_total']) {
			$pay_st = '<span class="label label-success">Paid</span>';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
		  }
		}
		
		
		$total_paid_amount_inv=0;
		//$sale_paid = $this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		$sale_payments_list= $this->Sales_Model->get_sale_payments_by_sale_id($sale_id);
		$tot_advnc_paid=0;
		$cr_interest_tot=0;
 		foreach ($sale_payments_list as $row_p){
			$sale_pymnt_amount=0;
			$cr_interest=0;
			$sale_pymnt_amount=$row_p->sale_pymnt_amount;
			if($row_p->extra_val_1){
				//$tot_advnc_paid+=$row_p->sale_pymnt_amount;
				$cr_interest=$sale_pymnt_amount*0.03;
			}
			$cr_interest_tot+=$cr_interest;
			$tot_advnc_paid=$tot_advnc_paid+$sale_pymnt_amount;//-$cr_interest;
 		}
		//$tot_advnc_paid=0;
		
		$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$row['cost_total'], 2, '.', '');
		
		
		$nestedData[] =number_format($tot_advnc_paid, 2, '.', '');
		$nestedData[] =number_format($cr_interest_tot, 2, '.', '');
	
		

	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	public function get_list_supplier_for_print($value='')
	{
		$this->load->model('Supplier_Model');
		$requestData= $_REQUEST;
		
	
		$columns = array( 
			0 =>'supp_code', 
			0 =>'supp_company_name', 
			1 => 'supp_email',
			2=> 'supp_company_phone',
			3 =>'supp_city', 
			4 => 'country_id',
			5=> 'supp_id'
		);
	
	$data = array();
	$suppliers = $this->Supplier_Model->get_all_supplier();
	$totalData = count($suppliers);
	$totalFiltered = $totalData; 
	//print_r($suppliers);
	
	foreach ($suppliers as $row){
		$nestedData=array(); 
		$nestedData[] =$row['supp_code'];
		$nestedData[] =$row['supp_company_name'];
		$nestedData[] = $row['supp_email'];
		$nestedData[] = $row['supp_company_phone'];
		$nestedData[] =$row['supp_city'];
		$nestedData[] = $row['country_short_name'];
		$data[] = $nestedData;
	 }
	 	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}
	

	public function get_list_supplier_product_for_print($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$supplier_srh=$this->input->post('supplier_srh');
		
			$this->load->model('Product_Models');
	        $values = $this->Product_Models->getSupplierProductsForReport($srh_warehouse_id,$supplier_srh);
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $products) {

	            if ($products->product_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
				$retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;

	            $row = array();
				
				//get transferd qty
				$transferd_qty=0;
				$transfer_reseve_qty=0;
				$transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				 
				 $row = array();
				 $balance_qty=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty;
				
				 
                  $row[] = $products->product_code;
	                $row[] = $products->product_name;
					 $row[] = $products->supp_company_name;//. " ($products->supp_code)";
					 if($products->product_part_no){
					  $row[] = $products->product_part_no;
					 }else {
						$row[] = ''; 
					 }
					  $row[] = number_format($purchased_qty, 2, '.', ',');
					   $row[] = number_format($sold_qty, 2, '.', ',');
	                $row[] = number_format($products->product_alert_qty, 2, '.', ',');
					 $row[] = number_format($balance_qty, 2, '.', ',');
					 
					
	                //$row[] = $transferd_qty;
	                $data[] = $row;
	            }

	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	   }
	   
	public function get_product_balance_by_product_id($srh_warehouse_id='',$product_id='',$product_sn_exissts=''){
		$balance=0;
		$transferd_qty=0;
		$transfer_reseve_qty=0;
		$sold_qty=0;
		$purchased_qty=0;
		$product_damaged_qty=0;
		$sales_return_qty=0;
		//$=0;
		$srh_from_date='';
		$srh_to_date='';
				
				$transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				//$purchased_qty=1;
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date);
				
		return $balance;
	}
	
    public function get_list_product_for_print($value = '') {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh = $this->input->post('cat_srh');
		$with_emi_no = $this->input->post('with_emi_no');
		$subcategory = $this->input->post('subcategory');

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }

        /*         * ****************** */
        $search_key = $this->input->post('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->post('start');
        $length = $this->input->post('length');

        $this->load->model('Product_Models');
        $values = '';
        $totalFiltered = 0;

//	$sales = $this->Sales_Model->get_all_sales($start,$length,$search_key_val);
//	$sales_count = $this->Sales_Model->get_all_sales('','','');

        $totalData = 0;
//	echo $length."//";
        //$getSumProductsForReport = $this->Product_Models->getSumProductsForReport($srh_warehouse_id,$cat_srh);

        if ($search_key_val) {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,'',$subcategory);
            //$values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, '', '', $search_key_val);
            $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, $search_key_val,1,$subcategory);
        } else {
            $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, $length, '','',$subcategory);
           // $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id, $cat_srh, $start, '', '');
            //print_r($values_c[0]->count);
             $totalData = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh, $start, '', '',1,$subcategory);
        }

        $totalFiltered = $totalData;
        /*         * ****************** */

        $costPriceTot = 0; //$this->Purchases_Model->getPurchasedQtyByWarehouseId('','',$srh_from_date,$srh_to_date);

        $data = array();

        if (!empty($values)) {
            foreach ($values as $products) {

                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;

                $row = array();

                //get transferd qty
                $transferd_qty = 0;
                $transfer_reseve_qty = 0;
				$purchases_return_qty=0;

                $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
                $transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
                $sold_qty = $this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $purchased_qty = $this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);
				
				// echo $this->db->last_query();

                //echo	$srh_warehouse_id;

                $purchases_return_qty = $this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                //$purchased_qty=1;
                $product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
                $sales_return_qty = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $product_balance = 0;
                $product_balance=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty-$purchases_return_qty;
				
				$details='';
				
				

                //$product_balance = $purchased_qty + $sales_return_qty - $sold_qty - $purchases_return_qty;

                $sale_price_sub_tot = $products->product_price * $product_balance;
				
				//get cost price for serial no
				$cost_price_sub_tot=0;
				
				if($products->product_sn_exissts){
					$sn_list1 = $this->Purchases_Model->get_serial_no_by_product_id($products->product_id,$srh_warehouse_id);
		 			$sn_list_tra_res2 = $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($products->product_id,$srh_warehouse_id);
					$sn_list=array_merge($sn_list1,$sn_list_tra_res2);
					 foreach ($sn_list as $row_1){
						$cost_price_sub_tot=$cost_price_sub_tot+$row_1->pis_cost_price; 
					 }
						
				}else{
					 $cost_price_sub_tot = $products->product_cost * $product_balance;
				}
				
				if($products->product_sn_exissts){
				$details="<a style=\"cursor:pointer\" onclick=\"pop_up_serial_no('$products->product_id')\">View Serial</a>";
				}
				
				/*show serial list*/
				$product_id=$products->product_id;
				$sn_list1 = $this->Purchases_Model->get_serial_no_by_product_id($product_id,$srh_warehouse_id);
				$sn_list_tra_res2= $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($product_id,$srh_warehouse_id);
				//print_r($sn_list_tra_res2);
				$sn_list_grn_rtn= $this->Purchases_Model->get_grn_return_serial_no_by_product_id($product_id,$srh_warehouse_id);
				
				$sn_list_by_avalable_warehosue = $this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
				$tra_pending_sn_list_by_avalable_warehosue = $this->Purchases_Model->get_tra_pending_serial_no_by_avalable_warehosue_id($product_id,$srh_warehouse_id);
				
				$sn_list=array_merge($sn_list1,$sn_list_tra_res2);
				$i=0;
				
				
				
				if($with_emi_no){
					
					//print_r($sn_list);
					
					//print_r($sn_list_grn_rtn);
					
				/*foreach ($sn_list as $row_1){ 
					if (in_array($row_1->pis_number, array_column($sn_list_grn_rtn, 'pris_number'))){
						
						//$details.="<br/>($i).".$row_1->pis_number;
						$test='yes';
					}else{
						$i++;
						//$details.= "<br/> ($i).".$row_1->pis_number;
					}
					
					
					}*/
					
					
					//list avalable ware house array
					//$details.= "<br/>..System Under Testing..<br/>";
					$k=0;
					foreach ($sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$details.= "<br/> ($k).".$row_1->pis_number;
					}
					foreach ($tra_pending_sn_list_by_avalable_warehosue as $row_1){ 
						$k++;
						$details.= "<br/> ($k).".$row_1->pis_number."( TP)";//.' - '.$row_1->code;
					}
				}
				/*
				if($sn_list_grn_rtn){
				foreach ($sn_list_grn_rtn as $row_r){ 
						$i++;
						$details.="<br/>($i).".$row_r->pris_number;
					}
				}
				*/
				
				//echo "";
				$display=0;
				if($purchased_qty!='' || $transferd_qty!='' || $transfer_reseve_qty!=''  || $sales_return_qty!=''  || $purchases_return_qty!=''|| $product_balance!=''){
					$display=1;	
				}
				
               
                $row[] = $products->product_code;
                $row[] = $products->product_name;
                $row[] = $products->product_part_no;
                $row[] = $products->cat_name;
                $row[] = $products->sub_cat_name;
                $row[] = number_format($purchased_qty, 2, '.', ',');
				$row[] = number_format($transferd_qty, 2, '.', ',');
				$row[] = number_format($transfer_reseve_qty, 2, '.', ',');
                $row[] = number_format($sold_qty, 2, '.', ',');
                $row[] = number_format($sales_return_qty, 2, '.', ',');
                $row[] = number_format($purchases_return_qty, 2, '.', ',');
                $row[] = '0'; //number_format($product_damaged_qty, 2, '.', ',');
                $row[] = $sale_price_sub_tot;
                $row[] = $cost_price_sub_tot;
                //$row[] = number_format($transferd_qty, 2, '.', ',');
                //$row[] = number_format($transfer_reseve_qty, 2, '.', ',');
                $row[] = $product_balance;
                //	$costPriceTot += $cost_price_sub_tot;
                $row[] = $details;
				if($display){
                $data[] = $row;
				}
				 
            }
            /**/

            $purchased_qty = 0;
            $purchases_return_qty = 0;
            $sold_qty = 0;
            $sales_return_qty = 0;
            $product_balance = 0;

            $sale_price_tot = 0;
            $cost_price_tot = 0;
            /* $product_id				= '';
              if (!empty($values_c)) {


              $transferd_qty=0;
              $transfer_reseve_qty=0;
              $transferd_qty=0;//$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $transfer_reseve_qty= 0;//$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $purchases_return_qty=$this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              $product_damaged_qty= 0;//$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id,$srh_from_date,$srh_to_date);
              $sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$product_id,$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);


              //$product_balance=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty-$purchases_return_qty;

              //$sale_price_tot=$this->Sales_Model->getSoldPriceByWarehouseId($srh_warehouse_id,'',$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);
              //$cost_price_tot=$this->Sales_Model->getCostPriceByWarehouseId($srh_warehouse_id,'',$srh_from_date,$srh_to_date,$search_key_val,$cat_srh);

              //$sale_price_tot=$product_price*$product_balance;
              //$cost_price_tot=$product_cost*$product_balance;


              } */
            /**/

            /**/
            $output = array(
                "purchased_qty" => intval($purchased_qty),
                "sold_qty" => intval($sold_qty),
                "sales_return_qty" => intval($sales_return_qty),
                "purchases_return_qty" => intval($purchases_return_qty),
                "product_balance" => intval($product_balance),
                "damadge_qty" => 0,
                "sale_price_tot" => floatval($sale_price_tot),
                "cost_price_tot" => floatval($cost_price_tot),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                'data' => $data);
            echo json_encode($output);
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
    }
	   
	   
	   
	   	public function get_list_product_qty_for_print($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$cat_srh=$this->input->post('cat_srh');
		
			$this->load->model('Product_Models');
	        $values = $this->Product_Models->getProductsForQTYReport($srh_warehouse_id,$cat_srh);
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $products) {

	            if ($products->product_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
				$retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;

	            $row = array();
				
				//get transferd qty
				$transferd_qty=0;
				$transfer_reseve_qty=0;
				$transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				 
                  $row[] = $products->product_code;
	                $row[] = $products->product_name;
					// $row[] = $products->product_part_no;
					  $row[] = $products->cat_name;
					   $row[] = $products->sub_cat_name;
	                
					$tmp_qty=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty;
					 $row[] = number_format(($products->product_cost), 2, '.', '');
					 $row[] = number_format(($products->product_price), 2, '.', '');
					 
	                $row[] = number_format($tmp_qty, 2, '.', '');
					
					  $row[] = number_format(($products->product_cost*$tmp_qty), 2, '.', '');
					 $row[] = number_format(($products->product_price*$tmp_qty), 2, '.', '');
					
					
	                //$row[] = $transferd_qty;
	                $data[] = $row;
	            }

	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	   }
	   
	   
	   public function get_list_product_alert_quantity_for_print($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$cat_srh=$this->input->post('cat_srh');
		
			$this->load->model('Product_Models');
	        $values = $this->Product_Models->getProductsForReport($srh_warehouse_id,$cat_srh);
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $products) {

	            if ($products->product_status == 0) {$k = "btn-warning";$m = "fa-minus-circle";} else {$k = "btn-green";$m = "fa-check";}
				$retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name ;

	            
				
				//get transferd qty
				$transferd_qty=0;
				$transfer_reseve_qty=0;
				$transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id,$products->product_id);
				 
				 $row = array();
				 $balance_qty=$purchased_qty+$transfer_reseve_qty+$sales_return_qty-$sold_qty-$transferd_qty-$product_damaged_qty;
                  if($balance_qty<=$products->product_alert_qty){
				  
				  $row[] = $products->product_code;
	                $row[] = $products->product_name;
					 $row[] = $products->product_part_no;
					 $row[] = $products->cat_name;
					 $row[] = $products->sub_cat_name;
					  $row[] = $products->product_alert_qty;
					  $row[] = $products->product_max_qty;
					  
	               
	                $row[] = number_format(($balance_qty), 2, '.', ',');
	                //$row[] = $transferd_qty;
	                $data[] = $row;
				  }
	            }

	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	   }
/*customer_receivable*/
	public function customer_receivable()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'customer_receivable';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['customer_list'] = $this->Customer_Model->get_all_customers();
		$data['rep_list'] = $this->User_Model->getSalesRep();
		$this->load->view('rep_customer_receivable',$data);
	}	
	public function get_list_customer_receivable_for_report($value='')
	{
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		$srh_customer_id=$this->input->post('srh_customer_id');
		$srh_payment_status=$this->input->post('srh_payment_status');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		
		$this->load->model('Sales_Model');
		$columns = array( 
		0 =>'sale_datetime', 
		1 => 'sale_reference_no',
		2=> 'cus_name',
		3 =>'sale_id', 
		4 => 'sale_id',
		5=> 'sale_id'
	);
	
	$data = array();

	
	
	$sales = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,'','','',$srh_customer_id);
	//echo $this->db->last_query();
	$totalData = count($sales);
	$totalFiltered = $totalData;  
	
	foreach ($sales as $row){
		$nestedData=array(); 
		$p_status='';
		$pay_st ='';
		$sale_id=$row['sale_id'];
		$total_paid_amount=$row['total_paid_amount']; //$this->Sales_Model->get_total_paid_by_sale_id($sale_id);
		$nestedData[] =display_date_time_format($row['sale_datetime']);
		$nestedData[] = $row['sale_reference_no'];
		$nestedData[] = $row['cus_name'];
		
		
		if (empty($total_paid_amount)) {
		  $pay_st = '<span class="label label-warning">Pending</span>';
		   $p_status='Pending';
		}else{
		  if ($total_paid_amount >= $row['sale_total']) {
			$pay_st = '<span class="label label-success">Paid</span>';
			$p_status='Paid';
		  }else{
			$pay_st = '<span class="label label-info">Partial</span>';
			$p_status='Partial';
		  }
		}
		
		if($srh_payment_status){
			if($srh_payment_status==$p_status)
		{
		$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
	
		}}else {
			$nestedData[]=$pay_st;
		$nestedData[] = number_format($row['cost_total'], 2, '.', '');
		$nestedData[] = number_format($row['sale_total'], 2, '.', '');
		$nestedData[] = number_format($total_paid_amount, 2, '.', '');
		$nestedData[] = number_format($row['sale_total']-$total_paid_amount, 2, '.', '');

	$data[] = $nestedData;
		}
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	function print_customer_receivable(){
		$data['main_menu_name'] = 'reports';
		
		$srh_warehouse_id=$this->input->get('srh_warehouse_id');
		$srh_customer_id=$this->input->get('srh_customer_id');
		$srh_from_date=$this->input->get('srh_from_date');
		$srh_to_date=$this->input->get('srh_to_date');
		
		
		
		if($srh_warehouse_id){
			$warehouse_details=$this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
			$data['srh_warehouse_name']=$warehouse_details['name'];
			$data['warehouse_details']=$warehouse_details;
			
			$customer_details=$this->Customer_Model->get_all_customer_print($srh_customer_id);
			$data['customer_details']=$customer_details;
			$data['srh_from_date']=$srh_from_date;
			$data['srh_to_date']=$srh_to_date;
		}else {
			$data['srh_warehouse_name']="-All-";
		}
		
		
		
		$this->load->view('models/print_customer_receivable',$data);
	}
	/*customer_receivable*/	
	
	
	   public function get_list_product_for_print_summary($value = '') {
        $srh_warehouse_id = $this->input->get('srh_warehouse_id');
        $cat_srh = $this->input->get('cat_srh');

        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
        }

        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
        }
        /* echo $srh_from_date;echo "||";
          echo $srh_to_date; */

//	$sales = $this->Sales_Model->get_all_sales($start,$length,$search_key_val);
//	$sales_count = $this->Sales_Model->get_all_sales('','','');

        $totalData = 0;
//	echo $length."//";
        //$getSumProductsForReport = $this->Product_Models->getSumProductsForReport($srh_warehouse_id,$cat_srh);
        //$all_values = $this->Product_Models->getProductIdsForReport($srh_warehouse_id,$cat_srh,'','','');
        $values = $this->Product_Models->getProductIdsForReport($srh_warehouse_id, $cat_srh);
        //print_r($values);	
        /* 	if($search_key_val){
          $values = $this->Product_Models->getProductsForReport($srh_warehouse_id,$cat_srh,$start,$length,$search_key_val);
          $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id,$cat_srh,'','',$search_key_val);
          $totalData = $values_c[0]->count;
          }else{
          $values = $this->Product_Models->getProductsForReport($srh_warehouse_id,$cat_srh,$start,$length,'');
          $values_c = $this->Product_Models->getProductsForReport_c($srh_warehouse_id,$cat_srh,$start,'','');
          //print_r($values_c[0]->count);
          $totalData = $values_c[0]->count;
          } */

        //$totalFiltered = $totalData;
        /*         * ****************** */

        $purchased_qty_tot = 0;
        $purchases_return_qty_tot = 0;
        $sold_qty_tot = 0;
        $sales_return_qty_tot = 0;
        $product_balance_tot = 0;
        $sale_price_tot = 0;   //$this->Purchases_Model->getPurchasedQtyByWarehouseId('','',$srh_from_date,$srh_to_date);
        $cost_price_tot = 0;
        $data = array();

        if (!empty($values)) {
            foreach ($values as $products) {


                $transferd_qty = 0;
                $transfer_reseve_qty = 0;
				 $purchases_return_qty=0;

                $sold_qty = $this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $sold_qty_tot += $sold_qty;
                /* echo "|sq:".$sold_qty."|";
                  echo "|sqt:".$sold_qty_tot."|"; */
                $purchased_qty = $this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);
                $purchased_qty_tot += $purchased_qty;

              //  $purchases_return_qty = $this->Purchases_Model->getReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);

                $purchases_return_qty_tot+= $purchases_return_qty;

                $sales_return_qty = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id, $srh_from_date, $srh_to_date);
                $sales_return_qty_tot += $sales_return_qty;

                $product_balance = $purchased_qty + $sales_return_qty - $sold_qty - $purchases_return_qty;
                $product_balance_tot += $product_balance;

                $sale_price_tot += $products->product_price * $product_balance;
                $cost_price_tot += $products->product_cost * $product_balance;
            }
            /**/
//$output = array();
            $output = array(
                "purchased_qty" => intval($purchased_qty_tot),
                "sold_qty" => intval($sold_qty_tot),
                "sales_return_qty" => intval($sales_return_qty_tot),
                "purchases_return_qty" => intval($purchases_return_qty_tot),
                "product_balance" => intval($product_balance_tot),
                "damadge_qty" => 0,
                "sale_price_tot" => floatval($sale_price_tot),
                "cost_price_tot" => floatval($cost_price_tot)
            );

            echo json_encode($output);
        } else {
            $output = array(
                "recordsTotal" => '',
                "recordsFiltered" => '',
                'data' => '');
            echo json_encode($output);
        }
    }
	
	public function cash_report(){
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'reports/cash_report';
		$service_type=$this->uri->segment('3');
		$data['service_type']=$service_type;
		$pageName='';
		
		$data['pageName'] =$pageName;
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['user_list'] = $this->User_Model->getUsers();
		//$data['vehicle_list'] = $this->Vehicle_Model->get_all_vehicle();
		$this->load->view('rep_cash_report',$data);
	}
	
	public function get_list_payments_for_report_rtn()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$srh_type='sales_return';
		 $values = $this->Sales_Model->getPaymentsForPrint_rtn($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
	        if (!empty($values)) {
	            foreach ($values as $users) {
					$invoice_no='';
					$display=false;
					
						//get sales return ref no
						//$sales_return_des=$this->Sales_Return_Model->get_sale_return_info($users->sale_id);
						//$invoice_no=$sales_return_des['sl_rtn_reference_no'];
						//$warehouse_id_sales_rtn=$sales_return_des['warehouse_id'];
						
					
					
					
					
	            $row = array();
					//$bkng_id=$users->sale_id;
					//$paymnt_id=$users->sale_pymnt_id;
					
					$row[] =sprintf("%04d", $users->sale_pymnt_id);
					$row[] = $users->sale_pymnt_date_time;
					$row[] = $users->sl_rtn_reference_no;
					$row[] =  $users->cus_name;
					$row[] = $users->sale_payment_type;
					$row[] = $users->sale_pymnt_paying_by;
					$row[] = $users->sale_pymnt_amount;
					 // $row[] = sprintf("%04d", $users->sale_pymnt_id);
					//  $row[] = $users->sale_pymnt_date_time;
					 //  $row[] = $invoice_no;
					  
					   
					
					//$pymnt_collected='';
				//	$checked_status='';
					

					// $row[] =  $users->sale_payment_type;
					// $row[] =  $users->sale_pymnt_paying_by;
					//$row[] = $users->sale_pymnt_amount;		
                   $paid=0;
							
	
	                $data[] = $row;
					
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}
public function get_list_payments_for_report_grn()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		 $values = $this->Purchases_Model->getPaymentsForPrint_grn($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		 
		 
		
		//echo $this->db->last_query();
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
	        if (!empty($values)) {
	            foreach ($values as $users) {
					$invoice_no='';
					$display=false;
					
						//get sales return ref no
						//$sales_return_des=$this->Sales_Return_Model->get_sale_return_info($users->sale_id);
						//$invoice_no=$sales_return_des['sl_rtn_reference_no'];
						//$warehouse_id_sales_rtn=$sales_return_des['warehouse_id'];
						
					
					
					
					
	            $row = array();
					//$bkng_id=$users->sale_id;
					//$paymnt_id=$users->sale_pymnt_id;
					
					$row[] =sprintf("%04d", $users->sale_pymnt_id);
					$row[] = $users->sale_pymnt_date_time;
					$row[] = $users->reference_no;
					$row[] = $users->supp_company_name;
					$row[] = $users->sale_payment_type;
					$row[] = $users->sale_pymnt_paying_by;
					$row[] = $users->sale_pymnt_amount;
					 // $row[] = sprintf("%04d", $users->sale_pymnt_id);
					//  $row[] = $users->sale_pymnt_date_time;
					 //  $row[] = $invoice_no;
					  
					   
					
					//$pymnt_collected='';
				//	$checked_status='';
					

					// $row[] =  $users->sale_payment_type;
					// $row[] =  $users->sale_pymnt_paying_by;
					//$row[] = $users->sale_pymnt_amount;		
                   $paid=0;
							
	
	                $data[] = $row;
					
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}

public function get_list_expenses_for_report()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		 $values = $this->Expenses_Model->get_all_expenses_items_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
		$itm_count=0;
	        if (!empty($values)) {
	            foreach ($values as $users) {
					
	            $row = array();
				$itm_count++;
					$exp_id=$users->exp_id;
					$row[]=sprintf("%03d", $itm_count);
					$row[]=sprintf("%04d", $users->exp_id);
					$row[]=$users->exp_datetime;
					//$row[]=$users->user_first_name;
					$row[]=$users->product_name;
					//$row[]=$users->unit_name;
					$row[]=$users->product_cost;
					$row[]=$users->expitm_qty;
					$row[]="($users->expitm_dis_val)".$users->expitm_dis_val;
					$row[]=$users->sub_total_item;
					
					//$paymnt_id=$users->sale_pymnt_id;
					$row[]='';
					//  $row[] = sprintf("%04d", $users->sale_pymnt_id);
					//  $row[] = $users->sale_pymnt_date_time;
					//   $row[] = $users->sale_reference_no;
					  
					   
					// checked="checked"
					$pymnt_collected='';
					$checked_status='';
					if($pymnt_collected==1) {
						$checked_status='checked=\"checked\"';
					}else {
						$checked_status='';
					}
					/*
					  $row[] = "<label class=\"checkbox-inline\">
										<input id=\"collected_$paymnt_id\" type=\"checkbox\" class=\"flat-red\" value=\"$paymnt_id\" onchange=\"changeColectedStatus($paymnt_id,this.checked)\" $checked_status>
										Collected
									</label>";	
*/
						// $row[] =  $users->user_first_name;
						// $row[] =  $users->sale_payment_type;
						// $row[] =  $users->sale_pymnt_paying_by;
						//  $row[] = $users->sale_pymnt_amount;		
                      		$paid=0;
							//$paid=$this->Booking_Model->get_total_paid_by_booking_id($bkng_id);
						//$row[] =number_format($paid, 2, '.', ',');
						
							//$row[] =number_format($users->bkng_tot_amount-$paid, 2, '.', ',');
				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;
	
	                $data[] = $row;
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}


	public function get_list_payments_for_report_service()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$srh_type=$this->input->post('srh_type');
		$srh_payment_term=$this->input->post('srh_payment_term');
		$ss_user_id=$this->input->post('ss_user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$srh_type='sales_return';
		 $values = $this->Sales_Model->getPaymentsForPrintService($srh_warehouse_id,$srh_to_date,$srh_from_date,$srh_type,$srh_payment_term,$ss_user_id);
		
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
	        if (!empty($values)) {
				$k=0;
	            foreach ($values as $users) {
					$k++;
					$invoice_no='';
					$display=false;
					
						//get sales return ref no
						//$sales_return_des=$this->Sales_Return_Model->get_sale_return_info($users->sale_id);
						//$invoice_no=$sales_return_des['sl_rtn_reference_no'];
						//$warehouse_id_sales_rtn=$sales_return_des['warehouse_id'];
						
					
					
					
					
	            $row = array();
					//$bkng_id=$users->sale_id;
					//$paymnt_id=$users->sale_pymnt_id;
					
					$returned_text='';
						if($users->sale_pymnt_cheque_rtn_status==1)
						{
							$returned_text='Returned';
						}
					
					$row[] =sprintf("%04d", $k);
					$row[] =sprintf("%04d", $users->sale_pymnt_id);
					$row[] = $users->sale_pymnt_date_time;//$users->sl_rtn_reference_no;
					$row[] =$users->service_reference_no;//sprintf("%04d", $users->service_id);
					$row[] = $users->service_walking_cus_name;
					//$row[] ='';// $users->sale_payment_type;
					
					
					//$row[] =  '';
					$row[] = $users->sale_pymnt_paying_by;
					$row[] = $users->sale_pymnt_amount;
					$row[] =$returned_text;
					 // $row[] = sprintf("%04d", $users->sale_pymnt_id);
					//  $row[] = $users->sale_pymnt_date_time;
					 //  $row[] = $invoice_no;
					  
					   
					
					//$pymnt_collected='';
				//	$checked_status='';
					

					// $row[] =  $users->sale_payment_type;
					// $row[] =  $users->sale_pymnt_paying_by;
					//$row[] = $users->sale_pymnt_amount;		
                   $paid=0;
							
	
	                $data[] = $row;
					
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}

 public function view_serial_by_product_id()
    {
       
		  $product_id = $this->uri->segment(3);
		 // echo $product_id;
		   $warehouse_id = $this->uri->segment(4);
		   //$each_price=$this->uri->segment(7);
		   $data['product_id']=$product_id;
		   //$data['each_price']=floatval($each_price);
		   $product_des=$this->Product_Models->get_product_by_id($product_id);
		   $data['product_dis_name']=$product_des->product_code." ".$product_des->product_name;
		   
		
		//echo "test:".$this->uri->segment(3);
		// $data['btnText'] = 'Submit';
		// $data['sn_list1'] = $this->Purchases_Model->get_serial_no_by_product_id($product_id,$warehouse_id);
		 
		 // echo $this->db->last_query();
		 
		 //get transfer reseved serial no
		// $data['sn_list_tra_res2'] = $this->Purchases_Model->get_transfer_reserved_serial_no_by_product_id($product_id,$warehouse_id);
		 
		// $data['sn_list']=array_merge($data['sn_list1'],$data['sn_list_tra_res2']);
		$data['sn_list']=$this->Purchases_Model->get_serial_no_by_avalable_warehosue_id($product_id,$warehouse_id);
		 
		// print_r($data['sn_list_tra_res']);
		 
		// print_r($data['sn_list']);
        $this->load->view('models/rep_serial_no',$data);
    }
	
public function product_enquiry_reports(){
	$data['main_menu_name'] = $this->main_menu_name;
	$data['sub_menu_name']='enquiry_reports';
	$data['sub_menu_name_1']='hire_purchase';
   // $data['location_list']=$this->Location_Model->get_all_location_for_dropdown();
	//$data['route_list']=$this->Route_Model->get_routes_for_dropdown();
	$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
	//$data['cash_collector_list']=$this->User_Model->get_all_cash_collector_users();
	$this->load->view('rep_product_enquiry',$data);
	}
	
		public function get_list_product_for_product_enquiry_report($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$serail_no=$this->input->post('serail_no');
		
		
		$data = array();
		//get grn data
		$values_grn = $this->Report_Model->get_grn_details_by_serail_no($serail_no);
		$row=array();
		foreach ($values_grn as $products) {
			$row=array();
			$rep_type='GRN';
			$ref_no="<a target=\"_blank\" href='".base_url("purchases/view/$products->id")."'>".$products->reference_no."</a>";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			$row[] = $serail_no;
			$row[] =$rep_type;
			$row[] = $ref_no;
			$data[] = $row;
		}
		
		//$data = array();
		//get transer data
		
		$values_transer = $this->Report_Model->get_trasfer_details_by_serail_no($serail_no);
		// echo $this->db->last_query();
		$row=array();
		foreach ($values_transer as $products) {
			$row=array();
			$rep_type='Transfer';
			$ref_no="<a onclick=\"fbs_click($products->trnsfr_id)\"href='#'>".$products->trnsfr_id."</a>";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			$row[] = $serail_no;
			$row[] =$rep_type;
			$row[] = $ref_no;
			if($products->trnsfr_id){
			$data[] = $row;
			}
		}
		
		
		
		
		
		//get sale
		$values_issue = $this->Report_Model->get_sale_details_by_serail_no($serail_no);
		$row=array();
		$ref_no='';
		$rep_type='';
		//print_r($values_issue);
		
		foreach ($values_issue as $products) {
			//
			$row=array();
			$rep_type='Sale';
			$ref_no='';
			$ref_no="<a target=\"_blank\" href='".base_url("sales/view/$products->sale_id")."'>".$products->sale_reference_no."</a>";
			
			//print_r($products->sale_id); echo " , ";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			
			$exchanged="";
			/*
			if($products->item_exchanged){
				$exchanged=" (Item Exchanged)";
			}
			*/
			$row[] = $serail_no ." $exchanged";
			$row[] =$rep_type;
			
			$row[] = $ref_no;
			$data[] = $row;
		}
		
		
		//get sale return
		$values_issue = $this->Report_Model->get_sale_return_details_by_serail_no($serail_no);
		$row=array();
		$ref_no='';
		$rep_type='';
		//print_r($values_issue);
		
		foreach ($values_issue as $products) {
			//
			$row=array();
			$rep_type='Sale Return';
			$ref_no='';
			$ref_no="<a target=\"_blank\" href='".base_url("sales/sales_return_details/$products->sl_rtn_id")."'>".$products->sl_rtn_reference_no."</a>";
			
			//print_r($products->sale_id); echo " , ";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			$row[] = $serail_no;
			$row[] =$rep_type;
			
			$row[] = $ref_no;
			$data[] = $row;
		}

			$output = array('data' =>$data);
			echo json_encode($output);
	       
	   }	
	   
	   
	 public function get_list_product_by_product_code_for_product_enquiry_report($value='')
	{
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$product_code=$this->input->post('product_code');
		
		
		$data = array();
		//get grn data
		$values_grn = $this->Report_Model->get_grn_details_by_product_code($product_code,$srh_warehouse_id);
		//print_r($values_grn);
		$row=array();
		foreach ($values_grn as $products) {
			$row=array();
			$rep_type='GRN';
			$ref_no="<a target=\"_blank\" href='".base_url("purchases/view/$products->grn_id")."'>".$products->reference_no."</a>";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			$row[] =$rep_type;
			$row[] = $ref_no;
			$row[] = $products->grn_date;
			$data[] = $row;
		}
		
		//get trasfer data
		$values_transer = $this->Report_Model->get_trsfer_details_by_product_code($product_code,$srh_warehouse_id);
		//print_r($values_grn);
		$row=array();
		foreach ($values_transer as $products) {
			$row=array();
			$rep_type='Transfer';
			$ref_no="<a onclick=\"fbs_click($products->trnsfr_id)\"href='#'>".$products->trnsfr_id."</a>";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			$row[] =$rep_type;
			$row[] = $ref_no;
			$row[] = $products->trnsfr_datetime;
			if($products->trnsfr_id){
			$data[] = $row;
			}
		}
		
		//get trasfer reserved data
		$values_transer = $this->Report_Model->get_trsfer_reserverd_details_by_product_code($product_code,$srh_warehouse_id);
		//print_r($values_grn);
		$row=array();
		foreach ($values_transer as $products) {
			$row=array();
			$rep_type='Transfer Reserved';
			$ref_no="<a onclick=\"fbs_click($products->trnsfr_id)\"href='#'>".$products->trnsfr_id."</a>";	
			$row[] = $products->product_code;
			$row[] = $products->product_name;
			$row[] =$rep_type;
			$row[] = $ref_no;
			$row[] = $products->trnsfr_datetime;
			if($products->trnsfr_id){
			$data[] = $row;
			}
		}
		

			$output = array('data' =>$data);
			echo json_encode($output);
	       
	   }	
	   
    public function customer_balance()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'customer_balance';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        if ($this->input->get('type')) {
            $data['wh']  = $this->input->get('wh');
            $data['cs']  = $this->input->get('cs');
            $data['dt']  = $this->input->get('dt');
            $data['csn'] = $this->input->get('csn');
            $this->load->view('rep_customer_balance_print', $data);
        } else {
            $this->load->view('rep_customer_balance', $data);
        }
    }
	
	   public function get_list_sales_return_for_balance_report($value = '')
    {
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_customer_id  = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        if ($this->input->post('srh_customer_id')) {
            $srh_customer_id = $this->input->post('srh_customer_id');
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_return_for_balance_report($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_customer_id);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $total_paid_amount = $row['total_paid_amount'];
            $pay_st            = '';
            $nestedData[]      = display_date_time_format($row['sl_rtn_datetime']);
            $nestedData[]      = $row['sl_rtn_reference_no'];
            $nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st = '<span class="label label-warning">Pending</span>';
            } else {
                if ($total_paid_amount >= $row['sl_rtn_total']) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                } else {
                    $pay_st = '<span class="label label-info">Partial</span>';
                }
            }
            $nestedData[] = $pay_st;
            $nestedData[] = $row['sl_rtn_total'];
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_list_payments_for_balance_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_customer_id  = $this->input->post('srh_customer_id');
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getPaymentsForBalance($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id, $srh_customer_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        if (!empty($values)) {
            foreach ($values as $users) {
                $row             = array();
                $bkng_id         = $users->sale_id;
                $paymnt_id       = $users->sale_pymnt_id;
                $row[]           = sprintf("%04d", $users->sale_pymnt_id);
                $row[]           = $users->sale_pymnt_date_time;
				
				if($srh_type == 'sale')
                $row[]           = $users->sale_reference_no;
				
				if($srh_type == 'sales_return')
                $row[]           = $users->sl_rtn_id;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
                $row[]  = $users->sale_payment_type;
                $row[]  = $users->sale_pymnt_paying_by;
                $row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_sales_for_print_balance($value = '')
    {
        $srh_to_date        = '';
        $srh_from_date      = '';
        $srh_warehouse_id   = $this->input->post('srh_warehouse_id');
        $srh_customer_id    = $this->input->post('srh_customer_id');
        $srh_payment_status = $this->input->post('srh_payment_status');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_for_report_balance($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', '', $srh_customer_id);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $p_status          = '';
            $pay_st            = '';
            $sale_id           = $row['sale_id'];
            $total_paid_amount = 0;
            $total_paid_amount = $this->Sales_Model->get_total_paid_by_sale_id($sale_id);
            $return_tot_amt    = 0;
            $return_tot_amt    = $this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
            $nestedData[]      = $row['sale_id'];
            $nestedData[]      = display_date_time_format($row['sale_datetime']);
            $nestedData[]      = $row['sale_reference_no'];
            $nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st   = '<span class="label label-warning">Pending</span>';
                $p_status = 'Pending';
            } else {
                if ($total_paid_amount >= ($row['sale_total'] - $return_tot_amt)) {
                    $pay_st   = '<span class="label label-success">Paid</span>';
                    $p_status = 'Paid';
                } else {
                    $pay_st   = '<span class="label label-info">Partial</span>';
                    $p_status = 'Partial';
                }
            }
            if ($srh_payment_status) {
                if ($srh_payment_status == $p_status) {
                    $nestedData[] = $pay_st;
                    $nestedData[] = number_format($row['sale_total'], 2, '.', '');
                    $nestedData[] = $return_tot_amt;
                    $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                    $nestedData[] = number_format($row['sale_total'] - $return_tot_amt - $total_paid_amount, 2, '.', '');
                    $nestedData[] = $row['sale_note'];
                    $data[]       = $nestedData;
                }
            } else {
                $nestedData[] = $pay_st;
                $nestedData[] = number_format($row['sale_total'], 2, '.', '');
                $nestedData[] = $return_tot_amt;
                $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                $nestedData[] = number_format($row['sale_total'] - $return_tot_amt - $total_paid_amount, 2, '.', '');
                $nestedData[] = $row['sale_note'];
                $data[]       = $nestedData;
            }
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
	
	   public function get_unrealized_cheques()
    {
        $cash             = 0;
        $ret_amt          = 0;
        $srh_warehouse_id = $this->input->get('warehouse_id');
        $cus_id           = $this->input->get('cus_id');
        $date             = $this->input->get('date');
        $date             = date('Y-m-d', strtotime($date));
        $totcash          = 0;
        $cheque           = 0;
        $today            = date("Y-m-d");
        $total_paid       = $this->Sales_Model->getPaymentsForBalance($srh_warehouse_id, '', '', 'sale', '', '', $cus_id);
        if ($total_paid) {
            foreach ($total_paid as $row2) {
                if ($row2->sale_pymnt_paying_by != 'Return_Cash') {
                    if ($row2->sale_pymnt_paying_by == 'Cheque') {
                        if ($row2->sale_pymnt_date_time > $date) {
                            $cheque = $cheque + $row2->sale_pymnt_amount;
                        }
                    }
                }
            }
        }
        echo json_encode(array(
            'old_credit_amount' => $cheque
        ));
    }
    public function customer_balance_summery()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'customer_summery_balance';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_customer_balance_summery', $data);
    }
    function print_customer_summery()
    {
        $data['main_menu_name'] = 'reports';
        $srh_warehouse_id       = $this->input->get('srh_warehouse_id');
        $srh_customer_id        = $this->input->get('srh_customer_id');
        $srh_from_date          = $this->input->get('srh_from_date');
        $srh_to_date            = $this->input->get('srh_to_date');
        $type                   = $this->input->get('type');
        $data['customers']      = $this->Customer_Model->get_customers($srh_customer_id);
        if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['srh_warehouse_name'] = $warehouse_details['name'];
            $data['warehouse_details']  = $warehouse_details;
            $data['warehouse_id']       = $srh_warehouse_id;
            $data['srh_from_date']      = $srh_from_date;
            $data['srh_to_date']        = $srh_to_date;
            $data['srh_customer_id']    = $srh_customer_id;
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
        if ($type == 'a') {
            $data['summery'] = $this->Customer_Model->get_all_customer();
            $this->load->view('rep_summery_view', $data);
        }
        if ($type == 'b')
            $this->load->view('rep_summery_balance_view', $data);
    }
	
	 public function cheque()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'cheque';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_cheque', $data);
    }
    public function unrealized_cheque()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'unrealized_cheque';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_unrealized_cheque', $data);
    }
    public function return_cheque()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'return_cheque';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_cheque_return', $data);
    }
	
	 public function get_list_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
				if($users->smp_amount>0)
                $row[]  = $users->smp_amount;
				else 
				$row[]  = $users->sale_pymnt_amount;
				
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_unrealized_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getUnrealizedChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
                $row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_return_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getRetChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
                $row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
}