<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Route_Assign_Model extends CI_Model {
  
  private $tableName = 'route';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  function get_all_routes() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("route_name", "desc");
		$this->db->where("route_id IS NOT NULL");
		$query = $this->db->get($this->tableName);
		return $query->result();
  }

	function save_route($route_data,$route_id)
	{
		if (!$route_id)
		{
			$this->db->insert($this->tableName,$route_data);
		}else {
			$this->db->where('route_id', $route_id);
			return $this->db->update($this->tableName,$route_data);
		}
	}	

		function get_all_route_list() {
		$this->db->select($this->tableName.'.*');
		
		$this->db->order_by("route_id", "desc");
		//$this->db->where("route_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result(); 
	}
	
	 // get all area list 
   function get_all_area_names() {
		$this->db->select('master_area'.'.*');
		$this->db->order_by("area_id", "desc");
		$this->db->where("area_id IS NOT NULL");
		$query = $this->db->get('master_area');
		return $query->result();
	}
	
	
	// acccess selected routes
	function get_selected_route($area_id) {
		$this->db->select('route.*');
		$this->db->from('route');
		$this->db->order_by('route_id', 'desc');
		$this->db->where('area_id',$area_id);
		$this->db->where('route_status',1);
		$query = $this->db->get();		
		return $query->result_array();
	}
	
	
	function get_relevent_route_ids($area_id) {
		$this->db->select('route.route_id,route.route_name');
		$this->db->from('route');
		$this->db->where('area_id',$area_id);
		$this->db->where('route_status',1);
		$query = $this->db->get();		
		$routes= $query->result_array();
		$route_array=array();
		$count_=0;
		foreach($routes as $key)
		{
			$count_=1;
			$route_array[]=$key['route_id']	;		
		}
		if($count_==0)
		{
		$route_array=array("-566");	
		}
		return $route_array;		
	}
	
	// acccess pending routes
	function get_pending_route() {
		$this->db->select('route.*');
		$this->db->from('route');
		$this->db->order_by('route_id', 'desc');
		$this->db->where('area_id',0);
		$this->db->where('route_status',1);
		$query = $this->db->get();		
		return $query->result_array();
	}
	
	
	public function get_all_route_by_warehouse_id($warehouse_id)
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("warehouse_id", $warehouse_id);
		$query = $this->db->get();
		$data=array();
 
//$data[0] = 'SELECT'; 
foreach ($query->result() as $row)
{
$data[$row->route_id] = $row->route_name;
}
return ($data);
}

	public function get_route_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("route_id", $id);
		$this->db->order_by("route_id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
	
	/*public function delete_route($route_id)
	{
		$this->db->where('route_id', $route_id);
		$this->db->delete($this->tableName);
	
	}*/

	public function disable_route($route_id)
	{
		$data = array(
			'area_id' => 0
		);	
		$this->db->where('route_id', $route_id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_route($route_id,$area_id)
	{
		
		$data = array(
			'area_id' => $area_id
		);	
		$this->db->where('route_id', $route_id);
		$this->db->update($this->tableName, $data);
	}
}