<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Sale_Multiple_Payment_Model extends CI_Model
{
    private $tableName = 'sale_multiple_payment';
    function __construct()
    {
        parent::__construct();
    }
    function get_all_list_sale_multiple_payment()
    {
        $this->db->select('mp.*,c.*');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('customer c', 'c.cus_id = mp.customer_id');
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_sale_multiple_payment_details_by_id($smp_id)
    {
        $this->db->select('mp.*,c.cus_name');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('customer c', 'c.cus_id = mp.customer_id');
        $this->db->where("mp.smp_id", $smp_id);
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->row();
    }
    public function get_sale_multiple_payment_items_by_id($smp_id)
    {
        $this->db->select('p.*, s.*');
        $this->db->from('sale_payments p');
        $this->db->join('sales s', 's.sale_id = p.sale_id', 'left');
        $this->db->where("p.smp_id", $smp_id);
        $this->db->order_by("p.sale_pymnt_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
    function get_next_ref_no()
    {
        $this->db->select_max('smp_last_id');
        $query = $this->db->get('sale_multiple_payment');
        return $query->row();
    }
    function save_sale_multiple_payment_header(&$supplier_data, $exp_id = false)
    {
        if (!$exp_id) {
            $smp_id = $this->db->insert('sale_multiple_payment', $supplier_data);
            return $smp_id;
        } else {
            $this->db->where('smp_id', $exp_id);
            return $this->db->update($this->tableName, $supplier_data);
        }
    }
    public function get_sale_complete_info_by_customer_id($id)
    {
        $this->db->select('s.*,sum(sp.sale_pymnt_amount) as paid_amount,c.cus_name');
        $this->db->from('sales s');
        $this->db->join('sale_payments sp', 's.sale_id=sp.sale_id', 'left');
        $this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
        $this->db->where("s.customer_id", $id);
        $this->db->order_by("s.sale_id", "desc");
        $this->db->group_by("s.sale_id");
        $query = $this->db->get();
        return $query->result();
    }
    function save_sale_multiple_payment(&$data_item)
    {
        if ($this->db->insert('sale_payments', $data_item)) {
            return true;
        } else {
            return false;
        }
    }
}