<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Mobile extends CI_Controller{
    
    function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('session');
        $this->load->library('cart');
        $this->load->model('User_Model');
        $this->load->model('Home_Model');
        $this->load->model('product_model');
        $this->load->helper('security');
        if(is_logged_in()){
            redirect(base_url());
        }
        date_default_timezone_set("asia/Colombo");
    }

    public function index(){
        $data=array('status'=>0,'error'=>1,'msg'=>"access denided");
        echo json_encode($data);
    }
    
    public function getDailyDeals(){
        $product_list = $this->product_model->getTopDeals(30);
        $top_flash_30=$this->product_model->flash_deal_multi_product($product_list);	
        $product_list = $this->product_model->getTopDeals(50);
		$top_flash_50=$this->product_model->flash_deal_multi_product($product_list);	
        $product_list = $this->product_model->getTopDeals(70);
        $top_flash_70=$this->product_model->flash_deal_multi_product($product_list);
        $data=array('top_flash_30'=>$top_flash_30,'top_flash_50'=>$top_flash_50,'top_flash_70'=>$top_flash_70);
        echo json_encode($data);

    }

    public function getDailyDealsAll(){
        $this->load->library('form_validation'); //form validation lib		
        //validations
        $this->form_validation->set_rules('value', 'Value', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        } else
        {	
        $value=$this->input->post('value');	
        $product_list = $this->product_model->getTopDealsAll($value);
        $top_flash=$this->product_model->flash_deal_multi_product($product_list);
        $data=array('top_flash'=>$top_flash,'status' =>1,'message' => validation_errors());
        echo json_encode($data);
        }

    }

    public function getSpecialOffers(){      
        $product_list= $this->Home_Model->get_specical_offer_top_list();	
        //$top_flash=$this->product_model->flash_deal_multi_product($product_list);
        $data=array('special_offer'=>$product_list,'status' =>1,'message' => "done");
        echo json_encode($data);
       

    }



    
    public function get_latest(){
        $data['latest'] = $this->Home_Model->get_latest();
        $data['home_product'] = $this->home_Home_Modelmodel->home_product();
        $data['home_accessoreis'] = $this->Home_Model->home_accessoreis();
        $data['home_services'] = $this->Home_Model->home_services();
        
        echo json_encode($data);
    }
    

    public function get_all_category(){
        $data['categories'] = $this->Home_Model->get_category_for_homepage();        
        echo json_encode($data);
    }
    
    
    public function signup() {
        $this->load->library('form_validation'); //form validation lib		
		//validations
		$this->form_validation->set_rules('email', 'User Name or E-mail', 'trim|required|min_length[4]|max_length[40]|xss_clean');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[6]|max_length[40]|xss_clean|matches[com_password]');
		$this->form_validation->set_rules('com_password', 'Confirm Password', 'trim|required|min_length[6]|max_length[40]|xss_clean');
		//check validation	
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $cus_id='';
            $status=1;            
            $message="somthing going worng";
            $email=$this->input->post('email');
		    $password=$this->input->post('password');
		    $com_password=$this->input->post('com_password');
           //check pasord are matched
            if($com_password==$password){
                $status=1;
                $message="passwords matched";
            }else{
                $status=0;
                $message="passwords not matched!";
            }
            //check alrady using username
            if($status==1)
            {
                $result = $this->User_Model->check_user($email);
                if($result==0)
                {
                    $status=1;
                    $message="User availble";
                }else{
                    $status=0;
                    $message="User already exist!";
                }
            }
            if($status==1)
            {
                $user_data=array('user_name'=>$email,'paswrd'=>$com_password);
                
                $result = $this->User_Model->save_user($user_data);
                if($result==0){
                    $status=0;
                    $message="Somthing worng while register user. please try again!";
                }else{
                    $user_id=$result;
                    $status=1;
                    $message="User availble"; 
                    $cus_code=$this->User_Model->gen_code('cus_id','customer','CUSMOB');                   
                    $customer_data=array('cus_email'=>$email,'reg_user_id'=>$result,'cus_type'=>'MOB');
                    $result = $this->User_Model->save_user_customer_profile($customer_data);
                    $cus_id=$result;
                    if($result==0){
                        $status=0;
                        $message="Somthing worng while register user. please try again!";
                    }else{
                        $status=1;
                        $message="customer profile saved"; 
                        //email sent
                        if(isset($cus_id)){
                            $cusdata = $this->User_Model->get_customer_details($cus_id); 
                            $confierm_code=mt_rand(100000, 999999);
                            $user =$this->User_Model->get_user_id_by_cus_id_only($cus_id);
                            $user_data=array(
                                'comfirmation_code'=>$confierm_code,                       
                            );
                            $user_id=$cusdata['reg_user_id'];
                            $email=$cusdata['cus_email'];
                            $result=$this->User_Model->update_user($user_id,$user_data);
                            $data['cus_data'] =$cusdata;                           
                            //-------------------------------------------------
                            $body    =  '<html>
                            <head>
                            <title>Account Verfication</title>
                            </head>
                            <body>
                            <h3>Account Verfication</h3>
                            <body>   
                            Confirmation Code : '.$confierm_code.' 
                            <hr>
                            use this code to verify your account
                            <hr>
                            Thank You<br>
                            Team Siyallanka
                            <hr>Note - please note this is an auto generated email. please do not reply to this email. 
                            </body></html>';//$this->load->view('employer/employer_email/selected_mail', $data1, TRUE);
                            $subject = 'Siyallanka password reset , Confirmation code';           
                            $this->load->library('email');
                            $config['protocol'] = "SMTP";
                            $config['smtp_host'] = "smtp.gmail.com";
                            $config['smtp_port'] = "465";
                            $config['smtp_user'] = "sachithworks@gmail.com";
                            $config['smtp_pass'] = "demo1234((";
                            $config['charset'] = "iso-8859-1";
                            $config['mailtype'] = "html";
                            $config['newline'] = "\r\n";
                            $config['validation'] = TRUE;
                            $this->email->initialize($config);          
                            $this->email->from('noreply@siyallanka.com'); 
                            $this->email->to($email);
                            $this->email->set_mailtype("html");
                            $this->email->subject($subject);
                            $this->email->message($body);
                            $responce =$this->email->send();
                            if ($responce) {
                                $email_status = 1;
                            } else {
                                $email_status = 0;
                               // print_r($this->email->print_debugger());  
                            }  
                        }                      
                        //email sent end
                        //CREATE TEMP USER LOGING
                        //$the_session = array("site_user" =>  $user_id, "site_cus" => $cus_id, "login_type" => "temp", "cus_name" => $email);
                        //$this -> session -> set_userdata($the_session);
                    }
                }
            }
            $st = array('status' =>$status,'message' => $message,'site_cus' => $cus_id) ;
            echo json_encode($st);
        }
    }

        public function confirmUser() {
            $this->load->library('form_validation'); //form validation lib		
            //validations
            $this->form_validation->set_rules('code', 'Confirmation Code', 'trim|required|min_length[4]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('site_cus', 'Customer', 'trim|required|xss_clean');
            //check validation	
             if ($this->form_validation->run() == FALSE)
            {
               $st = array('status' =>0,'message' => validation_errors());
               echo json_encode($st);
            }
            else
            {
                //$cus_id=$this -> session -> userdata('site_cus');
                $status=1;            
                $message="somthing going worng";
                $cus_id=$this->input->post('site_cus');
                $code=$this->input->post('code');          
               
                    $result =$this->User_Model->check_code($cus_id,$code);
                    if($result==1){
                        $status=1; $message="password is correct";
                        $user =$this->User_Model->get_user_id_by_cus_id_only($cus_id);
                        $user_data=array(
                            'is_confirm'=>1,
                            'last_modified_date_time'=> date("Y-m-d H:i:s")  ,
                            'last_modify_by'=> $user['reg_user_id']        
                        );
                        $user_id=$user['reg_user_id'];
                        $result=$this->User_Model->update_user($user_id,$user_data);
                        if($result==1){
                            $status=1; $message="Successfully Updated";
                           
                        }else{
                            $status=0; $message="Somthing going worng while confirm in your account ";
                        }
                  
                }
                //------------------------------------           
                $st = array('status' =>$status,'message' => $message) ;
                echo json_encode($st);
            }
        }

        public function login() {
            $this->load->library('form_validation'); //form validation lib		
            //validations
            $this->form_validation->set_rules('username', 'User Name or E-mail', 'trim|required|min_length[6]|max_length[40]|xss_clean');
            $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[6]|max_length[40]|xss_clean');
            $this->form_validation->set_rules('target', 'Link', 'trim|xss_clean');
            //check validation	
             if ($this->form_validation->run() == FALSE)
            {
               $st = array('status' =>0,'message' => validation_errors());
               echo json_encode($st);
            }
            else
            {
                $status=1;            
                $message="somthing going worng";
                $email=$this->input->post('username');
                $password=$this->input->post('password');                
                //check alrady using username               
                if($status==1)
                {
                    $result = $this->User_Model->check_user_password($email,$password);
                    if($result==1)
                    {
                        $status=1;
                        $message="User availble";
                        $user_data=$this->User_Model->get_user_details($email,$password);
                    }else{
                        $status=0;
                        $message="Login credentials not found";
                    }
                }           
                $st = array('status' =>$status,'message' => $message,'cus_details'=>$user_data) ;
                echo json_encode($st);
            }
        }
    


    
   
    
}