<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
    include('core_production_batch.php');  
class Production_Batch extends Core_Production_Batch
{
    public function __construct()
    {
        parent::__construct();
    }
    
    
    public function createEstimateBatch(){
       // ini_set('display_errors', 1);
        $id = $this->getId();
        $reult=array();
        /* get estimate master data and save batch production master data */
        $result_master=$this->Production_Batch_Model->runSelectEstimateMasterByMasterId($id);
        $batch_mstr=array(
            'pcem_id'=>$result_master['pcem_id'],
            'pbm_warehouse_id'=>$result_master['pcem_warehouse_id'],
            'pbm_ref_no'=>$this->Common_Model->gen_ref_number('pbm_id','production_batch_master','MBN'),
            'pbm_user_id'=>$this->session->userdata('ss_user_id'),
            'pbm_date_time'=>date('Y-m-d H:i:s'),
            );
        $master_last_id=$this->executeSaveMasterTable($batch_mstr);
        $result_items=$this->Production_Batch_Model->runSelectEstimateItemByMasterId($id);
        foreach($result_items as $ri){
            $batch_count=$ri['no_of_batches'];
            for($i=0;$i<$batch_count;$i++){
             $batch_item=array(
            'pbm_id'=>$master_last_id,
            'pcei_id'=>$ri['pcei_id'],
            'pbi_ref_no'=>$this->Common_Model->gen_ref_number('pbi_id','production_batch_items','AL'),
            'pbi_product_id'=>$ri['product_id'],
            'pbi_qty'=>($ri['final_output_qty']/$batch_count),
            'pbi_estimate_cost'=>($ri['pcei_cost']/$batch_count),
            'pbi_required_date'=>$ri['required_date'],
            ); 
            $item_last_id=$this->executeSaveItemTable($batch_item);
            $result_sub_items=$this->Production_Batch_Model->runSelectEstimateSubItemByItem_id($ri['pcei_id']);
            foreach($result_sub_items as $rsi){
                 $batch_sub_item=array(
                'pbi_id'=>$item_last_id,
                'pcesi_id'=>$rsi['pcesi_id'],
                'pbsi_product_mat_id'=>$rsi['product_mat_id'],
                'pbis_qty'=>($rsi['pcesi_final_qty']/$rsi['no_of_batch']),
                'pbsi_cost_total'=>($rsi['pcesi_tot_cost']/$rsi['no_of_batch']),
                'pbsi_original_cost'=>$rsi['pcesi_cost'],
                ); 
                $sub_item_last_id=$this->executeSaveSubItemTable($batch_sub_item);
            }
            }
        }
        if($master_last_id>0){$result=1;}else{$result=0;}
        
        $estimateMaster=array(
            'pcem_pickup_status'=>1,
            'pcem_pickup_by'=>$this->session->userdata('ss_user_id'),
            'pcem_pickup_date_time'=>date('Y-m-d H:i:s')
            );
        $this->Production_Batch_Model->runEstimateUpdateMaster($id,$estimateMaster);
        $output = array(
                'status' => $result,
                "message" => "Done"
            );
            //$this->autoStoreNoteCreate($master_last_id);
            echo json_encode($output);
    }
    
     function sendProductionBatch(){
        $data=array();
        $this->load->model('Warehouse_Model');
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'send_to_stores';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('estimate/prepare_store_note_master',$data);
    }
    
    
    
    function autoStoreNoteCreate($id){
        $this->load->model('Production_Preparation_Model');
        
        $get_batch_list=$this->Production_Preparation_Model->runGetBatchItem($id);
        foreach($get_batch_list as $bl){
            $data=array(
			'psnm_manual_ref_no'=>'',
			'psnm_warehouse_id'=>$bl['pbm_warehouse_id'],
			'psnm_user_id'=>$this->session->userdata('ss_user_id'),
			'psnm_date_time'=>date('Y-m-d H:i:s'),
			'psnm_ref_no'=>$this->Common_Model->gen_ref_number('psnm_id','production_store_note_master','STN'),
			'shedule_date_time'=>date('Y-m-d H:i:s'),
			'time_profile_id'=>1
		);
	    $last_mstr_id=	$this->Production_Preparation_Model->runSaveMaster($data);
            $data=array(
			'psnm_id'=>$last_mstr_id,
			'pbi_id'=>$bl['pbi_id'],
		);
		$last_item_id= $this->Production_Preparation_Model->runSaveItems($data);
        $material_item_list=  $this->Production_Preparation_Model->runGetBatchSubItem($bl['pbi_id']);
		foreach($material_item_list as $mil){
             $data=array(
			'psnm_id'=>$last_mstr_id,
			'psni_id'=>$last_item_id,
			'pbi_id'=>$mil['pbi_id'],
			'pbsi_id'=>$mil['pbsi_id'],
		);
		$this->Production_Preparation_Model->runSaveSTNSubItems($data);
		}
		 $data=array(
			'pbi_pickup_status'=>1,
			'pbi_pickup_by'=>$this->session->userdata('ss_user_id'),
			'pbi_pickup_on'=>date('Y-m-d H:i:s'),
		);
		$this->Production_Preparation_Model->runUpdateSubItemsUsingPrimaryId($bl['pbi_id'],$data);   
        }
        return true;
    }
    
    
    
    
    
  
  
   
}