<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Android extends CI_Controller
{
    var $main_menu_name = "android";
    var $sub_menu_name = "android";
    public function __construct()
    {
        parent::__construct();
        ini_set('display_errors', '1');
        ini_set('display_startup_errors', '1');
        error_reporting(E_ALL);
        $this->load->model('Common_Model');
        $this->load->model('Android_Model');
        date_default_timezone_set("Asia/Colombo");
    }
    public function index()
    {
        show_404();
    }
    
    
    function get_product_list(){
        $data=array();
        $product_list=$this->Android_Model->get_product_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'product_id' => $row['product_id'],
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'tackeout_price' => $row['product_price'],
                'dinin_price' => $row['credit_salling_price'],
                'uber_price' => $row['wholesale_price'],
                'pick_me_price' => $row['retail_wholesale'],
                'product_cost' => $row['product_cost'],
                'is_batch_validate'=>$row['is_batch_validate'],
            );
            $data[]      = $nested_date;
            
        }
        echo json_encode($data);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    //umconfiem
    public function login()
    //get user name and password
    {
        $user_username = $this->input->post('user_name');
        $password      = $this->input->post('password');
        //get user id
        $this->load->model('User_Model');
        $user_id = $this->User_Model->login($user_username, $password);
        if ($user_id) {
            $data['user_details'] = $this->User_Model->get_user_info($user_id);
            $ss_user_username     = $data['user_details']['user_username'];
            $ss_user_id           = $data['user_details']['user_id'];
            $ss_group_id          = $data['user_details']['group_id'];
            $ss_warehouse_id      = $data['user_details']['warehouse_id'];
            $ss_user_first_name   = $data['user_details']['user_first_name'];
            $ss_user_last_name    = $data['user_details']['user_last_name'];
            $ss_user_group_name   = $data['user_details']['user_group_name'];
            //if cash collector owener super admin
            if ($ss_group_id == 4 || $ss_group_id == 1 || $ss_group_id == 2 || $ss_group_id == 3 || $ss_group_id == 5|| $ss_group_id == 7) {
                $stutus = 1;
                $user   = array(
                    'ss_stutus' => $stutus,
                    'ss_user_id' => $user_id,
                    'ss_group_id' => $ss_group_id,
                    'ss_warehouse_id' => $ss_warehouse_id,
                    'ss_user_first_name' => $ss_user_first_name,
                    'ss_user_group_name' => $ss_user_group_name
                );
                echo json_encode($user);
            } else {
                $stutus = 2;
                $user   = array(
                    'ss_stutus' => $stutus
                );
                echo json_encode($user);
            }
        } else {
            $stutus = 0;
            $user   = array(
                'ss_stutus' => $stutus
            );
            echo json_encode($user);
        }
    }
    function get_order_master_data(){
       $this->load->model('Order_Model');
       $this->load->model('Warehouse_Model');
       $data['order_type_list'] = $this->Order_Model->get_order_type();
       $data['price_list'] = $this->Order_Model->get_order_price_type();
       $data['order_price_type'] = $this->Android_Model->order_price_type();
       $data['peyment_term_list'] = $this->Android_Model->peyment_term();
       $warehouse_list_original = $this->Warehouse_Model->get_all_warehouse();
       $warehouse_list=array();
       foreach($warehouse_list_original as $wl){
           $nested_data=array(
               'warehouse_id'=>$wl->id,
               'warehouse_name'=>$wl->name,
               );
               $warehouse_list[]=$nested_data;
       }
       $master_data['order_type_list']=$data['order_type_list'];
       $master_data['price_list']=$data['price_list'];
       $master_data['order_price_type']=$data['order_price_type'];
       $master_data['warehouse_list']=$warehouse_list;
       $master_data['peyment_term_list']=$data['peyment_term_list'];
       $master_data['delivery_id']=6;
       echo json_encode($master_data);
    }
    function get_delivery_dispatch_product_list(){
        $delivery_id = $this->input->post('delivery_id');
        $data=array();
        $product_list=$this->Android_Model->get_delivery_product_list($delivery_id);
        foreach ($product_list as $row) {
            $nested_date = array(
                'product_id' => $row['product_id'],
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'product_cash_price' => $row['product_price'],
                'product_credit_price' => $row['credit_salling_price'],
                'product_wholesale_price' => $row['wholesale_price'],
                'retail_wholesale' => $row['retail_wholesale'],
                'product_cost' => $row['product_cost'],
                'is_batch_validate'=>$row['is_batch_validate'],
                 'exchange_id'=>$row['excchange_id'],
            );
            $data[]      = $nested_date;
            
        }
        echo json_encode($data);
    }
    function get_delivery_dispatch_batch_product_list(){
          $delivery_id = $this->input->post('delivery_id');
        $data=array();
        $product_list=$this->Android_Model->get_delivery_product_list($delivery_id);
        foreach ($product_list as $row) {
            $nested_date = array(
                'product_id' => $row['product_id'],
                'batch_id' => $row['batch_id'],
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'product_cash_price' => $row['product_price'],
                'product_credit_price' => $row['credit_salling_price'],
                'product_wholesale_price' => $row['wholesale_price'],
                'retail_wholesale' => $row['retail_wholesale'],
                'retail_cash' => $row['retail_cash'],
                'product_cost' => $row['product_cost'],
                'is_batch_validate'=>$row['is_batch_validate'],
                'stock'=>$row['issued_qty'],
                 'exchange_id'=>$row['excchange_id'],
            );
            $data[]      = $nested_date;
        }
        echo json_encode($data);
    }
    function get_company_product_batch_list(){
        $delivery_id = $this->input->post('delivery_id');
        $data=array();
        $product_list=$this->Android_Model->get_company_product_batch_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'product_id' => $row['product_id'],
                'batch_id' => $row['batch_id'],
                'exchange_id' => $row['excchange_id'],
                'product_cash_price' => $row['product_price'],
                'product_credit_price' => $row['credit_salling_price'],
                'product_wholesale_price' => $row['wholesale_price'],
                'retail_wholesale' => $row['retail_wholesale'],
                'retail_cash' => $row['retail_cash'],
                'product_cost' => $row['product_cost'],
            );
            $data[]      = $nested_date;
            
        }
        echo json_encode($data);
    }
    function save_delivery_invoice(){
        $this->load->model('Sales_Model');
        $this->load->model('Android_Model');
        $this->load->model('Delivery_Invoice_Model');
        $tracking_id=$this->input->post('tracking_id');
        $sale_datetime_1=$this->input->post('invoice_date_time');
		$sale_datetime=date('Y-m-d H:i:s', strtotime($sale_datetime_1));
		$user_id=$this->input->post('user_id');
		$cus_id=$this->input->post('cus_id');
		$total_gross_amount=$this->input->post('total_gross_amount');
		$discount_total_amount=$this->input->post('discount_total_amount');
		$total_net_amount=$this->input->post('total_net_amount');
		$warehouse_id=$this->input->post('warehouse_id');
		$invoice_type_id	=$this->input->post('invoice_type_id');
		$price_type_id	=$this->input->post('price_type_id');
		$product = $this->input->post('invoiced_products');
		$delivery_id = $this->input->post('delivery_id');
		$dispatch_id = $this->input->post('dispatch_id');
		$cost_total= $this->input->post('cost_total');
		$total_collectable_value= $this->input->post('total_collectable_value');
		$total_claiming_value= $this->input->post('total_claiming_value');
		$exchange_product_details= $this->input->post('exchange_product_details');
		$paymet_term_id = $this->input->post('payment_term_id');
		
		$payment_date_count=$this->Delivery_Invoice_Model->get_payment_term_date_count($paymet_term_id);
		
		
	    $last_result=0;
	    $result=0;
	    $sale_reference_no	= $this->Common_Model->gen_ref_number('sale_id','sales','INV'); 
        $sale_datetime_created = date('Y-m-d H:i:s'); 
		$data=array(
				'tracking_id'=>$tracking_id,
				'invoice_date_time'=>$sale_datetime,
				'sale_datetime'=>$sale_datetime,
				'user'=>$user_id,
				'customer_id'=>$cus_id,
				'warehouse_id'=>$warehouse_id,
				'invoice_type'=>$invoice_type_id,
				'price_type'=>$price_type_id,
				'cost_total'=>$cost_total,
				'card_ref_number' =>$tracking_id,
				'sale_reference_no' =>$sale_reference_no,
				'sale_datetime_created' => $sale_datetime_created,
                'delivery_id' => $delivery_id,
                'direct_sale' => 0,
                'due_date' => date('Y-m-d', strtotime("+".$payment_date_count." days", strtotime(date("Y-m-d")))),
				'sales_rep_id' => $user_id,
				'sale_status' => 0,
                'payment_status' => 0,
                'sale_total' => $total_net_amount,
                'sale_inv_gross_total' => $total_gross_amount,
                'sale_inv_total' => $total_gross_amount,
				'dpn_id'=>$dispatch_id,
				'bill_no'=>$tracking_id,
				'total_collectble'=>$total_collectable_value,
				'total_cliamble'=>$total_claiming_value,
				'invoice_generate_type'=>3,
				'paymet_term_id'=>$paymet_term_id,
				'paymet_term_days'=>$payment_date_count,
			);
			$_insert=$this->Sales_Model->save_sales($data);
			$lastid=$this->db->insert_id();
			$sale_id=$lastid;
			$invoiced_items=stripslashes($product);
			$products = json_decode($invoiced_items);
			//insert sale item data
			foreach($products as $key=>$row){
			    foreach($row as $obj){
			        if(isset($obj->product_id)){}else{continue;}
			        $data_item=array(
    					'sale_id'=>$sale_id,
    					'product_id'=>$obj->product_id,
    					'batch_id'=>$obj->batch_id,
    					'product_unit'=>6,
    					'quantity'=>$obj->invoiced_qty,
    					'unit_price'=>$obj->product_price,
    					'net_price'=>$obj->selling_price,
    					'item_cost'=>$obj->item_cost,
    					'added_discount_val'=>$obj->item_discount,
    					'discount_val'=>$obj->total_item_discount_amount,
    					'total_item_cost'=>$obj->total_item_cost,
    					'gross_total'=>$obj->total_item_gross_amount,
    					'net_total'=>$obj->total_item_net_amount,
    					'delivery_id'=>$obj->delivery_id,
    					'dpn_id'=>$obj->delivery_dispatch_id,
    					'collectable_value'=>$obj->collectable_value,
    					'claimble_value'=>$obj->claiming_value,
    					'cus_default_price'=>$obj->cus_default_price,
    					'as_package'=>$obj->as_package,
    					'is_free_issue'=>$obj->is_free_issue,
    					
    				);
    			$last_result=$this->Sales_Model->save_sales_item($data_item);
			    }
			}
			$exchange_product_details=stripslashes($exchange_product_details);
			$products_exc = json_decode($exchange_product_details);
			foreach($products_exc as $key=>$row){
			        if(isset($row->product_id)){ }else{continue;}
			        $data_item=array(
    					'sale_id'=>$sale_id,
    					'product_id'=>$row->product_id,
    					'batch_id'=>$row->batch_id,
    					'delivery_id'=>$delivery_id,
    					'dpn_id'=>$dispatch_id,
    					'collect_qty'=>$row->exchange_qty
    				);
    			$this->Sales_Model->save_sales_collected_item($data_item);
			}
			if($last_result==true){
			    $result=1;
			}
			$st = array(
                'status' => 1,
                'msg' => "",
                'data' => "done"
        );
        echo json_encode($st);
    }
    function get_invoice_master_data(){
       $this->load->model('Order_Model');
       $this->load->model('Warehouse_Model');
       $this->load->model('In_Type_Model');
       $user_id = $this->input->post('user_id');
       $data['invoice_type_list'] = $this->In_Type_Model->get_active_in_types();
       $data['price_list'] = $this->Order_Model->get_order_price_type();
       //$data['order_price_type'] = $this->Android_Model->order_price_type();
       $data['peyment_term_list'] = $this->Android_Model->peyment_term();
       $warehouse_list_original = $this->Warehouse_Model->get_all_warehouse();
       $warehouse_list=array();
       foreach($warehouse_list_original as $wl){
           $nested_data=array(
               'warehouse_id'=>$wl->id,
               'warehouse_name'=>$wl->name,
               );
               $warehouse_list[]=$nested_data;
       }
        $master_data['invoice_type_list']=$data['invoice_type_list'];
        $master_data['price_list']=$data['price_list'];
        //$master_data['order_price_type']=$data['order_price_type'];
        $master_data['warehouse_list']=$warehouse_list;
        $master_data['peyment_term_list']=$data['peyment_term_list'];
        $last_dispatch=$this->Android_Model->get_currant_delivery($user_id);
        if(isset($last_dispatch['dpn_id'])){
        $master_data['delivery_id']=$last_dispatch['delivery_id'];
        $master_data['delivery_dispatch_id']=$last_dispatch['dpn_id'];
        }else{
             $master_data['delivery_id']=-1;
             $master_data['delivery_dispatch_id']=-1;
        }
        echo json_encode($master_data);
    }
    
     public function save_multiple_payment(){
        $this->load->model('Android_Model');
        $this->load->model('Sale_Multiple_Payment_Model');	
        $payemt_date_time_1=$this->input->post('order_date_time');
		$payment_date_time=date('Y-m-d H:i:s', strtotime($payemt_date_time_1));
	    $customer_id=$this->input->post('cus_id');
	    $user_id=$this->input->post('user_id');
	    $total_paid_amount=$this->input->post('total_paid_amount');
	    $payment_type=$this->input->post('payment_type');
	    $cheque_no=$this->input->post('cheque_no');
	    $received_date=$this->input->post('received_date');
	    $realised_date=$this->input->post('realised_date');
	    $payment_invoices=$this->input->post('invoices');
	    $warehouse_id=$this->input->post('warehouse_id');
	    $bank_id=$this->input->post('bank_id');
	    $tracking_id=$this->input->post('payment_tracking_id');
	    $system_datetime_created=date('Y-m-d H:i:s');
	    $return_ref_no=$this->input->post('return_ref_no');
	    $delivery_id = $this->input->post('delivery_id');
		$error='';
		$disMsg='';
		$lastid='';
		$sale_id='';
		$delivery=	'';
		$old_in_smp_last_id = $this->Sale_Multiple_Payment_Model->get_next_ref_no();
        $old_in_smp_last_id = $old_in_smp_last_id->smp_id;
        $smp_last_id        = $old_in_smp_last_id + 1;
        $smp_no             = 'MP/' . sprintf('%03d', $smp_last_id);
		$payment_invoices=stripslashes($payment_invoices);
		$invoice_list = json_decode($payment_invoices);
		$expire_date=date('Y-m-d', strtotime("+6 months", strtotime($payemt_date_time_1)));
		if(!$error){
			$data=array(
				'customer_id'=>$customer_id,
				'smp_no'=>$smp_no,
				'smp_amount'=>$total_paid_amount,
				'smp_added_date'=>$system_datetime_created,
				'user_id'=>$user_id,
				'warehouse_id'=>$warehouse_id,
				'bank_id'=>$bank_id,
				'payment_ref_no'=>$cheque_no,
				'payment_type'=>$payment_type,
				'payment_expire_date_cq'=>$expire_date,
				'payment_status'=>1,
				'payment_date'=>$payment_date_time,
				'ref_no'=>$tracking_id,
				'collector_id'=>$user_id,
				'delivery_id'=>$delivery_id,
				'secondory_ref_no'=>$return_ref_no
			);
			$cash_payning_by="Cash";
			if($payment_type==2){$cash_payning_by="Cheque";}
			if($payment_type==5){$cash_payning_by="Credit Note";}
			$this->Sale_Multiple_Payment_Model->save_sale_multiple_payment_header($data);
            $smp_id  = $this->db->insert_id(); 
			$disMsg='Payment successfully added';
			//insert sale item data
			foreach($invoice_list as $key=>$row){
			    foreach($row as $obj){
			       $sale_id= $this->Sale_Multiple_Payment_Model->get_sale_id_by_sales_no($obj->order_no);
			        $data_item=array(
    				'sale_id' => $sale_id,
                    'sale_pymnt_amount' =>$obj->payment_allocation,
                    'sale_pymnt_paying_by' => $cash_payning_by,
                    'user_id' => $user_id,
					'bank_id' => $bank_id,
                    'sale_pymnt_added_date_time' => $system_datetime_created,
                    'sale_payment_type' => 'sale',
                    'sale_pymnt_cheque_no' => $cheque_no,
                    'sale_pymnt_date_time' => $payment_date_time,
                    'smp_id' => $smp_id,
    				);
    				 $this->Sale_Multiple_Payment_Model->save_sale_multiple_payment($data_item);
			    }
			}
		}else {
			$disMsg='Please select these before adding any product:'.$disMsg;
		}		
        $st = array(
                'status' => 1,
                'msg' => $disMsg,
                'data' => "done"
        );
        echo json_encode($st);
    }
    
    public function get_list_customer_user_id()
    {
        $user_id = $this->input->post('user_id');
        $this->load->model('Customer_Model');
        //$this->load->model('Route_Assign_Model');
        /*$this->load->model('Android_Model');
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
        //$route_array   = $this->Route_Assign_Model->get_relevent_route_ids($area_id);*/
        $customer_list = $this->Customer_Model->get_all_customers();
        $data          = array();
        foreach ($customer_list as $cs) {
            $cus_id    = $cs['cus_id'];
            $data_item = array(
                'cus_id' => $cs['cus_id'],
                'cus_code' => $cs['cus_code'],
                'cus_name' => $cs['cus_name'],
                'cus_phone' => $cs['cus_phone'],
                'cus_phone2' => $cs['cus_m_phone'],
                'cus_address' => $cs['cus_address'],
                'route_id' => $cs['route_id'],
                'location_status' => $cs['location_status'],
                'location_latitude' => $cs['location_latitude'],
                'location_long' => $cs['location_long'],
                'cus_img' => '',
                'place_id'=>$cs['place_id'],
                'free_issue'=>$cs['free_issue'],
                'price_type'=>$cs['price_type'],
                'discount_pre'=>$cs['discount_pre'],
                'allowed_manual_override_price'=>$cs['allowed_manual_override_price'],
            );
            $data[]    = $data_item;
        }
        $jsondata = array(
            "data" => $data
        );
        echo json_encode($jsondata);
    } 
    
     public function get_customer_outstanding_invoices()
    {
        $this->load->model('Reports_Marketing_Model');
        $this->load->model('Sales_Return_Model');
        $this->load->model('Android_Model');
        $user_id=$this->input->post('user_id');
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['d_id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['d_id'];
        }
            $sale_list                = $this->Reports_Marketing_Model->get_all_sale_list_by_area_id($area_id);
            $sale_array         = array();
            foreach ($sale_list as $key) {
                $converted_sale_date = date('Y-m-d', strtotime($key['sale_datetime']));
                $s_paid              = $this->Reports_Marketing_Model->get_total_sale_paid_by_smp_id_with_no_claim($key['sale_id']);
                
                $sale_total_full = $key['total_collectble'];
                $s_outstanding   = ($key['total_collectble']) - ($s_paid);
                //$total_outstanding_amount += $s_outstanding;
                $count           = 1;
                $s_outstanding   = number_format($s_outstanding, 2, '.', '');
                $temp_sale_array = array(
                    'sale_id' => $key['sale_id'],
                    'sale_reference_no' => $key['sale_reference_no'],
                    'sale_traking_id' => $key['card_ref_number'],
                    'invoice_date' => $converted_sale_date,
                    'cus_id'=>$key['cus_id'],
                    'cus_code'=>$key['cus_code'],
                    'cus_name'=>$key['cus_name'],
                    //'cus_id'=>$key['due_date'],
                    'invoice_type ' => $key['invoice_type_name'],
                    'bill_amount' => $sale_total_full,
                    'discount' => 0,
                    'netAmount' => $sale_total_full,
                    'due_date' => $key['due_date'],
                    's_paid' => $s_paid,
                    'outstanding_amount' => $s_outstanding,
                );
                $sale_array[]    = $temp_sale_array;
            }
        echo json_encode(array(
            //"recordsTotal"    => intval( $totalData ),  
            //"recordsFiltered" => intval( $totalFiltered ),
            'data' => $sale_array
        ));
    }
    
    
    
    
    
    //unchecked function
    function get_product_list_old(){
        $data=array();
        $product_list=$this->Android_Model->get_product_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'product_id' => $row['product_id'],
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'product_cash_price' => $row['product_price'],
                'product_credit_price' => $row['credit_salling_price'],
                'product_wholesale_price' => $row['wholesale_price'],
                'retail_wholesale' => $row['retail_wholesale'],
                'product_cost' => $row['product_cost'],
                'is_batch_validate'=>$row['is_batch_validate'],
            );
            $data[]      = $nested_date;
            
        }
        echo json_encode($data);
    }
    
    
    public function save_customer_order(){
        $this->load->library('form_validation');	
		$this->form_validation->set_rules('new_order', 'ORDER', 'required|xss_clean');
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'msg' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            
        $this->load->model('Order_Model');
        $new_order=$this->input->post('new_order');
        $new_order=stripslashes($new_order);
		$new_order = json_decode($new_order);  
        $order_product=$new_order->order_product;
       
        $warehouse_id=$new_order->warehouse_id;
		$sale_rep_id=$new_order->user_id;
		$customer_id=$new_order->customer_id;
		$odr_price_type_id=$new_order->odr_price_type_id;
		$ref_no=$new_order->ref_no;
		$note=$new_order->note;
		$odr_type=$new_order->odr_type;
		$is_delivery_charge=$new_order->is_delivery_charge;
		$tracking_id=$new_order->tracking_id;
		$sale_datetime=$new_order->order_date_time;
		$sale_datetime=date('Y-m-d H:i:s', strtotime($sale_datetime));
		$user_id=$new_order->user_id;
		$totalCost=$new_order->totalCost;
		$total_gross_amount=$new_order->total_gross_amount;
        $total_net_amount=$new_order->total_net_amount;
        $payment_term=$new_order->pay_term_id;
        
         $data=array(
			'odr_warehouse_id'=>$warehouse_id,
			'odr_sale_rep_id'=>$sale_rep_id,
			'odr_customer_id'=>$customer_id,
			'odr_manual_ref_no'=>$tracking_id,
			'odr_note'=>$note,	
			'odr_type_id'=>$odr_type,
			'price_type_id'=>$odr_price_type_id,
			'odr_ref_no'=>$this->Common_Model->gen_ref_number('odr_id','order_master','ODR'),
			'added_user_id'=>$user_id,
			'added_date_time'=>date("Y-m-d H:i:s"),
			'total_odr_price'=>$total_net_amount,
			'total_odr_cost'=>$totalCost,
			'order_date_time'=>$sale_datetime,
			'odr_status'=>1,
			'odr_payment_term'=>$payment_term,
			'is_delivery_charge'=>$is_delivery_charge
		);	
        $last_id = $this->Order_Model->save_order($data);
        foreach($order_product as $row){
            $price_cost=$this->Order_Model->get_order_product_price_cost($row->product_id);
	    	$orign_price=0;
	    	if($odr_price_type_id==1){
	    	   $orign_price= $price_cost['product_price'];
	    	}
	    	if($odr_price_type_id==2){
	    	   $orign_price= $price_cost['credit_salling_price'];
	    	}
	    	if($odr_price_type_id==3){
	    	   $orign_price= $price_cost['wholesale_price'];
	    	}
	    	$price_important=0;
	    	if($orign_price==$row->selling_price){
	    	  $price_important=0;  
	    	}else{
	    	   $price_important=1;  
	    	}
	    	if($row->is_important==1){
	    	   $price_important=1;  
	    	}
	    	$edit_status=0;
	    	
	    	if($orign_price!=$row->selling_price){
	    	    $edit_status=1;
	    	}
	    	
			$data=array(
			'odr_id'=>$last_id,
			'product_id'=>$row->product_id,
			'batch_id'=>$row->batch_id,
			'request_qty'=>$row->invoiced_qty,	
			'approved_qty'=>$row->invoiced_qty,
			'uom_price'=>$row->selling_price,
			'uom_cost'=>$row->item_cost,
			'total_price'=>$row->selling_price*$row->invoiced_qty,
			'total_cost'=>$row->item_cost*$row->invoiced_qty,
			'price_important'=>$price_important,
			'original_uom_price'=>$orign_price,
			'is_batch_validate'=>$row->is_batch_validate,
			'price_important'=>$row->is_important,
			'price_edit_status'=>$edit_status,
			'price_edit_by'=>$sale_rep_id,
			
		);	
         $status=$this->Order_Model->save_order_item($data);
        }
        } 
			//--------------------------------------------------------
			$disMsg="Succesfully Added";
       $st = array(
                'status' => 1,
                'msg' => $disMsg,
                'data' => "done"
        );
        echo json_encode($st);
    }
    
    
     function get_validated_batch_list(){
       $this->load->model('Stock_Counter_Model');  
        $data=array();
        $product_list=$this->Android_Model->get_validated_product_batch_list();
        foreach ($product_list as $row) {
            
            $stock=$this->Stock_Counter_Model->get_availble_stock_for_invoicing_and_order('',$row['product_id'],$row['batch_id']);
            $nested_date = array(
                'product_id' => $row['product_id'],
                'batch_id' => $row['batch_id'],
                'batch_qty' => $stock,
                'product_cash_price' => $row['product_price'],
                'product_credit_price' => $row['credit_salling_price'],
                'product_wholesale_price' => $row['wholesale_price'],
                'product_cost' => $row['product_cost'],
            );
            $data[]      = $nested_date;
            
        }
        echo json_encode($data);
    }
    
    
    
    function save_transaction_log()
    {
        $this->load->model('Android_Model');
        $transaction_id           = $this->input->post('transaction_id');
        $transaction_customer     = $this->input->post('transaction_customer');
        $transaction_user         = $this->input->post('transaction_user');
        $transaction_recode_id    = $this->input->post('transaction_recode_id');
        $transaction_type         = $this->input->post('transaction_type');
        $transaction_start_time   = $this->input->post('transaction_start_time');
        $transaction_sending_type = $this->input->post('transaction_sending_type');
        $connection_status        = $this->input->post('connection_status');
        $data_saving_type         = $this->input->post('data_saving_type');
        $transaction_end_time     = $this->input->post('transaction_end_time');
        $response_status          = $this->input->post('response_status');
        $response_result          = $this->input->post('response_result');
        $response_message         = $this->input->post('response_message');
        $device_id                = $this->input->post('device_id');
        $log                      = $this->input->post('log');
        $added_date_time          = date('Y-m-d H:i:s');
        $data                     = array(
            'transaction_id' => $transaction_id,
            'transaction_customer' => $transaction_customer,
            'transaction_user' => $transaction_user,
            'transaction_recode_id' => $transaction_recode_id,
            'transaction_type' => $transaction_type,
            'transaction_start_time' => $transaction_start_time,
            'transaction_sending_type' => $transaction_sending_type,
            'connection_status' => $connection_status,
            'data_saving_type' => $data_saving_type,
            'transaction_end_time' => $transaction_end_time,
            'response_status' => $response_status,
            'response_result' => $response_result,
            'log' => $log,
            'device_id' => $device_id,
            'added_date_time' => $added_date_time
        );
        $result                   = $this->Android_Model->save_transaction_log($data);
        if ($result == 1) {
            echo json_encode(array(
                'error' => 1,
                'message' => "Transaction done",
                'status' => 1
            ));
        } else {
            echo json_encode(array(
                'error' => 0,
                'message' => "Error occurd!",
                'status' => 0
            ));
        }
    }
    
    
    
    
     public function save_transaction()
    {
        $this->load->model('Android_Model');
        $description      = $this->input->post('description');
        $system_date_time = $this->input->post('system_date_time');
        $page_name        = $this->input->post('page_name');
        $user_id          = $this->input->post('user_id');
        $device_address   = $this->input->post('device_address');
        $added_date_time  = date('Y-m-d H:i:s');
        /*$user_currunt     = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id          = -5;
        $delivery_id      = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }*/
        $data_item = array(
            //'delivery_id' => $delivery_id,
            'description' => $description,
            'system_date_time' => date('Y-m-d H:i:s', strtotime($system_date_time)),
            'user_id' => $user_id,
            'device_address' => $device_address,
            'page_name' => $page_name,
            'added_date_time' => $added_date_time
        );
        $result    = $this->Android_Model->save_log_android_transaction($data_item);
        if ($result == 1) {
            echo json_encode(array(
                'error' => 0,
                'message' => "Transaction done",
                'status' => 1
            ));
        } else {
            echo json_encode(array(
                'error' => 1,
                'message' => "Error occurd!",
                'status' => 0
            ));
        }
    }
    function get_order_summary_report(){
        $user_id = $this->input->post('user_id');
        $date = $this->input->post('date');
        if($date){
        $date = date('Y-m-d', strtotime($date));
        }
        $result    = $this->Android_Model->get_pending_order_list($user_id,$date);
        $data=array();
        
        foreach($result as $row){
            $nested_date = array(
                'cus_code' => $row['cus_code'],
                'cus_name' => $row['cus_name'],
                'odr_ref_no' => $row['odr_ref_no'],
                'odr_manual_ref_no' => $row['odr_manual_ref_no'],
                'total_odr_price' => $row['total_odr_price'],
                'order_date_time' => $row['order_date_time'],
                'status'=>""
              );
            $data[]      = $nested_date;
        }
        echo json_encode(array('data'=>$data));
    }
    
     
    
    
    
    
    
    
    
    
    
    
    
    
    
    //old functions------------------------------------------------------------------------------------------------
    public function get_customer_outstanding_list()
    {
        $this->load->model('Reports_Marketing_Model');
        $this->load->model('Sales_Return_Model');
        $route_id      = $this->input->get('area_id');
        $start         = 1;
        $length        = 500;
        $search        = $this->input->get('search');
        $totalData     = 1000; //$this->Reports_Marketing_Model->get_all_customers_by_area_id($route_id,"","",$search);
        $totalFiltered = 1000;
        $customer_list = $this->Reports_Marketing_Model->get_all_customers_by_area_id($route_id, $start, $length, $search);
        $json_data     = array();
        foreach ($customer_list as $row) {
            $total_outstanding_amount = 0;
            $customer_id              = $row['cus_id'];
            $sale_total               = $this->Reports_Marketing_Model->get_all_sale_total_by_customer_id($customer_id);
            $sale_paid                = $this->Reports_Marketing_Model->get_all_paid_total_by_customer_id($customer_id);
            $sale_list                = $this->Reports_Marketing_Model->get_all_sale_list_by_customer_id($customer_id);
            $return_balance           = 0; //$this->Reports_Marketing_Model->get_cheque_return_balance_by_customer_id($customer_id);
            $return_cheque_list       = $this->Reports_Marketing_Model->get_all_cheque_return_list_by_customer_id($customer_id);
            $over_cheq_list           = $this->Reports_Marketing_Model->get_uncomplte_multiple_payment($customer_id);
            $cus_payment_balance      = 0;
            foreach ($over_cheq_list as $ovc) {
                $id           = $ovc['smp_id'];
                $sale_paid    = $this->Reports_Marketing_Model->get_total_sale_paid_by_smp_id($id);
                $return_paid  = $this->Reports_Marketing_Model->get_total_cheque_return_paid_by_smp_id($id);
                $sale_balance = $ovc['smp_amount'] - $return_paid - $sale_paid;
                $cus_payment_balance += $sale_balance;
            }
            $return_full_amount = 0;
            $count              = 0;
            $sale_array         = array();
            foreach ($sale_list as $key) {
                $converted_sale_date = date('Y-m-d', strtotime($key['sale_datetime']));
                $s_paid              = $this->Reports_Marketing_Model->get_all_paid_total_by_sale_id($key['sale_id']);
                $return_tot          = $this->Sales_Return_Model->get_relevant_return_by_sale_id($key['sale_id']);
                if (isset($return_tot['sl_rtn_total'])) {
                    $return_tot_amt = $return_tot['sl_rtn_total'];
                } else {
                    $return_tot_amt = 0;
                }
                if (isset($return_tot['sls_rtn_total_paid'])) {
                    $return_tot_paid = $return_tot['sls_rtn_total_paid'];
                } else {
                    $return_tot_paid = 0;
                }
                $sale_total_full = $key['sale_total'] - $return_tot_amt;
                $s_outstanding   = ($key['sale_total'] - $return_tot_amt) - ($s_paid);
                $total_outstanding_amount += $s_outstanding;
                $count           = 1;
                $s_outstanding   = number_format($s_outstanding, 2, '.', '');
                $temp_sale_array = array(
                    'sale_id' => $key['sale_id'],
                    'sale_reference_no' => $key['sale_reference_no'],
                    'card_ref_number' => $key['card_ref_number'],
                    'converted_sale_date' => $converted_sale_date,
                    'due_date' => $key['due_date'],
                    'invoice_type_name' => $key['invoice_type_name'],
                    'sale_total_full' => $sale_total_full,
                    's_paid' => $s_paid,
                    's_outstanding' => $s_outstanding
                );
                $sale_array[]    = $temp_sale_array;
                //$table_row='<tr><td>'.$key['sale_reference_no'].'</td>'.'<td>'.$key['card_ref_number'].'</td>'.'<td>'.$converted_sale_date.'</td>'.'<td>'.$key['due_date'].'</td>'.'<td><span class="'.$key['class_name_report'].'">'.$key['invoice_type_name'].'</span></td>'.'<td>'.$sale_total_full.'</td><td>'.$s_paid.'</td><td>'.$s_outstanding.'</td></tr>';
                $return_full_amount += $return_tot_amt;
            }
            $return_count        = 0;
            $return_cheque_array = array();
            foreach ($return_cheque_list as $key) {
                $retun_paid_amount           = $this->Reports_Marketing_Model->get_cheque_reurn_paid_amount($key['ret_pay_id']);
                $chequ_return_balance_amount = $key['total_return_amount'] - $retun_paid_amount;
                $che_re_due_date             = date('Y-m-d', strtotime($key['return_date'] . ' + 10 day'));
                $return_count                = 1;
                //$table_row='<tr><td>'.$key['payment_ref_no'].'</td>'.'<td>'.$key['payment_date'].'</td>'.'<td>'.$key['return_date'].'</td>'.'<td>'.$che_re_due_date.'</td>'.'<td>'.$key['smp_amount'].'</td><td>'.$key['panalty_charge'].'</td><td>'.$chequ_return_balance_amount.'</td></tr>';          
                $temp_retyurn_array          = array(
                    'payment_ref_no' => $key['payment_ref_no'],
                    'payment_date' => $key['payment_date'],
                    'return_date' => $key['return_date'],
                    'smp_amount' => $key['smp_amount'],
                    'che_re_due_date' => $che_re_due_date,
                    'panalty_charge' => $key['panalty_charge'],
                    'chequ_return_balance_amount' => $chequ_return_balance_amount
                );
                $return_cheque_array[]       = $temp_retyurn_array;
            }
            $nested_data = array(
                'cus_id' => $row['cus_id'],
                'cus_code' => $row['cus_code'],
                'cus_name' => $row['cus_name'],
                'cus_address' => $row['cus_address'],
                'over_payment' => number_format($cus_payment_balance, 2, ".", ""),
                'outstanding' => number_format($total_outstanding_amount - $cus_payment_balance, 2, ".", ""),
                'sale_list' => $sale_array,
                'cheque_return_list' => $return_cheque_array
            );
            $json_data[] = $nested_data;
        }
        echo json_encode(array(
            //"recordsTotal"    => intval( $totalData ),  
            //"recordsFiltered" => intval( $totalFiltered ),
            'data' => $json_data
        ));
    }
   
    public function save_location()
    {
        $this->load->model('Customer_Model');
        $user_id           = $this->input->post('user_id');
        $cus_id            = $this->input->post('cus_id');
        $location_status   = $this->input->post('location_status');
        $location_latitude = $this->input->post('location_latitude');
        $location_long     = $this->input->post('location_long');
        $data              = array(
            'location_update_user_id' => $user_id,
            'location_status' => $location_status,
            'location_latitude' => $location_latitude,
            'location_long' => $location_long
        );
        $result            = $this->Customer_Model->save_customer($data, $cus_id);
        if ($result == 1) {
            $data_r = array(
                'status' => 1,
                'error' => 0,
                'message' => "Successfuly Updated"
            );
        } else {
            $data_r = array(
                'status' => 0,
                'error' => 1,
                'message' => "Not Saved"
            );
        }
        echo json_encode($data_r);
    }
    public function get_invoice_type_list()
    {
        $this->load->model('In_Type_Model');
        $invoice_type = $this->In_Type_Model->get_active_in_types();
        echo json_encode(array(
            'data' => $invoice_type
        ));
    }
    public function get_sub_cat_list()
    {
        $this->load->model('category_models');
        $sub_cat_list = $this->category_models->get_sub_category_by_cat_id();
        echo json_encode(array(
            'data' => $sub_cat_list
        ));
    }
   
   
    public function create_new_invoice()
    {
        $this->load->library('form_validation'); 
        $user_id  = $this->input->post('user_id');
        $order_id = $this->input->post('order_id');
        $this->form_validation->set_rules('user_id', 'User', 'required');
        $this->form_validation->set_rules('order_id', 'Order No', 'required');
        if ($this->form_validation->run() == FALSE) {
            $st = array(
                'status' => 0,
                'msg' => validation_errors(),
                "data" => "Error"
            );
            echo json_encode($st);
        } else {
            $this->load->model('Customer_Order_Process_Model');
            $this->load->model('Sales_Model');
            $sale_reference_no	= $this->Common_Model->gen_ref_number('sale_id','sales','INV'); 
            $sale_datetime_created = date('Y-m-d H:i:s'); 
            $order_data            = $this->Customer_Order_Process_Model->get_cus_order_master_details($order_id);
            $order_items           = $this->Customer_Order_Process_Model->get_cus_order_item_details($order_id);
            $total_cost           = $this->Customer_Order_Process_Model->get_order_total_cost($order_id);
            $data                  = array(
                'card_ref_number' => $order_data['cus_order_ref_no'],
                'sale_reference_no' => $sale_reference_no,
                'sales_rep_id' => $order_data['order_rep_id'],
                'customer_id' => $order_data['customer_id'],
                'area_id' => $order_data['route_id'],
                'warehouse_id' => $order_data['wharehouse_id'],
                'lot_master_id' => $order_data['cus_order_master_id'],
                'sale_datetime' => $sale_datetime_created,
                'sale_status' => 1,
                'payment_status' => 0,
                'sale_total' => $order_data['total_amount'],
                'total_default_discount_value' => $order_data['item_total_default_discount'],
                'total_added_discount_value' => $order_data['item_total_added_discount'],
                'sale_inv_discount' => $order_data['order_discount'],
                'sale_inv_discount_amount' => $order_data['discount_val'],
                'sale_inv_gross_total' => $order_data['net_amount'],
                'sale_inv_total' => $order_data['bd_amount'],
                'sale_paid' => 0,
                'cost_total' => $total_cost,
                'invoice_type' => $order_data['invoice_type'],
                'user' => $user_id,
                'sale_datetime_created' => $sale_datetime_created,
                'delivery_id' => $order_data['delivery_id'],
                'direct_sale' => 0,
                'due_date' => date('Y-m-d', strtotime("+3 months", strtotime(date("Y-m-d"))))
            );
            $_insert               = $this->Sales_Model->save_sales($data, '');
            $lastid                = $this->db->insert_id();
            $sale_id               = $lastid;
            if($sale_id){
                
                $data=array('invoiced_status'=>1);
                $this->Customer_Order_Process_Model->insert_update_master_table($data,$order_data['cus_order_master_id']);
                
            }
            foreach($order_items as $row){
                $data_item             = array(
                    'sale_id' => $sale_id,
                    'product_id'=>$row['product_id'],
                    'product_unit'=>6,
                    'quantity'=>$row['order_qty'],
                    'unit_price'=>$row['product_price'],
                    'net_price'=>$row['total_price']/$row['order_qty'],
                    'item_cost'=>$row['product_cost'],
                    'discount'=>$row['discount'],
                    'added_discount_val'=>$row['add_sales_discount_price'],
                    'total_item_cost'=>$row['total_cost'],
                    'discount_val'=>$row['total_item_discount'], 
                    'gross_total'=>$row['total_price']+$row['total_item_discount'],
                    'net_total'=>$row['total_price'],
                    'delivery_id'=>$order_data['delivery_id'],
                    'order_id'=>$order_data['cus_order_master_id'],
                    );
                $this->Sales_Model->save_sales_item($data_item);   
            }
            //----------------------------------------------------------------------------------
            $st = array(
                'status' => 1,
                'msg' => '',
                'data' => "done"
            );
            echo json_encode($st);
        }
    }
    
    //bulk order product list
    public function get_order_bulk_product_list()
    {
        $this->load->model('Android_Model');
        $this->load->model('Marketing_Delivery_Model');
        $this->load->model('Customer_Order_Process_Model');
        $user_id      = $this->input->post('user_id');
        
        
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
        $delivary_details = $this->Marketing_Delivery_Model->get_delivary_details($delivery_id);
        $order_list       = $this->Customer_Order_Process_Model->get_delivary_bulk_order_items($delivery_id);
        $data             = array();
        foreach ($order_list as $row) {
            //$sold_qty=$this->Customer_Order_Process_Model->get_invoiced_product_count($delivery_id,$row['cus_order_master_id']);
            $invoice_qty=$this->Marketing_Delivery_Model->get_invoice_product_item($delivery_id,$row['product_id'],$row['cus_order_master_id']);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivery_id,$row['product_id']);
            $nested_date = array(
                'order_id' => $row['cus_order_master_id'],
                'order_item_id' => $row['cus_order_item_id'],
                'product_id' => $row['product_id'],
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'product_price' => $row['product_price'],
                'product_cost' => $row['product_cost'],
                'product_qty' => $row['order_qty']-($invoice_qty+$return_qty),
                'issue_qty' => $row['issue_qty']-($invoice_qty+$return_qty),
                'total_price' => $row['total_price'],
                'add_sales_discount_price' => $row['add_sales_discount_price'],
                'discount_defualt' => $row['discount_defualt'],
                'default_discount_price' => $row['default_discount_price'],
                'after_discount_added_price' => $row['after_discount_added_price'],
                'total_item_discount' => $row['total_item_discount'],
                'total_added_discount_value' => $row['total_added_discount_value'],
                'batch_id'=>1,
            );
            $data[]      = $nested_date;
        }
        $json_array = array(
            'order_item_list' => $data
        );
        echo json_encode($json_array);
    }
    //uncheck function fro distribution join project
    public function save_customer_via_online()
    {
        $this->load->model('Customer_Model');
        $this->load->library('form_validation'); //form validation lib    
        $customer_nic      = $this->input->post('cus_nic');
        $customer_name     = $this->input->post('cus_name');
        $customer_mobile   = $this->input->post('cus_moblie');
        $customer_address  = $this->input->post('cus_address');
        $customer_route    = $this->input->post('cus_route');
        $user_id           = $this->input->post('user_id');
        $location_latitude = $this->input->post('location_latitude');
        $location_long     = $this->input->post('location_long');
        $location_status   = $this->input->post('location_status');
        $cus_code          = $this->Common_Model->gen_ref_number('cus_id', 'customer', 'CUS');
        //validations
        $this->form_validation->set_rules('cus_nic', 'NIC', 'required');
        $this->form_validation->set_rules('cus_name', 'Name', 'required');
        $this->form_validation->set_rules('cus_moblie', 'Mobile', 'required');
        $this->form_validation->set_rules('cus_address', 'Address', 'required');
        $this->form_validation->set_rules('cus_route', 'Route', 'required');
        $this->form_validation->set_rules('user_id', 'Rep ID', 'required');
        if ($this->form_validation->run() == FALSE) {
            $st = array(
                'status' => 0,
                'validation' => validation_errors()
            );
            echo json_encode($st);
        } else {
            $data   = array(
                'priority' => 0,
                'route_id' => $customer_route,
                'country_id' => 251,
                'cus_name' => $customer_name,
                'cus_code' => $cus_code,
                'cus_phone' => $customer_mobile,
                'cus_address' => $customer_address,
                'last_modify_by' => $user_id,
                'last_modify_date_time' => date('Y-m-d H:i:s'),
                'location_latitude' => $location_latitude,
                'location_long' => $location_long,
                'location_status' => $location_status
            );
            $cus_id = '';
            $this->load->model('Customer_Model');
            $_insert     = $this->Customer_Model->save_customer($data, $cus_id);
            $lastid      = $this->db->insert_id();
            $cus_details = $this->Customer_Model->get_customer_info($lastid);
            $st          = array(
                'status' => 1,
                'validation' => '',
                'data' => $cus_details
            );
            echo json_encode($st);
        }
    }
   
    public function get_route_list()
    {
        $user_id = $this->uri->segment('3');
        $this->load->model('Route_Assign_Model');
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
        $data['route_list'] = $this->Route_Assign_Model->get_selected_route($area_id);
        echo json_encode($data);
    }
    //-------------------------------------------
    public function get_all_easy_customers()
    {
        $this->load->model('Customer_Model');
        $data['customer_list'] = $this->Customer_Model->get_all_easy_customers_list();
        echo json_encode($data);
    }
    //transaction log start
    
    //transaction log starendt
    function save_visit_location()
    {
        $this->load->model('Android_Model');
        $date              = $this->input->post('date');
        $user_id           = $this->input->post('user_id');
        $cus_id            = $this->input->post('cus_id');
        $location_latitude = $this->input->post('location_latitude');
        $location_long     = $this->input->post('location_long');
        $device_id         = $this->input->post('device_id');
        $time              = $this->input->post('time');
        $transaction       = $this->input->post('transaction');
        $transaction_type  = $this->input->post('transaction_type');
        $recode_id         = $this->input->post('recode_id');
        $system_date_time  = date('Y-m-d H:i:s');
        $route_id          = $this->input->post('route_id');
        $data              = array(
            'date' => $date,
            'user_id' => $user_id,
            'cus_id' => $cus_id,
            'location_latitude' => $location_latitude,
            'location_long' => $location_long,
            'device_id' => $device_id,
            'time' => $time,
            'transaction' => $transaction,
            'transaction_type' => $transaction_type,
            'recode_id' => $recode_id,
            'route_id' => $route_id,
            'system_date_time' => $system_date_time
        );
        $result            = $this->Android_Model->save_visitlocation_log($data);
        if ($result == 1) {
            echo json_encode(array(
                'error' => 0,
                'message' => "Done",
                'status' => 1
            ));
        } else {
            echo json_encode(array(
                'error' => 1,
                'message' => "Error occurd!",
                'status' => 0
            ));
        }
    }
    public function get_bank_list()
    {
        $this->load->model('Bank_Model');
        $bank_list = $this->Bank_Model->get_all_bank();
        echo json_encode(array(
            'data' => $bank_list
        ));
    }
    function save_payment()
    {
        $st = array(
            'status' => 1,
            'msg' => '',
            'data' => "done",
            "comming_requste" => $_REQUEST
        );
        echo json_encode($st);
    }
    
    
    
      function get_direct_sale_list()
    {
        $this->load->model('Sales_Model');
        $this->load->model('Android_Model');
        $user_id=$this->input->post('user_id');
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
        $sale_list= $this->Android_Model->get_delivery_sale_list($delivery_id,$user_id);
        $sales=array();
        foreach($sale_list as $row){
            $products=array();
            $product_list= $this->Android_Model->get_delivery_sale_product_list($row['sale_id']);
            foreach($product_list as $row_i){
            $data_item=array(
            'product_id'=> $row_i['product_id'],
            'item_code'=> $row_i['product_code'],
            'item_name'=> $row_i['product_name'],
            'invoice_qty'=> $row_i['quantity'],
            'product_price'=> $row_i['net_price'],
            'gross_amount'=> $row_i['gross_total'],
            'discount'=> $row_i['discount_val'],
            'net_amount'=> $row_i['net_total'],
            );
            $products[]=$data_item;
            }
             $data=array(
            'sale_id'=> $row['sale_id'],
            'invoice_date'=> $row['sale_datetime'],
            'bill_no'=> $row['card_ref_number'],
            'cus_code'=> $row['cus_code'],
            'cus_name'=> $row['cus_name'],
            'rep_name'=> $row['user_first_name'],
            'total_gross_amount'=> $row['sale_inv_gross_total'],
            'total_discount'=> $row['total_added_discount_value']+$row['total_default_discount_value']+$row['sale_inv_discount_amount'],
            'total_net_amount'=>$row['sale_total'] ,
            'sale_item_list'=> $products
            );
            $sales[]=$data;
        }
         $st = array(
                'data' => $sales
        );
        echo json_encode($st);
    }
    
     function get_multiple_payment_list()
    {
        $this->load->model('Sales_Model');
        $this->load->model('Android_Model');
        $user_id=$this->input->post('user_id');
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
        $payment_list= $this->Android_Model->get_delivery_payment_list($delivery_id,$user_id);
        $sales=array();
        foreach($payment_list as $row){
            $single_payment=array();
            $single_payment_list= $this->Android_Model->get_delivery_sale_single_payment_list($row['smp_id']);
            foreach($single_payment_list as $row_i){
            $data_item=array(
            'sale_id'=> $row_i['sale_id'],
            'invoice_no'=> $row_i['card_ref_number'],
            'payable_amount'=> $row_i['sale_pymnt_amount'],
            'paid_amount'=> $row_i['sale_pymnt_amount'],
            'outstanding_amount'=> 0,
            
            );
            $single_payment[]=$data_item;
            }
             $data=array(
            'payment_id'=> $row['smp_id'],
            'payment_date'=> $row['payment_date'],
            'bill_no'=> $row['ref_no'],
            'cus_code'=> $row['cus_code'],
            'cus_name'=> $row['cus_name'],
            'rep_name'=> $row['user_first_name'],
            'total_payable_amount'=>0,
            'total_paid_amount'=> $row['smp_amount'],
            'total_outstanding_amount'=>0 ,
            'p_type_name'=> $row['p_type_name'],
            'payment_invoice_list '=> $single_payment,
            
            );
            $sales[]=$data;
        }
         $st = array(
                'data' => $sales
        );
        echo json_encode($st);
    }
    
     function get_direct_sale_details()
    {
        $this->load->model('Sales_Model');
        $this->load->model('Android_Model');
        $sale_id=$this->input->post('sale_id');
        $sale_data= $this->Android_Model->get_direct_sale_details($sale_id);
            $product_list= $this->Android_Model->get_delivery_sale_product_list($sale_data['sale_id']);
            $products=array();
            foreach($product_list as $row_i){
            $data_item=array(
            'product_id'=> $row_i['product_id'],
            'item_code'=> $row_i['product_code'],
            'item_name'=> $row_i['product_name'],
            'invoice_qty'=> $row_i['quantity'],
            'product_price'=> $row_i['net_price'],
            'gross_amount'=> $row_i['gross_total'],
            'discount'=> $row_i['discount_val'],
            'net_amount'=> $row_i['net_total'],
            );
            $products[]=$data_item;
            }
             $data=array(
            'sale_id'=> $sale_data['sale_id'],
            'invoice_date'=> $sale_data['sale_datetime'],
            'bill_no'=> $sale_data['card_ref_number'],
            'cus_code'=> $sale_data['cus_code'],
            'cus_name'=> $sale_data['cus_name'],
            'rep_name'=> $sale_data['user_first_name'],
            'total_gross_amount'=> $sale_data['sale_inv_gross_total'],
            'total_discount'=> $sale_data['total_added_discount_value']+$sale_data['total_default_discount_value']+$sale_data['sale_inv_discount_amount'],
            'total_net_amount'=>$sale_data['sale_total'] ,
            'sale_item_list'=> $products
            );
         $st = array(
                'data' => $data
        );
        echo json_encode($data);
    }
    
     function get_multiple_payment_details()
    {
        $this->load->model('Sales_Model');
        $this->load->model('Android_Model');
        $payment_id=$this->input->post('payment_id');
        $payment_data= $this->Android_Model->get_multiple_payment_details($payment_id);
            $single_payment=array();
            if(isset($payment_data['smp_id'])){
            $single_payment_list= $this->Android_Model->get_delivery_sale_single_payment_list($payment_data['smp_id']);
            foreach($single_payment_list as $row_i){
            $data_item=array(
            'sale_id'=> $row_i['sale_id'],
            'invoice_no'=> $row_i['card_ref_number'],
            'payable_amount'=> $row_i['sale_pymnt_amount'],
            'paid_amount'=> $row_i['sale_pymnt_amount'],
            'outstanding_amount'=> 0,
            );
            $single_payment[]=$data_item;
            }
             $data=array(
            'payment_id'=> $payment_data['smp_id'],
            'payment_date'=> $payment_data['payment_date'],
            'bill_no'=> $payment_data['ref_no'],
            'cus_code'=> $payment_data['cus_code'],
            'cus_name'=> $payment_data['cus_name'],
            'rep_name'=> $payment_data['user_first_name'],
            'total_payable_amount'=>0,
            'total_paid_amount'=> $payment_data['smp_amount'],
            'total_outstanding_amount'=>0 ,
            'payment_invoice_list '=> $single_payment
            );
            }else{
                $data = array(
                'status' => 0
        ); 
            }
        
        echo json_encode($data);
    }
    
    //----------------  
   
    
    
     public function get_expenses_category_list()
    {
        $this->load->model('Finance_Tranport_Model');
        $bank_list = $this->Finance_Tranport_Model->get_list_trasport_expenses_category();
        echo json_encode(array(
            'data' => $bank_list
        ));
    }
    
    function save_delivery_expencess()
	{
	    $this->load->model('Marketing_Delivery_Model');
	    $this->load->model('Android_Model');
	    $this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('master_transport_id', 'Expenses Category', 'required');
		$this->form_validation->set_rules('finance_rule_master_id', 'Rule', 'required');
		$this->form_validation->set_rules('open_datetime', 'Delevary Date', 'required');
	//	$this->form_validation->set_rules('issue_type', 'Issue Type', 'required');
		$this->form_validation->set_rules('amount', 'Amount', 'required');
		$remark=$this->input->post('remark');		
		$master_transport_id=$this->input->post('master_transport_id');
		$finance_rule_master_id=$this->input->post('finance_rule_master_id');
		$delivery_id=$this->input->post('delivery_id');
		$temp_date=$this->input->post('open_datetime');
		$amount=$this->input->post('amount');
		$user_id=$this->input->post('user_id');
		$tracking_id=$this->input->post('tracking_id');
		$next_ref_number=$this->Common_Model->gen_ref_number('tra_exp_id','finance_transport_expenses','TEX');
		$delevary_date_time=date('Y-m-d', strtotime($temp_date));
		$added_date_time=date('Y-m-d H:i:s');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('error'=>1,'status' =>0,'msg' => validation_errors());
           echo json_encode($st);
        }
        else
        {
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
        
            $debeit=0;
            $credit=0;
            $final_amount=0;
            if($finance_rule_master_id==1){
                $debeit=$amount;
                $final_amount=$amount;
            }else{
               $credit=$amount; 
               $final_amount=($amount*-1);
            }
			$data=array(
			'open_datetime'=>$delevary_date_time,
			'master_transport_id'=>$master_transport_id,
			'finance_rule_master_id'=>$finance_rule_master_id,
			'amount'=>$amount,
			'remark'=>$remark,
			'tr_exp_ref'=>$next_ref_number,
			'status'=>1,
			'user_id'=>$user_id,
			'delivery_id'=>$delivery_id,
			'exp_tracking_id'=>$tracking_id,
			'debit'=>$debeit,
			'credit'=>$credit,
			);			
		    $result=$this->Marketing_Delivery_Model->save_delivery_expencess($data);
		    if($result>0){
		        $status=1;
		    }else{
		        $status=0;
		    }
			$st = array('error'=>0,'status' =>$status,'msg'=>" Done");
           echo json_encode($st);
		}
	}	
	
	 public function get_delivery_expenses_list()
    {
        $this->load->model('Finance_Tranport_Model');
        $this->load->model('Android_Model');
        $user_id=$this->input->post('user_id');
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
        $bank_list = $this->Finance_Tranport_Model->get_delivery_expenses_list($delivery_id);
        echo json_encode(array(
            'data' => $bank_list
        ));
    }
    
    function save_delivery_deposit()
	{
	    $this->load->model('Marketing_Delivery_Model');
	    $this->load->model('Android_Model');
	    $this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('bank_id', 'Bank', 'required');
		$this->form_validation->set_rules('tracking_id', 'Tracking Id', 'required');
		$this->form_validation->set_rules('user_id', 'User', 'required');
		$this->form_validation->set_rules('recode_date_time', 'Deposited Date', 'required');
		$this->form_validation->set_rules('deposited_amount', 'Amount', 'required');
		$this->form_validation->set_rules('deposit_payment_type', 'Amount', 'required');
		$this->form_validation->set_rules('bank_slip_no', 'Bank Slip No', 'required');
		$bank_id=$this->input->post('bank_id');
		$branch_id=$this->input->post('branch_id');
		$tracking_id=$this->input->post('tracking_id');
		$user_id=$this->input->post('user_id');
		$deposit_payment_type=$this->input->post('deposit_payment_type');
		$deposited_amount=$this->input->post('deposited_amount');
		$bank_slip_no=$this->input->post('bank_slip_no');
		$remark=$this->input->post('remark');
		$temp_date=$this->input->post('recode_date_time');
		$recode_date_time=date('Y-m-d H:i:s', strtotime($temp_date));
		$next_ref_number=$this->Common_Model->gen_ref_number('dbd_id','bank_deposits','BND');
		
		$added_date_time=date('Y-m-d H:i:s');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('error'=>1,'status' =>0,'msg' => validation_errors());
           echo json_encode($st);
        }
        else
        {
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
			$data=array(
			'bank_id'=>$bank_id,
			'branch_id'=>$branch_id,
			'user_id'=>$user_id,
			'delivery_id'=>$delivery_id,
			'deposit_payment_type'=>$deposit_payment_type,
			'deposited_amount'=>$deposited_amount,
			'remarks'=>$remark,
			'recode_date_time'=>$recode_date_time,
			'bank_slip_no'=>$bank_slip_no,
			'deposit_ref_no'=>$next_ref_number,
			'recode_date_time'=>$recode_date_time,
			'system_date_time'=>$added_date_time,
			'deposit_tracking_id'=>$tracking_id
			
			);			
		    $result=$this->Marketing_Delivery_Model->save_delivery_deposit($data);	
		     if($result>0){
		        $status=1;
		    }else{
		        $status=0;
		    }
			$st = array('error'=>0,'status' =>$status,'msg'=>" Done");
           echo json_encode($st);
		}
	}
	
	 public function get_delivery_deposit_list()
    {
        $this->load->model('Finance_Tranport_Model');
        $this->load->model('Android_Model');
        $user_id=$this->input->post('user_id');
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
        $bank_list = $this->Finance_Tranport_Model->get_delivery_diposit_list($delivery_id);
        echo json_encode(array(
            'data' => $bank_list
        ));
    }
    
     public function activate_device()
    {
        $this->load->model('Android_Model');
        $user_id=$this->input->post('user_id');
        $device_id=$this->input->post('device_id');
        $code=$this->input->post('code');
        $result = $this->Android_Model->get_registered_device($user_id,$device_id,$code);
        $recode_id='';
        $approval_status=0;
        $activation_status=0;
        if(isset($result['mr_id'])){
		  $recode_id = $result['mr_id'];
		}
		 if(isset($result['activation_status'])){
		  $approval_status = $result['activation_status'];
		}
        if($recode_id){
            if($approval_status==1){
               $activation_status=1; 
            }
        }else{
            $data=array(
            'device_id' => $device_id,
            'user_id' => $user_id,
            'activation_code' =>$code,
            'activation_status' =>0,
            'added_date_time' =>date('Y-m-d H:i:s'),
            );
            $result = $this->Android_Model->save_activation_code($data);
        }
        echo json_encode(array(
            'activate_status' => $activation_status,
            'user_id' => $user_id,
            'activation_code' =>$code,
        ));
    }
    
    function save_new_direct_invoice_in_special_mod(){
        
        $this->load->model('Sales_Model');
        $this->load->model('Android_Model');
        $tracking_id=$this->input->post('tracking_id');
        $sale_datetime_1=$this->input->post('invoice_date_time');
		$sale_datetime=date('Y-m-d H:i:s', strtotime($sale_datetime_1));
		$user_id=$this->input->post('user_id');
		$cus_id=$this->input->post('cus_id');
		$total_gross_amount=$this->input->post('total_gross_amount');
		$discount_total_amount=$this->input->post('discount_total_amount');
		$total_net_amount=$this->input->post('total_net_amount');
		$warehouse_id=$this->input->post('warehouse_id');
		$sale_type	=$this->input->post('sale_type');
		$product = $this->input->post('product');
		$cost_total= $this->input->post('cost_total');
	    $last_result=0;
	    $result=0;
		$data=array(
				'tracking_id'=>$tracking_id,
				'invoice_date_time'=>$sale_datetime,
				'user_id'=>$user_id,
				'cus_id'=>$cus_id,
				'total_gross_amount'=>$total_gross_amount,
				'discount_total_amount'=>$discount_total_amount,
				'total_net_amount'=>$total_net_amount,
				'warehouse_id'=>$warehouse_id,
				'sale_type'=>$sale_type,
				'cost_total'=>$cost_total,
			);
			$_insert=$this->Android_Model->save_sales($data);
			$lastid=$this->db->insert_id();
			$sale_id=$lastid;
			$invoiced_items=stripslashes($product);
			$products = json_decode($invoiced_items);
			//insert sale item data
			foreach($products as $key=>$row){
			    foreach($row as $obj){
			        if(isset($obj->product_id)){}else{continue;}
			        $data_item=array(
    					'sale_id'=>$sale_id,
    					'batch_id'=>$obj->batch_id,
    					'discount_amount'=>$obj->discount_amount,
    					'gross_amount'=>$obj->gross_amount,
    					'invoiced_qty'=>$obj->invoiced_qty,
    					'invoice_id'=>$obj->invoice_id,
    					'item_cost'=>$obj->item_cost,
    					'item_discount'=>$obj->item_discount,
    					'net_amount'=>$obj->net_amount,
    					'order_id'=> $obj->order_id,
    					'product_id'=>$obj->product_id,
    					'selling_price'=>$obj->selling_price,
    					'total_item_cost'=>$obj->total_item_cost,
    				);
    			$last_result=$this->Android_Model->save_sales_item($data_item);
			    }
			}
			if($last_result==true){
			    $result=1;
			}
			$st = array(
                'status' => 1,
                'msg' => "",
                'data' => "done"
        );
        echo json_encode($st);
        
    }
    
    
    
    public function save_multiple_payment_in_special_mod(){
        $this->load->model('Android_Model');
        $payemt_date_time_1=$this->input->post('order_date_time');
		$payment_date_time=date('Y-m-d H:i:s', strtotime($payemt_date_time_1));
	    $customer_id=$this->input->post('cus_id');
	    $user_id=$this->input->post('user_id');
	    $total_paid_amount=$this->input->post('total_paid_amount');
	    $payment_type=$this->input->post('payment_type');
	    $cheque_no=$this->input->post('cheque_no');
	    $received_date=$this->input->post('received_date');
	    $realised_date=$this->input->post('realised_date');
	    $payment_invoices=$this->input->post('invoices');
	    $warehouse_id=$this->input->post('warehouse_id');
	    $bank_id=$this->input->post('bank_id');
	    $tracking_id=$this->input->post('payment_tracking_id');
	    $system_datetime_created=date('Y-m-d H:i:s');
		$error='';
		$disMsg='';
		$lastid='';
		$sale_id='';
		$delivery=	'';
		$area_id=	'';
		$payment_invoices=stripslashes($payment_invoices);
		$invoice_list = json_decode($payment_invoices);
		if(!$error){
			$data=array(
				'customer_id'=>$customer_id,
				'smp_amount'=>$total_paid_amount,
				'smp_added_date'=>$system_datetime_created,
				'user_id'=>$user_id,
				'warehouse_id'=>$warehouse_id,
				'bank_id'=>$bank_id,
				'payment_ref_no'=>$cheque_no,
				'payment_type'=>$payment_type,
				'payment_date'=>$payment_date_time,
				'ref_no'=>$tracking_id,
				'collector_id'=>$user_id,
			);
			$cash_payning_by="Cash";
			if($payment_type==2){$cash_payning_by="Cheque";}
			$this->Android_Model->save_backup_payment($data);
            $smp_id  = $this->db->insert_id(); 
			$disMsg='Payment successfully added';
			//insert sale item data
			foreach($invoice_list as $key=>$row){
			    foreach($row as $obj){
			        $data_item=array(
    				'sale_id' => $obj->order_no,
                    'sale_pymnt_amount' =>$obj->payment_allocation,
                    'sale_pymnt_paying_by' => $cash_payning_by,
                    'user_id' => $user_id,
					'bank_id' => $bank_id,
                    'sale_pymnt_added_date_time' => $system_datetime_created,
                    'sale_payment_type' => 'sale',
                    'sale_pymnt_cheque_no' => $cheque_no,
                    'sale_pymnt_date_time' => $payment_date_time,
                    'smp_id' => $smp_id,
    				);
    				 $this->Android_Model->save_backup_payment_items($data_item);
			    }
			}
		}else {
			
			$disMsg='Please select these before adding any product:'.$disMsg;
		}		
        $st = array(
                'status' => 1,
                'msg' => $disMsg,
                'data' => "done"
        );
        echo json_encode($st);
    }
    
    
    
     public function get_all_product_list()
    {
        $this->load->model('Android_Model');
        $this->load->model('Marketing_Delivery_Model');
        $this->load->model('Customer_Order_Process_Model');
        $user_id      = $this->input->post('user_id');
        $user_currunt = $this->Android_Model->get_user_active_delivery($user_id);
        $area_id      = -5;
        $delivery_id  = -5;
        if (isset($user_currunt['id'])) {
            $area_id     = $user_currunt['area_id'];
            $delivery_id = $user_currunt['id'];
        }
        $product_list       = $this->Customer_Order_Process_Model->get_all_product_list();
        $data             = array();
        foreach ($product_list as $row) {
            $nested_date = array(
                'product_id' => $row['product_id'],
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'product_cash_price' => $row['product_price'],
                'product_credit_price' => $row['credit_salling_price'],
                'product_wholesale_price' => $row['wholesale_price'],
                'product_cost' => $row['product_cost'],
                'batch_id'=>1,
                'delivery_id'=>$delivery_id,
            );
            $data[]      = $nested_date;
        }
        $message="product list for customer sales return";
        if($delivery_id==(-5)){
            $data=array();
            $message="user not not have ongoing delivery";
        }
        
        
        $json_array = array(
            'order_item_list' => $data,
            'message' => $message,
        );
        echo json_encode($json_array);
    }
    
    
    function get_batch_product_list(){
        $data=array();
        $product_list=$this->Android_Model->get_product_list();
        foreach ($product_list as $row) {
            $nested_date = array(
                'product_id' => $row['product_id'],
                'batch_id' => $row['product_id'],
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'product_cash_price' => $row['product_price'],
                'product_credit_price' => $row['credit_salling_price'],
                'product_wholesale_price' => $row['wholesale_price'],
                'retail_wholesale' => $row['retail_wholesale'],
                'product_cost' => $row['product_cost'],
                'is_batch_validate'=>$row['is_batch_validate'],
                'stock'=>100,
            );
            $data[]      = $nested_date;
            
        }
        echo json_encode($data);
    }
    
    
    
   
    
    
    
}