<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');
class Delivery_Invoice extends CI_Controller {
    var $main_menu_name = "delivery";
    var $sub_menu_name = "price_management";
    private $main_model;
    public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('Common_Model');
        $this->load->model('Order_Model');
        $this->load->model('Delivery_Invoice_Model');
        $this->load->model('User_Model');
        $this->load->model('Customer_Model');
        $this->load->model('Warehouse_Model');
        $this->load->model('Product_Models');
        $this->load->model('Stock_Counter_Model');
    }
    public function index() {
        show_404();
    }
    function new_delivery_invoice() {
        $this->load->model('Sys_Settings_Model');
        $this->load->model('In_Type_Model');
        $this->load->model('Dispatch_Model');
        $id = $this->input->get('id');
        $data['main_menu_name'] = 'delivery';
        $data['sub_menu_name'] = 'new_delivery_invoice';
        $setting_data = $this->Sys_Settings_Model->get_sys_setting_info(1);
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['invoice_type_list'] = $this->In_Type_Model->get_active_in_types();
        $data['dispatch'] = $this->Dispatch_Model->get_all_dipatch_details($id);
        $data['payment_term_list'] = $this->Order_Model->peyment_term();
        if ($setting_data['system_setting_status'] == 0) {
            $this->load->view('order/not_permited', $data);
        } else {
            $this->load->view('delivery_invoice/add_del_inv_master', $data);
        }
    }
    public function get_customer_dynamic() {
        $str = $this->input->post('search_string');
        $area_id = $this->input->post('area_id');
        $result = $this->Customer_Model->get_customer_with_area_for_ajex($str, $area_id);
        echo json_encode($result);
    }
    public function save_delivery_invoice_master() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('warehouse_id', 'WAREHOUSE', 'required|xss_clean');
        $this->form_validation->set_rules('dpn_sale_rep_id', 'SALES REPRESENTATIVE', 'required|xss_clean');
        $this->form_validation->set_rules('customer_id', 'CUSTOMER', 'required|xss_clean');
        $this->form_validation->set_rules('ref_no', 'Ref No', 'xss_clean|required|is_unique[sales.card_ref_number]');
        $this->form_validation->set_rules('odr_type', 'INVOICE TYPE', 'required|xss_clean');
        $this->form_validation->set_rules('note', 'Quntity', 'max_length[500]|xss_clean');
        //$this->form_validation->set_rules('odr_price_type_id', 'PRICE TYPE', 'required|xss_clean');
        $this->form_validation->set_rules('is_delivery_charge', 'LOADING CHARGE', 'required|xss_clean');
        $this->form_validation->set_rules('pay_term_id', 'PAYMENT TERM', 'required|xss_clean');
        $this->form_validation->set_rules('delivery_charge', 'DELIVERY CHARGE', 'xss_clean');
        $this->form_validation->set_rules('delivery_id', 'DELIVERY', 'required|xss_clean');
        $this->form_validation->set_rules('dispatch_id', 'DISPATCH', 'required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $warehouse_id = $this->input->post('warehouse_id');
            $sale_rep_id = $this->input->post('dpn_sale_rep_id');
            $customer_id = $this->input->post('customer_id');
            //$odr_price_type_id=$this->input->post('odr_price_type_id');
            $delivery_id = $this->input->post('delivery_id');
            $dispatch_id = $this->input->post('dispatch_id');
            $ref_no = $this->input->post('ref_no');
            $note = $this->input->post('note');
            $odr_type = $this->input->post('odr_type');
            $is_delivery_charge = $this->input->post('is_delivery_charge');
            $pay_term_id = $this->input->post('pay_term_id');
            $delivery_charge = $this->input->post('delivery_charge');
            $customer_data = $this->Customer_Model->get_customer_info($customer_id);
            $odr_price_type_id = $customer_data['price_type'];
            $payment_date_count = $this->Delivery_Invoice_Model->get_payment_term_date_count($pay_term_id);
            $data = array('warehouse_id' => $warehouse_id, 'delivery_charge' => $delivery_charge, 'sales_rep_id' => $sale_rep_id, 'customer_id' => $customer_id, 'card_ref_number' => $ref_no, 'bill_no' => $ref_no, 'sale_note' => $note, 'invoice_type' => $odr_type, 'price_type' => $odr_price_type_id, 'sale_reference_no' => $this->Common_Model->gen_ref_number('sale_id', 'sales', 'INV'), 'user' => $this->session->userdata('ss_user_id'), 'invoice_date_time' => date("Y-m-d H:i:s"), 'sale_datetime_created' => date("Y-m-d H:i:s"), 'sale_datetime' => date("Y-m-d H:i:s"),
            //'is_delivery_charge'=>$is_delivery_charge,
            'paymet_term_id' => $pay_term_id, 'due_date' => date('Y-m-d', strtotime("+" . $payment_date_count . " days", strtotime(date("Y-m-d")))), 'delivery_id' => $delivery_id, 'dpn_id' => $dispatch_id, 'invoice_generate_type' => 3, 'sale_status' => 1, 'paymet_term_days' => $payment_date_count);
            $result = $this->Delivery_Invoice_Model->save_master($data);
            $status = 0;
            if ($result > 0) {
                $status = 1;
            }
            $retun_data = array('result' => $result, 'status' => $status,);
            echo json_encode($retun_data);
        }
    }
    function add_delivery_invoice_items() {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name'] = $this->sub_menu_name;
        $data['odr_id'] = $this->input->get('id');
        $data['details'] = $this->Delivery_Invoice_Model->get_sale_info($data['odr_id']);
        $this->load->view('delivery_invoice/add_del_inv_items', $data);
    }
    public function get_product_dynamic() {
        $str = $this->input->post('search_string');
        $dpn_id = $this->input->post('dpn_id');
        $result = $this->Delivery_Invoice_Model->get_search_products($str, $dpn_id);
        $data = array();
        foreach ($result as $row) {
            $issue_stock = $this->Delivery_Invoice_Model->get_bulk_issue_qty($dpn_id, $row->product_id);
            $invoice_stock = $this->Delivery_Invoice_Model->get_bulk_invoice_qty($dpn_id, $row->product_id);
            $nsested_data = array('product_id' => $row->batch_id, 'product_code' => $row->product_code, 'product_name' => $row->product_name, 'stock' => $issue_stock - $invoice_stock);
            $data[] = $nsested_data;
        }
        echo json_encode($data);
    }
    public function save_delivery_invoice_item() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('product_id', 'Product', 'trim|required|xss_clean');
        $this->form_validation->set_rules('odr_id', 'Main ', 'trim|required|xss_clean');
        $this->form_validation->set_rules('req_qty', 'Quntity', 'trim|required|greater_than[0]|xss_clean');
        $this->form_validation->set_rules('price_type', 'Price type', 'trim|required|greater_than[0]|xss_clean');
        $this->form_validation->set_rules('dpn_id', 'DISATCH ', 'trim|required|xss_clean');
        $this->form_validation->set_rules('customer_id', 'CUSTOMER ', 'trim|required|xss_clean');
        $manual_entry = $this->input->post('manual_entry');
        if ($manual_entry == 1) {
            $this->form_validation->set_rules('manual_collectble_price', 'COLLECTBLE PRICE', 'trim|required|greater_than[0]|xss_clean');
            $this->form_validation->set_rules('manual_claimble_price', 'CLAIMBLE PRICE ', 'trim|required|greater_than[0]|xss_clean');
        }
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $batch_id = $this->input->post('product_id');
            $odr_id = $this->input->post('odr_id');
            $req_qty = $this->input->post('req_qty');
            $price_type = $this->input->post('price_type');
            $price_important = $this->input->post('price_important');
            $dpn_id = $this->input->post('dpn_id');
            $delivery_id = $this->input->post('delivery_id');
            $customer_id = $this->input->post('customer_id');
            $is_free = $this->input->post('is_free');
            $as_package = $this->input->post('as_package');
            $manual_collectble_price = $this->input->post('manual_collectble_price');
            $manual_claimble_price = $this->input->post('manual_claimble_price');
            $product_batch_details = $this->Delivery_Invoice_Model->get_product_batch_details($dpn_id, $batch_id);
            $customer_details = $this->Delivery_Invoice_Model->get_customer_details($customer_id);
            $product_details = $this->Delivery_Invoice_Model->get_product_details($product_batch_details['product_id']);
            //normal price procedure
            $price = 0;
            $manual_entry_item=0;
            if ($price_type == 1) {
                $price = $product_batch_details['product_price'];
            }
            if ($price_type == 2) {
                $price = $product_batch_details['credit_salling_price'];
            }
            if ($price_type == 3) {
                $price = $product_batch_details['wholesale_price'];
            }
            if ($price_type == 4) {
                $price = $product_batch_details['retail_wholesale'];
            }
           
            $is_free_issue = 0;
            $invoice_price = $product_batch_details['credit_salling_price'];
            if ($price_type == 3) {
                $invoice_price = $product_batch_details['product_price'];
            }
            if ($price_type == 2) {
                $invoice_price = $product_batch_details['credit_salling_price'];
            }
            if ($price_type == 1) {
                $invoice_price = $product_batch_details['product_price'];
            }
            $claimble_value = ($invoice_price - $price) * $req_qty;
            $collectable_value = ($invoice_price * $req_qty) - $claimble_value;
            //manual proceeder
            if ($manual_entry == 1) {
            //******************************************
            $invoice_price = $manual_collectble_price + $manual_claimble_price;
            $collectable_value = $manual_collectble_price * $req_qty;
            $claimble_value = $manual_claimble_price * $req_qty;
            $manual_entry_item=1;
            //*****************************************
            }
            $cost = $product_batch_details['product_cost'];
            $count = $this->Delivery_Invoice_Model->check_already_added($product_batch_details['product_id'], $odr_id);
            //free issue procedure
            $free_status = '';
            if ($is_free == 1) {
                if (!($customer_details['free_issue'] == $product_details['is_free_issue_item'])) {
                    $st = array('status' => 0, 'validation' => 'NOT VALID FREE ISSUE !');
                    $this->update_sale_table_total($odr_id);
                    echo json_encode($st);
                    return false;
                }
                $cost = $product_batch_details['product_cost'];
                $invoice_price = $product_batch_details['credit_salling_price'];
                $claimble_value = ($cost) * $req_qty;
                $collectable_value = (($invoice_price - $cost) * $req_qty);
                $count = 0;
                $is_free_issue = 1;
                //manual proceeder
                if ($manual_entry == 1) {
                //******************************************
                $invoice_price = $manual_collectble_price + $manual_claimble_price;
                $collectable_value = $manual_collectble_price * $req_qty;
                $claimble_value = $manual_claimble_price * $req_qty;
                $manual_entry_item=1;
                //*****************************************
                }
            }
            //new package procedure
            //new product item select//
            if ($as_package == 1) {
                $exchange_price = 0;
                $exchange_product_details = $this->Delivery_Invoice_Model->exchange_product_details($product_batch_details['excchange_id']);
                //this part is cheaking cilinder price//
                if ($price_type == 1) {
                    $exchange_price = $exchange_product_details['product_price'];
                }
                if ($price_type == 2) {
                    $exchange_price = $exchange_product_details['credit_salling_price'];
                }
                if ($price_type == 3) {
                    $exchange_price = $exchange_product_details['credit_salling_price'];
                }
                if ($price_type == 4) {
                    $exchange_price = $exchange_product_details['credit_salling_price'];
                }
                //this part is cheaking cilinder price//
                if ($price_type == 1) {
                    $invoice_price = $product_batch_details['product_price'];
                }
                if ($price_type == 2) {
                    $invoice_price = $product_batch_details['credit_salling_price'];
                }
                if ($price_type == 3) {
                    $invoice_price = $product_batch_details['credit_salling_price'];
                }
                if ($price_type == 4) {
                    $invoice_price = $product_batch_details['credit_salling_price'];
                }
                $invoice_price+= $exchange_price;
                $claimble_value = 0;
                $collectable_value = ($invoice_price * $req_qty);
                $count = 0;
                //manual proceeder
                if ($manual_entry == 1) {
                //******************************************
                $invoice_price = $manual_collectble_price + $manual_claimble_price;
                $collectable_value = $manual_collectble_price * $req_qty;
                $claimble_value = $manual_claimble_price * $req_qty;
                $manual_entry_item=1;
                //*****************************************
                }
                $cost = $product_batch_details['product_cost'];
                $exchange_cost = $exchange_product_details['product_cost'];
                $cost+= $exchange_cost;
                
            }
            /*testing & finish  the part 2023-11-23 thilini */
            if ($count > 0) {
                $st = array('status' => 0, 'validation' => 'Item Already Added !');
                echo json_encode($st);
                return false;
            }
            if ($manual_entry == 1) {
                $master_data=array('is_manual_entry'=>1);
                $this->Delivery_Invoice_Model->update_master($odr_id, $master_data); 
            }
            $data = array('sale_id' => $odr_id, 'product_id' => $product_batch_details['product_id'], 'quantity' => $req_qty, 'unit_price' => $invoice_price, 'net_price' => $invoice_price, 'item_cost' => $cost, 'total_item_cost' => $cost * $req_qty, 'gross_total' => $invoice_price * $req_qty, 'net_total' => $invoice_price * $req_qty, 'batch_id' => $batch_id, 'delivery_id' => $delivery_id, 'dpn_id' => $dpn_id, 'cus_default_price' => $price, 'collectable_value' => $collectable_value, 'claimble_value' => $claimble_value, 'is_free_issue' => $is_free_issue, 'as_package' => $as_package,'manual_entry_item'=>$manual_entry_item);
            $result = $this->Delivery_Invoice_Model->save_item($data);
            $st = array('status' => 1, 'validation' => 'Item has been added');
            $this->update_sale_table_total($odr_id);
            echo json_encode($st);
        }
    }
    function update_sale_table_total($sale_id) {
        $result = $this->Delivery_Invoice_Model->get_sale_totals($sale_id);
        if ($result != false) {
            $data = array('sale_inv_gross_total' => $result['gross_total'], 'sale_inv_total' => $result['net_total'], 'sale_total' => $result['net_total'], 'cost_total' => $result['total_item_cost'], 'total_collectble' => $result['collectable_value'], 'total_cliamble' => $result['claimble_value'],);
            $result = $this->Delivery_Invoice_Model->update_master($sale_id, $data);
        } else {
            $data = array('sale_inv_gross_total' => 0, 'sale_inv_total' => 0, 'sale_total' => 0, 'cost_total' => 0, 'total_collectble' => 0, 'total_cliamble' => 0,);
            $result = $this->Delivery_Invoice_Model->update_master($sale_id, $data);
        }
    }
    public function get_delivery_invoice_item_list() {
        $id = $this->input->get('id');
        $values = $this->Delivery_Invoice_Model->get_delivery_invoice_product_list($id);
        $totalData = count($values);
        $totalFiltered = $totalData;
        $data = array();
        foreach ($values as $row) {
            $free_status = '';
            if ($row['is_free_issue'] == 1) {
                $free_status = ' <span class="btn btn-xs btn-warning">FREE</span>';
            }
            $update_price = '';
            $nestad_data = array();
            $nestad_data[] = $row['product_code'];
            $nestad_data[] = $row['product_name'];
            $nestad_data[] = $row['unit_code'];
            //$nestad_data[]  = $row['uom_cost'];
            $nestad_data[] = $row['unit_price'];
            $nestad_data[] = $row['quantity'];
            $nestad_data[] = $row['collectable_value'];
            $nestad_data[] = $row['claimble_value'];
            $nestad_data[] = $row['net_total'];
            
            $subject_to_auth='';
            if($row['manual_entry_item']==1){
                $subject_to_auth=' <span class="btn btn-xs btn-danger"> <i class="fa fa-exclamation-triangle" aria-hidden="true"></i></span>';
            }
            $remove_button = ' <button type="button" class="btn btn-danger btn-xs" data-toggle="tooltip" data-placement="bottom" title="Remove This Item"  onClick="delete_item_block(' . $row['id'] . ')"><i class="fa fa-trash-o" aria-hidden="true"> Remove</i></button> ';
            $edit_qty_button = ''; //' <button type="button" class="btn btn-primary btn-xs" data-toggle="tooltip" data-placement="bottom" title="Edit Quantity" onClick="update_aloacted_qty('.$row['odri_id'].')" ><i class="fa fa-pencil-square-o" aria-hidden="true"> Qty</i></button> ';
            $action = '';
            $action.= $edit_qty_button . $remove_button . $update_price . $free_status.$subject_to_auth;
            $nestad_data[] = $action;
            $data[] = $nestad_data;
        }
        $output = array('data' => $data, "recordsTotal" => intval($totalData), "recordsFiltered" => intval($totalFiltered));
        echo json_encode($output);
    }
    function delete_delivery_invoice_item() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $id = $this->input->post('id');
            $result = $this->Delivery_Invoice_Model->delete_item($id);
            $st = array('status' => 1, 'validation' => 'Added');
            echo json_encode($st);
        }
    }
    function final_invoice() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $id = $this->input->post('id');
            $this->update_sale_table_total($id);
            $data = array('sale_status' => 1,);
            $result = $this->Delivery_Invoice_Model->update_master($id, $data);
            $sale_data = $this->Delivery_Invoice_Model->get_sale_info($id);
            $st = array('status' => 1, 'validation' => 'FINALED', 'delivery_id' => $sale_data['delivery_id']);
            echo json_encode($st);
        }
    }
    public function save_delivery_invoice_item_exchange() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('product_id_ex', 'Product', 'trim|required|xss_clean');
        $this->form_validation->set_rules('odr_id_ex', 'Main ', 'trim|required|xss_clean');
        $this->form_validation->set_rules('req_qty_ex', 'Quntity', 'trim|required|greater_than[0]|xss_clean');
        $this->form_validation->set_rules('price_type_ex', 'Price type', 'trim|required|greater_than[0]|xss_clean');
        $this->form_validation->set_rules('dpn_id_ex', 'DISATCH ', 'trim|required|xss_clean');
        $this->form_validation->set_rules('delivery_id_ex', 'DELIVERY ', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $batch_id = $this->input->post('product_id_ex');
            $odr_id = $this->input->post('odr_id_ex');
            $req_qty = $this->input->post('req_qty_ex');
            $price_type = $this->input->post('price_type_ex');
            $price_important = $this->input->post('price_important_ex');
            $dpn_id = $this->input->post('dpn_id_ex');
            $delivery_id = $this->input->post('delivery_id_ex');
            $product_details = $this->Delivery_Invoice_Model->get_product_by_batch_id($batch_id);
            $count = $this->Delivery_Invoice_Model->check_already_added_exchange($product_details['product_id'], $odr_id);
            if ($count > 0) {
                $st = array('status' => 0, 'validation' => 'Item Already Added !');
                echo json_encode($st);
                return false;
            }
            $data = array('sale_id' => $odr_id, 'product_id' => $product_details['product_id'], 'collect_qty' => $req_qty, 'batch_id' => $batch_id, 'delivery_id' => $delivery_id, 'dpn_id' => $dpn_id);
            $result = $this->Delivery_Invoice_Model->save_sub_item($data);
            $st = array('status' => 1, 'validation' => 'Added');
            $this->update_sale_table_total($odr_id);
            echo json_encode($st);
        }
    }
    public function get_delivery_invoice_item_list_exchange() {
        $id = $this->input->get('id');
        $values = $this->Delivery_Invoice_Model->get_delivery_invoice_product_list_exchange($id);
        $totalData = count($values);
        $totalFiltered = $totalData;
        $data = array();
        foreach ($values as $row) {
            $update_price = '';
            $nestad_data = array();
            $nestad_data[] = $row['product_code'];
            $nestad_data[] = $row['product_name'];
            $nestad_data[] = $row['unit_code'];
            //$nestad_data[]  = $row['uom_cost'];
            // $nestad_data[]  = $row['unit_price'];
            $nestad_data[] = $row['collect_qty'];
            //$nestad_data[]  =$row['net_total'];
            $remove_button = ' <button type="button" class="btn btn-danger btn-xs" data-toggle="tooltip" data-placement="bottom" title="Remove This Item"  onClick="delete_sub_item_block(' . $row['sci_id'] . ')"><i class="fa fa-trash-o" aria-hidden="true"> Remove</i></button> ';
            $edit_qty_button = ''; //' <button type="button" class="btn btn-primary btn-xs" data-toggle="tooltip" data-placement="bottom" title="Edit Quantity" onClick="update_aloacted_qty('.$row['odri_id'].')" ><i class="fa fa-pencil-square-o" aria-hidden="true"> Qty</i></button> ';
            $action = '';
            $action.= $edit_qty_button . $remove_button . $update_price;
            $nestad_data[] = $action;
            $data[] = $nestad_data;
        }
        $output = array('data' => $data, "recordsTotal" => intval($totalData), "recordsFiltered" => intval($totalFiltered));
        echo json_encode($output);
    }
    function delete_delivery_invoice_item_exchange() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $id = $this->input->post('id');
            $result = $this->Delivery_Invoice_Model->delete_sub_item($id);
            $st = array('status' => 1, 'validation' => 'deleted');
            echo json_encode($st);
        }
    }
    //uncheceked functions
    public function get_user_dynamic() {
        $str = $this->input->post('search_string');
        $result = $this->User_Model->get_user_for_ajex($str, 4);
        echo json_encode($result);
    }
    public function get_order_price_type_dynamic() {
        $str = $this->input->post('search_string');
        $odr_type = $this->input->post('order_type');
        $warehouse_id = $this->input->post('warehouse_id');
        if (!$odr_type) {
            $odr_type = 0;
        }
        $result = $this->Order_Model->get_search_order_price_type($str, $odr_type, $warehouse_id);
        echo json_encode($result);
    }
    public function save_order_item() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('product_id', 'Product', 'trim|required|xss_clean');
        $this->form_validation->set_rules('odr_id', 'Main ', 'trim|required|xss_clean');
        $this->form_validation->set_rules('req_qty', 'Quntity', 'trim|required|greater_than[0]|xss_clean');
        $this->form_validation->set_rules('price_type', 'Price type', 'trim|required|greater_than[0]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $product_id = $this->input->post('product_id');
            $odr_id = $this->input->post('odr_id');
            $req_qty = $this->input->post('req_qty');
            $price_type = $this->input->post('price_type');
            $price_important = $this->input->post('price_important');
            $is_batch_validate = $this->Order_Model->check_product_batch_validation($product_id);
            if ($is_batch_validate == 1) {
                $batch_list = $this->Order_Model->get_active_batch_list($product_id);
                $data = array();
                $batch_stock = array();
                $selected_batch = '';
                $count = 0;
                foreach ($batch_list as $bl) {
                    $count++;
                    if ($count == 1) {
                        $selected_batch = $bl['batch_id'];
                    }
                    $stock = $this->Stock_Counter_Model->get_availble_stock_for_invoicing_and_order('', $product_id, $bl['batch_id']);
                    $price = 0;
                    if ($price_type == 1) {
                        $price = $bl['product_price'];
                    }
                    if ($price_type == 2) {
                        $price = $bl['credit_salling_price'];
                    }
                    if ($price_type == 3) {
                        $price = $bl['wholesale_price'];
                    }
                    if ($price_type == 4) {
                        $price = $bl['retail_wholesale'];
                    }
                    $nesteddata = array('text' => "RS. " . $price . " -- STOCK : " . $stock . " -- BATCH NO : " . $bl['batch_ref_number'], 'value' => $bl['batch_id']);
                    $data[] = $nesteddata;
                    $nested_batch_data = array('batch_id' => $bl['batch_id'], 'stock' => $stock);
                    $batch_stock[] = $nested_batch_data;
                }
                $st = array('status' => 2, 'validation' => 'batch list', 'batch_list' => $data, 'selected_batch' => $selected_batch, 'batch_stock' => $batch_stock, 'request_qry' => $req_qty);
                echo json_encode($st);
                return;
            }
            $count = $this->Order_Model->check_already_added($product_id, $odr_id);
            if ($count > 0) {
                $st = array('status' => 0, 'validation' => 'Item Already Added !');
                echo json_encode($st);
                return false;
            }
            $price_cost = $this->Order_Model->get_order_product_price_cost($product_id);
            $price = 0;
            if ($price_type == 1) {
                $price = $price_cost['product_price'];
            }
            if ($price_type == 2) {
                $price = $price_cost['credit_salling_price'];
            }
            if ($price_type == 3) {
                $price = $price_cost['wholesale_price'];
            }
            if ($price_type == 4) {
                $price = $price_cost['retail_wholesale'];
            }
            $cost = $price_cost['product_cost'];
            $data = array('odr_id' => $odr_id, 'product_id' => $product_id, 'request_qty' => $req_qty, 'approved_qty' => $req_qty, 'uom_price' => $price, 'uom_cost' => $cost, 'total_price' => $price * $req_qty, 'total_cost' => $cost * $req_qty, 'price_important' => $price_important, 'original_uom_price' => $price);
            $result = $this->Order_Model->save_order_item($data);
            $st = array('status' => 1, 'validation' => 'Added');
            echo json_encode($st);
        }
    }
    public function update_order_product_price() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
        $this->form_validation->set_rules('result', 'PRICE ', 'trim|required|greater_than[0]|xss_clean');
        $this->form_validation->set_rules('qty', 'QTY ', 'trim|required|greater_than[0]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $id = $this->input->post('id');
            $result = $this->input->post('result');
            $qty = $this->input->post('qty');
            $data = array('uom_price' => $result, 'total_price' => $result * $qty, 'price_edit_status' => 1, 'price_edit_by' => $this->session->userdata('ss_user_id'), 'price_edit_on' => date("Y-m-d H:i:s"));
            $result = $this->Order_Model->update_order_item($id, $data);
            $st = array('status' => 1, 'validation' => 'Added');
            echo json_encode($st);
        }
    }
    public function update_order_product_qty() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'trim|required|xss_clean');
        $this->form_validation->set_rules('result', 'PRICE ', 'trim|required|greater_than[0]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $id = $this->input->post('id');
            $result = $this->input->post('result');
            $price_cost = $this->Order_Model->get_order_item_price_cost($id);
            $data = array('request_qty' => $result, 'approved_qty' => $result, 'total_price' => $price_cost['uom_price'] * $result, 'total_cost' => $price_cost['uom_cost'] * $result,);
            $result = $this->Order_Model->update_order_item($id, $data);
            $st = array('status' => 1, 'validation' => 'Added');
            echo json_encode($st);
        }
    }
    function list_orders() {
        $data['main_menu_name'] = 'order';
        $data['sub_menu_name'] = 'list_orders';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('order/list_orders', $data);
    }
    public function get_order_list($value = '') {
        $search_key = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->get('start');
        $length = $this->input->get('length');
        $warehouse_id = $this->input->get('warehouse_id');
        $customer_id = $this->input->get('customer_id');
        $sale_rep_id = $this->input->get('sale_rep_id');
        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
        }
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
        }
        $totalData = 0;
        $values = $this->Order_Model->get_order_list($start, $length, $search_key_val, $warehouse_id, $customer_id, $sale_rep_id, $srh_from_date, $srh_to_date);
        $value_count = $this->Order_Model->get_order_list('', '', '', $warehouse_id, $customer_id, $sale_rep_id, $srh_from_date, $srh_to_date);
        if ($search_key_val) {
            $values_c = $this->Order_Model->get_order_list('', '', $search_key_val, $warehouse_id, $customer_id, $sale_rep_id, $srh_from_date, $srh_to_date);
            $totalData = 100;
        }
        $totalData = $value_count;
        $totalFiltered = $totalData;
        $data = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row = array();
                $status = '<span class=" btn btn-xs btn-primary"> DRAFT</sapn>';
                if ($products->odr_status == 1) {
                    $status = '<span class=" btn btn-xs btn-success"> COMPLETED</sapn>';
                }
                $pickup_note = "";
                if ($products->pickup_status == 0 && $products->invoice_status == 0) {
                    $pickup_note = "To be assign to delivery.";
                }
                if ($products->pickup_status == 1 && $products->invoice_status == 0) {
                    $pickup_note = "Assigned to delivery on : " . $products->pickup_date_time;
                }
                $delivery_note = "";
                if ($products->pickup_status == 1 && $products->invoice_status == 1) {
                    $delivery_note = " Delivery completed on : " . $products->invoice_on;
                }
                $tooltip = $pickup_note . $delivery_note;
                if (!$products->dpn_ref_no) {
                    $tooltip = "Dispatch Note Not Generated";
                }
                $row[] = $products->added_date_time;
                $row[] = $products->odr_ref_no . " " . $products->odr_manual_ref_no;
                $row[] = ' <span data-toggle="tooltip" title="' . $tooltip . '" class="fa fa-btn btn-info"> <i class="fa fa-info-circle"> </i> </span> ' . $products->dpn_ref_no;
                $row[] = $products->sale_reference_no;
                $row[] = $products->cus_code;
                $row[] = $products->cus_name;
                $row[] = $products->user_first_name;
                $row[] = $status;
                $row[] = $products->mas_name;
                $row[] = $products->approval_user_first_name . " " . $products->approval_user_last_name;
                //$row[]               = $products->approval_date_time;//$products->brm_note;
                $actdes = '';
                $option_order_details = '<li><a href="' . base_url('order/order_details') . '?id=' . $products->odr_id . '"><i class="fa fa-file-o"></i> DETAILS</a></li>';
                $update_action = '<li><a href="' . base_url('order/add_order_items') . '?id=' . $products->odr_id . '"><i class="fa fa-pencil-square-o"></i> UPDATE</a></li>';
                $action_option = '';
                if ($products->odr_approval_status == 1 || $products->odr_status == 1) {
                    $action_option = $option_order_details;
                } else {
                    $action_option = $option_order_details . $update_action;
                }
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            ' . $action_option . '</ul></div>                      ';
                $row[] = $actdes;
                $data[] = $row;
            }
            $output = array('data' => $data, "recordsTotal" => intval($totalData), "recordsFiltered" => intval($totalFiltered));
            echo json_encode($output);
        } else {
            $output = array('data' => '');
            echo json_encode($output);
        }
    }
    function approval_orders() {
        $data['main_menu_name'] = 'order';
        $data['sub_menu_name'] = 'approval_orders';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('order/approval_list_order', $data);
    }
    public function get_order_approval_pending_list($value = '') {
        $search_key = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->get('start');
        $length = $this->input->get('length');
        $warehouse_id = $this->input->get('warehouse_id');
        $customer_id = $this->input->get('customer_id');
        $sale_rep_id = $this->input->get('sale_rep_id');
        $totalData = 0;
        $values = $this->Order_Model->get_order_approval_pending_list($start, $length, $search_key_val, $warehouse_id, $customer_id, $sale_rep_id);
        $value_count = $this->Order_Model->get_order_approval_pending_list('', '', '', $warehouse_id, $customer_id, $sale_rep_id);
        if ($search_key_val) {
            $values_c = $this->Order_Model->get_order_approval_pending_list('', '', $search_key_val, $warehouse_id, $customer_id, $sale_rep_id);
            $totalData = 100;
        }
        $totalData = $value_count;
        $totalFiltered = $totalData;
        $data = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row = array();
                $status = '<span class=" btn btn-xs btn-primary"> DRAFT</sapn>';
                if ($products->odr_status == 1) {
                    $status = '<span class=" btn btn-xs btn-success"> COMPLETED</sapn>';
                }
                $row[] = $products->added_date_time;
                $row[] = $products->odr_ref_no;
                $row[] = $products->odr_manual_ref_no;
                $row[] = $products->cus_code;
                $row[] = $products->cus_name;
                $row[] = $products->user_first_name . " " . $products->user_last_name;
                $row[] = $status;
                $row[] = $products->mas_name;
                $row[] = $products->approval_user_first_name . " " . $products->approval_user_last_name;
                $row[] = $products->approval_date_time; //$products->brm_note;
                $actdes = '';
                $option_order_details = '<li><a href="' . base_url('order/management_order_details') . '?id=' . $products->odr_id . '"><i class="fa fa-file-o"></i> VIEW & APPROVAL</a></li>';
                $update_action = '<li><a href="' . base_url('order/add_order_items') . '?id=' . $products->odr_id . '"><i class="fa fa-pencil-square-o"></i> UPDATE</a></li>';
                $option_order_approval = '<li><a style="cursor: pointer;" onclick="approval_requste(' . $products->odr_id . ')"><i class="glyphicon fa fa-check"></i> APPROVAL</a></li>';
                $option_reject = ' <li><a style="cursor: pointer;" onclick="reject_request(' . $products->odr_id . ')"><i class="glyphicon fa fa-ban"></i> REJECT</a></li>';
                $action_option = '';
                if ($products->odr_approval_status == 1) {
                    $action_option = $option_order_details;
                } else {
                    $action_option = $option_order_details . $update_action . $option_order_approval . $option_reject;
                }
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            ' . $action_option . '</ul></div>                      ';
                $row[] = $actdes;
                $data[] = $row;
            }
            $output = array('data' => $data, "recordsTotal" => intval($totalData), "recordsFiltered" => intval($totalFiltered));
            echo json_encode($output);
        } else {
            $output = array('data' => '');
            echo json_encode($output);
        }
    }
    function grant_approval() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $id = $this->input->post('id');
            $data = array('odr_approval_status' => 1, 'approval_by' => $this->session->userdata('ss_user_id'), 'approval_date_time' => date("Y-m-d H:i:s"),);
            $this->Order_Model->update_order_master($id, $data);
            $st = array('status' => 1, 'validation' => 'Saved');
            echo json_encode($st);
        }
    }
    function reject_approval() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $id = $this->input->post('id');
            $data = array('odr_approval_status' => 2, 'approval_by' => $this->session->userdata('ss_user_id'), 'approval_date_time' => date("Y-m-d H:i:s"),);
            $this->Order_Model->update_order_master($id, $data);
            $st = array('status' => 1, 'validation' => 'Saved');
            echo json_encode($st);
        }
    }
    public function save_order_item_with_batch() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('product_id', 'Product', 'trim|required|xss_clean');
        $this->form_validation->set_rules('odr_id', 'Main ', 'trim|required|xss_clean');
        $this->form_validation->set_rules('req_qty', 'Quntity', 'trim|required|greater_than[0]|xss_clean');
        $this->form_validation->set_rules('price_type', 'Price type', 'trim|required|greater_than[0]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $batch_id = $this->input->get('id');
            $product_id = $this->input->post('product_id');
            $odr_id = $this->input->post('odr_id');
            $req_qty = $this->input->post('req_qty');
            $price_type = $this->input->post('price_type');
            $price_important = $this->input->post('price_important');
            $count = $this->Order_Model->check_already_added($product_id, $odr_id);
            if ($count > 0) {
                $st = array('status' => 0, 'validation' => 'Item Already Added !');
                echo json_encode($st);
                return false;
            }
            $price_cost = $this->Order_Model->get_batch_details($batch_id);
            $price = 0;
            if ($price_type == 1) {
                $price = $price_cost['product_price'];
            }
            if ($price_type == 2) {
                $price = $price_cost['credit_salling_price'];
            }
            if ($price_type == 3) {
                $price = $price_cost['wholesale_price'];
            }
            $cost = $price_cost['product_cost'];
            $data = array('odr_id' => $odr_id, 'product_id' => $product_id, 'request_qty' => $req_qty, 'approved_qty' => $req_qty, 'uom_price' => $price, 'uom_cost' => $cost, 'total_price' => $price * $req_qty, 'total_cost' => $cost * $req_qty, 'price_important' => 1, 'batch_id' => $batch_id, 'is_batch_validate' => 1, 'original_uom_price' => $price);
            $result = $this->Order_Model->save_order_item($data);
            $st = array('status' => 1, 'validation' => 'Added');
            echo json_encode($st);
        }
    }
    function order_details() {
        $data['main_menu_name'] = '';
        $data['sub_menu_name'] = '';
        $data['odr_id'] = $this->input->get('id');
        $data['details'] = $this->Order_Model->get_order_info($data['odr_id']);
        $this->load->view('order/order_details', $data);
    }
    public function get_order_item_details_list() {
        $id = $this->input->get('id');
        $values = $this->Order_Model->get_order_product_list($id);
        $totalData = count($values);
        $totalFiltered = $totalData;
        $data = array();
        foreach ($values as $row) {
            if ($row['price_important'] == 1) {
                $update_price = '<button type="button" class="btn btn-warning btn-xs" data-toggle="tooltip" data-placement="bottom" title="Edit UOM Price" onClick="update_product_price(' . $row['odri_id'] . ',' . $row['request_qty'] . ')" ><i class="fa fa-pencil-square-o" aria-hidden="true"> Price</i></button>';
            } else {
                $update_price = '';
            }
            $weight = $row['product_weight'] + 0;
            $request_qty = $row['request_qty'] + 0;
            $total_weight = $request_qty * $weight;
            $nestad_data = array();
            $nestad_data[] = $row['product_code'];
            $nestad_data[] = $row['product_name'];
            $nestad_data[] = $row['unit_code'];
            $nestad_data[] = $weight . "KG";
            //$nestad_data[]  = $row['uom_cost'];
            $nestad_data[] = number_format($row['uom_price'] / $row['product_weight'], 2, '.', ',');
            $nestad_data[] = number_format($row['uom_price'], 2, '.', ',');
            $nestad_data[] = $row['request_qty'] + 0;
            $nestad_data[] = $total_weight + 0;
            $nestad_data[] = number_format($row['total_price'], 2, '.', '');
            $action = '';
            if ($row['price_edit_status'] == 1) {
                $action = '<span class="btn btn-xs btn-warning">ITEM PRICE OVERRIDE BY USER </span><br>ORIGINAL ITEM PRICE Rs.' . $row['original_uom_price'] . "<br>ORIGINAL UOM WEIGHT PRICE Rs " . number_format($row['original_uom_price'] / $row['product_weight'], 2, '.', ',');
            }
            $nestad_data[] = $action;
            $data[] = $nestad_data;
        }
        $output = array('data' => $data, "recordsTotal" => intval($totalData), "recordsFiltered" => intval($totalFiltered));
        echo json_encode($output);
    }
    function management_order_details() {
        $data['main_menu_name'] = '';
        $data['sub_menu_name'] = '';
        $data['odr_id'] = $this->input->get('id');
        $data['details'] = $this->Order_Model->get_order_info($data['odr_id']);
        $this->load->view('order/management_order_details', $data);
    }
    function order_status() {
        $data['main_menu_name'] = 'order';
        $data['sub_menu_name'] = 'order_status';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('order/list_order_status', $data);
    }
    public function get_order_status_list($value = '') {
        $search_key = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->get('start');
        $length = $this->input->get('length');
        $warehouse_id = $this->input->get('warehouse_id');
        $customer_id = $this->input->get('customer_id');
        $sale_rep_id = $this->input->get('sale_rep_id');
        $srh_from_date = ''; //$this->input->get('srh_from_date');
        $srh_to_date = ''; //$this->input->get('srh_to_date');
        $odr_status = $this->input->get('odr_status');
        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
        }
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
        }
        $totalData = 0;
        $values = $this->Order_Model->get_order_list_with_invoice($start, $length, $search_key_val, $warehouse_id, $customer_id, $sale_rep_id, $srh_from_date, $srh_to_date);
        $value_count = $this->Order_Model->get_order_list_with_invoice('', '', '', $warehouse_id, $customer_id, $sale_rep_id, $srh_from_date, $srh_to_date);
        if ($search_key_val) {
            $values_c = $this->Order_Model->get_order_list_with_invoice('', '', $search_key_val, $warehouse_id, $customer_id, $sale_rep_id, $srh_from_date, $srh_to_date);
            $totalData = 100;
        }
        $totalData = $value_count;
        $totalFiltered = $totalData;
        $data = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row = array();
                $status = '<span class=" btn btn-xs btn-primary"> DRAFT</sapn>';
                if ($products->odr_status == 1) {
                    $status = '<span class=" btn btn-xs btn-success"> COMPLETED</sapn>';
                }
                $pickup_note = "";
                if ($products->pickup_status == 0 && $products->invoice_status == 0) {
                    $pickup_note = "To be assign to delivery. ";
                }
                if ($products->pickup_status == 1 && $products->invoice_status == 0) {
                    $pickup_note = "Assigned to delivery on : " . $products->pickup_date_time . " " . $products->d_ref_no;
                }
                $delivery_note = "";
                if ($products->pickup_status == 1 && $products->invoice_status == 1) {
                    $delivery_note = " Delivery completed on : " . $products->invoice_on . " " . $products->d_ref_no;
                }
                $tooltip = $pickup_note . $delivery_note;
                if (!$products->dpn_ref_no) {
                    $tooltip = "Dispatch Note Not Generated";
                }
                $delivery_return = '';
                if (($products->sale_total != $products->total_dpn_value) && ($products->sale_total > 0)) {
                    $delivery_return = '<span data-toggle="tooltip" title="Delivery Return  Detected : ' . ($products->total_dpn_value - $products->sale_total) . '" class="fa fa-btn btn-danger"> <i class="fa fa-info-circle"> </i> </span> ';
                }
                if ($odr_status == 1) {
                    if (!$products->dpn_ref_no) {
                    } else {
                        continue;
                    }
                }
                if ($odr_status == 2) {
                    if (($products->dpn_ref_no) && ($products->pickup_status == 0 && $products->invoice_status == 0)) {
                    } else {
                        continue;
                    }
                }
                if ($odr_status == 3) {
                    if ($products->pickup_status == 1 && $products->invoice_status == 0) {
                    } else {
                        continue;
                    }
                }
                if ($odr_status == 4) {
                    if ($products->pickup_status == 1 && $products->invoice_status == 1) {
                    } else {
                        continue;
                    }
                }
                $row[] = $products->added_date_time;
                $row[] = $products->odr_ref_no . " " . $products->odr_manual_ref_no;
                $row[] = $products->total_odr_price;
                $row[] = ' <!--<span data-toggle="tooltip" title="' . $tooltip . '" class="fa fa-btn btn-info"> <i class="fa fa-info-circle"> </i> </span>--> ' . $delivery_return . $products->dpn_ref_no;
                $row[] = $products->total_dpn_value;
                $row[] = $products->sale_reference_no;
                $row[] = $products->sale_total; //$products->brm_note;
                $row[] = $products->cus_code;
                $row[] = $products->cus_name;
                $row[] = $products->user_first_name;
                $row[] = $products->mas_name;
                $row[] = $tooltip;
                $actdes = '';
                $option_order_details = '<li><a href="' . base_url('order/order_details') . '?id=' . $products->odr_id . '"><i class="fa fa-file-o"></i> DETAILS</a></li>';
                $update_action = ''; //'<li><a href="' . base_url('order/add_order_items') . '?id=' . $products->odr_id . '"><i class="fa fa-pencil-square-o"></i> UPDATE</a></li>';
                $action_option = '';
                if ($products->odr_approval_status == 1 || $products->odr_status == 1) {
                    $action_option = $option_order_details;
                } else {
                    $action_option = $option_order_details . $update_action;
                }
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            ' . $action_option . '</ul></div>                      ';
                //$row[]               = $actdes;
                $data[] = $row;
            }
            $output = array('data' => $data, "recordsTotal" => intval($totalData), "recordsFiltered" => intval($totalFiltered));
            echo json_encode($output);
        } else {
            $output = array('data' => '');
            echo json_encode($output);
        }
    }
    function order_credit_approval() {
        $data['main_menu_name'] = 'order';
        $data['sub_menu_name'] = 'order_credit_approval';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('order/credit_approval_list_order', $data);
    }
    public function get_order_credit_approval_pending_list($value = '') {
        $search_key = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->get('start');
        $length = $this->input->get('length');
        $warehouse_id = $this->input->get('warehouse_id');
        $customer_id = $this->input->get('customer_id');
        $sale_rep_id = $this->input->get('sale_rep_id');
        $totalData = 0;
        $values = $this->Order_Model->get_order_credit_approval_pending_list($start, $length, $search_key_val, $warehouse_id, $customer_id, $sale_rep_id);
        $value_count = $this->Order_Model->get_order_credit_approval_pending_list('', '', '', $warehouse_id, $customer_id, $sale_rep_id);
        if ($search_key_val) {
            $values_c = $this->Order_Model->get_order_credit_approval_pending_list('', '', $search_key_val, $warehouse_id, $customer_id, $sale_rep_id);
            $totalData = 100;
        }
        $totalData = $value_count;
        $totalFiltered = $totalData;
        $data = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row = array();
                $status = '<span class=" btn btn-xs btn-primary"> DRAFT</sapn>';
                if ($products->odr_status == 1) {
                    $status = '<span class=" btn btn-xs btn-success"> COMPLETED</sapn>';
                }
                $row[] = $products->added_date_time;
                $row[] = $products->odr_ref_no;
                $row[] = $products->odr_manual_ref_no;
                $row[] = $products->cus_code;
                $row[] = $products->cus_name;
                $row[] = $products->user_first_name . " " . $products->user_last_name;
                $row[] = $status;
                $row[] = $products->cus_credit_limit;
                $row[] = $products->credit_reject_reason;
                $row[] = $products->mas_name; //$products->brm_note;
                $actdes = '';
                $option_order_details = '<li><a href="' . base_url('order/management_order_details') . '?id=' . $products->odr_id . '"><i class="fa fa-file-o"></i> VIEW & APPROVAL</a></li>';
                $update_action = '<li><a href="' . base_url('order/add_order_items') . '?id=' . $products->odr_id . '"><i class="fa fa-pencil-square-o"></i> UPDATE</a></li>';
                $option_order_approval = '<li><a style="cursor: pointer;" onclick="approval_requste(' . $products->odr_id . ')"><i class="glyphicon fa fa-check"></i> APPROVAL CREDIT</a></li>';
                $option_reject = ' <li><a style="cursor: pointer;" onclick="reject_request(' . $products->odr_id . ')"><i class="glyphicon fa fa-ban"></i> REJECT ORDER</a></li>';
                $action_option = '';
                if ($products->odr_approval_status == 1) {
                    $action_option = $option_order_details;
                } else {
                    $action_option = $option_order_details . $update_action . $option_order_approval . $option_reject;
                }
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            ' . $action_option . '</ul></div>';
                $row[] = $actdes;
                $data[] = $row;
            }
            $output = array('data' => $data, "recordsTotal" => intval($totalData), "recordsFiltered" => intval($totalFiltered));
            echo json_encode($output);
        } else {
            $output = array('data' => '');
            echo json_encode($output);
        }
    }
    function grant_credit_approval() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $id = $this->input->post('id');
            $data = array('odr_credit_approval_status' => 1, 'odr_credit_approval_by' => $this->session->userdata('ss_user_id'), 'odr_credit_approval_on' => date("Y-m-d H:i:s"),);
            $this->Order_Model->update_order_master($id, $data);
            $st = array('status' => 1, 'validation' => 'Saved');
            echo json_encode($st);
        }
    }
    function new_order_bulk() {
        $this->load->model('Sys_Settings_Model');
        $data['main_menu_name'] = 'loading';
        $data['sub_menu_name'] = 'new_order_bulk';
        $setting_data = $this->Sys_Settings_Model->get_sys_setting_info(1);
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['order_type_list'] = $this->Order_Model->get_order_type();
        $data['payment_term_list'] = $this->Order_Model->peyment_term();
        if ($setting_data['system_setting_status'] == 0) {
            $this->load->view('order/not_permited', $data);
        } else {
            $this->load->view('order/add_order_master_bulk', $data);
        }
    }
    function add_order_items_bulk() {
        $data['main_menu_name'] = 'loading';
        $data['sub_menu_name'] = $this->sub_menu_name;
        $data['odr_id'] = $this->input->get('id');
        $data['details'] = $this->Order_Model->get_bulk_order_info($data['odr_id']);
        $this->load->view('order/add_order_items_bulk', $data);
    }
    public function save_order_bulk_master() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('warehouse_id', 'WAREHOUSE', 'required|xss_clean');
        $this->form_validation->set_rules('sale_rep_id', 'SALES REPRESENTATIVE', 'required|xss_clean');
        //$this->form_validation->set_rules('customer_id', 'CUSTOMER', 'required|xss_clean');
        $this->form_validation->set_rules('ref_no', 'Ref No', 'xss_clean');
        //$this->form_validation->set_rules('odr_type', 'ORDER TYPE', 'required|xss_clean');
        $this->form_validation->set_rules('note', 'Quntity', 'max_length[500]|xss_clean');
        //$this->form_validation->set_rules('odr_price_type_id', 'PRICE TYPE', 'required|xss_clean');
        $this->form_validation->set_rules('is_delivery_charge', 'LOADING CHARGE', 'required|xss_clean');
        //$this->form_validation->set_rules('pay_term_id', 'PAYMENT TERM', 'required|xss_clean');
        $this->form_validation->set_rules('delivery_charge', 'DELIVERY CHARGE', 'xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $warehouse_id = $this->input->post('warehouse_id');
            $sale_rep_id = $this->input->post('sale_rep_id');
            $customer_id = $this->input->post('customer_id');
            $odr_price_type_id = $this->input->post('odr_price_type_id');
            $ref_no = $this->input->post('ref_no');
            $note = $this->input->post('note');
            $odr_type = $this->input->post('odr_type');
            $is_delivery_charge = $this->input->post('is_delivery_charge');
            $pay_term_id = $this->input->post('pay_term_id');
            $delivery_charge = $this->input->post('delivery_charge');
            $data = array('odr_warehouse_id' => $warehouse_id, 'delivery_charge' => $delivery_charge, 'odr_sale_rep_id' => $sale_rep_id, 'odr_credit_approval_status' => 1,
            //'odr_customer_id'=>$customer_id,
            'odr_manual_ref_no' => $ref_no, 'odr_note' => $note, 'odr_type_id' => 4,
            //'price_type_id'=>$odr_price_type_id,
            'odr_ref_no' => $this->Common_Model->gen_ref_number('odr_id', 'order_master', 'ODR'), 'added_user_id' => $this->session->userdata('ss_user_id'), 'added_date_time' => date("Y-m-d H:i:s"), 'is_delivery_charge' => $is_delivery_charge,
            //'odr_payment_term'=>$pay_term_id,
            'odr_approval_status' => 1);
            $result = $this->Order_Model->save_order($data);
            $status = 0;
            if ($result > 0) {
                $status = 1;
            }
            $retun_data = array('result' => $result, 'status' => $status,);
            echo json_encode($retun_data);
        }
    }
    public function save_order_bulk_item() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('product_id', 'Product', 'trim|required|xss_clean');
        $this->form_validation->set_rules('odr_id', 'Main ', 'trim|required|xss_clean');
        $this->form_validation->set_rules('req_qty', 'Quntity', 'trim|required|greater_than[0]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $product_id = $this->input->post('product_id');
            $odr_id = $this->input->post('odr_id');
            $req_qty = $this->input->post('req_qty');
            $is_batch_validate = $this->Order_Model->check_product_batch_validation($product_id);
            if ($is_batch_validate == 1) {
                $batch_list = $this->Order_Model->get_active_batch_list($product_id);
                $data = array();
                $batch_stock = array();
                $selected_batch = '';
                $count = 0;
                foreach ($batch_list as $bl) {
                    $count++;
                    if ($count == 1) {
                        $selected_batch = $bl['batch_id'];
                    }
                    $stock = $this->Stock_Counter_Model->get_availble_stock_for_invoicing_and_order('', $product_id, $bl['batch_id']);
                    $price = 0;
                    $price = $bl['product_price'];
                    $nesteddata = array('text' => "RS. " . $price . " -- STOCK : " . $stock . " -- BATCH NO : " . $bl['batch_ref_number'], 'value' => $bl['batch_id']);
                    $data[] = $nesteddata;
                    $nested_batch_data = array('batch_id' => $bl['batch_id'], 'stock' => $stock);
                    $batch_stock[] = $nested_batch_data;
                }
                $st = array('status' => 2, 'validation' => 'batch list', 'batch_list' => $data, 'selected_batch' => $selected_batch, 'batch_stock' => $batch_stock, 'request_qry' => $req_qty);
                echo json_encode($st);
                return;
            }
            $count = $this->Order_Model->check_already_added($product_id, $odr_id);
            if ($count > 0) {
                $st = array('status' => 0, 'validation' => 'Item Already Added !');
                echo json_encode($st);
                return false;
            }
            $price_cost = $this->Order_Model->get_order_product_price_cost($product_id);
            $price = 0;
            $price = $price_cost['product_price'];
            $cost = $price_cost['product_cost'];
            $data = array('odr_id' => $odr_id, 'product_id' => $product_id, 'request_qty' => $req_qty, 'approved_qty' => $req_qty, 'uom_price' => $price, 'uom_cost' => $cost, 'total_price' => $price * $req_qty, 'total_cost' => $cost * $req_qty, 'price_important' => $price_important, 'original_uom_price' => $price,);
            $result = $this->Order_Model->save_order_item($data);
            $st = array('status' => 1, 'validation' => 'Added');
            echo json_encode($st);
        }
    }
    public function save_order_item_with_batch_for_bulk() {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('product_id', 'Product', 'trim|required|xss_clean');
        $this->form_validation->set_rules('odr_id', 'Main ', 'trim|required|xss_clean');
        $this->form_validation->set_rules('req_qty', 'Quntity', 'trim|required|greater_than[0]|xss_clean');
        //$this->form_validation->set_rules('price_type', 'Price type', 'trim|required|greater_than[0]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $st = array('status' => 0, 'validation' => validation_errors());
            echo json_encode($st);
        } else {
            $batch_id = $this->input->get('id');
            $product_id = $this->input->post('product_id');
            $odr_id = $this->input->post('odr_id');
            $req_qty = $this->input->post('req_qty');
            //	$price_type=$this->input->post('price_type');
            //	$price_important=$this->input->post('price_important');
            $count = $this->Order_Model->check_already_added($product_id, $odr_id);
            if ($count > 0) {
                $st = array('status' => 0, 'validation' => 'Item Already Added !');
                echo json_encode($st);
                return false;
            }
            $price_cost = $this->Order_Model->get_batch_details($batch_id);
            $price = $price_cost['product_price'];
            if ($price_type == 1) {
                $price = $price_cost['product_price'];
            }
            if ($price_type == 2) {
                $price = $price_cost['credit_salling_price'];
            }
            if ($price_type == 3) {
                $price = $price_cost['wholesale_price'];
            }
            $cost = $price_cost['product_cost'];
            $data = array('odr_id' => $odr_id, 'product_id' => $product_id, 'request_qty' => $req_qty, 'approved_qty' => $req_qty, 'uom_price' => $price, 'uom_cost' => $cost, 'total_price' => $price * $req_qty, 'total_cost' => $cost * $req_qty, 'price_important' => 1, 'batch_id' => $batch_id, 'is_batch_validate' => 1, 'original_uom_price' => $price);
            $result = $this->Order_Model->save_order_item($data);
            $st = array('status' => 1, 'validation' => 'Added');
            echo json_encode($st);
        }
    }
    function list_bulk_orders() {
        $data['main_menu_name'] = 'loading';
        $data['sub_menu_name'] = 'list_bulk_orders';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('order/list_bulk_orders', $data);
    }
    public function get_bulk_order_list($value = '') {
        $search_key = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $start = $this->input->get('start');
        $length = $this->input->get('length');
        $warehouse_id = $this->input->get('warehouse_id');
        $customer_id = $this->input->get('customer_id');
        $sale_rep_id = $this->input->get('sale_rep_id');
        $srh_from_date = '';
        $srh_to_date = '';
        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
        }
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
        }
        $totalData = 0;
        $values = $this->Order_Model->get_bulk_order_list($start, $length, $search_key_val, $warehouse_id, $customer_id, $sale_rep_id, $srh_from_date, $srh_to_date);
        $value_count = $this->Order_Model->get_bulk_order_list('', '', '', $warehouse_id, $customer_id, $sale_rep_id, $srh_from_date, $srh_to_date);
        if ($search_key_val) {
            $values_c = $this->Order_Model->get_bulk_order_list('', '', $search_key_val, $warehouse_id, $customer_id, $sale_rep_id, $srh_from_date, $srh_to_date);
            $totalData = 100;
        }
        $totalData = $value_count;
        $totalFiltered = $totalData;
        $data = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row = array();
                $status = '<span class=" btn btn-xs btn-primary"> DRAFT</sapn>';
                if ($products->odr_status == 1) {
                    $status = '<span class=" btn btn-xs btn-success"> COMPLETED</sapn>';
                }
                $pickup_note = "";
                if ($products->pickup_status == 0 && $products->invoice_status == 0) {
                    $pickup_note = "To be assign to delivery.";
                }
                if ($products->pickup_status == 1 && $products->invoice_status == 0) {
                    $pickup_note = "Assigned to delivery on : " . $products->pickup_date_time;
                }
                $delivery_note = "";
                if ($products->pickup_status == 1 && $products->invoice_status == 1) {
                    $delivery_note = " Delivery completed on : " . $products->invoice_on;
                }
                $tooltip = $pickup_note . $delivery_note;
                if (!$products->dpn_ref_no) {
                    $tooltip = "Dispatch Note Not Generated";
                }
                $row[] = $products->added_date_time;
                $row[] = $products->odr_ref_no . " " . $products->odr_manual_ref_no;
                $row[] = ' <span data-toggle="tooltip" title="' . $tooltip . '" class="fa fa-btn btn-info"> <i class="fa fa-info-circle"> </i> </span> ' . $products->dpn_ref_no;
                //$row[]               = $products->sale_reference_no;
                //$row[]               = $products->cus_code;
                //$row[]               = $products->cus_name;
                $row[] = $products->user_first_name;
                $row[] = $status;
                //$row[]               = $products->mas_name;
                //$row[]               = $products->approval_user_first_name." ".$products->approval_user_last_name;
                //$row[]               = $products->approval_date_time;//$products->brm_note;
                $actdes = '';
                $option_order_details = '<li><a href="' . base_url('order/order_bulk_details') . '?id=' . $products->odr_id . '"><i class="fa fa-file-o"></i> DETAILS</a></li>';
                $update_action = '<li><a href="' . base_url('order/add_order_items_bulk') . '?id=' . $products->odr_id . '"><i class="fa fa-pencil-square-o"></i> UPDATE</a></li>';
                $action_option = '';
                if ($products->odr_status == 1) {
                    $action_option = $option_order_details;
                } else {
                    $action_option = $option_order_details . $update_action;
                }
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            ' . $action_option . '</ul></div>                      ';
                $row[] = $actdes;
                $data[] = $row;
            }
            $output = array('data' => $data, "recordsTotal" => intval($totalData), "recordsFiltered" => intval($totalFiltered));
            echo json_encode($output);
        } else {
            $output = array('data' => '');
            echo json_encode($output);
        }
    }
    function order_bulk_details() {
        $data['main_menu_name'] = 'loading';
        $data['sub_menu_name'] = '';
        $data['odr_id'] = $this->input->get('id');
        $data['details'] = $this->Order_Model->get_bulk_order_info($data['odr_id']);
        $this->load->view('order/order_details', $data);
    }
    public function get_product_dynamic_collected() {
        $str = $this->input->post('search_string');
        $dpn_id = $this->input->post('dpn_id');
        $result = $this->Delivery_Invoice_Model->get_search_products_exchange($str, $dpn_id);
        $data = array();
        foreach ($result as $row) {
            $issue_stock = $this->Delivery_Invoice_Model->get_bulk_issue_qty($dpn_id, $row->product_id);
            $invoice_stock = $this->Delivery_Invoice_Model->get_bulk_invoice_qty($dpn_id, $row->product_id);
            $nsested_data = array('product_id' => $row->batch_id, 'product_code' => $row->product_code, 'product_name' => $row->product_name, 'stock' => "");
            $data[] = $nsested_data;
        }
        echo json_encode($data);
    }
}
