<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Batch_Process extends CI_Controller {
	
    var $main_menu_name = "purchases";
	  var $sub_menu_name = "categories";

      function __construct() 
      {
        parent::__construct();
        $this->load->model('Batch_Process_Model');
        $this->load->model('Common_Model');
		$this->load->model('Sequerty_Model');
        $this->load->library('form_validation');
		$this->load->model('User_Model');
      }

    public function index($e=0)
    {
      $data['error'] = $e;
      $data['main_menu_name'] = $this->main_menu_name;
      $data['sub_menu_name'] = "batch";
      $this->load->view('batch/batch_purchases_list',$data);
    }

    public function get_list_purchases($value='')
    {
          $values = $this->Batch_Process_Model->getpurchases();
            $data = array();
            if (!empty($values)) {
                foreach ($values as $purchases) {
                $row = array();
                    $row[] = $purchases->date;
                    $row[] = $purchases->reference_no;
                    $row[] = $purchases->supp_company_name;
					$row[] = $purchases->supp_invocie_no;
                    $row[] = $purchases->product_code;
                    $row[] = $purchases->product_name;
                    $row[] = $purchases->unit_price;
                     $row[] = $purchases->unit_price;
                    $row[] = '<div class="text-center"><div class="btn-group text-left">
                    <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                    <ul role="menu" class="dropdown-menu pull-right">
                    <a onClick="click_grn_update_btn('.$purchases->id.')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit customers">create new batch</a>
                    </ul></div>
                    </div>';
                    $data[] = $row;
                }
                $output = array('data' =>$data);
                echo json_encode($output);
            }else{
                $output = array('data' =>'');
                echo json_encode($output);
            }
       }
    
    	public function create_batch()
	{
        $data['id'] = 1;
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'create_batch';
		
        if (isset($_GET['grn_item_id'])) {
			$grn_item_id=$_GET['grn_item_id'];
		}
		else {
			$grn_item_id='';
		}
		if($grn_item_id){
			$data['grn_item_id']=$grn_item_id;
			$data['type']='A';
			$data['pageName']='CREATE BATCH';
			$data['btnText']='create batch';
			$data['details']= $this->Batch_Process_Model->get_gen_item_id_details($grn_item_id);	
		}
        $this->load->view('batch/create_batch',$data);	
	}
	
	 public function save_batch()
	{
	  
	    $this->load->library('form_validation'); //form validation lib
	    $this->form_validation->set_rules('batch_code', 'Batch Code', 'is_unique[batch_product.batch_ref_number]');
		$this->form_validation->set_rules('grn_item_id', 'GRN', 'required');
		$type=$this->input->post('type');
		$grn_item_id=$this->input->post('grn_item_id');
		$product_id=$this->input->post('product_id');
		$cost=$this->input->post('cost');
		$batch_code=$this->input->post('batch_code');
		$dcc=$this->input->post('dcc');
		$dcp=$this->input->post('dcp');
		$dwp=$this->input->post('dwp');
		$rcc=$this->input->post('rcc');
		$rcp=$this->input->post('rcp');	
		$rwp=$this->input->post('rwp');
		if($batch_code)
		{}else{
		$batch_code=$this->Common_Model->gen_ref_number('batch_id','batch_product','BTC');
		}
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		$data=array(
			'grn_item_id'=>$grn_item_id,
			'product_id'=>$product_id,
			'batch_ref_number'=>$batch_code,	
			'product_cost'=>$cost,
			'product_price'=>$dcc,
			'credit_salling_price'=>$dcp,
			'wholesale_price'=>$dwp,	
			'retail_cash'=>$rcc,
			'retail_credit'=>$rcp,
			'retail_wholesale'=>$rwp,
			'user_id'=>$this->session->userdata('ss_user_id'),
		);
		$result=$this->Batch_Process_Model->save_batch($data);
		$lastid=$this->db->insert_id();
        if($result==1){
            $result=$this->Batch_Process_Model->update_product($grn_item_id);
        }
		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type,'status' =>1));
			} else {
				echo json_encode(array('status'=>'0'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type,'status' =>1));
		}	
		}
	}
	
	public function update_batch()
	{
	    $id=$this->input->get('id');
	    $status=$this->input->get('status');
	    $data=array(
			'batch_status'=>$status,
			'user_id'=>$this->session->userdata('ss_user_id'),
			'added_date_time'=>date("Y-m-d H:i:s"),
		);
		$result=$this->Batch_Process_Model->update_batch($id,$data);
			if($result==1){
				echo json_encode(array('id'=>'','status' =>1,'message'=>"Done"));
			} else {
			   echo json_encode(array('id'=>'','status' =>0,'message'=>"Fail"));
			}
	}
	


}