<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Report_Stock_Ctrl extends CI_Controller
{
    var $main_menu_name = "stock_reports";
    var $sub_menu_name = "";
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('Common_Model');
        $this->load->model('Report_Common_Model');
        $this->load->model('Report_Stock_Model');
        $this->load->model('Stock_Counter_Model');
    }
   
    public function index()
    {
        exit();
    }
    //2022-02-08 m.m.sachith eranga (stock availble report)
    public function product_quntity()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'product_quntity';
        $data['category_list']  = $this->Report_Common_Model->getActiveProductCategoryList();
        $this->load->view('reports/stock_reports/product_availble_stock_rp', $data);
    }
    public function get_availble_product_list()
	{
		$first_filter_id            = $this->input->get('first_filter_id');
		$second_filter_id            = $this->input->get('second_filter_id');
        $new_list=$this->Report_Stock_Model->getProductList($first_filter_id);
        $count=count($new_list);
		$data=array();
		foreach($new_list as $row)
		{	
		     $freez_stock=$this->Stock_Counter_Model->get_freeze_quntity('',$row['product_id']);
		     $availble_stock=$this->Stock_Counter_Model->get_stock_balance('',$row['product_id']);
		    if($second_filter_id==1){
		        if($freez_stock==0&&$availble_stock==0){
		            continue;
		        }
		    }
		     if($second_filter_id==2){
		        if($availble_stock!=0){
		            continue;
		        }
		    }
		    if($second_filter_id==3){
		        if($availble_stock==0||$availble_stock>0){
		            continue;
		        }
		    }
			$nested_data= array();
		    $nested_data[]=$row['product_code'] ;
			$nested_data[]=$row['product_name'];
			$nested_data[]=$row['cat_name'] ;
			$nested_data[]=$row['sub_cat_name'] ;
			$nested_data[]=$row['product_alert_qty'] ;
			$nested_data[]=$row['product_max_qty'] ;
			$nested_data[]=$row['product_cost'] ;
			$nested_data[]=$row['product_price'] ;
			$nested_data[]=$row['credit_salling_price'] ;
			$nested_data[]=$row['wholesale_price'] ;
			$nested_data[]=$row['unit_code'] ;
		    $nested_data[]=$freez_stock ;
		    $nested_data[]=$availble_stock;
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	public function bin_card()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'bin_card';
        $data['delivery_list']  = $this->Report_Stock_Model->getProductList();
        $this->load->view('reports/stock_reports/bin_card', $data);
    }
    
    public function get_bin_card_data()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
        $this->Report_Stock_Model->delete_all_recode_by_user_id($this->session->userdata('ss_user_id'));
        
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        
      
		$list=$this->Report_Stock_Model->get_all_direct_sale_item($product_id,'',$srh_to_date);
		$list2=$this->Report_Stock_Model->get_all_purchese_item($product_id,'',$srh_to_date);
		$list3=$this->Report_Stock_Model->get_all_loading_item($product_id,'',$srh_to_date);
		$list4=$this->Report_Stock_Model->get_all_un_loading_item($product_id,'',$srh_to_date);
		$list5=$this->Report_Stock_Model->get_all_damage_item($product_id,'',$srh_to_date);
		foreach($list as $row){
		    $data=array(
		    'date_time'=>$row['sale_datetime'],
			'document_no'=>$row['sale_reference_no'],
			'type'=>"direct sale",
			'in_out_type'=>"out",
			'ref'=>$row['card_ref_number'],
			'out_qty'=>$row['quantity'],
			'in_qty'=>null,
			'qty'=>$row['quantity'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			);
		$this->Report_Stock_Model->insert_data_to_bin_reirt_table($data);
		}
		foreach($list2 as $row){
		    $data=array(
		    'date_time'=>$row['date'],
			'document_no'=>$row['reference_no'],
			'type'=>"purchese",
			'in_out_type'=>"in",
			'ref'=>$row['supp_invocie_no'],
			'out_qty'=>null,
			'in_qty'=>$row['quantity'],
			'qty'=>$row['quantity'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			);
		$this->Report_Stock_Model->insert_data_to_bin_reirt_table($data);
		}
		foreach($list3 as $row){
		    $data=array(
		    'date_time'=>$row['system_date_time'],
			'document_no'=>$row['loading_ref_no']  ,
			'type'=>"load",
			'in_out_type'=>"out",
			'ref'=>" (".$row['cus_order_ref_no']." ) ".$row['remark'] ,
			'out_qty'=>$row['issue_qty'],
			'in_qty'=>null,
			'qty'=>$row['issue_qty'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			);
		$this->Report_Stock_Model->insert_data_to_bin_reirt_table($data);
		}
		foreach($list4 as $row){
		    $data=array(
		    'date_time'=>$row['return_date_time'],
			'document_no'=>$row['loading_ref_no'],
			'type'=>"unload",
			'in_out_type'=>"in",
			'ref'=>$row['remark'],
			'out_qty'=>null,
			'in_qty'=>$row['return_qty'],
			'qty'=>$row['return_qty'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			);
		$this->Report_Stock_Model->insert_data_to_bin_reirt_table($data);
		}
		foreach($list5 as $row){
		    $data=array(
		    'date_time'=>$row['pdmg_datetime_created'],
			'document_no'=>$row['pdmg_reference_no'],
			'type'=>"damage",
			'in_out_type'=>"out",
			'ref'=>$row['pdmg_note'],
			'out_qty'=>$row['pdmgitm_quantity'],
			'in_qty'=>null,
			'qty'=>$row['pdmgitm_quantity'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			);
		$this->Report_Stock_Model->insert_data_to_bin_reirt_table($data);
		}
	    $new_list=$this->Report_Stock_Model->get_bin_card($this->session->userdata('ss_user_id'));
		$data=array();
		$count=count($new_list);
		$total_stock_count=0;
		foreach($new_list as $row)
		{	
		    if($row['out_qty']){
		        $total_stock_count-=$row['out_qty'];
		    }if($row['in_qty']){
		        $total_stock_count+=$row['in_qty'];
		    }
		    $date           = date_create($row['date_time']);
            $recode_date = date_format($date, "Y-m-d");
            if($srh_from_date){
                
                if($srh_from_date>$recode_date){
                    continue;
                }
            }
			$nested_data= array();
		    $nested_data[]=$row['date_time'] ;
			$nested_data[]=$row['document_no'];
			$nested_data[]=$row['type'] ;
			$nested_data[]=$row['ref'] ;
			$nested_data[]=$row['in_qty'] ;
			$nested_data[]=$row['out_qty'] ;
			$nested_data[]=number_format($total_stock_count, 3, '.', '');
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	 public function product_quntity_print()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'customer_outstanding_report';
       $first_filter_id            = $this->input->get('first_filter_id');
		$second_filter_id            = $this->input->get('second_filter_id');
		$filter1name            = $this->input->get('filter1name');
		$filter2name            = $this->input->get('filter2name');
        $new_list=$this->Report_Stock_Model->getProductList($first_filter_id);
        $json_data          = array();
        foreach ($new_list as $row) {
            if($row['product_id']==106){continue;}
           $freez_stock=$this->Stock_Counter_Model->get_freeze_quntity('',$row['product_id']);
		     $availble_stock=$this->Stock_Counter_Model->get_stock_balance('',$row['product_id']);
		    if($second_filter_id==1){
		        if($freez_stock==0&&$availble_stock==0){
		            continue;
		        }
		    }
		     if($second_filter_id==2){
		        if($availble_stock!=0){
		            continue;
		        }
		    }
		    if($second_filter_id==3){
		        if($availble_stock==0||$availble_stock>0){
		            continue;
		        }
		    }
			$nested_data= array();
		    $nested_data['product_code']=$row['product_code'] ;
			$nested_data['product_name']=$row['product_name'];
			$nested_data['cat_name']=$row['cat_name'] ;
			$nested_data['sub_cat_name']=$row['sub_cat_name'] ;
			$nested_data['product_alert_qty']=$row['product_alert_qty'] ;
			$nested_data['product_max_qty']=$row['product_max_qty'] ;
			$nested_data['product_cost']=$row['product_cost'] ;
			$nested_data['product_price']=$row['product_price'] ;
			$nested_data['credit_salling_price']=$row['credit_salling_price'] ;
			$nested_data['wholesale_price']=$row['wholesale_price'] ;
			$nested_data['unit_code']=$row['unit_code'] ;
		    $nested_data['freez_stock']=$freez_stock ;
		    $nested_data['availble_stock']=$availble_stock;
			$json_data[]=$nested_data;			
        }
        $data['product_list'] =$json_data;
        $data['filters'] =$filter1name." and ".$filter2name;
        $this->load->view('reports/stock_reports/product_availble_stock_rp_print', $data);
    }











	
}