<?php
require_once("Main_model.php");
class Leave_model extends Main_model
{
	private $tableName = 'leave';
	private $join = 'comp';
	public function _construct()
	{
		//$this->load->database();
	}
	/*
	Determines if a given string is an exists
	*/
	function exists($var)
	{
		if($var)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	function count_all($id=0)
	{
		$this->db->from($this->tableName);
		if($id!=0) 
		{
			$this->db->where('Code',$id);
		}
		return $this->db->count_all_results();
	}
	
	/*
	Returns all the shifts
	*/
	function get_all()
	{
		$this->db->select('t.Leave_code, t.Description, t.Days, jt.Name');
		$this->db->from($this->tableName." AS t");
		$this->db->join($this->join.' AS jt', 't.Comp_Id = jt.Code','left');
  		$query = $this->db->get();
		return $query->result();
	}
	
	function get_all_leave_code()
	{
		$this->db->select('t.Leave_code, t.Description');
		$this->db->from($this->tableName." AS t");
  		$query = $this->db->get();
		return $query->result();
	}
	

	function get_info($leave_id='')
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where('Leave_code',$leave_id);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}
	

	/*
	Inserts or updates a page
	*/
	function save(&$leave_data,$leave_id=false)
	{
		if (!$leave_id)
		{
			$where = array('Leave_code'=>$leave_data['Leave_code']);
			if(!$this->exist_leave($where))
			{
				
				if($this->db->insert($this->tableName,$leave_data))
				{
					$leave_data['Leave_code']=$this->db->insert_id();
					return true;
				}
			}
			return false;
		}
		$this->db->where('Leave_code', $leave_id);
		return $this->db->update($this->tableName,$leave_data);
	}

	function exist_leave($where=array())
	{
		$this->db->from($this->tableName);
		$this->db->where($where);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			$this->messages->add($this->lang->line('error_leave_exist'), "error");
			return true;
		}
		else
		{
			return false;
		}
	}
	
	/*
	Deletes one shift
	*/
	function delete($id)
	{
		if($this->delete_image($id))
		{
			$this->db->where('Code', $id);
			return $this->db->delete($this->tableName); 
		}
		return false;
	}
	
	public function change_status($leave_id,$status)
	{
		$this->db->where('Code', $leave_id);
		return $this->db->update($this->tableName,array( 'pStatus' => $status));	
	}

}
?>
