<?php require_once("Main_model.php");
class settings_model extends Main_model
{
	private $tableName = 'settings';
	private $join = 'comp';
	private $comp;
	
	public function _construct()
	{
		//$this->load->database();
	}

	/*
	Determines if a given string is an exists
	*/
	function exists($var)
	{
		if($var)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	function exist_row()
	{
		$this->db->from($this->tableName);
		$this->db->where('Comp',$this->attn->getComp());
		//$this->db->where('Status',1);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	function count_all($id=0)
	{
		$this->db->from($this->tableName);
		if($id!=0) 
		{
			$this->db->where('Code',$id);
		}
		return $this->db->count_all_results();
	}
	
	/*
	Returns all the companys
	*/
	function get_all($id=0,$limit=0,$offset=0)
	{
		$this->db->select('t.*, jt.Name');
		$this->db->from($this->tableName." AS t");
		$this->db->join($this->join.' AS jt', 't.Comp = jt.Code','left');
		//$this->db->where('t.Status',1);
		$this->db->where('t.Comp',$this->attn->getComp());
		$this->db->where('jt.Comp_Id',$this->attn->getComp());
  		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}

	function get_all_d_setting()
	{
		$this->db->select('t.*, jt.Description');
		$this->db->from("settings AS t");
		$this->db->join('department AS jt', 't.department = jt.Dep_code','left');
		$this->db->where('jt.Comp_Id',$this->attn->getComp());
		//$this->db->where('t.Status',1);
		$this->db->where('t.Comp',$this->attn->getComp());
		$query = $this->db->get();
		return $query->result();
	}

	function get_info($comp='')
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where('Comp',$comp);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}

	function get_info_depatment($where)
	{
		$this->db->select('*');
		$this->db->from('settings');
		$this->db->where($where);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			return false;
		}
	}

	/*
	Inserts or updates a page
	*/
	function save(&$company_data)
	{
		if(!$this->exist_row())
		{
			if($this->db->insert($this->tableName,$company_data))
			{
				return true;
			}
		}
		$this->db->where('Comp', $this->attn->getComp());
		return $this->db->update($this->tableName,$company_data);
	}

	function save_department(&$company_data)
	{
		if(!$this->exist($company_data['department']))
		{
			if($this->db->insert('settings',$company_data))
			{
				return true;
			}
		}
		$this->db->where('Comp', $this->attn->getComp());
		$this->db->where('department', $company_data['department']);
		return $this->db->update('settings',$company_data);
	}

	function exist($department)
	{
		$this->db->from('settings');
		$this->db->where('Comp',$this->attn->getComp());
		$this->db->where('department',$department);
		//$this->db->where('Status',1);
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	/*
	Deletes one company
	*/
	function delete($where)
	{
			$this->db->where($where);
			return $this->db->delete('settings');
	}
	
	public function change_status($company_code)
	{
		$this->db->trans_start();
		$this->db->from('employee');
		$this->db->where('Comp',$this->attn->getComp());
		$this->db->where('Dep_code',$company_code);
		$this->db->where('Active',1);
		$count = $this->db->count_all_results();
		$this->db->trans_complete();
		if($count==0)
		{
			$this->db->trans_start();
			$this->db->where('Dep_code', $company_code);
			 $this->db->where('Comp_Id', $this->attn->getComp());
			 $this->db->update($this->tableName,array('Status' => 0));
			 echo $this->db->last_query();
			 //return $this->db->affected_rows();
			 $return = (bool) ($this->db->affected_rows() > 0); 
			 $this->db->trans_complete();
			 return $return;
		}
		else
		{
			$this->messages->add($this->lang->line('error_company_delete'), "error");
			return false;
		}
	}
}
?>