<?php $this->load->view("templates/common/header"); ?>
<body>
<div class="navbar">
    <div class="navbar-inner">
        <div class="container-fluid">
            <?php $this->load->view("templates/common/site-name"); ?>
            <?php $this->load->view("templates/common/top_right"); ?>
        </div>
    </div>
</div>
<div class="main-container container-fluid"> <a href="#" id="menu-toggler" class="menu-toggler"> </a>
    <?php $this->load->view("templates/common/sidebar"); ?>
    <div class="main-content">
        <div id="breadcrumbs" class="breadcrumbs">
            <ul class="breadcrumb">
                <?php $this->load->view("templates/common/home-link"); ?>
                <li class="active">Records</li>
            </ul>
        </div>
        <?php echo (isset($message)) ? $message: null;?>
        <div class="page-content">
            <div class="page-header position-relative">
                <h1>Today Attendance</h1>
            </div>


            <div class="row-fluid">
                <br/>
                <div class="span12">

                    <!-- /control-group -->

                    <div class="span4">

                        <a href="#" class="btn btn-info btn-small" onClick="updateDayEntry();">Absences</a>
                    </div>
                </div>
            </div>

            <br/>

            <div class="row-fluid">
                <div class="span12">

                    <div role="grid">
                        <?php
                        if(isset($records) and is_array($records) and !empty($records)){
                            ?>
                            <table  class="table table-striped table-bordered table-hover">
                                <thead>
                                <tr role="row">
                                    <th>Employee Id </th>
                                    <th>Employee Name</th>
                                    <th>Date</th>
                                    <th>Time</th>
                                </tr>
                                </thead>
                                <tbody role="alert" aria-live="polite" aria-relevant="all">
                                <?php
                                foreach($records as $rs)
                                {
                                    ?>
                                    <tr>
                                        <td><?php echo $rs['USER'];?></td>
                                        <td><?php echo $rs['EmpName'];?></td>
                                        <td><?php echo date('Y-m-d', strtotime($rs['INOUTTIME']));?></td>
                                        <td><?php echo date('H:i:s', strtotime($rs['INOUTTIME']));?></td>

                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                            <div class="pagination"><?php echo $pagination; ?></div>

                        <?php }
                        else echo '<p>No records Found</p>';
                        ?>


                        <div class="row" style="display:none;">
                            <div class="col-md-12">
                                <form class="form-horizontal">

                                    <div class="form-group">
                                        <label class="col-md-4 control-label" for="name">Name :</label>
                                        <div class="col-md-4">
                                            <input id="name" name="name" readonly value="" type="text" placeholder="Your name" class="form-control input-md">
                                        </div>
                                    </div>
                                    <br/>


                                    <div class="form-group">
                                        <label class="col-md-4 control-label" for="name">In Date :</label>
                                        <div class="col-md-4">
                                            <input data-date-format="yyyy-mm-dd" id="inDate" name="inDate" type="text" placeholder="In Date" class="form-control input-md date-picker check_date"><span class="add-on"> <i class="icon-calendar big"></i></span>
                                        </div>
                                    </div>
                                    <br/>

                                    <div class="form-group">
                                        <label class="col-md-4 control-label" for="name">In Time :</label>
                                        <div class="col-md-4">
                                            <input data-date-format="hh:mm:ss" id="inTime" name="inTime" type="text" placeholder="In Date" class="form-control input-md check_date"><span class="add-on"> <i class="icon-calendar big"></i></span>
                                        </div>
                                    </div>
                                    <br/>

                                    <div class="form-group">
                                        <label class="col-md-4 control-label" for="name">Out Date :</label>
                                        <div class="col-md-4">
                                            <input id="outDate" data-date-format="yyyy-mm-dd" name="outDate" type="text" placeholder="Out Date" class="form-control input-md date-picker check_date"><span class="add-on"> <i class="icon-calendar big"></i></span>
                                        </div>
                                    </div>
                                    <br>

                                    <div class="form-group">
                                        <label class="col-md-4 control-label" for="name">Out Time :</label>
                                        <div class="col-md-4">
                                            <input id="outTime" data-date-format="hh:mm:ss" name="outTime" type="text" placeholder="Out Date" class="form-control input-md check_date"><span class="add-on"> <i class="icon-calendar big"></i></span>
                                        </div>
                                    </div>
                                    <br>


                            </div>

                        </div>
                        </form>
                    </div>
                </div>


                <div id="login" style="display:none;" class="span5">
                    <?php
                    if(isset($today_not_attend) and is_array($today_not_attend) and !empty($today_not_attend)){
                        ?>
                        <table  class="table table-striped table-bordered table-hover">
                            <thead>
                            <tr role="row">
                                <th>Employee Id </th>
                                <th>Employee Name</th>
                            </tr>
                            </thead>
                            <tbody role="alert" aria-live="polite" aria-relevant="all">
                            <?php
                            foreach($today_not_attend as $rs)
                            {
                                ?>
                                <tr>
                                    <td><?php echo $rs['EmpNo'];?></td>
                                    <td><?php echo $rs['EmpName'];?></td>

                                </tr>
                            <?php } ?>
                            </tbody>
                        </table>

                    <?php }
                    else echo '<p>No records Found</p>';
                    ?>
                </div>

                <script type="text/javascript">


                    function updateDayEntry(){
                        $('#login').show();

                        var modal = bootbox.dialog({
                                title: "Full day",
                                closeButton:  true,
                                message:$('#login'),
                                buttons: {
                                    danger: {
                                        label: "Close!",
                                        className: "btn-default",
                                        callback: function() {
                                        }
                                    }
                                },
                                show: false,
                                onEscape: function() {
                                    modal.modal("hide");
                                }
                            }
                        );
                        modal.modal("show");
                        return false;
                    }

                    function show_box(id) {
                        $('.widget-box.visible').removeClass('visible');
                        $('#'+id).addClass('visible');
                    }
                </script>




            </div>
        </div>
    </div>
</div>
</div>
</div>


