<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Employee extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
        $this->load->model('employee_model');
        $this->model = $this->employee_model;
        $this->load->library('form_validation');
    }

    function index($action = NULL)
    {
        //$this->tmw->checkPermissions();
        //echo $this->data['page'];
        //$data['page'] = 'employee';
        $this->data['message'] = view_error($this->messages->get());
        $this->data['action'] = $action;
        $this->data['page_title'] = 'List';
        $this->data['heading'] = 'Employee';
        $bc = array(array('link' => base_url('admin'), 'page' => lang('home')), array('link' => '#', 'page' => lang('employees')));
        $meta = array('page_title' => lang('Companies'), 'bc' => $bc);
        $this->page_construct('employees/index', $meta, $this->data);
    }

    function getEmployees()    {
        //$this->tmw->checkPermissions('index');
        $action = "
        <div class=\"dropdown\">
				<button type=\"button\" class=\"btn p-0 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
				  <i class=\"bx bx-dots-vertical-rounded\"></i>
				</button>
				<div class=\"dropdown-menu\">
				  <a class=\"dropdown-item\" href='" . base_url('employee/edit/$1') ."'
					><i class=\"bx bx-edit-alt me-1\"></i> Edit</a>
                    <a class=\"dropdown-item\" href='" . base_url('employee/view/$1') ."'
					><i class=\"bx bx-edit-alt me-1\"></i> View</a>
				  <a class=\"dropdown-item\" href='". base_url('employee/delete/$1') . "'
					><i class=\"bx bx-trash me-1\"></i> Delete</a>
				</div>
			  </div>";
        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('employee') .".EmpNo AS EmpNo,
                ".$this->db->dbprefix('companies') .".Name AS Cname,
                ".$this->db->dbprefix('employee') .".FullName")
            ->from("employee")
            ->join('companies', $this->db->dbprefix('employee') . '.Comp=' . $this->db->dbprefix('companies') . '.Code', 'left')
            //->edit_column('status', '$1__$2', 'status,Id')
            //->unset_column('Id')
            ->add_column("Actions", $action, "EmpNo");
            //->unset_column('Id');
        echo $this->datatables->generate();
    }

    function add()
    {
        //$this->sma->checkPermissions(false, true);
        $this->form_validation->set_rules('EmpNo', 'Employee Code', 'trim|required');
		$this->form_validation->set_rules('FullName', 'Employee Name', 'trim|required');
		$this->form_validation->set_rules('Active', 'Active', 'trim|required');
        
        if ($this->form_validation->run('employees/add') == true) {

            //echo '<pre>',print_r($_FILES['EmpPic']['name']); die();
            if(isset($_FILES['EmpPic']['name']) && !empty($_FILES['EmpPic']['name'])) 
			{
				$image_upload = $this->model->upload_file('EmpPic');
                //echo '<pre>',print_r($image_upload); die();
				if($image_upload)
				{
						$upImageName = $image_upload['file_name'];
				}
				else
				{
					$upImageName = '';
				}
			}
			else
			{
				$upImageName = isset($_POST['image']) ? $_POST['image'] : '';
			}

            //die();

			$edata = array(
			'EmpNo' => $this->input->post('EmpNo'),
			'Comp' => $this->input->post('Comp'),
			'work_type' => $this->input->post('work_type'),
			'EmpName' => $this->input->post('EmpName'),
			'FullName' => $this->input->post('FullName'),
			'SureName' => $this->input->post('SureName'),
			'InitialsName' => $this->input->post('InitialsName'),
			'EPFNo' => $this->input->post('EPFNo'),
			'EmpPic' => $upImageName,
			'Gender' => ($this->input->post('Gender'))?$this->input->post('Gender'):'Male',
			'Title' => $this->input->post('Title'),
			'Birth' => $this->input->post('Birth'),
			'HomeNo' => $this->input->post('HomeNo'),
			'MobileNo' => $this->input->post('MobileNo'),
			'IDNo' => $this->input->post('IDNo'),
			'Address' => $this->input->post('Address'),
			'StartDate' => $this->input->post('StartDate'),
			'Dep_code' => $this->input->post('Dep_code'),
			'Designation' => $this->input->post('Designation'),
			'Basic_Salery' => ($this->input->post('Basic_Salery'))?$this->input->post('Basic_Salery'):0,
			'Empstatus' => $this->input->post('Empstatus'),
			'Emergency' => $this->input->post('Emergency'),
			'Relationship' => $this->input->post('Relationship'),
			'EmerAddress' => $this->input->post('EmerAddress'),
			'Bank' => $this->input->post('Bank'),
			'Branch' => $this->input->post('Branch'),
			'AccountName' => $this->input->post('AccountName'),
			'AccountNo' => $this->input->post('AccountNo'),
			'Month_working_days' => $this->input->post('Month_working_days'),
			'Active' => $this->input->post('Active')
			);	
        } elseif ($this->input->post('add_customer')) {
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            redirect('employee');
        }

        if ($this->form_validation->run() == true && $this->model->addEmployee($edata)) {
            $this->messages->add($this->lang->line("Employee_Added"), "success");
            redirect('employee');
        } else {
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            $this->data['message'] = view_error($this->messages->get());
            //$this->data['modal_js'] = $this->site->modal_js();
            $this->load->model('company_model');
            $this->data['companies'] = $this->company_model->getAll();
            $this->load->model('designation_model');
            $this->data['designations'] = $this->designation_model->get_all();
            $this->load->model('department_model');
            $this->data['departments'] = $this->department_model->getAll();
            //echo '<pre>',print_r($this->data['companies']); die();
            $this->data['page_title'] = 'Add Employee';
		    $this->data['heading'] = 'Employee';
            $this->load->view('templates/employees/add', $this->data);
        }
    }
    
     function edit($id = NULL)
    {
        //$this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $comp_details = $this->model->getEmployeeByID($id);
        $this->form_validation->set_rules('EmpNo', 'Employee Code', 'trim|required');
		$this->form_validation->set_rules('FullName', 'Employee Name', 'trim|required');
		$this->form_validation->set_rules('Active', 'Active', 'trim|required');
        

        if ($this->form_validation->run('employees/add') == true) {
       
            if(isset($_FILES['EmpPic']['name']) && !empty($_FILES['EmpPic']['name'])) 
			{
				$image_upload = $this->model->upload_file('EmpPic');
				if($image_upload)
				{
						$upImageName = $image_upload['file_name'];
				}
				else
				{
					$upImageName = '';
				}
			}
			else
			{
				$upImageName = isset($_POST['image']) ? $_POST['image'] : '';
			}
            $edata = array(
                'EmpNo' => $this->input->post('EmpNo'),
                'Comp' => $this->input->post('Comp'),
                'work_type' => $this->input->post('work_type'),
                'EmpName' => $this->input->post('EmpName'),
                'FullName' => $this->input->post('FullName'),
                'SureName' => $this->input->post('SureName'),
			    'InitialsName' => $this->input->post('InitialsName'),
                'EPFNo' => $this->input->post('EPFNo'),
                'EmpPic' => $upImageName,
                'Gender' => ($this->input->post('Gender'))?$this->input->post('Gender'):'Male',
                'Title' => $this->input->post('Title'),
                'Birth' => $this->input->post('Birth'),
                'HomeNo' => $this->input->post('HomeNo'),
                'MobileNo' => $this->input->post('MobileNo'),
                'IDNo' => $this->input->post('IDNo'),
                'Address' => $this->input->post('Address'),
                'StartDate' => $this->input->post('StartDate'),
                'Dep_code' => $this->input->post('Dep_code'),
                'Designation' => $this->input->post('Designation'),
                'Basic_Salery' => ($this->input->post('Basic_Salery'))?$this->input->post('Basic_Salery'):0,
                'Empstatus' => $this->input->post('Empstatus'),
                'Emergency' => $this->input->post('Emergency'),
                'Relationship' => $this->input->post('Relationship'),
                'EmerAddress' => $this->input->post('EmerAddress'),
                'Bank' => $this->input->post('Bank'),
                'Branch' => $this->input->post('Branch'),
                'AccountName' => $this->input->post('AccountName'),
                'AccountNo' => $this->input->post('AccountNo'),
                'Month_working_days' => $this->input->post('Month_working_days'),
                'Active' => $this->input->post('Active')
                );	
        } elseif ($this->input->post('edit_customer')) {
            $this->messages->add(validation_errors(), "error");
            //redirect($_SERVER["HTTP_REFERER"]);
            redirect('employees');
        }

        if ($this->form_validation->run() == true && $this->model->updateEmployee($id, $edata)) {
           
            $this->messages->add(lang("Employee_Updated"), "success");
            //redirect($_SERVER["HTTP_REFERER"]);
            redirect('employee');
        } else {
            $this->data['employee'] = $comp_details;
            if(validation_errors()) $this->messages->add(validation_errors(), "error");
            $this->data['message'] = view_error($this->messages->get());
            $this->load->model('company_model');
            $this->data['companies'] = $this->company_model->getAll();
            $this->load->model('designation_model');
            $this->data['designations'] = $this->designation_model->get_all();
            $this->load->model('department_model');
            $this->data['departments'] = $this->department_model->getAll();
            $this->data['page_title'] = 'Edit Employee';
		    $this->data['heading'] = 'Employee';
            $this->load->view('templates/employees/edit', $this->data);
        }
    }

    function view($id = NULL)
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        $emp_details= $this->model->getEmployeeByID($id);
        //echo '<pre>',print_r($emp_details); die();
        $this->data['page_title'] = 'View Employee';
		    $this->data['heading'] = 'Employee';
        $this->data['employee']= $emp_details;
        $this->data['message'] = view_error($this->messages->get());
        $bc = array(array('link' => base_url('admin'), 'page' => lang('home')), array('link' => '#', 'page' => lang('employees')));
        $meta = array('page_title' => lang('Companies'), 'bc' => $bc);
        $this->page_construct('employees/view', $meta, $this->data);
    }

   
    function deactivate($id = NULL)
    {
        if ($this->employees_model->change_status($id,'Unpublish')) {
            $this->messages->add('employees UnPublished', "success");
        } else {
            if($this->messages->count() == 0)
                $this->messages->add('employees UnPublished error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function activate($id = NULL)
    {
        if ($this->employees_model->change_status($id,'Publish')) {
            $this->messages->add('employees Published', "success");
        } else {
            if($this->messages->count() == 0)
                $this->messages->add('employees Published error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function delete($id = NULL)
    {
        //$this->tmw->checkPermissions(NULL, TRUE);
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if ($this->employees_model->delete($id)) {
            $this->messages->add('employees deleted', "success");
        } else {
            if($this->messages->count() == 0)
            $this->messages->add('employees delete error', "error");
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function suggestions($term = NULL, $limit = NULL)
    {
        // $this->tmw->checkPermissions('index');
        if ($this->input->get('term')) {
            $term = $this->input->get('term', TRUE);
        }
        if (strlen($term) < 1) {
            return FALSE;
        }
        $limit = $this->input->get('limit', TRUE);
        $rows['results'] = $this->companies_model->getemployeesuggestions($term, $limit);
        echo json_encode($rows);
    }


}