<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Payroll extends MY_Controller {

    private $model;
    var $data;

    public function __construct()
    {
        parent::__construct();
        $this->data['menus'] = $this->main_model->getMenu();
        $this->load->model('payroll_model');
        $this->model = $this->payroll_model;
        $this->load->library('form_validation');

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
    }

    // this function for index page (Home)
    function index()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'employee';
        $data['message'] = view_error($this->messages->get());
        $data['Edit'] = $this->check_edit();
        $this->load->model('company_model','company');
        $data['companies'] = $this->company->get_all_company($this->attn->getComp());
        $data['employees'] = $this->model->get_all($this->attn->getComp());
        $data['page_title'] = 'Employees';
        $data['heading'] = 'Master Files';
        $data['url'] = base_url('employee');
        $this->load->view('templates/employee/emp_details',$data);
    }

    function getEmployeePayroll()
    {
        $month = ($this->input->get('month'))?$this->input->get('month'):date('Y-m');
        $this->load->library('datatables');
        $this->datatables
            ->select("Comp,EmpNo,EmpName,Month")
            ->from("payslip")
            ->where('Month',$month)
            ->where('Comp',$this->attn->getComp())
            ->add_column("Actions", "<a class=\"tip\" title='view' href='" . site_url('payroll/employee_payroll/?emp=$1&month=$2') . "' ><span class=\"label label-sm label-inverse arrowed-in\">View</span></a>", "EmpNo,Month")
        ->unset_column('Month,Comp');
        echo $this->datatables->generate();
    }

    // this function for index page (Home)
    function employee_payroll()
    {
        $this->attn->checkPermissions('payroll_employee_payroll');
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'employee_payroll';
        $data['message'] = view_error($this->messages->get());
        $this->load->model('company_model','company');
        $data['companies'] = $this->company->getAll($this->attn->getComp());
        $this->load->model('employee_model');
        $data['employees'] = $this->employee_model->get_all_emp_name($this->attn->getComp());
        $month = ($this->input->get('month'))?$this->input->get('month'):date('Y-m');
        $data['payrolls'] = $this->model->getMonthPayroll($this->attn->getComp(),$month);
        if($this->input->get('emp') and $this->input->get('month')){
            $month = $this->input->get('month');
            $this->load->model('reports/payslip_model');
            $model = $this->payslip_model;
            $payroll = $model->getPayslip($this->attn->getComp(),$month,$this->input->get('emp'));
            $data['payroll'] = $payroll[0];
            //$this->attn->p($payroll);
            $data['v'] = '&month='.$month.'&emp='.$this->input->get('emp');
            $data['month'] = $month;
            $data['emp'] = $this->input->get('emp');
        }
        $data['page_title'] = 'Employees';
        $data['heading'] = 'Master Files';
        $data['url'] = base_url('employee');
        $this->load->view('templates/payroll/employee_payroll',$data);
    }

    // this function for index page (Home)
    function template()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'employee';
        $data['message'] = view_error($this->messages->get());
        $data['Edit'] = $this->check_edit();
        $this->load->model('company_model','company');
        $data['companies'] = $this->company->get_all_company($this->attn->getComp());
        $data['employees'] = $this->model->get_all($this->attn->getComp());
        $data['page_title'] = 'Employees';
        $data['heading'] = 'Master Files';
        $data['url'] = base_url('employee');
        $this->load->view('templates/employee/emp_details',$data);
    }

    function add_template()
    {
        $this->attn->checkPermissions('payroll_add_template');
        $data['page'] = 'payroll';
        $data['page_title'] = 'Add Template';
        $data['heading'] = 'Payroll';
        $this->form_validation->set_rules('Emp_Code', 'Employee', 'required');
        if ($this->form_validation->run('payroll/add_template') == true) {
            $data = array(
                'Comp' => $this->input->post('Comp'),
                'EmpNo' => $this->input->post('Emp_Code'),
                'Basic_Salary' => $this->input->post('Basic_Salary'),
                'Ot' => ($this->input->post('Ot'))?1:0,
                'Epf' => ($this->input->post('Epf'))?1:0,
                'Attendance' => ($this->input->post('Attendance'))?1:0,
                'Welfare' => ($this->input->post('Welfare'))?1:0,
            );
            $attn = ($this->input->post('a'))?$this->input->post('a'):NULL;
            $dect = ($this->input->post('d'))?$this->input->post('d'):NULL;
            $options = array();
            if($attn){
                foreach($attn as $a){
                    $options[] = array(
                        'EmpNo' => $this->input->post('Emp_Code'),
                        'Comp' => $a[0],
                        'Type_Id' => $a[1],
                        'Code' => $a[2],
                        'Amount' => $a[3],
                    );
                }
            }
            if($dect){
                foreach($dect as $d){
                    $options[] = array(
                        'EmpNo' => $this->input->post('Emp_Code'),
                        'Comp' => $d[0],
                        'Type_Id' => $d[1],
                        'Code' => $d[2],
                        'Amount' => $d[3],
                    );
                }
            }
            //$this->attn->p($data); die();
        } elseif ($this->input->post('add_biller')) {
            $this->messages->add(validation_errors(), "error");
            redirect('payroll/add_template');
        }
        if ($this->form_validation->run() == true && $this->payroll_model->addPayroll($data,$options)) {
            $this->messages->add('Template successfully added', "success");
            redirect('payroll/add_template');
        } else {
            $this->load->model('items_model');
            $this->load->model('employee_model');
            $data['allowances'] = $this->items_model->get_all_by_type('A');
            $data['deductions'] = $this->items_model->get_all_by_type('D');
            $data['employees'] = $this->employee_model->get_all_filter();
            //echo '<pre>',print_r($data['allowances']); die();
            $this->messages->add(validation_errors(), "error");
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/payroll/payroll_template', $data);
        }
    }

    /*** Increment ***/
    function increment_list()
    {
        //to get menus from Secure_area contraller
        $data = $this->data;
        $data['page'] = 'increment';
        $data['message'] = view_error($this->messages->get());
        $data['page_title'] = 'Increment';
        $data['heading'] = 'Payroll';
        $data['url'] = base_url('employee');
        $this->load->view('templates/increment/index',$data);
    }

    function increment()
    {
        $this->attn->checkPermissions('payroll_increment');
        $data['page'] = 'increment';
        $data['e'] = ($this->input->get('emp'))?$this->input->get('emp'):NULL;
        $data['m'] = ($this->input->get('month'))?$this->input->get('month'):NULL;
        if($this->input->get('month') AND $this->input->get('emp') AND $this->input->get('Code')){
            $data['meal'] = $this->monthitem_model->getCustomTran($this->attn->getComp(),$this->input->get('emp'),$this->input->get('month'),$this->input->get('Code'));
            //echo var_dump($data['meal']); die();
        }
        $this->load->library('form_validation');
        $this->form_validation->set_rules('EmpNo', 'Employee', 'required');
        $this->form_validation->set_rules('month', 'Month', 'required');
        if ($this->form_validation->run() == true) {
            $rows = array(
                'Comp' => $this->attn->getComp(),
                'Month' => $this->input->post('month'),
                'EmpNo' => $this->input->post('EmpNo'),
                'Amount' => $this->input->post('Amount'),
            );
        } elseif ($this->input->post('add_increment')) {
            $this->messages->add(validation_errors(), "error");
            redirect('payroll/increment');
        }
        if ($this->form_validation->run() == true && $this->model->addIncrement($rows)) {
            $this->messages->add('Increment successfully added', "success");
            redirect('payroll/increment?emp='.$this->input->post('EmpNo').'&month='.$this->input->post('month'));
        } else {
            $this->load->model('employee_model');
            $data['employees'] = $this->employee_model->get_all_filter();
            $data['message'] = view_error($this->messages->get());
            $data['page_title'] = 'Add Increment';
            $data['heading'] = 'Transactions';
            $this->load->view('templates/payroll/increment', $data);
        }
    }



    public function getIncrements()
    {
        $emp = ($this->input->get('emp'))?$this->input->get('emp'):'';
        $month = ($this->input->get('month'))?$this->input->get('month'):'';
        $this->load->library('datatables');
        $this->datatables
            ->select("Month,EmpNo,Amount,Comp")
            ->from("increment")
            ->where('Comp', $this->attn->getComp())
            ->add_column("Actions", "
            <div class='d-flex align-items-center'>
            <a href='".site_url('payroll/deleteCustomTrans/?emp=$1&month=$2&comp=$3')."' data-bs-toggle=\"tooltip\" class=\"text-body\" data-bs-placement=\"top\" aria-label=\"Preview Invoice\" data-bs-original-title=\"Delete Record\">
            <i class=\"bx bx-trash mx-1\"></i></a>", "EmpNo,Month,Comp")
            ->unset_column('EmpNo,Comp');
        if(!empty($emp)){
            $this->db->where('EmpNo', $emp);
        }
       /* if(!empty($month)){
            $this->db->where('Month', $month);
        }*/
        echo $this->datatables->generate();
    }

    function deleteCustomTrans()
    {
        $emp = ($this->input->get('emp'))?$this->input->get('emp'):NULL;
        $month = ($this->input->get('month'))?$this->input->get('month'):NULL;
        $comp = ($this->input->get('comp'))?$this->input->get('comp'):NULL;
        //$this->sma->checkPermissions(NULL, TRUE);
        if ($this->model->deleteIncrement($emp,$month,$comp)) {
            if($this->input->is_ajax_request()) {
                echo 'Deleted'; die();
            }
            $this->session->set_flashdata('message', lang('meal_deleted'));
            redirect('welcome');
        }
    }
    /*** /Increment ***/

    public function get_info()
    {
        $Comp = (isset($_POST['Comp'])  and (!empty($_POST['Comp'])))? $this->input->post('Comp'): '';
        $EmpNo = (isset($_POST['EmpNo'])  and (!empty($_POST['EmpNo'])))? $this->input->post('EmpNo'): '';
        $employee = $this->payroll_model->get_info_filter($EmpNo);
        $return = array();
        if($employee)
        {
            $return['type'] = 1;
            $return['msg'] = $employee;
        }
        else
        {
            $return['type'] = 0;
            $return['msg'] = 'Error';
        }
        echo json_encode($return);
    }

    function make_payslips()
    {
        $this->attn->checkPermissions('payroll_make_payslips');
        $data['page'] = 'make_payslips';
        $this->form_validation->set_rules('month', ' Month', 'required');
        if ($this->form_validation->run('payroll/make_payslips') == true) {

            //ini_set('max_execution_time', 0);
            $data = $this->data;
            $month = $this->input->post('month');
            $this->load->model('reports/payslip_model');
            $model = $this->payslip_model;
            $employees = $model->get_all_employee_filter(0);
            
            $setting = $model->get_setting($this->attn->getComp());
            //$this->attn->p($setting); die();
            $i= 0;
            $all_options = $model->get_items($month);
            //$this->attn->p($all_options); die();
            $this->load->library('payslip');
            $options_by_employees = $this->payslip->make_month_items($all_options);
            //$this->attn->p($options_by_employees); die();
            $this->load->model('transaction/leave_transaction_model');
            $this->load->model('loan_model');
            $payrolls = $model->get_payroll();
            $increment = $model->get_increment();
            $payslip_array = array();
            $loans = array();
            $payslip_option_array = array();
            foreach($employees as $empl)
            {
                
                //if($empl->EmpNo=='5') {

                    $loan = $this->loan_model->get_empl_loan($empl->EmpNo);
                    //echo '<pre>'.$empl->EmpNo,print_r($loan); die();
                    //$days = $setting->days;
                    $days = $empl->Month_working_days;
                    $is_EPF = 0;
                    $is_attendance = 0;
                    $payroll = array();
                    $options = isset($options_by_employees[$empl->EmpNo]) ? $options_by_employees[$empl->EmpNo] : false;

                    if (!empty($options)) {

                        $loan_Installment = 0;
                        $LoanId = 0;
                        $LoanAmount = 0;
                        $LoanInsCount = 0;
                        $LoanInsAmount = 0;
                        if($loan){
                            $loan_Installment = $loan->Installment;
                            $LoanId = $loan->Installment;
                            $LoanAmount = $loan->FullAmount;
                            $LoanInsCount = (int)$loan->InsCount+1;
                            $LoanInsAmount = (float)$loan->InsAmount+floatval($loan->Installment);
                        }

                        if (isset($payrolls[$empl->EmpNo])) {
                            $payroll = $payrolls[$empl->EmpNo];
                            $is_EPF = $payroll['Epf'];
                            $is_attendance = $payroll['Attendance'];
                        }

                        $add_increment =0;
                        if (isset($increment[$empl->EmpNo])) {
                            $add_increment = $increment[$empl->EmpNo];
                        }

                        $add_basics = 0;
                        foreach ($options as $o) {
                            if (isset($o['Basic']) and $o['Basic'] == 'yes') {
                                $add_basics += (float)$o['Amount'];
                            }
                        }

                        $salary = (isset($payroll['Basic_Salary'])) ? $payroll['Basic_Salary'] : 0;
                        //echo $salary; die();

                        //add increment to salary
                        $salary = (float)$salary + (float)$add_increment;
                        $basic = array('Salary', $salary);
                        $basic_salary = (float)$salary + (float)$add_basics;
                        $total_basic_allowances_salary = $basic_salary;
                        $allowance = $this->payslip->make_allowance_deduction($options, 'A', 'Amount');
                        $deduction = $this->payslip->make_allowance_deduction($options, 'D', 'Amount');
                        //$EPF_allowance = $this->payslip->make_allowance_deduction($options, 'A', 'Amount','yes');
                        //$EPF_deduction = $this->payslip->make_allowance_deduction($options, 'D', 'Amount','yes');
                        /*$this->attn->p($options);
                        die();*/
                        $Late = $this->payslip->make_options($options, 'L', 'Rate', $basic_salary, $days, $setting->hours);
                        //($options=array(),$type='N',$field='',$no='no',$sal=0,$days=null,$hour=null)
                        $nopays = $this->leave_transaction_model->get_employee_month_nopays($empl->EmpNo,$month);

                        $app_nopay = $this->leave_transaction_model->get_employee_month_nopays($empl->EmpNo,$month);

                        $this->load->model('monthitem_model');
                        $trns_nopay = $this->monthitem_model->get_employee_month_nopay($month,$empl->EmpNo);

                        //check nopay added in timesheet apply nopay or transaction month transaction (all)
                        $nopays = 0;
                        if($trns_nopay){
                            $nopays = $trns_nopay;
                        }else if($app_nopay and $app_nopay=!0){
                            $nopays = $app_nopay;
                        }

                        /*if($empl->EmpNo=='953482479'){
                            echo print_r($nopays); die();
                        }*/

                        $Nopay = $this->payslip->make_options($options, 'N', 'Rate', 'no', $basic_salary, $days);
                        $Nopay_value = round(((float)(($basic_salary/$days)*(float)$nopays)*1),2);
                        $Nopay[0] = $Nopay_value;
                        $Nopay[1][0] = array('No Pay(1.00) - Days '.$nopays.'.00',$Nopay_value,'N',(float)$nopays.'.00','NP');

                        //$Nopay_value;
                        //$this->attn->p($Nopay); die();
                        $Overtime = $this->payslip->make_options($options, 'O', 'Rate', 'no', $basic_salary, $days, $setting->hours);
                        $EPF_Late = $this->payslip->make_options($options, 'L', 'Rate', 'yes');
                        $EPF_Nopay = $this->payslip->make_options($options, 'N', 'Rate', 'yes');

                        $EPF_Overtime = $this->payslip->make_options($options, 'O', 'Rate', 'yes');
                        $allowance[4] = 'Allowances';
                        $deduction[4] = 'Deductions';
                        $Late[3] = 'Lates';
                        $Nopay[3] = 'Nopays';
                        $Overtime[3] = 'Overtimes';

                        $not_value = 0; //store normal ot hours
                        $dot_value = 0; //store double ot hours
                        $tot_value = 0; //store double ot hours
                        //$this->attn->p($Overtime); //die();


                        if (isset($Overtime[1]) and !empty($Overtime[1])) {
                            foreach ($Overtime[1] as $ot) {
                                $allowance[2][] = $ot;
                                switch ($ot[4]) {
                                    case 'NOT':
                                        $not_value = $ot[3];
                                        break;
                                    case 'DOT':
                                        $dot_value = $ot[3];
                                        break;
                                    case 'TOT':
                                        $tot_value = $ot[3];
                                        break;
                                }
                            }
                        }

                        // If have napay days deduct from basic salary and display basic salary section
                        if (isset($Nopay[1]) and !empty($Nopay[1])) {
                            foreach ($Nopay[1] as $n) {
                                $deduction[3][] = $n;
                            }
                        }
                        //Total salary for EPF
                        //$totalForEpf = (float)($basic_salary) - (float)$EPF_Nopay[0]-(float)$EPF_Late+(float)$EPF_Overtime;
                        $totalForEpf = (float)($basic_salary) - (float)$Nopay[0];
                        //$totalForEpf = (float)($basic_salary);
                        //Total salary for EPF
                        $total_salary = (float)($salary) - (float)$Nopay[0];
                        //$total_salary = (float)($salary);
                        $EPF = array('E.P.F ' . $setting->EPF_Empl . '%', (($setting->EPF_Empl) * $totalForEpf) / 100, 'D', $setting->EPF_Empl, 'EPFE');

                        //Calculate total allowances
                        $total_allowance = (float)$allowance[0];
                        $total_allowance += $Overtime[0];
                        $total_allowance_without_salary = $total_allowance;
                        $gross_salary = $total_salary + $total_allowance;
                        $NotBasicAllowance = $total_allowance - (float)$add_basics;
                        //calculate total deductions
                        $total_deduction = (float)$deduction[0];
                        $total_deduction += (float)$Late[0];
                        if ($is_EPF == 1) {
                            $deduction[2][] = array($EPF[0], $EPF[1], $EPF[2], $EPF[3], 'EPF');
                            $total_deduction += (float)$EPF[1];
                        } else {
                            $deduction[2][] = array($EPF[0], 0, $EPF[2], $EPF[3], 'EPF');
                        }
                        //Allowances for basic
                        $allowances_for_basic = (isset($allowance[3]) AND !empty($allowance[3])) ? $allowance[3] : array();
                        //Deductions for basic
                        $deductions_for_basic = (isset($deduction[3]) AND !empty($deduction[3])) ? $deduction[3] : array();
                        $allowances_array = array_merge($allowance[2]);
                        //$this->attn->p($allowances_array); die();
                        $deductions_array = array_merge($deduction[2]);
                        //Salary payable
                        $salaryPayable = $gross_salary - $total_deduction;
                        $salaryPayable_round = $this->payslip->round_down_to_hundred($salaryPayable);
                        if ($is_EPF == 1) {
                            $EPFepm = array('EPF ' . $setting->EPF_Empe . '%', (($setting->EPF_Empe) * $totalForEpf) / 100, 'OD', $setting->EPF_Empe, 'EPFEM');
                            $ETF = array('ETF ' . $setting->ETF . '%', (($setting->ETF) * $totalForEpf) / 100, 'OD', $setting->ETF, 'ETF');
                        } else {
                            $EPFepm = array('EPF ' . $setting->EPF_Empe . '%', 0, 'OD', $setting->EPF_Empe, 'EPFEM');
                            $ETF = array('ETF ' . $setting->ETF . '%', 0, 'OD', $setting->ETF, 'ETF');
                        }
                        $p = array(
                            'Comp' => $this->attn->getComp(),
                            'EmpNo' => $empl->EmpNo,
                            'Month' => $month,
                            'EmpName' => $empl->EmpName,
                            'Title' => $empl->Title,
                            'EPFNo' => $empl->EPFNo,
                            'Department' => $empl->Department,
                            'Designation' => $empl->Designation,
                            'Bank' => $empl->Bank,
                            'Branch' => $empl->Branch,
                            'AccountNo' => $empl->AccountNo,
                            'Salary' => $salary,
                            'BasicSalary' => $basic_salary,
                            'AllowancesForBasic' => serialize($allowances_for_basic),
                            'DeductionsForBasic' => serialize($deductions_for_basic),
                            'TotalSalary' => $total_salary,
                            'TBAllowances' => $total_basic_allowances_salary,
                            'Allowance' => $total_allowance,
                            'NotBasicAllowance' => $NotBasicAllowance,
                            'AllowanceString' => serialize($allowances_array),
                            'GrossSalary' => $gross_salary,
                            'DeductionString' => serialize($deductions_array),
                            'Deduction' => $total_deduction,
                            'Late' => $Late[0],
                            'Nopay' => $Nopay[0],
                            'NopayDays' => $nopays,
                            'NotValue' => $not_value,
                            'DotValue' => $dot_value,
                            'TotValue' => $tot_value,
                            'TotalForEpf' => $totalForEpf,
                            'EPF' => $EPF[1],
                            'GrossSalary' => $gross_salary,
                            'salaryPayable' => $salaryPayable,
                            'salaryPayableRound' => $salaryPayable_round,
                            'EPFepmString' => $EPFepm[0],
                            'EPFepm' => $EPFepm[1],
                            'ETFString' => $ETF[0],
                            'ETF' => $ETF[1],
                            'LoanId' => $LoanId,
                            'LoanAmount' => $LoanAmount,
                            'LoanInsCount' => $LoanInsCount,
                            'LoanInsAmount' => $LoanInsAmount,
                        );
                        $payslip_array[] = $p;
                        if($LoanId > 0){
                            $loans[]= array(
                                'loan_id' => $LoanId,
                                'month' => $month,
                                'amount' => $loan_Installment,
                            );
                        }

                    }
                    $i++;
                //}


            }
            //die();
            //$this->attn->p($loans); die();
            /* If only one employee
            close the opened table
            */
            //insert payslip for database
        } elseif ($this->input->post('add_biller')) {
            $this->messages->add(validation_errors(), "error");
            redirect('payroll/make_payslips');
        }

        $this->load->model('reports/payslip_model');
        if ($this->form_validation->run() == true && $this->payslip_model->addPayslip($payslip_array,$loans,$month,$this->attn->getComp())) {
            $this->messages->add('Payslips successfully Created', "success");
            redirect('payroll/make_payslips');
        } else {
            $data['page_title'] = 'Payroll';
            $data['heading'] = 'Generate Payslip';
            $this->messages->add(validation_errors(), "error");
            $data['message'] = view_error($this->messages->get());
            $this->load->view('templates/payroll/make_payslips', $data);
        }
    }}
?>